;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Ast/app.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 21 09:34:48 1996                          */
;*    Last change :  Fri May  2 17:11:05 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The application compilation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_app
   (include "Ast/node.sch")
   (import  tools_error
	    tools_location
	    tools_shape
	    type_cache
 	    ast_sexp)
   (export  (application->node::node ::obj ::obj ::obj ::symbol)
	    (make-app-node::node stack loc var::var args)
	    (correct-arity-app?::bool ::variable ::obj)))

;*---------------------------------------------------------------------*/
;*    correct-arity-app? ...                                           */
;*    -------------------------------------------------------------    */
;*    We check functional application arity in order to print, as      */
;*    soon as possible, user errors.                                   */
;*---------------------------------------------------------------------*/
(define (correct-arity-app? var::variable args)
   (let* ((fun     (variable-value var))
	  (nb-args (length args))
	  (arity   (fun-arity fun)))
      (cond
	 ((=fx arity -1)
	  #t)
	 ((>=fx arity 0)
	  (= arity nb-args))
	 (else
	  (<=fx (-fx (negfx arity) (+fx nb-args 1)) 0)))))

;*---------------------------------------------------------------------*/
;*    application->node ...                                            */
;*    -------------------------------------------------------------    */
;*    Each parameters which is not a variable _is_ force to be bound   */
;*    to a variable.                                                   */
;*---------------------------------------------------------------------*/
(define (application->node exp stack loc site)
   (define (all-subexp-symbol? exp)
      (let loop ((exp exp))
	 (if (null? exp)
	     #t
	     (match-case (car exp)
		((atom ?-)
		 (loop (cdr exp)))
		((@ (? symbol?) (? symbol?))
		 (loop (cdr exp)))
		(else
		 (or (atom? (car exp))
		     (var? (car exp))))))))
   (let* ((loc      (find-location/loc exp loc))
	  (err-nb   *nb-error-on-pass*)
	  (fun      (sexp->node (car exp) stack loc 'app))
	  (fun-err? (>fx *nb-error-on-pass* err-nb)))
      (if (and (all-subexp-symbol? exp) (var? fun))
	  (let* ((args  (cdr exp))
		 (delta (check-user-app fun args)))
	     (cond
		((not (var? fun))
		 (sexp->node ''() stack loc 'value))
		((=fx delta 0)
		 (make-app-node stack loc fun args))
		(else
		 (wrong-number-of-arguments exp loc fun args))))
	  (let loop ((old-args (cdr exp))
		     (new-args '())
		     (bindings '()))
	     (cond
		((null? old-args)
		 (let ((old-fun      (car exp))
		       (make-the-app (lambda (fun)
					(if (pair? bindings)
					    `(let ,(reverse! bindings)
						(,fun ,@(reverse! new-args)))
					    `(,fun ,@(reverse! new-args))))))
		    (if (var? fun)
			(sexp->node (make-the-app old-fun) stack loc site)
			(let ((new-fun (gensym 'fun)))
			   (sexp->node `(let ((,new-fun ,(if fun-err?
							     '(lambda l l)
							     old-fun)))
					   ,(make-the-app new-fun))
				       stack
				       loc
				       site)))))
		((or (symbol? (car old-args))
		     (cnst? (car old-args)))
		 (loop (cdr old-args)
		       (cons (car old-args) new-args)
		       bindings))
		(else
		 (let ((new-arg (gensym 'arg)))
		    (loop (cdr old-args)
			  (cons new-arg new-args)
			  (cons (list new-arg (car old-args)) bindings)))))))))

;*---------------------------------------------------------------------*/
;*    wrong-number-of-arguments ...                                    */
;*---------------------------------------------------------------------*/
(define (wrong-number-of-arguments exp loc fun args)
   (let* ((var     (var-variable fun))
	  (fun     (variable-value var))
	  (nb-args (length args))
	  (arity   (cond
		      ((fun? fun)
		       (fun-arity fun))
		      (else
		       -1)))
	  (expect  (cond
		      ((>=fx arity 0)
		       (string-append (number->string arity)
				      " arg(s) expected, "))
		      (else
		       (string-append (number->string (negfx (+fx arity 1)))
				      " or more arg(s) expected, "))))
	  (provide (string-append (number->string (length args)) " provided")))
      (error-sexp->node
       (string-append "Illegal application: " expect provide)
       exp
       loc)))
				   
;*---------------------------------------------------------------------*/
;*    make-app-node ...                                                */
;*---------------------------------------------------------------------*/
(define (make-app-node stack loc var args)
   (let ((fun (variable-value (var-variable var))))
      (if (or (not (fun? fun)) (>=fx (fun-arity fun) 0))
	  (let ((args (map (lambda (a) (sexp->node a stack loc 'value))
			   args)))
	     (make-fx-app-node loc var args))
	  (make-va-app-node (fun-arity fun) stack loc var args))))

;*---------------------------------------------------------------------*/
;*    make-fx-app-node ...                                             */
;*---------------------------------------------------------------------*/
(define (make-fx-app-node loc var args)
   (let ((v (var-variable var)))
      (if (fun? (variable-value v))
	  (instantiate::app
	     (loc loc)
	     (type (variable-type v))
	     (fun  (if (closure? var)
		       (duplicate::var var)
		       var))
	     (args args))
	  (instantiate::funcall
	     (loc loc)
	     (type *_*)
	     (fun  var)
	     (args (cons var args))))))

;*---------------------------------------------------------------------*/
;*    make-va-app-node ...                                             */
;*---------------------------------------------------------------------*/
(define (make-va-app-node arity stack loc var args)
   (define (make-args-list args)
      (if (null? args)
	  ''()
	  `((@ c-cons foreign) ,(car args) ,(make-args-list (cdr args)))))
   (let loop ((old-args args)
	      (arity    arity)
	      (f-args   '()))
      (if (=fx arity -1)
	  (let* ((l-arg  (gensym 'list))
		 (l-exp  `(let ((,l-arg ,(make-args-list old-args)))
			     ,l-arg))
		 (l-node (sexp->node l-exp stack loc 'value))
		 (l-var  (let-var-body l-node))
		 (app    (make-fx-app-node loc
					   var
					   (reverse! (cons l-var f-args)))))
	     [assert (l-var) (var? l-var)]
	     (let-var-body-set! l-node app)
	     l-node)
	  (loop (cdr old-args)
		(+fx arity 1)
		(cons (sexp->node (car old-args) stack loc 'value) f-args)))))
 
;*---------------------------------------------------------------------*/
;*    check-user-app ...                                               */
;*    -------------------------------------------------------------    */
;*    We check functional application arity in order to print, as      */
;*    soon as possible, user errors.                                   */
;*---------------------------------------------------------------------*/
(define (check-user-app fun args)
   (if (not (var? fun))
       ;; we may have found an error while compiling the
       ;; function and have compiled '() instead. In order
       ;; to not print several messages for the same error
       ;; we skip the arity one here.
       0
       (let* ((var     (var-variable fun))
	      (fun     (variable-value var))
	      (nb-args (length args))
	      (arity   (cond
			  ((fun? fun)
			   (fun-arity fun))
			  (else
			   -1))))
	  (cond
	     ((=fx arity -1)
	      0)
	     ((>=fx arity 0)
	      (-fx arity nb-args))
	     (else
	      (if (<=fx (-fx (negfx arity) (+fx nb-args 1)) 0)
		  0
		  1))))))
