;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo/Engine/param.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 29 11:45:41 1995                          */
;*    Last change :  Thu Feb 26 15:09:53 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Configuration variables                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  tools_date)
   (export  *cigloo-version*
	    *cigloo-name*
	    *cigloo-level*
	    *cigloo-args*
	    *cigloo-rest-args*
	    *cigloo-author*
	    *cigloo-email*
	    *cigloo-date*
	    *cigloo-tmp*
	    *verbose*
	    *src*
	    *src-dirname*
	    *dest*
	    *iname*
	    *oport*
	    *scan-include*
	    *open-include*
	    *include-path*
	    *hookfile*
	    *c-type-alist*
	    *c-unsigned-type-alist*
	    *c-signed-type-alist*
	    *default-type*
	    *no-type*
	    *macro-variable*
	    *macro-function*
	    *directives*
	    *include-directive*
	    *define*
	    *define-fun*
	    *eval-stub?*
	    *gcc-extensions?*))
 
;*---------------------------------------------------------------------*/
;*    compiler and author names ...                                    */
;*---------------------------------------------------------------------*/
(define *cigloo-version*    "0.5")
(define *cigloo-name*       (string-append "Cigloo (v" *cigloo-version* ")"))
(define *cigloo-level*      #f)
(define *cigloo-cmd-name*   'nothing-yet)
(define *cigloo-args*       'nothing-yet)
(define *cigloo-rest-args*  '())
(define *cigloo-author*     "Manuel Serrano")
(define *cigloo-email*      "Manuel.Serrano@unice.fr")
(define *cigloo-date*       (cigloo-date))
(define *cigloo-tmp*        (let ((Venv (getenv "TMPDIR")))
			      (if (string? Venv)
				  Venv
				  "/tmp")))

;*---------------------------------------------------------------------*/
;*    Compiler controls                                                */
;*---------------------------------------------------------------------*/
(define *verbose*        0)

;*---------------------------------------------------------------------*/
;*    file names                                                       */
;*---------------------------------------------------------------------*/
(define *src*            '())
(define *src-dirname*    #f)
(define *iname*          "")
(define *dest*           #f)
(define *oport*          (current-output-port))

;*---------------------------------------------------------------------*/
;*    The includes                                                     */
;*---------------------------------------------------------------------*/
(define *include-path*   '())
(define *scan-include*   '())
(define *open-include*   '())

;*---------------------------------------------------------------------*/
;*    Hooks                                                            */
;*---------------------------------------------------------------------*/
(define *hookfile*       #f)

;*---------------------------------------------------------------------*/
;*    *c-type-alist* ...                                               */
;*    -------------------------------------------------------------    */
;*    This list defines the Bigloo name of the C type. This list       */
;*    can be enlarged by user.                                         */
;*---------------------------------------------------------------------*/
(define *c-type-alist*
   '((obj         . "obj")
     (bchar       . "bchar")
     (blong       . "blong")
     (procedure   . "procedure")    
     (pair        . "pair")         
     (nil         . "nil")          
     (bint        . "bint")         
     (blong       . "blong")        
     (bbool       . "bbool")        
     (cnst        . "cnst")         
     (bstring     . "bstring")      
     (bchar       . "bchar")        
     (real        . "real")         
     (vector      . "vector")             
     (tvector     . "tvector")      
     (struct      . "struct")       
     (tstruct     . "tstruct")      
     (output-port . "output-port" )
     (input-port  . "input-port"  )
     (binary-port . "binary-port")  
     (unspecified . "unspecified")  
     (symbol      . "symbol")       
     (cell        . "cell")         
     (exit        . "exit")         
     (foreign     . "foreign")      
     (char        . "char")
     (char*       . "string")
     (short       . "short")
     (int         . "int")
     (long        . "long")
     (longlong    . "llong") 
     (signed      . "sint")
     (unsigned    . "uint")
     (float       . "float")
     (double      . "double")
     (const       . "int")
     (volatile    . "int")))

(define *c-unsigned-type-alist*
   '((char     . "uchar")
     (short    . "ushort")
     (int      . "uint")
     (long     . "ulong")))

   
(define *c-signed-type-alist*
   '((char     . "schar")
     (short    . "sshort")
     (int      . "sint")
     (long     . "slong")))

(define *default-type* "int")

(define *no-type*      '())

;*---------------------------------------------------------------------*/
;*    *macro* ...                                                      */
;*---------------------------------------------------------------------*/
(define *macro-function* #f)
(define *macro-variable* #f)

;*---------------------------------------------------------------------*/
;*    *directives* ...                                                 */
;*---------------------------------------------------------------------*/
(define *directives*        #t)
(define *include-directive* #f)

;*---------------------------------------------------------------------*/
;*    The cpp commands ...                                             */
;*---------------------------------------------------------------------*/
(define *define*           #t)
(define *define-fun*       #t)   

;*---------------------------------------------------------------------*/
;*    Stub production                                                  */
;*---------------------------------------------------------------------*/
(define *eval-stub?*       #f)

;*---------------------------------------------------------------------*/
;*    *gcc-extensions?* ...                                            */
;*---------------------------------------------------------------------*/
(define *gcc-extensions?*  #f)
