/*  C K U A T H . H --  "C-Kermit to Authentication" interface  */
 
/*
  Author: Jeffrey Altman <jaltman@columbia.edu>,
  Columbia University Academic Information Systems, New York City.

  Copyright (C) 1985, 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.
*/
 
/*
 * Based on a concatenation of all necessary include files distributed with  
 * the Kerberos 5 NT Alpha 2 Telnet package from MIT.  
 */

#ifndef KRB5_KERMIT_H
#define KRB5_KERMIT_H

#ifndef BOOL
#define BOOL int
#endif

/* Header file for encrypted-stream library.
 * Written by Ken Raeburn (Raeburn@Cygnus.COM).
 * Copyright (C) 1991, 1992, 1994 by Cygnus Support.
 *
 * Permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation.
 * Cygnus Support makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 */

#ifndef K5STREAM_H
#define K5STREAM_H

typedef void *kstream_ptr;                      /* Data send on the kstream */
struct kstream_data_block {
  kstream_ptr ptr;
  size_t length;
};

typedef struct kstream_int {                    /* Object we pass around */
    int fd;                                       /* Open socket descriptor */
    int (*encrypt)(struct kstream_data_block *, /* output */
                   struct kstream_data_block *); /* input */
    int encrypt_type;
    int (*decrypt)(struct kstream_data_block *, /* output */
                   struct kstream_data_block *); /* input */
    int decrypt_type;
} *kstream;



struct kstream_crypt_ctl_block {
  int (*encrypt)(struct kstream_data_block *, /* output */
		 struct kstream_data_block *); /* input */
  int (*decrypt)(struct kstream_data_block *, /* output */
		 struct kstream_data_block *); /* input */
  int (*init)(kstream);
  void (*destroy)(void);
};


/* Prototypes */

int  kstream_destroy();
void kstream_set_buffer_mode(int);
int  kstream_create_from_fd(int fd,
			       const struct kstream_crypt_ctl_block *,
			       kstream_ptr);
int kstream_write(void *, size_t);
int kstream_read(void *, size_t);

#endif /* K5STREAM_H */

/*
 * Implements Telnet authentication and ecryption
 */

#ifndef TELNET_AUTH_H
#define TELNET_AUTH_H

int auth_parse(unsigned char *, int);

int auth_init(kstream);

void auth_destroy(void);

int auth_encrypt(struct kstream_data_block *, struct kstream_data_block *);

int auth_decrypt(struct kstream_data_block *, struct kstream_data_block *);

extern BOOL forward_flag;
extern BOOL forwardable_flag;
extern BOOL forwarded_tickets;

#ifdef ENCRYPTION
extern BOOL encrypt_flag;
#endif

#endif /* WINTEL_AUTH_H */


/* C-Kermit specific functions */
#ifdef OS2
_PROTOTYP(int ck_krb_loaddll, (VOID));
_PROTOTYP(int ck_krb_unloaddll, (VOID));
#endif /* OS2 */
_PROTOTYP(int ck_krb_init, (char *, char *, char *, int));
_PROTOTYP(int ck_krb_tn_sb_auth, (char *, int));
_PROTOTYP(int ck_krb_tn_sb_encrypt, (char *, int));
_PROTOTYP(void ck_krb_encrypt, (char *, int));
_PROTOTYP(void ck_krb_decrypt, (char *, int));
_PROTOTYP(void encrypt_send_support, (VOID));

#ifdef CK_KERBEROS
_PROTOTYP(int ck_krb5_initTGT, (struct krb_op_data *,struct krb5_init_data *));
_PROTOTYP(int ck_krb5_destroy, (struct krb_op_data *));
_PROTOTYP(int ck_krb5_list_creds, (struct krb_op_data *,
                                    struct krb5_list_cred_data *));
_PROTOTYP(char * ck_krb5_getrealm, (char *));

_PROTOTYP(int ck_krb4_initTGT, (struct krb_op_data *,struct krb4_init_data *));
_PROTOTYP(int ck_krb4_destroy, (struct krb_op_data *));
_PROTOTYP(int ck_krb4_list_creds, (struct krb_op_data *));
_PROTOTYP(char * ck_krb4_getrealm, (VOID));

_PROTOTYP(int ck_krb4_get_tkts, (VOID));
_PROTOTYP(char * ck_krb4_get_next_tkt, (VOID));
_PROTOTYP(int ck_krb4_tkt_isvalid,(char *));
_PROTOTYP(int ck_krb4_is_tgt_valid,(VOID));
_PROTOTYP(int ck_krb4_tkt_time,(char *));

_PROTOTYP(int ck_krb5_get_tkts, (char *));
_PROTOTYP(char * ck_krb5_get_next_tkt, (VOID));
_PROTOTYP(int ck_krb5_tkt_isvalid,(char *,char *));
_PROTOTYP(int ck_krb5_is_tgt_valid,(VOID));
_PROTOTYP(int ck_krb5_tkt_time,(char *,char *));
#endif /* CK_KERBEROS */

_PROTOTYP(int ck_krb5_is_installed,(void));
_PROTOTYP(int ck_krb4_is_installed,(void));
_PROTOTYP(int ck_srp_is_installed,(void));
_PROTOTYP(int ck_crypt_is_installed,(void));

_PROTOTYP(VOID ck_encrypt_send_support,(VOID));
_PROTOTYP(int ck_get_crypt_table,(struct keytab **, int *));

extern char *authtype_names[];
extern char *authmode_names[];
extern char *encrypt_names[];
extern char *enctype_names[];

#define HEXDISP

#define AUTHMODE_CNT            16

#define	AUTHMODE_NAME_OK(x)	((unsigned int)(x) < AUTHMODE_CNT)
#define	AUTHMODE_NAME(x)	authmode_names[x]
#define	AUTHTYPE_NULL		0
#define	AUTHTYPE_KERBEROS_V4	1
#define	AUTHTYPE_KERBEROS_V5	2
#define	AUTHTYPE_SPX		3
#define	AUTHTYPE_MINK		4
#define AUTHTYPE_SRP            5
#define AUTHTYPE_RSA            6
#define AUTHTYPE_SSL            7
#define AUTHTYPE_LOKI          10
#define AUTHTYPE_DSS           11
#define AUTHTYPE_KEA_SJ        12
#define AUTHTYPE_KEA_INTEG     13
#ifdef AUTHTYPE_CNT
#undef AUTHTYPE_CNT
#endif /* AUTHTYPE_CNT */
#define	AUTHTYPE_CNT	       14

#define	AUTHTYPE_AUTO		99

#ifdef	AUTH_NAMES
char *authtype_names[] = {
    "NULL", "KERBEROS_V4", "KERBEROS_V5", "SPX", "MINK (unassigned)", "SRP",
    "RSA", "SSL (unassigned)", "(unassigned)", "(unassigned)", 
    "LOKI", "SSA or DSS (unassigned)",
    "KEA_SJ (unassigned)", "KEA_INTEG (unassigned)", 0
};
char * authmode_names[] = {
    "CLIENT|ONE_WAY",   
    "SERVER|ONE_WAY",
    "CLIENT|MUTUAL",    
    "SERVER|MUTUAL",
    "CLIENT|ONE_WAY|ENCRYPT", 
    "SERVER|ONE_WAY|ENCRYPT",
    "CLIENT|MUTUAL|ENCRYPT",  
    "SERVER|MUTUAL|ENCRYPT",
    "CLIENT|ONE_WAY|CRED_FWD",   
    "SERVER|ONE_WAY|CRED_FWD",
    "CLIENT|MUTUAL|CRED_FWD",    
    "SERVER|MUTUAL|CRED_FWD",
    "CLIENT|ONE_WAY|ENCRYPT|CRED_FWD", 
    "SERVER|ONE_WAY|ENCRYPT|CRED_FWD",
    "CLIENT|MUTUAL|ENCRYPT|CRED_FWD",  
    "SERVER|MUTUAL|ENCRYPT|CRED_FWD",
    0
};
#else
extern char *authtype_names[];
extern char *authmode_names[];
#endif

#define	AUTHTYPE_NAME_OK(x)	((unsigned int)(x) < AUTHTYPE_CNT)
#define	AUTHTYPE_NAME(x)	authtype_names[x]


/*
 * ENCRYPTion suboptions
 */
#define	ENCRYPT_IS		0	/* I pick encryption type ... */
#define	ENCRYPT_SUPPORT		1	/* I support encryption types ... */
#define	ENCRYPT_REPLY		2	/* Initial setup response */
#define	ENCRYPT_START		3	/* Am starting to send encrypted */
#define	ENCRYPT_END		4	/* Am ending encrypted */
#define	ENCRYPT_REQSTART	5	/* Request you start encrypting */
#define	ENCRYPT_REQEND		6	/* Request you send encrypting */
#define	ENCRYPT_ENC_KEYID	7
#define	ENCRYPT_DEC_KEYID	8
#define	ENCRYPT_CNT		9

#define	ENCTYPE_ANY		0
#define	ENCTYPE_DES_CFB64	1
#define	ENCTYPE_DES_OFB64	2
#define ENCTYPE_CAST5_40_CFB64  8
#define ENCTYPE_CAST5_40_OFB64  9
#define ENCTYPE_CAST128_CFB64   10
#define ENCTYPE_CAST128_OFB64   11
#define ENCTYPE_BLOWFISH_CFB64  12
#define ENCTYPE_BLOWFISH_OFB64  13
#ifdef ENCTYPE_CNT
#undef ENCTYPE_CNT
#endif 
#define ENCTYPE_CNT             14

#ifdef	ENCRYPT_NAMES
char *encrypt_names[] = {
	"IS", "SUPPORT", "REPLY", "START", "END",
	"REQUEST-START", "REQUEST-END", "ENC-KEYID", "DEC-KEYID",
	0,
};
char *enctype_names[] = {
    "ANY", "DES_CFB64",  "DES_OFB64", 
    "UNKNOWN-3", "UNKNOWN-4", "UNKNOWN-5", "UNKNOWN-6", "UNKNOWN-7", 
    "CAST5_40_CFB64", "CAST5_40_OFB64", 
    "CAST128_CFB64", "CAST128_OFB64", 
    "BLOWFISH_CFB64", "BLOWFISH_OFB64",
    0,
};
#else
extern char *encrypt_names[];
extern char *enctype_names[];
#endif


#define	ENCRYPT_NAME_OK(x)	((unsigned int)(x) < ENCRYPT_CNT)
#define	ENCRYPT_NAME(x)		encrypt_names[x]

#define	ENCTYPE_NAME_OK(x)	((unsigned int)(x) < ENCTYPE_CNT)
#define	ENCTYPE_NAME(x)		enctype_names[x]

#endif /*KRB5_KERMIT_H*/
