static char     host_rcsid[] = "$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  host.c,v
 * Revision 1.2  1994/11/28  16:54:58  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.3  1994/08/21  02:57:28  raju
 * *** empty log message ***
 *
 *
 **********************************************************/

#include "globals.h"

static Widget           host_popup;
static Widget           widget_hostrc;
static Widget           widget_hostlabel;
static Widget           widget_hostframe;
static Widget           widget_hostmenu;
static Widget           widget_hostmain;
static Widget           widget_hostexec;
static Widget           widget_hostclear;
static Widget           widget_hostclose;
static Widget           widget_hostseparator;
static Widget           widget_hostopt;

struct optionstruct hostmenu[]={
  0,"Cell     ","-cell",MENUTYPE,NULL,NULL,
  0,"Add         ","-ah",ACTIONTYPE,NULL,NULL,
  0,"Delete      ","-dh",ACTIONTYPE,NULL,NULL,
  0,"Host Name",NULL,MENUTYPE,NULL,NULL,
  0,"Show Hosts  ","-sh",ACTIONTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_hostexec - Activate callback for exec
 */
XtCallbackProc pb_hostexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char          command[MAX_STRING_SIZE];
  
  sprintf(command,"%s -cell %s",QCONF_BINARY,current_cell);
  buildcommand(command,hostmenu,0);
}


/***********************************************************
 * pb_hostclear - Activate callback for clear
 */
XtCallbackProc pb_hostclear(Widget w,caddr_t client_data,caddr_t call_data)
{
int ii;
  Arg args[5];

  QmonTextSetString(hostmenu[0].widgetid ,current_cell );
  if(host_list) 
  	QmonTextSetString(hostmenu[3].widgetid ,host_list->name );
/*
  clearsubmenu(hostmenu);
*/
}


/***********************************************************
 * pb_hostclose - Activate callback for close
 */
XtCallbackProc pb_hostclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * hostaction - Activate callback for action type menu
 */
XtCallbackProc hostaction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];
  char            *ptr=NULL;
  char            *ptr1=NULL;

  ptr=QmonTextGetString(hostmenu[3].widgetid);
  ptr1=QmonTextGetString(hostmenu[0].widgetid);

  if(w==hostmenu[1].widgetid) {
    sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,hostmenu[1].flag,ptr);
  }
  else if(w==hostmenu[2].widgetid) {
    sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,hostmenu[2].flag,ptr);
  }
  else if(w==hostmenu[4].widgetid) {
    sprintf(command,"%s -cell %s %s &",QCONF_BINARY,ptr1,hostmenu[4].flag);
  }

  execit(command);
}


/***********************************************************
 * create_host_dialog - Create widgets used for the host menu
 */
void create_host_dialog(Widget w,XtPointer client_data,XtPointer  call_data)
{
  int             ii;
  Arg             args[32];
  Widget        host_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close;

  hostmenu[0].list = cell_list;
  hostmenu[3].list = host_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);


  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  host_popup = XtCreatePopupShell("hostpop", transientShellWidgetClass, w,
                             args, ii);
  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  host_form = XtCreateManagedWidget("form", formWidgetClass, host_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_hostlabel=
        XtCreateManagedWidget("Configure Host",labelWidgetClass,host_form,args
,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_hostlabel); ii++;
  widget_hostmain=XtCreateManagedWidget("box",formWidgetClass,host_form,
                                        args,ii);

/*
 exec=QmonAddButtonN(widget_hostmain,NULL,"Exec",pb_hostexec,NULL);
*/
 clear=QmonAddButtonN(widget_hostmain,NULL,"Reset",(XtCallbackProc)pb_hostclear,NULL);
 close=QmonAddButtonN(widget_hostmain,clear,"Close",(XtCallbackProc)pb_hostclose,NULL);

widget_hostopt=createmenuoptions(host_form,widget_hostmain,hostmenu,(XtCallbackProc)hostaction);

}


/***********************************************************
 * openwidget_hostsub - Open the host menu
 */
void openwidget_hostsub()
{
  pb_hostclear(NULL,NULL,NULL);
  XtPopup(host_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_hostsub - Close the host menu
 */
void closewidget_hostsub()
{
  XtPopdown(host_popup);
}
