static char struct_rcsid[]="$Id: struct.h,v 1.1.1.1 1997/04/10 15:10:35 green Exp $";

/*----------------------------------------------------
 * struct.h Tom Green Mon Jan 31 10:44:31 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: struct.h,v $
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.17  1996/08/26 14:21:16  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.16  1996/03/17  00:58:04  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.15  1996/03/14  03:16:59  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.14  1996/03/12  17:13:04  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.12  1996/02/07  13:08:30  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.11  1996/01/19  20:59:28  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.10  1995/06/21  16:58:07  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.9  1995/03/05  03:47:57  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.8  1995/02/06  16:32:00  nrl
 * Added "account" info to rusage structure and to the "acc_file"
 * for analysis by user.
 *
 * Revision 3.7  1994/08/02  23:11:14  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.6  1994/06/12  04:45:41  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.5  1994/06/12  03:57:45  green
 * added Kings's dqs_read_stats() and dqs_stats_type
 *
 * Revision 3.4  1994/06/05  16:53:57  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.3  1994/06/04  14:55:00  green
 * added the variable "job->parallel_package"
 *
 * Revision 3.2  1994/06/03  00:25:52  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.1  1994/04/01  02:59:39  green
 * added "qalter" support
 *
 * Revision 3.0  1994/03/07  04:15:27  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:52  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
typedef char string[MAX_STRING_SIZE];

/*--------------------------------------------------------------*/

struct meel {

    /* Process-specific quantities */
    char        *Version;                 /* for backward compatability */
    char        *dqs_formal_prog_name;
    char        *qualified_prog_name;
    char        *unqualified_prog_name;
    char        *qualified_hostname;
    char        *unqualified_hostname;
    u_long32    who;
    u_long32    pid;
    u_long32    ppid;
    u_long32    pgrp;
    u_long32    uid;
    u_long32    euid;
    u_long32    gid;
    u_long32    egid;
    u_long32    *grpptr;
    u_long32    ngroups;
    u_long32    daemonized;
    char        *user_name;
    char        *default_cell;
    char        *default_editor;
    
    /* System-specific quantities */
    u_long arg_max;                     /* max size of argv[] & envp[] */
    u_long child_max;                   /* max number of processes per UID */
    u_long clock_tick;                  /* clock ticks per second */
    u_long job_control;                 /* job control supported [Boolean] */
    u_long ngroup_max;                  /* max number of concurrent groups */
    u_long open_max;                    /* max number of open files/process */
    u_long saved_ids;                   /* saved IDs supported [Boolean] */
    u_long posix_version;               /* version of the POSIX std supported */

    /* POSIX version-dependent quantities */
    u_long exit_sighup;                 /* SIGHUP children if process group */
                                        /* leader exits [Boolean] */
    u_long pid_max;                     /* maximum process ID */
    u_long uid_max;                     /* maximum user ID */

    char     *DQSX_STR106;
    char     *DQSX_STR107;
    char     *DQSX_STR108;
    char     *DQSX_STR109;
    char     *DQSX_STR1010;
    u_long32 DQSX_INT106;
    u_long32 DQSX_INT107;
    u_long32 DQSX_INT108;
    u_long32 DQSX_INT109;
    u_long32 DQSX_INT1010;

  };

typedef struct meel dqs_me_type;

/*--------------------------------------------------------------*/
/* These are the dynamically alterable components of the config */
/* via CONF_FILE or qconf IFF !STATIC_CONFIGURATION             */

struct confel {                         /* cluster configuration parameters */
    char        *Version;               /* for backward compatability */
    char        *qmaster_spool_dir;      /* qmaster spool directory path */
    char        *execd_spool_dir;        /* dqs_spool directory base path */
    char        *default_cell;           /* default cell */
    u_long32    reserved_port;           /* use reserved ports */
    char        *qmaster_service;        /* as per /etc/services */
    char        *dqs_execd_service;      /* as per /etc/services */
    char        *intercell_service;     /* as per /etc/services */
    char        *klog;                   /* "klog" to use for re-authing */
    u_long32    reauth_time;             /* how often to re-auth */
    char        *mailer;                 /* path to e-mail delivery agent */
    char        *dqs_bin;                /* path to the DQS binaries */
    char        *administrator;          /* e-mail address of cluster admin */
    char        *default_account;        /* default DQS account if none supplied */
    u_long32    min_gid;                /* lower bound on GIDs that can qsub */
    u_long32    min_uid;                /* lower bound on UIDs that can qsub */
    u_long32    maxujobs;               /* limit on max running jobs per user */
    u_long32    output_handling;         /* linked or copying of output files  */
    char        *addon_script;          /* additional scripting file  */
    char        *addon_info;             /* additional information script */    
    u_long32    user_access;            /* cluster access control */
    u_long32    default_rerun;          /* default rerun setting if no -r */
    u_long32    sort_seq_no;            /* use seq_no to sort else use load */
    u_long32    sync_io;                /* to O_SYNC or not O_SYNC */
    u_long32    loglevel;               /* qmaster event logging level */
    u_long32    logfacility;            /* qmaster event logging facility */
    u_long32    load_log_time;          /* how often to send in load */
    u_long32    stat_log_time;          /* how often to log stats */
    u_long32    schedule_time;          /* how often to attemt to schedule */
    u_long32    max_unheard;            /* how long before dqs_execd considered dead */
    u_long32    logmail;                /* qmaster event logging via e-mail */
    u_long32    alarms;                 /* short timeout */
    u_long32    alarmm;                 /* medium timeout */
    u_long32    alarml;                 /* long timeout */
    char        *DQSX_STR1;
    char        *DQSX_STR2;
    char        *DQSX_STR3;
    char        *DQSX_STR4;
    char        *DQSX_STR5;
    u_long32    DQSX_INT1;
    u_long32    DQSX_INT2;
    u_long32    DQSX_INT3;
    u_long32    DQSX_INT4;
    u_long32    DQSX_INT5;
  };
typedef struct confel dqs_conf_type;

/*--------------------------------------------------------------*/

struct drusage {
	    char     *Version;       /* for backward compatabiity  */
        char     *qname;
        char     *hostname;
        u_long32 master;
        char     *group;
        char     *owner;
        char     *job_name;
        char     *dqs_job_name;
        char     *account;
        u_long32 priority;
        u_long32 job_number;
    u_long32 submission_time;
        u_long32 start_time;
        u_long32 end_time;
        u_long32 exit_status;
        u_long32 ru_wallclock;  
        u_long32 ru_utime;      /* user time used */
        u_long32 ru_stime;      /* system time used */
        u_long32 ru_maxrss;
        u_long32 ru_ixrss;      /* integral shared text size */
        u_long32 ru_ismrss;     /* integral shared memory size*/
        u_long32 ru_idrss;      /* integral unshared data " */
        u_long32 ru_isrss;      /* integral unshared stack " */
        u_long32 ru_minflt;     /* page reclaims */
        u_long32 ru_majflt;     /* page faults */
        u_long32 ru_nswap;      /* swaps */
        u_long32 ru_inblock;    /* block input operations */
        u_long32 ru_oublock;    /* block output operations */
        u_long32 ru_msgsnd;     /* messages sent */
        u_long32 ru_msgrcv;     /* messages received */
        u_long32 ru_nsignals;   /* signals received */
        u_long32 ru_nvcsw;      /* voluntary context switches */
        u_long32 ru_nivcsw;     /* involuntary " */
        char     *DQSX_STR6;
        char     *DQSX_STR7;
        char     *DQSX_STR8;
        char     *DQSX_STR9;
        char     *DQSX_STR10;
        u_long32 pid;
        u_long32 DQSX_INT7;
        u_long32 DQSX_INT8;
        u_long32 DQSX_INT9;
        u_long32 DQSX_INT10;
};

typedef struct drusage dqs_rusage_type;

/*--------------------------------------------------------------*/

struct stats
{
        u_long32 time;
        char hostname[MAX_STRING_SIZE];
        char qname[MAX_STRING_SIZE];
        u_long32 load_avg;
        u_long32 qty;
        u_long32 qty_active;
        char states[MAX_STRING_SIZE];
   };

typedef struct stats dqs_stats_type;

/*--------------------------------------------------------------*/

struct job_element 
{
        /* misc setup variables */
        u_long32         job_number;
        char			 *Version;       /* for backward compatability */
        char             *dqs_job_name;
        char             *job_file;
        char             *exec_file;
        u_long32         status;
        u_long32         submission_time;
        u_long32         start_time;
        u_long32         end_time;
        char             *owner;
        u_long32         uid;
        u_long32         euid;
        u_long32         jobs_per_user;
        /* env variables to be captured as per P1003.15D11 */
        char             *dqs_o_home;
        char             *dqs_o_log_name;
        char             *dqs_o_path;
        char             *dqs_o_mail;
        char             *dqs_o_shell;
        char             *dqs_o_tz;
        char             *dqs_o_workdir;
        char             *dqs_o_host;

        /* options */
        u_long32         execution_time;            /* "-a date_time" specifies time availability of job(qalter,qsub) */
        u_long32         execution_time_op;         /* "-a [op]date_time" selects jobs relative to date(qselect) */
        struct listel    *account_list;             /* "-A account_string" specifies account to run job(qalter,qsub) */
                                                    /* "-A account_string" selects jobs relative to account_string(qselect) */
        u_long32         server_name;               /* "-B" specifies operand is a server string(qstat) */  
        u_long32         checkpoint_attr;           /* "-c interval" specifies checkpoint attributes(qalter,qsub) */
        u_long32         checkpoint_attr_op;        /* "-c [op]interval" restricts selection to intervals(qselect) only */
        u_long32         checkpoint_interval;       /* "-c minutes" specifies checkpoint frequency(qalter,qsub) */
        char             *cell;                     /* "-cell cell_name" specifies cell(ALL COMMANDS) */
                char             *cwd;                      /* "-cwd" use current working directory */
        char             *directive_prefix;         /* "-C directive_prefix" specifies the comment directive prefix(qsub) */
        struct listel    *stderr_path_list;         /* "-e path_name" stderr stream path (qsub,qalter) */
        struct listel    *exec_list;                /* "-exec path_name" specifies binary to be executed (qsub,qsh) */
        u_long32         send_msg_to_stderr;        /* "-E" specifies message to be sent to stderr(qmsg) */
        u_long32         full_listing;              /* "-f" specifies full format display(qstat) */
        u_long32         force_submission;          /* "-F  forces submission of jobs regardless of resource existence*/        
        struct listel    *group_list;               /* "-G group" specifies group list(qsub) */
        u_long32         hold;                      /* "-h hold_list" specifies hold list(qalter,qhold,qrls */
        u_long32         merge_stderr;              /* "-j y|n" merge stderr into stdout(qalter,qsub) */
        u_long32         maint_local_output;        /* "-k keep" keep output on execution host(qalter,qsub) */
        struct listel    *hard_resource_list;       /* "-l resource_list" resource limits or restrictions */
        struct listel    *soft_resource_list;       /* "-l resource_list" resource limits or restrictions */
        u_long32         mail_options;              /* "-m mail_options" mail options(qalter,qsub) */
        struct listel    *hard_master_list;         /* "-master queue_name" specifies master queue(qsub) */
        struct listel    *soft_master_list;         /* "-master queue_name" specifies master queue(qsub) */
        struct listel    *mail_list;                /* "-M mail_list" list of mail recipiants(qalter,qsub) */
                u_long32         notify;                    /* "-notify" notify job of impending SIGKILL/SIGSTOP */
        char             *job_name;                 /* "-N job_name" specifies name of job(qalter,qsub) */
                                                    /* "-N job_name" restricts selection of jobs(qselect) */
        struct listel    *stdout_path_list;         /* "-o path_name" specifies pathname for stdout(qalter,qsub) */
        u_long32         send_msg_to_stdout;        /* "-O" message to be sent to stdout(qmsg) */
        u_long32         priority;                  /* "-p priority" Specifies job priority(qalter,qsub) */

        u_long32         priority_op;               /* "-p [op]priority" restricts jobs relative to op(qselect) */
                u_long32         passwd;                   /* "-passwd" sets reauth passwd */
                struct listel    *passwd_list;              /* DES could encrypt first field to a NULL - ergo we gotta do it this way */
                char             *Passwd;                   /* "-Passwd fname" sets reauth passwd file */
        struct listel    *hard_queue_list;          /* "-q destination_identifier" specifies a queue(qsub) */
        struct listel    *soft_queue_list;          /* "-q destination_identifier" restricts to a queue(qselect) */
        u_long32         op_is_destin_id;           /* "-Q" specifies that the operand is a destination id(qstat) */
                u_long32         reauth_time;               /* "-reautht #secs" specifies how often to reauth AFS tokens */
        u_long32         restart;                   /* "-r y|n" specifies if a job can be rerun(qalter,qsub) */
                                                    /* "-r y|n" restricts a job based on rerun(qselect) */
        u_long32         states;                    /* "-s states" restricts selection to jobs in specified states(qselect) */
        u_long32         signal;                    /* "-s signal" speifies the signal to be sent to a job(qsig) */
        struct listel    *shell_list;               /* "-S shell" specifies the interpretting shell(qalter,qsub) */
        struct listel    *user_list;                /* "-u user_list" specifies the user name under which a job is to run(qalter,qsub) */
                                                    /* "-u user_list" specifies the access list for job submitted to new loc(qmove) */
                                                    /* "-u user_list" restricts selection to pertinant jobs(qselect) */
                u_long32         unlog;                     /* "-ul" unlog AFS tokens at job reap time */
        struct listel    *variable_list;            /* "-v variable_list" specifies environmental variables to be exportred(qsub) */
        u_long32         verify;                    /* "-verify" specifies print out of options(ALL commands) */
        struct listel    *env_list;                 /* "-V" specififies exportation of all environmental variables(qsub) */
        u_long32         silent;                    /* "-z" specifies not to write job id to stdout(qsub) */

        struct listel    *destin_identifier_list;
        struct listel    *granted_destin_identifier_list;
        struct listel    *consumable_resources_used;
                struct listel    *job_identifier_list;
                char             *message;
                u_long32         script_size;
                char             *script_file;
                char             *script_ptr;
                struct listel    *srvr_nm_list;
        
        char             *master_queue;
        char             *master_queue_exec_str;
        char             *DQSX_STR13;
        char             *DQSX_STR14;
        char             *DQSX_STR15;
        u_long32         ext;
        u_long32         state;
        u_long32         clean;
        u_long32         parallel_package;
        u_long32         scheduling_flags;
            u_long32             subpriority;
            u_long32             schedule_seq_num;
        struct listel    *jid_hold_list;
        struct listel    *job_status_info;
        struct listel    *DQSX_L13;
        struct listel    *DQSX_L14;
        struct listel    *DQSX_L15;
                struct listel    *invalid_destin_identifier_list;

        /* misc variables */
        u_long32             pid;
        u_long32             pvm_pid;
        u_long32             sig_time;
        u_long32             sig;
        u_long32             notified;
        u_long32             suitable;
                u_long32             pending_signal;               
                u_long32             pending_signal_delivery_time; 
                u_long32             reauth_gmt;                   
                u_long32             soft_wallclock_gmt;           
                u_long32             hard_wallclock_gmt;           
        char                 *machine;
        struct listel        *script_argv_list;
        /* used by qmod */
                u_long32             suspend_enable;
        u_long32             soc_xsoc;
        u_long32             force;
};

typedef struct job_element dqs_job_type;

/*--------------------------------------------------------------*/
/*              DQS 3.1.3   queue elelemnt                      */
/*--------------------------------------------------------------*/

struct queueel {
	    char             *Version;              /* for backward compatability*/
        char             *qname;                /* name of Q */
        char             *qhostname;            /* qualified hostname */
        char             *hostname;             /* unqualified hostname */
        char             *tmpdir;               /* temporary WD */
        char             *shell;
    char             *klog;
    char             *DQSX_STR22;
    char             *DQSX_STR23;
    char             *DQSX_STR24;
    char             *DQSX_STR25;
        u_long32         seq_no;                /* sequence # for use by qmon */
        u_long32         load_massage;          /* load average massage constant */
    u_long32         load_alarm;            /* alarm at load average */
        u_long32         priority;              /* job priority */
        u_long32         rerun;                 /* restart a job */
    u_long32         qtype;                 /* BATCH, INTERACTIVE, BI */
    u_long32         qty;                   /* number of said queues */
        u_long32         qty_active;            /* number of said queues with active jobs */
        u_long32         s_rt;                  /* soft real time */
        u_long32         h_rt;                  /* hard real time */
        u_long32         s_cpu;                 /* soft cpu */
        u_long32         h_cpu;                 /* hard cpu */
        u_long32         s_fsize;               /* soft file size */
        u_long32         h_fsize;               /* hard file size */
        u_long32         s_data;                /* soft data size */
        u_long32         h_data;                /* hard data size */
        u_long32         s_stack;               /* soft stack size */
        u_long32         h_stack;               /* hard stack_size */
        u_long32         s_core;                /* soft core fsize */
        u_long32         h_core;                /* hard core fsize */
        u_long32         s_rss;                 /* soft ressident set size */
        u_long32         h_rss;                 /* hard ressident set size */
        u_long32         status;                /* Q status */
    u_long32         prev_status;
        u_long32         *load_avg_ptr;         /* ptr to last reported load average * 100 */
        u_long32         load_avg;
        u_long32         alive;                 /* active queue? */
        u_long32         *lt_heard_from_ptr;    /* last time load sent in */
    u_long32         lt_heard_from;
    u_long32         soc;                   /* susp on completion of current job */
    u_long32         master;
        u_long32         dirty;
    u_long32         reauth_time;
    u_long32         state;
        u_long32         notify;                /* seconds to notify job before SIGKILL/SIGSTOP */
    u_long32         last_user_delay;    /* seconds before same user can use queue */
    u_long32             max_user_jobs;      /* maximum jobs oper user for this queue */    
    u_long32         DQSX_INT25;
        struct listel    *acl;                   /* valid user linked list */
        struct listel    *xacl;                  /* excluded user list */
    struct listel    *owner_list;            /* list of "owners" */
    struct listel    *subordinate_list;      /* string containing list of subordinate Qs */
    struct listel    *q_activation_list;     /* minute Q de-activated */
        struct listel    *complex_list;
        struct listel    *job_list;
    struct listel    *last_user;      /* info on last user of this queue */
    struct listel    *consumables;   /* licenses memory and storage */
    struct listel    *DQSX_L23;
    struct listel    *DQSX_L24;
    struct listel    *DQSX_L25;

        /* the following are ephemeral in nature - don't pack them */
        u_long32         suitable;
    u_long32         tagged;
        u_long32         hard_master_tagged;
    u_long32         hard_destin_id_tagged;
    u_long32         hard_resource_tagged;
    u_long32         soft_master_tagged;
    u_long32         soft_destin_id_tagged;
    u_long32         soft_resource_tagged;
        u_long32         suitability_level;

};

typedef struct queueel dqs_queue_type;

/*--------------------------------------------------------------*/

struct  hashel
{
     char          *cp;
     char          *vp;
     u_long32      *load_avg_ptr;
     u_long32      *lt_heard_from_ptr;
     struct hashel *next;
};

typedef struct hashel dqs_hash_type;

/*--------------------------------------------------------------*/

struct  listel { 
        u_long32           who;
        u_long32           type;
        u_long32           status;
        u_long32           int0;
        u_long32           int1;
        u_long32           int2;
        u_long32           int3;
        u_long32           bufsize;
        char               *user;
        char               *str0;
        char               *str1;
        char               *str2;
        char               *str3;
        char               *buf;
        dqs_rusage_type    *rusage;
        dqs_queue_type     *queue;
        dqs_conf_type      *conf;
        dqs_job_type       *job;
        dqs_me_type        *me;
        struct listel      *chain;
        struct listel      *tid;
        struct listel      *next;
      };

typedef struct listel dqs_list_type;

