static char qsub_rcsid[]="$Id: qsub.c,v 1.4 1997/04/12 16:27:56 green Exp $";

/*----------------------------------------------------
 * qsub.c Tom Green Mon Jan 31 10:43:12 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: qsub.c,v $
 * Revision 1.4  1997/04/12 16:27:56  green
 * forgot to type cast rindex().  some compilers actually die rather than
 * giving a warning on such...(jeeze, you'd think it was Pascal or sumtin)
 *
 * Revision 1.3  1997/04/11 16:05:25  green
 * ooops, typo in previous commit
 *
 * Revision 1.2  1997/04/11 15:10:44  green
 * applied patch to truncate job_name(thanks to Tim W. James for pointing
 * this bug out).  Bug affects delivery of signals to jobs(don't ask why...)
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.12  1996/08/16 17:44:45  nrl
 * Added SETEUID macro to def.h to provide differentiation
 * for HP from the rest of the pack.
 *
 * Revision 3.11  1996/07/19  16:30:49  nrl
 * Added changes from Richard Friezel to handle qsub execution
 * for a user whose cwd is not in a NFS subdirectory accessbile
 * by root.
 *
 * Revision 3.10  1996/07/18  11:40:23  nrl
 * fixed a "double scan" problem in dqs_parse.c with a misplaced
 * continue statement. Qsub Was SegVing on LINUX system because
 * of the use of dqs_free_job. LINUX heap management is obviously not
 * compliant with UNIX standards.
 *
 * Revision 3.9  1996/07/14  14:59:29  nrl
 * Added DEFINES and INCLUDES to GNU configure output
 *
 * Revision 3.8  1996/06/27  01:56:21  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.7  1996/03/22  04:21:51  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.6  1995/06/16  15:35:28  nrl
 * eliminated the need to have a "qty.eq.1" in the default cases
 * fixed the "-notify" option when used with suspend queue function
 *
 * Revision 3.5  1995/02/22  14:29:55  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.4  1995/01/24  21:05:11  nrl
 * made changes to plug memory leaks and to complete the suspend
 * on completion function.
 *
 * Revision 3.3  1994/11/14  14:18:07  green
 * qsub was adding a newline when data was piped in - added patch
 * supplied by Francois MORRIS
 *
 * Revision 3.2  1994/06/19  18:48:25  green
 * handle embedded quotes
 *
 * Revision 3.1  1994/06/12  03:45:30  green
 * mods to dqs_send_receive_list() necessitated for the support of
 * moving dshd into dqs_execd required propagation to all ancillaries.
 * (eg: return value of dqs_send_receive_list() was modified...)
 *
 * Revision 3.0  1994/03/07  04:15:23  green
 * 3.0 freeze
 *
 * Revision 1.3  1994/03/04  16:35:50  green
 * added a sanity check to make sure the user requested some sort of
 * resources - this needs to be cleaned up and push a default_q/
 * default_resource onto the list in such cases.
 *
 * Revision 1.2  1994/02/24  18:11:41  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.1.1.1  1994/02/01  17:57:51  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

void dqs_strip_quotes();

/************************************************************************/

main(argc, argv,envp)
int argc;
char **argv;
char **envp;

{

     int              i;
     int              sfd;
     char             c;
     char             *tp;
     int              tpi;
     string           str;
     FILE             *fp;
     dqs_list_type    *argv_list=(dqs_list_type *) NULL;
     dqs_list_type    *head=(dqs_list_type *) NULL;
     dqs_list_type    *resp=(dqs_list_type *) NULL;
     dqs_list_type    listel;
     dqs_list_type    *listel_ptr;
     dqs_list_type    *tmp_ptr=NULL;
     dqs_list_type    *tmp_ptrX=NULL;
     int              str_len;       /* added FM */
     int              uid, euid;
     
     DENTER_MAIN((DQS_EVENT,"qsub"));

     uid = getuid();
     euid = geteuid();

     SETEUID(uid);
               
     
     dqs_setup(QSUB,argv[0]);
     dqs_setup_sig_handlers();     

     bzero((char *)&listel,sizeof(listel));

     argv_list=dqs_args2list(++argv,argc);
     listel.job=dqs_parse_job(argv_list,envp);

     if (listel.job->script_file) 
     {
	  fp=fopen(listel.job->script_file,"r");
	  if (fp==NULL) 
	  {
	       ERROR((DQS_EVENT,"DQS_ERROR_0566 error opening %s\n",listel.job->script_file));
	       exit(-1);
	  }
     }
     else
     {
	  fp=stdin;
     }

     if (!listel.job->directive_prefix)
     listel.job->directive_prefix=dqs_string_insert( (char *)NULL,"#$");

     bzero((char *)str,sizeof(str));

     while (fgets(str,MAX_STRING_SIZE,fp))
     {

         /* start of addition Francois Morris <morris@rubis.lmcp.jussieu.fr> */
         /* we delete an ending NEW-LINE character since dqs_concat_buf
                adds one. */
         str_len = strlen (str);
         if (str_len >  0)
         {
                  if (str[str_len - 1] == '\n')
              {
                       str[str_len - 1] = '\0';
              }
         }
         /* end of addition FM */

	  listel.job->script_ptr=dqs_concat_buf(listel.job->script_ptr,str,&listel.job->script_size);
	  if (strncmp(str,listel.job->directive_prefix,strlen(listel.job->directive_prefix)))
	  {
	       bzero((char *)str,sizeof(str));
	       continue;
	  }
	  i=strlen(str);
	  /* i--; deleted FM */
	  str[i]='\0';
	  tmp_ptr=dqs_string2list(str);
	  dqs_strip_quotes(tmp_ptr);
	  tmp_ptr=dqs_delete_head(tmp_ptr);
	  while (tmp_ptr) 
	  {
	       argv_list=dqs_insert(DQS_STR0,TAIL,argv_list,tmp_ptr);

	       tmp_ptrX=tmp_ptr->next;
               FREE(tmp_ptr);
               tmp_ptr=tmp_ptrX;
	  }
	  bzero((char *)str,sizeof(str));
     }


     DPRINTF((DQS_EVENT,"\n=========================================\n"));
     DPRINTF((DQS_EVENT,"%s",listel.job->script_ptr));
     DPRINTF((DQS_EVENT,"\n=========================================\n"));

     tp=listel.job->script_ptr;
     tpi=listel.job->script_size;

/* this is BAD programming practice but since the previous string resides
only during qsub execution we can get away with it. There used to de a
dqs_free_job call here but LINUX has a serius HEAP problem and this
causes a SEGV for some LINUX  */

     listel.job=dqs_parse_job(argv_list,envp);
     listel.job->script_ptr=tp;
     listel.job->script_size=tpi;
     
     if (!listel.job->script_file)
     {
          listel.job->script_file=dqs_string_insert( (char *)NULL,"STDIN");
     }

     if (!listel.job->job_name)
     {
          char *tmp_ptr;
	  sprintf(str,"%s",listel.job->script_file);
	  tmp_ptr=(char *)rindex(str,'/');
	  if (tmp_ptr)
	    listel.job->job_name=dqs_string_insert( (char *)NULL,++tmp_ptr);
	  else
	    listel.job->job_name=dqs_string_insert( (char *)NULL,str);
     }

     if (listel.job->hold)
     listel.job->state=HELD;

     if (listel.job->verify)
     {
          dqs_show_job(listel.job);
          exit(0);
     }

     dqs_get_passwd_info(listel.job);   

     listel.type=QSUB;
     listel.int0=QSUB;

/* THIS IS A LAST MINUTE HACK!
   need to push default_q/default_group
 */

     if ((!listel.job->hard_resource_list)&&(!listel.job->soft_resource_list)
	 && (!listel.job->hard_master_list)&&(!listel.job->soft_master_list)
	 && (!listel.job->hard_queue_list)&&(!listel.job->soft_queue_list))
     {
     	/*   force default  of at least qty.eq.1   */
        dqs_parse_resource_list(&listel.job->hard_resource_list,"qty.eq.1");
     }
     SETEUID(euid);
     if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
     {
          DEXITE;
          exit(DQS_EAGAIN);
     }

     dqs_show_acknak_list(resp);

     DEXIT;
     exit(resp->int0);
     
} 

/************************************************************************/
void dqs_strip_quotes(head)
dqs_list_type *head;

{

     int           i=0;
     char          *cp;
     string        str;

     DENTER((DQS_EVENT,"dqs_strip_quotes"));

     while (head)
     {
	  if (!head->str0)
	  {
	       head=head->next;
	       continue;
	  }
	  bzero((char *)str,sizeof(str));
	  cp=head->str0;
	  i=0;
	  while (cp[0])
	  { 
	       if ((cp[0])!='"')
	       str[i++]=cp[0];
	       cp++;
	  }
	  head->str0=dqs_string_insert(head->str0,str);
	  head=head->next;
     }
     DEXIT;
     return;

}
