
/* shameless stolen from netscape :-) */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>    /* for XmuClientWindow() */

static Window
find_window(Display * dpy, Atom atom)
{
    int             i;
    Window          root = RootWindowOfScreen(DefaultScreenOfDisplay(dpy));
    Window          root2, parent, *kids;
    unsigned int    nkids;
    Window          result = 0;

    if (!XQueryTree(dpy, root, &root2, &parent, &kids, &nkids)) {
        fprintf(stderr, "XQueryTree failed on display %s\n",
                DisplayString(dpy));
        exit(2);
    }

    if (!(kids && nkids)) {
        fprintf(stderr, "root window has no children on display %s\n",
                DisplayString(dpy));
        exit(2);
    }
    for (i = nkids - 1; i >= 0; i--) {
        Atom            type;
        int             format;
        unsigned long   nitems, bytesafter;
        unsigned char  *args = NULL;

        Window          w = XmuClientWindow(dpy, kids[i]);

        XGetWindowProperty(dpy, w, atom,
                           0, (65536 / sizeof(long)),
                           False, XA_STRING,
                           &type, &format, &nitems, &bytesafter,
                           &args);

        if (!args)
            continue;
	printf("xawtv window   : 0x%08lx\n",w);
	printf("current station: ");
	for (i = 0; i < nitems; i += strlen(args + i) + 1)
	    printf("%s ", args + i);
	printf("\n");
        XFree(args);

        result = w;
        break;
    }
    return result;
}

void
pass_cmd(Display *dpy, Atom atom, Window win, int argc, char **argv)
{
    int             i, len;
    char           *pass;

    printf("passing command: ");
    for (len = 0, i = 0; i < argc; i++) {
	printf("%s ",argv[i]);
        len += strlen(argv[i]) + 1;
    }
    printf("\n");
    pass = malloc(len);
    pass[0] = 0;
    for (len = 0, i = 0; i < argc; i++)
        strcpy(pass + len, argv[i]),
            len += strlen(argv[i]) + 1;
    XChangeProperty(dpy, win,
                    atom, XA_STRING,
                    8, PropModeReplace,
                    pass, len);
    free(pass);
}

void
usage(char *argv0)
{
    char *prog;

    if (NULL != (prog = strrchr(argv0,'/')))
	prog++;
    else
	prog = argv0;

    fprintf(stderr,
"This is a \"remote control\" for xawtv\n"
"usage: %s [ command ]\n"
"\n"
"available commands:\n"
"    setstation name | nr\n"
"        Tune in some station from $HOME/.xawtv. Takes either name or the\n"
"        number (0 = first entry) of the config file entry as argument.\n"
"    setchannel name\n"
"        Tune in some channel.  Takes the channel number as argument\n"
"    volume mute | dec | inc | number\n"
"        number (range 0 - 65536) sets the volume, the other arguments\n"
"        (un)mute sound or increase/decrease volume\n"
"\n"
	    ,prog);

}

int
main(int argc, char *argv[])
{
    Display  *dpy;
    Window   win;
    Atom     station,remote;
    int      c;

    for (;;) {
	c = getopt(argc, argv, "h");
	if (c == -1)
	    break;
	switch (c) {
	case 'h':
	default:
	    usage(argv[0]);
	    exit(1);
	}
    }

    if (NULL == (dpy = XOpenDisplay(NULL))) {
	fprintf(stderr,"can't open display\n");
	exit(1);
    }
    station = XInternAtom(dpy, "_XAWTV_STATION", False);
    remote =  XInternAtom(dpy, "_XAWTV_REMOTE",  False);
    
    if (0 == (win = find_window(dpy,station))) {
	fprintf(stderr,"xawtv not running\n");
	exit(2);
    }
    if (argc > 1)
	pass_cmd(dpy, remote, win, argc-1, argv+1);
    XCloseDisplay(dpy);
    return 0;
}
