/*
 * channel editor.
 *
 *   (c) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <math.h>
#include <sys/time.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

#include "channel.h"
#include "channels.h"

/*-------------------------------------------------------------------------*/

void pixit();
void set_channel(struct CHANNEL *channel);
void channel_menu();

extern Widget   app_shell,conf_shell;
extern Display  *dpy;
extern Atom     wm_protocols[2];
extern int      debug;

Widget conf_channel, conf_name, conf_key, conf_list;

static Widget last_command, viewport;
static String *channel_list;

/*-------------------------------------------------------------------------*/

void conf_station_switched();

static void list_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    XawListReturnStruct *lr = call_data;

    pixit();
    cur_sender = lr->list_index;
    set_channel(channels[cur_sender]);
}

static void add_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    struct CHANNEL *channel;
    char *name,*key;

    XtVaGetValues(conf_name,XtNstring,&name,NULL);
    XtVaGetValues(conf_key,XtNlabel,&key,NULL);

    if (0 == strlen(name))
	return;

    channel = add_channel(name);
    channel->key = strdup(key);
    channel->channel = cur_channel;
    channel->fine = cur_fine;
    configure_channel(channel);
    channel_menu();
}

static void del_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    del_channel(cur_sender);
    channel_menu();
    cur_sender = -1;
    conf_station_switched();
}

static void modify_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    char *name,*key;

    XtVaGetValues(conf_name,XtNstring,&name,NULL);
    XtVaGetValues(conf_key,XtNlabel,&key,NULL);

    if (0 == strlen(name))
	return;

    free(channels[cur_sender]->name);
    channels[cur_sender]->name = strdup(name);

    if (channels[cur_sender]->key)
	free(channels[cur_sender]->key);
    if (0 != strlen(key)) 
	channels[cur_sender]->key = strdup(key);
    else
	channels[cur_sender]->key = 0;
    hotkey_channel(channels[cur_sender]);
    channel_menu();
    conf_station_switched();
}

static void save_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    save_config();
}

static void close_cb(Widget widget, XtPointer clientdata, XtPointer call_data)
{
    XtCallActionProc(conf_shell,"Config",NULL,NULL,0);
}

static void key_eh(Widget widget, XtPointer client_data,
		   XEvent *event, Boolean *cont)
{
    XKeyEvent *ke = (XKeyEvent*)event;
    KeySym sym;
    char *key;
    char line[64];

    sym = XKeycodeToKeysym(dpy,ke->keycode,0);
    if (NoSymbol == sym) {
	fprintf(stderr,"can't translate keycode %d\n",ke->keycode);
	return;
    }
    key = XKeysymToString(sym);

    line[0] = '\0';
    if (ke->state & ShiftMask)   strcpy(line,"Shift+");
    if (ke->state & ControlMask) strcpy(line,"Ctrl+");
    strcat(line,key);
    XtVaSetValues(conf_key,XtNlabel,line,NULL);
}

/*-------------------------------------------------------------------------*/

#define FIX_RIGHT_TOP       \
    XtNleft,XawChainRight,  \
    XtNright,XawChainRight, \
    XtNtop,XawChainTop,     \
    XtNbottom,XawChainTop

void create_confwin()
{
    Widget form, label, command;
    
    conf_shell = XtVaAppCreateShell("Config", "Xawtv",
				    topLevelShellWidgetClass,
				    dpy,
				    XtNclientLeader,app_shell,
				    NULL);
    form = XtVaCreateManagedWidget("form", formWidgetClass, conf_shell,
                                   NULL);

    /* list */
    viewport =
	XtVaCreateManagedWidget("viewport", viewportWidgetClass, form,
				XtNleft,XawChainLeft,
				XtNright,XawChainRight,
				XtNtop,XawChainTop,
				XtNbottom,XawChainBottom,
                                NULL);
    conf_list = 
	XtVaCreateManagedWidget("list", listWidgetClass, viewport,
                                NULL);
    XtAddCallback(conf_list,XtNcallback,list_cb,(XtPointer)NULL);

    /* Einstellungen */
    label =
	XtVaCreateManagedWidget("lchannel", labelWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                NULL);
    conf_channel =
	XtVaCreateManagedWidget("channel", labelWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, label,
                                NULL);
    label =
	XtVaCreateManagedWidget("lname", labelWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, conf_channel,
                                NULL);
    conf_name =
	XtVaCreateManagedWidget("name", asciiTextWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, label,
                                NULL);
    label =
	XtVaCreateManagedWidget("lkey", labelWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, conf_name,
                                NULL);
    conf_key =
	XtVaCreateManagedWidget("key", labelWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, label,
                                NULL);
    XtAddEventHandler(conf_key, KeyPressMask, False, key_eh, NULL);

    /* buttons */
    command =
	XtVaCreateManagedWidget("add", commandWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, conf_key,
                                NULL);
    XtAddCallback(command,XtNcallback,add_cb,(XtPointer)NULL);
    command =
	XtVaCreateManagedWidget("delete", commandWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, command,
                                NULL);
    XtAddCallback(command,XtNcallback,del_cb,(XtPointer)NULL);
    command =
	XtVaCreateManagedWidget("modify", commandWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, command,
                                NULL);
    XtAddCallback(command,XtNcallback,modify_cb,(XtPointer)NULL);
    command =
	XtVaCreateManagedWidget("save", commandWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, command,
                                NULL);
    XtAddCallback(command,XtNcallback,save_cb,(XtPointer)NULL);
    last_command = command =
	XtVaCreateManagedWidget("close", commandWidgetClass, form,
                                FIX_RIGHT_TOP,
                                XtNfromHoriz, viewport,
                                XtNfromVert, command,
                                NULL);
    XtAddCallback(command,XtNcallback,close_cb,(XtPointer)NULL);
}

void
ConfigAction(Widget widget, XEvent *event,
	     String *params, Cardinal *num_params)
{
    static int mapped = 0, first = 1;

    if (event && event->type == ClientMessage) {
	if (event->xclient.data.l[0] == wm_protocols[1]) {
	    if (debug)
		fprintf(stderr,"Config: wm_save_yourself\n");
	    XSetCommand(XtDisplay(conf_shell), XtWindow(conf_shell), NULL, 0);
	    return;
	}
    }

    if (mapped) {
	XtPopdown(conf_shell);
	mapped = 0;
    } else {
	XtPopup(conf_shell, XtGrabNone);
	mapped = 1;
	if (first) {
	    XSetWMProtocols(XtDisplay(conf_shell), XtWindow(conf_shell),
			    wm_protocols, 2);
	    first = 0;
	}
    }
}

/*-------------------------------------------------------------------------*/

void conf_station_switched()
{
    char line[128];

    /* channel */
    strcpy(line,tvtuner[cur_channel].name);
    if (cur_fine != 0)
	sprintf(line+strlen(line)," (%+d)",cur_fine);
    XtVaSetValues(conf_channel, XtNlabel, line, NULL);

    if (cur_sender == -1) {
	XtVaSetValues(conf_key, XtNlabel, "", NULL);
	XtVaSetValues(conf_name, XtNstring, "", NULL);
	XawListUnhighlight(conf_list);
    } else {
	if (channels[cur_sender]->key)
	    XtVaSetValues(conf_key,XtNlabel,channels[cur_sender]->key, NULL);
	else 
	    XtVaSetValues(conf_key,XtNlabel,"", NULL);
	XtVaSetValues(conf_name, XtNstring, channels[cur_sender]->name, NULL);
	XawListHighlight(conf_list,cur_sender);
    }
}

void conf_list_update()
{
    int i;
    
    if (channel_list)
	free(channel_list);

    XawListUnhighlight(conf_list);
    if (count) {
	/* rebuild list */
	channel_list = malloc((count+1)*sizeof(String));
	for (i = 0; i < count; i++)
	    channel_list[i] = channels[i]->name;
	channel_list[i] = NULL;
    } else {
	/* empty list */
	channel_list    = malloc(2*sizeof(String));
	channel_list[0] = "empty";
	channel_list[1] = NULL;
    }
    XtVaSetValues(conf_list,
		  XtNlist, channel_list,
		  XtNnumberStrings, 0,
		  NULL);
}
