/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 *
 * Window list
 */

#include "icewm.h"

#ifdef CONFIG_WINLIST

WindowListItem::WindowListItem(YFrameWindow *frame): YListItem() {
    fFrame = frame;
}

WindowListItem::~WindowListItem() {
    if (fFrame) {
        fFrame->setWinListItem(0);
        fFrame = 0;
    }
}

YFrameWindow *WindowListItem::frame() {
    return fFrame;
}

int WindowListItem::getOffset() {
    int ofs = 0;
    YFrameWindow *w = frame();

    while (w->owner()) {
        ofs += 20;
        w = w->owner();
    }
    return ofs;
}

unsigned char *WindowListItem::getText() {
    return frame()->client()->windowTitle();
}

YIcon *WindowListItem::getIcon() {
    return frame()->clientIcon();
}


WindowListBox::WindowListBox(YScrollBar *vert, YWindow *aParent, Window win = 0):
    YListBox(vert, aParent, win)
{
}

WindowListBox::~WindowListBox() {
}

void WindowListBox::activateItem(YListItem *item) {
    WindowListItem *i = (WindowListItem *)item;
    YFrameWindow *f = i->frame();
    if (f) {
        f->wmRaise();
        f->activate(true);
        windowList->frame()->wmHide();
    }
}

void WindowListBox::handleCommand(WMCommand command, void *context, unsigned int modifiers) {
    switch (command) {
    case cmdCascade:
    case cmdTileVertical:
    case cmdTileHorizontal:
        break;
    default:
        if (hasSelection()) {
            YListItem *i;

            for (i = getFirst(); i; i = i->getNext()) {
                WindowListItem *item = (WindowListItem *)i;
                if (i->getSelected()) {
                    if (command == cmdHide)
                        if (item->frame()->isHidden())
                            continue;
                    item->frame()->handleCommand(command, context, modifiers);
                }
            }
        }
    }
}

bool WindowListBox::handleKey(const XKeyEvent &key) {
    if (key.type == KeyPress) {
        KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
        int m = KEY_MODMASK(key.state);
        
        switch (k) {
        case XK_Escape:
            windowList->frame()->wmHide();
            return true;
        case XK_F10:
        case XK_Menu:
            if (k != XK_F10 || m == ShiftMask) {
                windowListPopup->popup(0, this, 0,
                                       key.x_root, key.y_root, -1, -1,
                                       YPopupWindow::pfCanFlipVertical |
                                       YPopupWindow::pfCanFlipHorizontal |
                                       YPopupWindow::pfPopupMenu);
            }
            break;
        case XK_Delete:
            {
                handleCommand(cmdClose, 0, key.state);
            }
            break;
        }
    }
    return YListBox::handleKey(key);
}

void WindowListBox::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (up.button == 3 && count == 1) {
        int no;
        YListItem *i = findItem(up.y, no);

        if (i) {
            if (i->getSelected() != 1) {
                selectItem(i);
            } else {
                //fFocusedItem = -1;
            }
            windowListPopup->popup(0, this, 0,
                                   up.x_root, up.y_root, -1, -1,
                                   YPopupWindow::pfCanFlipVertical |
                                   YPopupWindow::pfCanFlipHorizontal |
                                   YPopupWindow::pfPopupMenu);
        }
        return ;
    }
    return YListBox::handleClick(down, up, count);
}

WindowList::WindowList(YWindow *aParent, Window win): YFrameClient(aParent, 0, win) {
    scrollVert = new YScrollBar(YScrollBar::Vertical, this);
    scrollVert->show();
    list = new WindowListBox(scrollVert, this);
    list->show();

    int w = manager->width();
    int h = manager->height();
    
    setGeometry(w / 3, h / 3, w / 3, h / 3);

    windowList = this;
    setWindowTitle((unsigned char *)"Window list");
    setIconTitle((unsigned char *)"Window list");
    setWinStateHint(WinStateAllWorkspaces, WinStateAllWorkspaces);
    setWinWorkspaceHint(0);
    setWinLayerHint(WinLayerAboveDock);
}

WindowList::~WindowList() {
    delete list; list = 0;
    windowList = 0;
}

void WindowList::handleFocus(const XFocusChangeEvent &focus) {
    if (focus.type == FocusIn) {
        list->setFocus();
    } else if (focus.type == FocusOut) {
    }
}

void WindowList::relayout() {
    list->repaint();
}

WindowListItem *WindowList::addWindowListApp(YFrameWindow *frame) {
    if (frame->client() == windowList)
        return 0;
    WindowListItem *item = new WindowListItem(frame);
    if (item) {
        if (frame->owner() &&
            frame->owner()->winListItem())
        {
            list->addAfter(frame->owner()->winListItem(), item);
        } else {
            list->addItem(item);
        }
    }
    return item;
}

void WindowList::removeWindowListApp(WindowListItem *item) {
    if (item) {
        list->removeItem(item);
        delete item;
    }
}

void WindowList::configure(int x, int y, unsigned int width, unsigned int height) {
    YFrameClient::configure(x, y, width, height);

    scrollVert->setGeometry(width - SCROLLBAR_SIZE, 0,
                            SCROLLBAR_SIZE, height);
    list->setGeometry(0, 0, width - SCROLLBAR_SIZE, height);
}

void WindowList::handleClose() {
    frame()->wmHide();
}

void WindowList::showFocused() {
    YFrameWindow *f = manager->focus();

    if (f != frame()) {
        if (f)
            list->selectItem(f->winListItem());
        else
            list->selectItem(0);
    }
    if (frame() == 0)
        manager->mapWindow(handle());
    if (frame() != 0) {
        frame()->setLayer(WinLayerAboveDock);
        frame()->setState(WinStateAllWorkspaces, WinStateAllWorkspaces);
        frame()->activate(true);
    }
/*        show();
        raise();*/
}
#endif
