/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

ObjectMenu::ObjectMenu(YWindow *parent = 0): YMenu(parent) {
}

ObjectMenu::~ObjectMenu() {
}

void ObjectMenu::addObject(char *name, int cmd, YIcon *icon, void *context) {
    YMenu::YMenuItem *item =
        new YMenu::YMenuItem(name, -1, "", (WMCommand)cmd, 0, context);
    if (icon)
        item->setPixmap(icon->small());
    add(item);
}

void ObjectMenu::addSeparator() {
    YMenu::addSeparator();
}

void ObjectMenu::addContainer(char *name, YIcon *icon, ObjectContainer *container) {
    if (container) {
        YMenu::YMenuItem *item =
            new YMenu::YMenuItem(name, -1, 0, cmdSubmenu, (ObjectMenu *)container, 0);
        
        if (icon)
            item->setPixmap(icon->small());
        add(item);
    }
}

ObjectBar::ObjectBar(YWindow *parent): YWindow(parent) {
    setSize(1, 1);
}

ObjectBar::~ObjectBar() {
}

void ObjectBar::addButton(char *name, YIcon *icon, YButton *button) {
    button->setToolTip(name);
    if (icon) {
        button->setPixmap(icon->small());
        button->setSize(button->width() + 4, button->width() + 4);
    } else
        button->setText(name);
    
    button->setListener(this);
    button->setPosition(width(), 0);
    unsigned int h = button->height();

    if (h < height())
        h = height();

    setSize(width() + button->width() + 1, h);
    button->show();
}

void ObjectBar::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(taskBarBg);
    g.fillRect(0, 0, width(), height());

}

void ObjectBar::addObject(char *name, int cmd, YIcon *icon, void *context) {
    YButton *button = new YButton(this, (WMCommand)cmd, context);
    addButton(name, icon, button);
}

void ObjectBar::addSeparator() {
    setSize(width() + 4, height());
}

void ObjectBar::addContainer(char *name, YIcon *icon, ObjectContainer *container) {
    if (container) {
        YButton *button = new YButton(this, (ObjectMenu *)container, wmapp);
        
        addButton(name, icon, button);
    }
}

void ObjectBar::ButtonClick(YButton *button, unsigned int modifiers) {
    wmapp->handleCommand(button->getCommand(), button->getContext(), modifiers);
}

ObjectMenu *rootMenu = 0;

#define ACOUNT(x) (sizeof(x)/sizeof(x[0]))

char *menuFile = 0;
char *programFile = 0;
char *toolbarFile = 0;

char **progNames = 0;
char **progCmds = 0;
char ***progArgs = 0;
int progCount = 0;

int addProgram(const char *name, const char *command, char **args) {
    char *fullname = 0;

    if (command && command[0] && findPath(getenv("PATH"), X_OK, command, &fullname) == 0) { // updates command with full path
        char **p = args;
        while (p && *p) {
            FREE(*p);
            p++;
        }
        FREE(args);

        fprintf(stderr, "Program %s (%s) not found.\n", name, command);
        return 0;
    }

    progNames = (char **)REALLOC((void *)progNames, sizeof(char *) * ((progCount) + 1));
    progCmds = (char **)REALLOC((void *)progCmds, sizeof(char *) * ((progCount) + 1));
    progArgs = (char ***)REALLOC((void *)progArgs, sizeof(char **) * ((progCount) + 1));

    assert(progNames != NULL);
    assert(progCmds != NULL);
    assert(progArgs != NULL);

    progNames[progCount] = name ? strdup(name) : 0;
    progCmds[progCount] = fullname ? fullname : command ? strdup(command) : 0;
    progArgs[progCount] = args;

    /*assert(progNames[progCount] != NULL);
    assert(progCmds[progCount] != NULL);*/
    
    progCount++;
    return 1;
}


char *getWord(char *word, int maxlen, char *p) {
    while (*p && (*p == ' ' || *p == '\t' || *p == '\r' || *p == '\n'))
        p++;
    while (*p && isalnum(*p) && maxlen > 1) {
        *word++ = *p++;
        maxlen--;
    }
    *word++ = 0;
    return p;
}

char *parseMenus(char *data, ObjectContainer *container) {
    char *p = data;
    char word[32];

    if (container == 0)
        return 0;
    
    while (p && *p) {
        p = getWord(word, sizeof(word), p);

        if (strcmp(word, "separator") == 0) {
            container->addSeparator();
        } else if (strcmp(word, "prog") == 0 || strcmp(word, "restart") == 0) {
            char name[64];
            char icons[128];
            int cmd = (strcmp(word, "restart") == 0) ? cmdRestart : cmdExec;

            p = getArgument(name, sizeof(name), p);
            if (p == 0)
                return p;

            p = getArgument(icons, sizeof(icons), p);
            if (p == 0)
                return p;

            char command[256];
            char **args = 0;
            int argCount = 0;
            
            p = getArgument(command, sizeof(command), p);
            if (p == 0) {
                fprintf(stderr, "missing 2nd argument for %s %s\n", word, name);
                return p;
            }
            
            while (p) {
                char argx[256];
                
                while (*p && (*p == ' ' || *p == '\t'))
                    p++;
                
                if (*p == '\n')
                    break;
                
                p = getArgument(argx, sizeof(argx), p);
                if (p == 0) {
                    fprintf(stderr, "missing bad argument %d for %s %s\n", argCount + 1, word, name);
                    return p;
                }
                
                if (args == 0) {
                    args = (char **)REALLOC((void *)args, ((argCount) + 2) * sizeof(char *));
                    assert(args != NULL);
                    
                    args[argCount] = strdup(command);
                    assert(args[argCount] != NULL);
                    args[argCount + 1] = NULL;
                    
                    argCount++;
                }
                
                args = (char **)REALLOC((void *)args, ((argCount) + 2) * sizeof(char *));
                assert(args != NULL);
                
                args[argCount] = strdup(argx);
                assert(args[argCount] != NULL);
                args[argCount + 1] = NULL;
                
                argCount++;
            }
            if (!p)
                fprintf(stderr, "missing 2nd argument for prog %s\n", name);
            else {
                if (addProgram(name, command, args)) {
                    YIcon *icon = 0;

                    if (icons[0] != '-')
                        icon = getIcon(icons);
                    container->addObject(name, cmd, icon, (void *)(progCount - 1));
                }
            }
        } else if (strcmp(word, "menu") == 0) {
            char name[64];
            char icons[128];
            
            p = getArgument(name, sizeof(name), p);

            p = getArgument(icons, sizeof(icons), p);
            if (p == 0)
                return p;

            p = getWord(word, sizeof(word), p);
            if (*p != '{')
                return 0;
            p++;

            YIcon *icon = 0;

            if (icons[0] != '-')
                icon = getIcon(icons);
            
            ObjectMenu *sub = new ObjectMenu();
            if (sub) {
                p = parseMenus(p, sub);
                if (sub->itemCount() == 0)
                    delete sub;
                else
                    container->addContainer(name, icon, sub);
            } else
                return p;
        } else if (*p == '}') {
            p++;
            return p;
        } else {
            return 0;
        }
    }
    return p;
}


void loadMenus(const char *menuFile, ObjectContainer *container) {
    if (menuFile == 0)
        return ;
    
    int fd = open(menuFile, O_RDONLY | O_TEXT);

    if (fd == -1)
        return ;

    struct stat sb;

    if (fstat(fd, &sb) == -1)
        return ;

    int len = sb.st_size;

    char *buf = (char *)MALLOC(len + 1);
    if (buf == 0)
        return ;

    if (read(fd, buf, len) != len)
        return;

    buf[sb.st_size] = 0;
    close(fd);

    parseMenus(buf, container);
    
    FREE(buf);

    /*for (int p = 0; p < progCount; p++)
        if (progNames[p] && progNames[p][0])
            rootMenu->addItem(progNames[p], 0, "", cmdExec, (void *)p);
        else
            rootMenu->addSeparator();*/
}

void freePrograms() {
    int i, j;

    for (i = 0; i < progCount; i++) {
        FREE(progNames[i]);
        FREE(progCmds[i]);
        if (progArgs[i]) {
            for (j = 0; progArgs[i][j]; j++)
                FREE(progArgs[i][j]);
            FREE(progArgs[i]);
        }
    }
    FREE(progNames); progNames = 0;
    FREE(progCmds); progCmds = 0;
    FREE(progArgs); progArgs = 0;
    progCount = 0;
}

#ifndef NO_WINDOW_OPTIONS
char *winOptFile = 0;
WindowOptions *defOptions = 0;
WindowOptions *hintOptions = 0;

WindowOptions::WindowOptions() {
    winOptionsCount = 0;
    winOptions = 0;
}

WindowOptions::~WindowOptions() {
    int i;

    for (i = 0; i < winOptionsCount; i++) {
        if (winOptions[i].name)
            FREE(winOptions[i].name);
        if (winOptions[i].icon)
            FREE(winOptions[i].icon);
    }
    FREE(winOptions);
    winOptions = 0;
    winOptionsCount = 0;
}

WindowOption *WindowOptions::getWindowOption(char *name, bool create, bool remove) {
    int L = 0, R = winOptionsCount, M, cmp;
    //fprintf(stderr, "option: %s\n", name);
    while (L < R) {
        M = (L + R) / 2;
        if (name == 0 && winOptions[M].name == 0)
            cmp = 0;
        else if (name == 0)
            cmp = -1;
        else if (winOptions[M].name == 0)
            cmp = 1;
        else
            cmp = strcmp(name, winOptions[M].name);
        if (cmp == 0) {
            if (create)
                FREE(name);

            //fprintf(stderr, "got %s %ld", name, winOptions[M].workspace);

            if (remove) {
                static WindowOption o = winOptions[M];
                
                winOptionsCount--;
                for (int dummy = M; dummy < winOptionsCount; dummy++)
                    winOptions[dummy] = winOptions[dummy + 1];   /* */
                return &o;
            }

            return winOptions + M;
        } else if (cmp > 0)
            L = M + 1;
        else
            R = M;
    }
    if (!create)
        return 0;

    WindowOption *newOptions =
        (WindowOption *)REALLOC(winOptions,
                                sizeof(winOptions[0]) * (winOptionsCount + 1));
    if (newOptions == 0)
        return 0;
    winOptions = newOptions;

    //memmove(winOptions + L + 1, 
    //        winOptions + L, 
    //        sizeof(winOptions[0]) * (winOptionsCount - L));
    for (int dummy = winOptionsCount; dummy > L; dummy--)
       winOptions[dummy] = winOptions[dummy - 1];   /* */
    winOptionsCount++;

    /* initialize empty option structure */
    memset(winOptions + L, 0, sizeof(WindowOption));
    winOptions[L].workspace = WinWorkspaceInvalid;
    winOptions[L].layer = WinLayerInvalid;
    winOptions[L].name = name;

    return winOptions + L;
}

void WindowOptions::setWinOption(char *class_instance, char *opt, char *arg) {
    WindowOption *op = getWindowOption(class_instance, 1);

    //fprintf(stderr, "%s-%s-%s\\", class_instance, opt, arg);
    
    if (strcmp(opt, "icon") == 0) {
        op->icon = strdup(arg);
    } else if (strcmp(opt, "workspace") == 0) {
        op->workspace = atoi(arg);
    } else if (strcmp(opt, "layer") == 0) {
        char *endptr;
        long l = strtol(arg, &endptr, 10);

        op->layer = WinLayerInvalid;

        if (arg[0] && !endptr[0])
            op->layer = l;
        else {
            struct {
                const char *name;
                int layer;
            } layers[] = {
                { "Desktop", WinLayerDesktop }, //
                { "Below", WinLayerBelow }, //
                { "Normal", WinLayerNormal }, //
                { "OnTop", WinLayerOnTop }, //
                { "Dock", WinLayerDock }, //
                { "AboveDock", WinLayerAboveDock } //
            };
            for (unsigned int i = 0; i < ACOUNT(layers); i++)
                if (strcmp(layers[i].name, arg) == 0)
                    op->layer = layers[i].layer;
        }
    } else {
        static struct {
            int what;
            const char *name;
            unsigned long flag;
        } options[] = {
            { 0, "fMove", YFrameWindow::ffMove }, //
            { 0, "fResize", YFrameWindow::ffResize }, //
            { 0, "fClose", YFrameWindow::ffClose }, //
            { 0, "fMinimize", YFrameWindow::ffMinimize }, //
            { 0, "fMaximize", YFrameWindow::ffMaximize }, //
            { 0, "fHide", YFrameWindow::ffHide }, //
            { 0, "fRollup", YFrameWindow::ffRollup }, //
            { 1, "dTitleBar", YFrameWindow::fdTitleBar }, //
            { 1, "dSysMenu", YFrameWindow::fdSysMenu }, //
            { 1, "dBorder", YFrameWindow::fdBorder }, //
            { 1, "dResize", YFrameWindow::fdResize }, //
            { 1, "dClose", YFrameWindow::fdClose }, //
            { 1, "dMinimize", YFrameWindow::fdMinimize }, //
            { 1, "dMaximize", YFrameWindow::fdMaximize }, //
            { 1, "dHide", YFrameWindow::fdHide },
            { 2, "allWorkspaces", YFrameWindow::foAllWorkspaces }, //
            { 2, "ignoreTaskBar", YFrameWindow::foIgnoreTaskBar }, //
            { 2, "ignoreWinList", YFrameWindow::foIgnoreWinList }, //
            { 2, "ignoreQuickSwitch", YFrameWindow::foIgnoreQSwitch }, //
            { 2, "fullKeys", YFrameWindow::foFullKeys }, //
            { 2, "noFocusOnAppRaise", YFrameWindow::foNoFocusOnAppRaise }, //
            { 2, "ignoreNoFocusHint", YFrameWindow::foIgnoreNoFocusHint } //
        };
        int t = (atoi(arg) == 1) ? 1 : 0;

        for (unsigned int a = 0; a < ACOUNT(options); a++) {
            unsigned long *what, *what_mask;
            
            if (options[a].what == 0) {
                what = &op->functions;
                what_mask  = &op->function_mask;
            } else if (options[a].what == 1) {
                what = &op->decors;
                what_mask = &op->decor_mask;
            } else if (options[a].what == 2) {
                what = &op->options;
                what_mask = &op->option_mask;
            } else {
                fprintf(stderr, "error in window option: %s\n", opt);
                break;
            }
            
            if (strcmp(opt, options[a].name) == 0) {
                if (t)
                    *what = (*what) | options[a].flag;
                else
                    *what = (*what) & ~options[a].flag;
                *what_mask =  (*what_mask) | options[a].flag;
                return ;
            }
        }
        fprintf(stderr, "unknown window option: %s\n", opt);
    }
}

void WindowOptions::combineOptions(WindowOption &cm, WindowOption &n) {
    if (cm.icon == 0)
        if (n.icon != 0)
            cm.icon = n.icon;
    cm.functions |= n.functions & ~cm.function_mask;
    cm.function_mask |= n.function_mask;
    cm.decors |= n.decors & ~cm.decor_mask;
    cm.decor_mask |= n.decor_mask;
    cm.options |= n.options & ~cm.option_mask;
    cm.option_mask |= n.option_mask;
    if (n.workspace != WinWorkspaceInvalid)
        cm.workspace = n.workspace;
    if (n.layer != WinLayerInvalid)
        cm.layer = n.layer;
}

char *parseWinOptions(char *data) {
    char *p = data;
    char *w, *e, *c;
    char *class_instance;

    char *opt;

    while (*p) {
        while (*p == ' ' || *p == '\t' || *p == '\n')
            p++;
        w = p;
        c = 0;
        while (*p && *p != ':') {
            if (*p == '.')
                c = p;
            p++;
        }
        e = p;

        if (e == w || *p == 0)
            break;
        if (c == 0) {
            fprintf(stderr, "icewm: syntax error in window options\n");
            break;
        }
        
        if (c - w + 1 == 0)
            class_instance = 0;
        else {
            class_instance = (char *)MALLOC(c - w + 1);
            if (class_instance == 0)
                goto nomem;
            memcpy(class_instance, w, c - w);
            class_instance[c - w] = 0;
        }

        *e = 0;
        c++;
        opt = c;
        e++;

        p = e;
        while (*p == ' ' || *p == '\t')
            p++;

        w = p;
        while (*p && (*p != '\n' && *p != ' ' && *p != '\t'))
            p++;

        if (*p != 0) {
            *p = 0;
            defOptions->setWinOption(class_instance, opt, w);
        } else {
            defOptions->setWinOption(class_instance, opt, w);
            break;
        }
        p++;
    }
    return p;
nomem:
    fprintf(stderr, "icewm: out of memory for window options\n");
    return 0;
}

void loadWinOptions(const char *optFile) {
    if (optFile == 0)
        return ;
    
    int fd = open(optFile, O_RDONLY | O_TEXT);

    if (fd == -1)
        return ;

    struct stat sb;

    if (fstat(fd, &sb) == -1)
        return ;

    int len = sb.st_size;

    char *buf = (char *)MALLOC(len + 1);
    if (buf == 0)
        return ;

    if (read(fd, buf, len) != len)
        return;

    buf[sb.st_size] = 0;
    close(fd);

    parseWinOptions(buf);
    
    FREE(buf);
}
#endif
