#include "icewm.h"
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>

class ObjectList;

YIcon *folder = 0;
YIcon *file = 0;

class ObjectListItem: public YListItem {
public:
    ObjectListItem(char *container, char *name) {
        fContainer = container;
        fName = strdup(name);
        fFolder = false;

        struct stat sb;
        char *path = getLocation();
        if (stat(path, &sb) == 0 && S_ISDIR(sb.st_mode))
            fFolder = true;
        free(path);
    }
    virtual ~ObjectListItem() { delete fName; }

    virtual unsigned char *getText() { return (unsigned char *)fName; }
    virtual YIcon *getIcon() { return isFolder() ? folder : file; }

    bool isFolder() { return fFolder; }

    char *getLocation() {
        char *dir = fContainer;
        char *name = (char *)getText();
        int dlen;
        int nlen = (dlen = strlen(dir)) + 1 + strlen(name) + 1;
        char *npath;
        
        npath = (char *)MALLOC(nlen);
        strcpy(npath, dir);
        if (dlen == 0 || dir[dlen - 1] != '/') {
            strcpy(npath + dlen, "/");
            dlen++;
        }
        strcpy(npath + dlen, name);
        return npath;
    }
private:
    char *fContainer;
    char *fName;
    bool fFolder;
};
class ObjectListBox: public YListBox, public CommandListener {
public:
    ObjectListBox(ObjectList *list, YScrollBar *vert, YWindow *aParent): YListBox(vert, aParent) {
        fObjList = list;
    }

    virtual ~ObjectListBox() { }

    virtual bool handleKey(const XKeyEvent &key) {
        return YListBox::handleKey(key);
    }
    
    virtual void handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
        return YListBox::handleClick(down, up, count);
    }
    
    virtual void activateItem(YListItem *item);
    
    virtual void handleCommand(WMCommand command, void *context, unsigned int modifiers) {
    }
private:
    ObjectList *fObjList;
};

class ObjectList: public YWindow {
public:
    ObjectList(char *path) {
        fPath = strdup(path);
        scrollVert = new YScrollBar(YScrollBar::Vertical, this);
        scrollVert->show();
        //scrollVert->setWinGravity(NorthEastGravity);
        list = new ObjectListBox(this, scrollVert, this);
        updateList();
        XStoreName(app->display(), handle(), fPath);
        list->show();
        
        int w = desktop->width();
        int h = desktop->height();
        
        setGeometry(w / 3, h / 3, w / 3, h / 3);
        XSetWMProtocols(app->display(), handle(), &_XA_WM_DELETE_WINDOW, 1);

        Pixmap icons[2];
        icons[0] = folder->small()->pixmap();
        icons[1] = folder->small()->mask();
        XChangeProperty(app->display(), handle(),
                        _XA_WIN_ICONS, XA_PIXMAP,
                        32, PropModeReplace,
                        (unsigned char *)icons, 2);
    }

    virtual void handleClose() {
        hide();
    }
    
    virtual void configure(int x, int y, unsigned int width, unsigned int height) {
        YWindow::configure(x, y, width, height);
        int dx = SCROLLBAR_SIZE;

        scrollVert->setGeometry(width - SCROLLBAR_SIZE, 0,
                                SCROLLBAR_SIZE, height);

        if (height > list->itemCount() * list->getLineHeight()) {
            dx = 0;
            scrollVert->hide();
        } else {
            scrollVert->show();
        }
        list->setGeometry(0, 0, width - dx, height);
    }

    void updateList() {
        DIR *dir;
        
        if ((dir = opendir(fPath)) != NULL) {
            struct dirent *de;
            
            while ((de = readdir(dir)) != NULL) {
                char *n = de->d_name;

                if (n[0] == '.' && (n[1] == 0 || (n[1] == '.' && n[2] == 0)))
                    ;
                else {
                    ObjectListItem *o = new ObjectListItem(fPath, n);

                    if (o)
                        list->addItem(o);
                }
            }
            closedir(dir);
        }
    }

    char *getPath() { return fPath; }
    
private:
    ObjectListBox *list;
    YScrollBar *scrollVert;

    char *fPath;
};

void ObjectListBox::activateItem(YListItem *item) {
    ObjectListItem *obj = (ObjectListItem *)item;
    char *path = obj->getLocation();
    
    if (obj->isFolder()) {
        ObjectList *list = new ObjectList(path);
        list->show();
    }
    free(path);
}

int main(int argc, char **argv) {
    YApplication app(&argc, &argv);

    folder = getIcon("folder");
    file = getIcon("file");
    
    ObjectList *list = new ObjectList(argv[1] ? argv[1] : (char *)"/");
    list->show();
    
    return app.mainLoop();
}
