/*
 * IceWM
 *
 * Copyright (C) 1998 Marko Macek
 */

/* just a quick hack (on top of a quick hack!) */

#ifdef GNOME

#include "icewm.h"
#include <dirent.h>
#include <gnome.h>

GnomeMenu::GnomeMenu(YWindow *parent,
                         const char *path): ObjectMenu(parent)
{
    fPath = strdup(path);
    fModTime = 0;
}

GnomeMenu::~GnomeMenu() {
    free(fPath);
}

void GnomeMenu::updatePopup() {
    struct stat sb;

    if (stat(fPath, &sb) != 0)
        removeAll();
    else if (sb.st_mtime > fModTime) {
        fModTime = sb.st_mtime;
        
        removeAll();

        DIR *dir;
        int plen = strlen(fPath);

        YPixmap *folder = 0;
#ifdef IMLIB
        char *folder_icon = gnome_pixmap_file("gnome-folder.png");
        if (folder_icon)
            folder = new YPixmap(folder_icon, ICON_SMALL, ICON_SMALL);
#endif
        if ((dir = opendir(fPath)) != NULL) {
            struct dirent *de;
            bool isDir;
            int nlen;
            char *npath;
            YMenu *sub;
            YMenu::YMenuItem *item;
	    GnomeDesktopEntry *dentry;

            while ((de = readdir(dir)) != NULL) {
                nlen = plen + 1 + strlen(de->d_name) + 1;
                npath = (char *)malloc(nlen);

                if (npath && de->d_name[0] != '.') {
                    strcpy(npath, fPath);
                    if (plen == 0 || npath[plen - 1] != '/') {
                        strcpy(npath + plen, "/");
                        strcpy(npath + plen + 1, de->d_name);
                    } else {
                        strcpy(npath + plen, de->d_name);
                    }

                    isDir = false;
                    
                    if (stat(npath, &sb) == 0)
                        if (S_ISDIR(sb.st_mode))
                            isDir = true;

                    if (isDir) {
		      //YIcon* icon = 0;

                        sub = new GnomeMenu(0, npath);
			item = new YMenuItem(strdup(de->d_name), -1, 0,
					     cmdSubmenu, sub,
					     (void *)npath);
			if (folder) item->setPixmap(folder);
			add(item);
		    }
		    else if ((dentry = gnome_desktop_entry_load(npath))) {
		        item = new YMenuItem(strdup(dentry->name), -1, 0,
					     cmdGnome, 0, (void *)dentry);
			if (dentry->icon) {
                            YPixmap *menuicon = 0;
#ifdef IMLIB
                            menuicon = new YPixmap(dentry->icon,
                                                   ICON_SMALL, ICON_SMALL);
#endif
                            if (menuicon) item->setPixmap(menuicon);
			}
			add(item);
                    }
                }
            }
            closedir(dir);
        }
    }
}
#endif
