#include "E.h"

ImageClass         *
CreateIclass()
{
   ImageClass         *i;

   EDBUG(5, "CreateIclass");
   i = Emalloc(sizeof(ImageClass));
   if (!i)
      EDBUG_RETURN(NULL);
   i->name = NULL;
   i->external = 0;
   i->norm.normal = i->norm.hilited = i->norm.clicked = i->norm.disabled = NULL;
   i->active.normal = i->active.hilited = i->active.clicked = i->active.disabled = NULL;
   i->sticky.normal = i->sticky.hilited = i->sticky.clicked = i->sticky.disabled = NULL;
   i->sticky_active.normal = i->sticky_active.hilited = i->sticky_active.clicked = i->sticky_active.disabled = NULL;
   i->padding.left = 0;
   i->padding.right = 0;
   i->padding.top = 0;
   i->padding.bottom = 0;
   i->colmod = NULL;
   EDBUG_RETURN(i);
}

ImageState         *
CreateImageState()
{
   ImageState         *is;

   EDBUG(6, "CreateImageState");
   is = Emalloc(sizeof(ImageState));
   if (!is)
      EDBUG_RETURN(NULL);
   is->im_file = NULL;
   is->unloadable = 0;
   is->im = NULL;
   is->transp = NULL;
   is->border = NULL;
   is->pixmapfillstyle = FILL_STRETCH;
   is->bg.r = 160;
   is->bg.g = 160;
   is->bg.b = 160;
   is->hi.r = 200;
   is->hi.g = 200;
   is->hi.b = 200;
   is->lo.r = 120;
   is->lo.g = 120;
   is->lo.b = 120;
   is->hihi.r = 255;
   is->hihi.g = 255;
   is->hihi.b = 255;
   is->lolo.r = 64;
   is->lolo.g = 64;
   is->lolo.b = 64;
   is->bevelstyle = BEVEL_NONE;
   is->colmod = NULL;
   EDBUG_RETURN(is);
}

void
ImageStatePopulate(ImageState * is)
{
   int                 r, g, b;

   EDBUG(6, "ImageStatePopulate");
   if (!is)
      EDBUG_RETURN_;
   r = is->bg.r;
   g = is->bg.g;
   b = is->bg.b;
   is->bg.pixel = Imlib_best_color_match(id, &r, &g, &b);
   r = is->hi.r;
   g = is->hi.g;
   b = is->hi.b;
   is->hi.pixel = Imlib_best_color_match(id, &r, &g, &b);
   r = is->lo.r;
   g = is->lo.g;
   b = is->lo.b;
   is->lo.pixel = Imlib_best_color_match(id, &r, &g, &b);
   r = is->hihi.r;
   g = is->hihi.g;
   b = is->hihi.b;
   is->hihi.pixel = Imlib_best_color_match(id, &r, &g, &b);
   r = is->lolo.r;
   g = is->lolo.g;
   b = is->lolo.b;
   is->lolo.pixel = Imlib_best_color_match(id, &r, &g, &b);
   EDBUG_RETURN_;
}

void
IclassPopulate(ImageClass * iclass)
{
   ColorModifierClass *cm;

   EDBUG(6, "IclassPopulate");
   if ((!iclass) || (iclass->external))
      EDBUG_RETURN_;

   if (!iclass->norm.normal)
      EDBUG_RETURN_;

   ImageStatePopulate(iclass->norm.normal);
   if (!iclass->norm.hilited)
      iclass->norm.hilited = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->norm.hilited);
   if (!iclass->norm.clicked)
      iclass->norm.clicked = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->norm.clicked);
   if (!iclass->norm.disabled)
      iclass->norm.disabled = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->norm.disabled);

   if (!iclass->active.normal)
      iclass->active.normal = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->active.normal);
   if (!iclass->active.hilited)
      iclass->active.hilited = iclass->active.normal;
   else
      ImageStatePopulate(iclass->active.hilited);
   if (!iclass->active.clicked)
      iclass->active.clicked = iclass->active.normal;
   else
      ImageStatePopulate(iclass->active.clicked);
   if (!iclass->active.disabled)
      iclass->active.disabled = iclass->active.normal;
   else
      ImageStatePopulate(iclass->active.disabled);

   if (!iclass->sticky.normal)
      iclass->sticky.normal = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->sticky.normal);
   if (!iclass->sticky.hilited)
      iclass->sticky.hilited = iclass->sticky.normal;
   else
      ImageStatePopulate(iclass->sticky.hilited);
   if (!iclass->sticky.clicked)
      iclass->sticky.clicked = iclass->sticky.normal;
   else
      ImageStatePopulate(iclass->sticky.clicked);
   if (!iclass->sticky.disabled)
      iclass->sticky.disabled = iclass->sticky.normal;
   else
      ImageStatePopulate(iclass->sticky.disabled);

   if (!iclass->sticky_active.normal)
      iclass->sticky_active.normal = iclass->norm.normal;
   else
      ImageStatePopulate(iclass->sticky_active.normal);
   if (!iclass->sticky_active.hilited)
      iclass->sticky_active.hilited = iclass->sticky_active.normal;
   else
      ImageStatePopulate(iclass->sticky_active.hilited);
   if (!iclass->sticky_active.clicked)
      iclass->sticky_active.clicked = iclass->sticky_active.normal;
   else
      ImageStatePopulate(iclass->sticky_active.clicked);
   if (!iclass->sticky_active.disabled)
      iclass->sticky_active.disabled = iclass->sticky_active.normal;
   else
      ImageStatePopulate(iclass->sticky_active.disabled);

   if (!iclass->colmod)
     {
	cm = (ColorModifierClass *) FindItem("ICLASS", 0, LIST_FINDBY_NAME,
					     LIST_TYPE_COLORMODIFIER);
	if (!cm)
	   cm = (ColorModifierClass *) FindItem("DEFAULT", 0, LIST_FINDBY_NAME,
						LIST_TYPE_COLORMODIFIER);
	iclass->colmod = cm;
     }
   cm = (ColorModifierClass *) FindItem("NORMAL", 0, LIST_FINDBY_NAME,
					LIST_TYPE_COLORMODIFIER);
   if (!cm)
      cm = iclass->colmod;
   if (!iclass->norm.normal->colmod)
      iclass->norm.normal->colmod = cm;
   if (!iclass->norm.hilited->colmod)
      iclass->norm.hilited->colmod = cm;
   if (!iclass->norm.clicked->colmod)
      iclass->norm.clicked->colmod = cm;
   if (!iclass->norm.disabled->colmod)
      iclass->norm.disabled->colmod = cm;
   cm = (ColorModifierClass *) FindItem("ACTIVE", 0, LIST_FINDBY_NAME,
					LIST_TYPE_COLORMODIFIER);
   if (!cm)
      cm = iclass->colmod;
   if (!iclass->active.normal->colmod)
      iclass->active.normal->colmod = cm;
   if (!iclass->active.hilited->colmod)
      iclass->active.hilited->colmod = cm;
   if (!iclass->active.clicked->colmod)
      iclass->active.clicked->colmod = cm;
   if (!iclass->active.disabled->colmod)
      iclass->active.disabled->colmod = cm;
   cm = (ColorModifierClass *) FindItem("STICKY", 0, LIST_FINDBY_NAME,
					LIST_TYPE_COLORMODIFIER);
   if (!cm)
      cm = iclass->colmod;
   if (!iclass->sticky.normal->colmod)
      iclass->sticky.normal->colmod = cm;
   if (!iclass->sticky.hilited->colmod)
      iclass->sticky.hilited->colmod = cm;
   if (!iclass->sticky.clicked->colmod)
      iclass->sticky.clicked->colmod = cm;
   if (!iclass->sticky.disabled->colmod)
      iclass->sticky.disabled->colmod = cm;
   cm = (ColorModifierClass *) FindItem("STICKY_ACTIVE", 0, LIST_FINDBY_NAME,
					LIST_TYPE_COLORMODIFIER);
   if (!cm)
      cm = iclass->colmod;
   if (!iclass->sticky_active.normal->colmod)
      iclass->sticky_active.normal->colmod = cm;
   if (!iclass->sticky_active.hilited->colmod)
      iclass->sticky_active.hilited->colmod = cm;
   if (!iclass->sticky_active.clicked->colmod)
      iclass->sticky_active.clicked->colmod = cm;
   if (!iclass->sticky_active.disabled->colmod)
      iclass->sticky_active.disabled->colmod = cm;
   EDBUG_RETURN_;
}

void
IclassApply(ImageClass * iclass, Window win, int w, int h, int active, int state, char expose)
{
   ImageState         *is;

   EDBUG(4, "IclassApply");
   if ((!iclass) || (!win) || (w < 1) || (h < 1))
      EDBUG_RETURN_;
   if (iclass->external)
      EDBUG_RETURN_;
   is = NULL;

   switch (active & (EWIN_ACTIVE | EWIN_STICKY))
     {
     case EWIN_ACTIVE:
	switch (state)
	  {
	  case STATE_NORMAL:
	     is = iclass->active.normal;
	     break;
	  case STATE_HILITED:
	     is = iclass->active.hilited;
	     break;
	  case STATE_CLICKED:
	     is = iclass->active.clicked;
	     break;
	  case STATE_DISABLED:
	     is = iclass->active.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case EWIN_STICKY:
	switch (state)
	  {
	  case STATE_NORMAL:
	     is = iclass->sticky.normal;
	     break;
	  case STATE_HILITED:
	     is = iclass->sticky.hilited;
	     break;
	  case STATE_CLICKED:
	     is = iclass->sticky.clicked;
	     break;
	  case STATE_DISABLED:
	     is = iclass->sticky.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case (EWIN_ACTIVE | EWIN_STICKY):
	switch (state)
	  {
	  case STATE_NORMAL:
	     is = iclass->sticky_active.normal;
	     break;
	  case STATE_HILITED:
	     is = iclass->sticky_active.hilited;
	     break;
	  case STATE_CLICKED:
	     is = iclass->sticky_active.clicked;
	     break;
	  case STATE_DISABLED:
	     is = iclass->sticky_active.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case 0:
	switch (state)
	  {
	  case STATE_NORMAL:
	     is = iclass->norm.normal;
	     break;
	  case STATE_HILITED:
	     is = iclass->norm.hilited;
	     break;
	  case STATE_CLICKED:
	     is = iclass->norm.clicked;
	     break;
	  case STATE_DISABLED:
	     is = iclass->norm.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     default:
	break;
     }
   if (is)
     {
	XGCValues           gcv;
	GC                  gc;
	Pixmap              pmap, mask;

	if (!expose)
	  {
	     if (is->im_file)
	       {
		  /* has bg pixmap */
		  if (!is->im)
		    {
		       /* not loaded, load and setup */
		       is->im = ELoadImage(is->im_file);
		       if (is->border)
			  Imlib_set_image_border(id, is->im, is->border);
		       if (is->transp)
			  Imlib_set_image_shape(id, is->im, is->transp);
		       if (is->colmod)
			 {
			    Imlib_set_image_red_curve(id, is->im,
						      is->colmod->red.map);
			    Imlib_set_image_green_curve(id, is->im,
							is->colmod->green.map);
			    Imlib_set_image_blue_curve(id, is->im,
						       is->colmod->blue.map);
			 }
		    }
		  if (is->im)
		    {
		       /* if image, render */
		       switch (is->pixmapfillstyle)
			 {
			 case FILL_STRETCH:
			 case FILL_TILE:
			 case FILL_INTEGER_TILE:
			    Imlib_render(id, is->im, w, h);
			    pmap = Imlib_move_image(id, is->im);
			    mask = Imlib_move_mask(id, is->im);
			    if (pmap)
			      {
				 XSetWindowBackgroundPixmap(disp, win, pmap);
				 XShapeCombineMask(disp, win, ShapeBounding,
						   0, 0, mask, ShapeSet);
			      }
			    Imlib_free_pixmap(id, pmap);
			    break;
			 default:
			    break;
			 }
		    }
	       }
	     if (!is->im)
	       {
		  /* bg color */
		  XSetWindowBackground(disp, win, is->bg.pixel);
	       }
	     else if (is->im_file)
	       {
		  /* if unloadable - then unload */
		  if (is->unloadable)
		    {
		       Imlib_destroy_image(id, is->im);
		       is->im = NULL;
		    }
	       }
	  }
	XClearWindow(disp, win);
	/* if there is a bevel to draw, draw it */
	if (is->bevelstyle != BEVEL_NONE)
	  {
	     gc = XCreateGC(disp, win, 0, &gcv);
	     switch (is->bevelstyle)
	       {
	       case BEVEL_AMIGA:
		  XSetForeground(disp, gc, is->hihi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 2, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 2);
		  XSetForeground(disp, gc, is->lolo.pixel);
		  XDrawLine(disp, win, gc, 1, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  break;
	       case BEVEL_MOTIF:
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 1, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 1);
		  XDrawLine(disp, win, gc, 1, 1, w - 2, 1);
		  XDrawLine(disp, win, gc, 1, 1, 1, h - 2);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 0, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, 1, h - 2, w - 2, h - 2);
		  XDrawLine(disp, win, gc, w - 2, 2, w - 2, h - 2);
		  break;
	       case BEVEL_NEXT:
		  XSetForeground(disp, gc, is->hihi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 1, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 1);
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 1, 1, w - 2, 1);
		  XDrawLine(disp, win, gc, 1, 1, 1, h - 2);
		  XSetForeground(disp, gc, is->lolo.pixel);
		  XDrawLine(disp, win, gc, 1, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 2, h - 2, w - 2, h - 2);
		  XDrawLine(disp, win, gc, w - 2, 2, w - 2, h - 2);
		  break;
	       case BEVEL_DOUBLE:
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 2, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 2);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 1, 1, w - 3, 1);
		  XDrawLine(disp, win, gc, 1, 1, 1, h - 3);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 1, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 2, h - 2, w - 2, h - 2);
		  XDrawLine(disp, win, gc, w - 2, 2, w - 2, h - 2);
		  break;
	       case BEVEL_WIDEDOUBLE:
		  XSetForeground(disp, gc, is->hihi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 1, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 1);
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 1, 1, w - 2, 1);
		  XDrawLine(disp, win, gc, 1, 1, 1, h - 2);
		  XDrawLine(disp, win, gc, 3, h - 4, w - 4, h - 4);
		  XDrawLine(disp, win, gc, w - 4, 3, w - 4, h - 4);
		  XSetForeground(disp, gc, is->lolo.pixel);
		  XDrawLine(disp, win, gc, 1, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 2, h - 2, w - 2, h - 2);
		  XDrawLine(disp, win, gc, w - 2, 2, w - 2, h - 2);
		  XDrawLine(disp, win, gc, 3, 3, w - 4, 3);
		  XDrawLine(disp, win, gc, 3, 3, 3, h - 4);
		  break;
	       case BEVEL_THINPOINT:
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, w - 2, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, h - 2);
		  XSetForeground(disp, gc, is->lo.pixel);
		  XDrawLine(disp, win, gc, 1, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, 1, w - 1, h - 1);
		  XSetForeground(disp, gc, is->hihi.pixel);
		  XDrawLine(disp, win, gc, 0, 0, 1, 0);
		  XDrawLine(disp, win, gc, 0, 0, 0, 1);
		  XSetForeground(disp, gc, is->lolo.pixel);
		  XDrawLine(disp, win, gc, w - 2, h - 1, w - 1, h - 1);
		  XDrawLine(disp, win, gc, w - 1, h - 2, w - 1, h - 1);
		  XSync(disp, False);
		  break;
	       case BEVEL_THICKPOINT:
		  XSetForeground(disp, gc, is->hi.pixel);
		  XDrawRectangle(disp, win, gc, 0, 0, w - 1, h - 1);
		  break;
	       default:
		  break;
	       }
	     XFreeGC(disp, gc);
	  }
     }
   EDBUG_RETURN_;
}
