
#include "E.h"

void
FocusToEWin(EWin * ewin)
{
   EDBUG(4, "FocusToEWin");
   if (mode.focuswin)
     {
	mode.focuswin->active = 0;
	mode.focuswin->state &= ~EWIN_ACTIVE;
	DrawEwin(mode.focuswin);
     }
   mode.focuswin = ewin;
   if (mode.focuswin)
     {
	mode.focuswin->active = 1;
	mode.focuswin->state |= EWIN_ACTIVE;
	DrawEwin(mode.focuswin);
     }
   ICCCM_Focus(mode.focuswin);
   EDBUG_RETURN_;
}

EWin               *
FindEwinByBase(Window win)
{
   EWin               *ewin;
   List               *ptr;

   EDBUG(6, "FindEwinByBase");
   ptr = lists.next;
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     if (win == ewin->win)
		EDBUG_RETURN(ewin);
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN(NULL);
}

EWin               *
FindEwinByChildren(Window win)
{
   EWin               *ewin;
   List               *ptr;
   int                 i;

   EDBUG(6, "FindEwinByChildren");
   ptr = lists.next;
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     if (win == ewin->client.win)
	       {
		  EDBUG_RETURN(ewin);
	       }
	     else
	       {
		  for (i = 0; i < ewin->border->num_winparts; i++)
		     if (win == ewin->bits[i].win)
			EDBUG_RETURN(ewin);
	       }
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN(NULL);
}

EWin               *
FindEwinByDecoration(Window win)
{
   EWin               *ewin;
   List               *ptr;
   int                 i;

   EDBUG(6, "FindEwinByDecoration");
   ptr = lists.next;
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		   EDBUG_RETURN(ewin);
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN(NULL);
}

Button             *
FindButton(Window win)
{
   Button             *b;
   List               *ptr;

   EDBUG(6, "FindButton");
   ptr = lists.next;
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_BUTTON)
	  {
	     b = (Button *) ptr->item;
	     if (win == b->win)
		EDBUG_RETURN(b);
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN(NULL);
}
