#include "E.h"
#include "conf.h"

int 
testForComment(char *line)
{
   EDBUG(8, "testForComment");
   if ((line[0] == '#') || (line[0] == '\n') || (line[0] == 0))
     {
	EDBUG_RETURN(1);
     }
   else
     {
	EDBUG_RETURN(0);
     }
   EDBUG_RETURN(0);
}

int 
GetNextLine(char *line, FILE * ConfigFile)
{
   EDBUG(8, "GetNextLine");
   if (!fgets(line, FILEPATH_LEN_MAX, ConfigFile))
      EDBUG_RETURN(0);
   line[strlen(line) - 1] = 0;
   if (testForComment(line))
     {
	GetNextLine(line, ConfigFile);
	EDBUG_RETURN(1);
     }
   else
     {
	{
	   int                 i = 0;
	   char                line2[FILEPATH_LEN_MAX];

	   line2[0] = 0;

	   while (line[i])
	     {
		if (line[i] == '$')
		  {
		     int                 j = 0;
		     char               *environment_variable = 0;
		     char                env_name[FILEPATH_LEN_MAX];

		     i++;
		     if (line[i] != '$')
		       {
			  while (isalnum(line[i]) || line[i] == '_')
			     env_name[j++] = line[i++];
			  env_name[j] = 0;
			  environment_variable = getenv(env_name);
			  if (environment_variable)
			     strcat(line2, environment_variable);
			  else
			    {
			       strcat(line2, "$");
			       strcat(line2, env_name);
			    }
		       }
		  }
		else
		  {
		     char                s[2];

		     s[0] = line[i];
		     s[1] = 0;
		     strcat(line2, s);
		     ++i;
		  }
	     }
	   strcpy(line, line2);
	}
	EDBUG_RETURN(1);
     }
   EDBUG_RETURN(0);
}

StringType         *
GenerateStringList(char *file)
{
   FILE               *definitionFile;
   char                line[FILEPATH_LEN_MAX];
   int                 definition;
   char                s[1024];
   StringType         *returnList = 0;

   EDBUG(8, "GenerateStringList");
   StringCount = 0;
   if (!file)
      definitionFile = fopen("definitions", "r");
   else
      definitionFile = fopen(file, "r");
   if (!definitionFile)
     {
	Alert("Enlightenment cannot load your string definitions file:\n"
	      "%s\n"
	      "Enlightenment can probably continue to attempt to load\n"
	      "however this error may prove to be fatal.\n"
	      "If you do not require a definitions file, you should\n"
	      "create a blank file to avoid this error message in\n"
	      "the future.\n", file);
     }
   while (GetNextLine(line, definitionFile))
     {
	sscanf(line, "%d %4000s", &definition, s);
	if (!returnList)
	   returnList = Emalloc(sizeof(StringType));
	else
	   returnList = Erealloc(returnList, sizeof(StringType) * (StringCount + 1));
	returnList[StringCount].definition = definition;
	returnList[StringCount].string = Emalloc(sizeof(char) * (strlen(s) + 1));

	returnList[StringCount].string = duplicate(s);
	++StringCount;
     }
   --StringCount;
   fclose(definitionFile);

   EDBUG_RETURN(returnList);
}

void 
DestroyStringList(StringType * listToKill)
{
   long                i = 0;

   EDBUG(4, "DestroyStringList");
   for (i = 0; i <= StringCount; i++)
     {
	Efree(listToKill[i].string);
     }
   Efree(listToKill);
   EDBUG_RETURN_;

}

int 
ReturnStringReference(StringType * StringSet, char *actionString)
{
   long                i = 0;

   EDBUG(8, "ReturnStringReference");
   for (i = 0; i <= StringCount; i++)
      if (!strcasecmp(StringSet[i].string, actionString))
	 EDBUG_RETURN(StringSet[i].definition);
   EDBUG_RETURN(0);
}

void 
Config_Text(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   TextClass          *tc;

   tc = CreateTclass();
   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     TclassPopulate(tc);
	     AddItem(tc, tc->name, 0, LIST_TYPE_TCLASS);
	     return;
	  case CONFIG_CLASSNAME:
	     tc->name = duplicate(s2);
	     tc->norm.normal = CreateTextState();
	     break;
	  case TEXT_ORIENTATION:
	     tc->norm.normal->style.orientation = ReturnStringReference(StringList, s2);
	     break;
	  case TEXT_JUSTIFICATION:
	     tc->norm.normal->style.justification = atoi(s2);
	     break;
	  case TEXT_FONTNAME:
	     tc->norm.normal->fontname = duplicate(s2);
	     tc->norm.normal->style.mode = MODE_VERBATIM;
	     break;
	  case TEXT_MODE:
	     tc->norm.normal->style.mode = ReturnStringReference(StringList, s2);
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
	      "the following text in the middle of current Text definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	  }

     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a text block.  Outcome is likely not good.\n");
}

void 
Config_Control(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  case CONFIG_SOUND:
	     mode.sound = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_FOCUSMODE:
	     mode.focusmode = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_MOVEMODE:
	     mode.movemode = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_RESIZEMODE:
	     mode.resizemode = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_SLIDEMODE:
	     mode.slidemode = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_CLEANUPSLIDE:
	     mode.cleanupslide = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_MAPSLIDE:
	     mode.mapslide = ReturnStringReference(StringList, s2);
	     break;
	  case DESKTOP_DRAGDIR:
	     desks.dragdir = atoi(s2);
	     break;
	  case DESKTOP_DRAGBAR_WIDTH:
	     desks.dragbar_width = atoi(s2);
	     break;
	  case DESKTOP_DRAGBAR_ORDERING:
	     desks.dragbar_ordering = atoi(s2);
	     break;
	  case DESKTOP_DRAGBAR_LENGTH:
	     desks.dragbar_length = atoi(s2);
	     break;
	  case DESKTOP_SLIDEIN:
	     desks.slidein = ReturnStringReference(StringList, s2);
	     break;
	  case DESKTOP_SLIDESPEED:
	     desks.slidespeed = atoi(s2);
	     break;
	  case DESKTOP_HIQUALITYBG:
	     desks.hiqualitybg = ReturnStringReference(StringList, s2);
	     break;
	  case CONTROL_SLIDESPEEDMAP:
	     mode.slidespeedmap = atoi(s2);
	     break;
	  case CONTROL_SLIDESPEEDCLEANUP:
	     mode.slidespeedcleanup = atoi(s2);
	     break;
	  case CONTROL_DESKTOP_BG_TIMEOUT:
	     mode.desktop_bg_timeout = atoi(s2);
	     break;
	  case CONTROL_BUTTON_MOVE_RESISTANCE:
	     mode.button_move_resistance = atoi(s2);
	     break;
	  case CONTROL_AUTOSAVE:
	     mode.autosave = ReturnStringReference(StringList, s2);
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
		   "the following text in the middle of current Control definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a Control block.  Outcome is likely not good.\n");
}

void 
Config_Menu(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];

   Alert("Easter Egg!  Menus aren't implemented yet.\n");

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  default:
	     break;
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a Menu block.  Outcome is likely not good.\n");
}

void 
BorderPartLoad(FILE * ConfigFile, char type, Border * b)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   ImageClass         *iclass = 0;
   ActionClass        *aclass = 0;
   TextClass          *tclass = 0;
   char                ontop = 1;
   int                 flags = FLAG_BUTTON;
   char                isregion = 0;
   int                 wmin = 0, wmax = 0, hmin = 0, hmax = 0, torigin = 0,
                       txp = 0, txa = 0, typ = 0, tya = 0, borigin = 0;
   int                 bxp = 0, bxa = 0, byp = 0, bya = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     AddBorderPart(b, iclass, aclass, tclass, ontop, flags, isregion,
	     wmin, wmax, hmin, hmax, torigin, txp, txa, typ, tya, borigin, bxp,
			   bxa, byp, bya);
	     return;
	  case CONFIG_IMAGECLASS:
	  case BORDERPART_ICLASS:
	     iclass = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS);
	     break;
	  case CONFIG_ACTIONCLASS:
	  case BORDERPART_ACLASS:
	     aclass = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_ACLASS);
	     break;
	  case CONFIG_TEXT:
	  case BORDERPART_TEXTCLASS:
	     tclass = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS);
	     break;
	  case BORDERPART_ONTOP:
	     ontop = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERPART_FLAGS:
	     flags = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERPART_ISREGION:
	     isregion = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERPART_WMIN:
	     wmin = atoi(s2);
	     if (!wmax)
		wmax = wmin;
	     break;
	  case BORDERPART_WMAX:
	     wmax = atoi(s2);
	     break;
	  case BORDERPART_HMIN:
	     hmin = atoi(s2);
	     if (!hmax)
		hmax = hmin;
	     break;
	  case BORDERPART_HMAX:
	     hmax = atoi(s2);
	     break;
	  case BORDERPART_TORIGIN:
	     torigin = atoi(s2);
	     break;
	  case BORDERPART_TXP:
	     txp = atoi(s2);
	     break;
	  case BORDERPART_TXA:
	     txa = atoi(s2);
	     break;
	  case BORDERPART_TYP:
	     typ = atoi(s2);
	     break;
	  case BORDERPART_TYA:
	     tya = atoi(s2);
	     break;
	  case BORDERPART_BORIGIN:
	     borigin = atoi(s2);
	     break;
	  case BORDERPART_BXP:
	     bxp = atoi(s2);
	     break;
	  case BORDERPART_BXA:
	     bxa = atoi(s2);
	     break;
	  case BORDERPART_BYP:
	     byp = atoi(s2);
	     break;
	  case BORDERPART_BYA:
	     bya = atoi(s2);
	     break;
	  default:
	     break;
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a BorderPart block.  Outcome is likely not good.\n");
}

void 
Config_Border(FILE * ConfigFile)
{
   Border             *b = 0;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   char                added = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	if (ReturnStringReference(StringList, s2) == CONFIG_OPEN)
	  {
	     BorderPartLoad(ConfigFile, ReturnStringReference(StringList, s1), b);
	  }
	else
	  {
	     switch (ReturnStringReference(StringList, s1))
	       {
	       case CONFIG_CLOSE:
		  if (!added)
		     AddItem(b, b->name, 0, LIST_TYPE_BORDER);
		  return;
	       case BORDER_INIT:
		  AddItem(b, b->name, 0, LIST_TYPE_BORDER);
		  added = 1;
		  break;
	       case BORDER_NAME:
		  b = CreateBorder(s2);
		  break;
	       case BORDER_LEFT:
		  b->border.left = atoi(s2);
		  break;
	       case BORDER_RIGHT:
		  b->border.right = atoi(s2);
		  break;
	       case BORDER_TOP:
		  b->border.top = atoi(s2);
		  break;
	       case BORDER_BOTTOM:
		  b->border.bottom = atoi(s2);
		  break;
	       default:
		  break;
	       }
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a Main Border block.  Outcome is likely not good.\n");
}

void 
Config_Button(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   char               *name = 0;
   ActionClass        *ac = 0;
   ImageClass         *ic = 0;
   Button             *bt = 0;
   Button             *pbt = 0;
   char                ontop = 0;
   int                 flags = 0, minw = 1, maxw = 99999, minh = 1, maxh = 99999,
                       xo = 0, yo = 0, xa = 0;
   int                 xr = 0, ya = 0, yr = 0, xsr = 0, xsa = 0, ysr = 0,
                       ysa = 0;
   char                simg = 0;
   int                 desk = 0;
   char                sticky = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     if (!pbt)
	       {
		  bt = CreateButton(name, ic, ac, ontop, flags, minw, maxw, minh, maxh,
				    xo, yo, xa, xr, ya, yr, xsr, xsa, ysr, ysa, simg, desk, sticky);
		  AddItem(bt, bt->name, 0, LIST_TYPE_BUTTON);
	       }
	     return;
	  case BORDERPART_ONTOP:
	     ontop = ReturnStringReference(StringList, s2);
	     if (pbt)
		pbt->ontop = ontop;
	     break;
	  case CONFIG_CLASSNAME:
	  case BUTTON_NAME:
	     name = duplicate(s2);
	     pbt = FindItem(name, 0, LIST_FINDBY_NAME, LIST_TYPE_BUTTON);
	     break;
	  case CONFIG_ACTIONCLASS:
	  case BUTTON_ACLASS:
	     ac = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_ACLASS);
	     if (pbt)
		pbt->aclass = ac;
	     break;
	  case CONFIG_IMAGECLASS:
	  case BUTTON_ICLASS:
	     ic = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS);
	     if (pbt)
		pbt->iclass = ic;
	     break;
	  case BORDERPART_WMIN:
	  case BUTTON_MINW:
	     minw = atoi(s2);
	     if (pbt)
		pbt->geom.width.min = minw;
	     break;
	  case BORDERPART_WMAX:
	  case BUTTON_MAXW:
	     maxw = atoi(s2);
	     if (pbt)
		pbt->geom.width.max = maxw;
	     break;
	  case BORDERPART_HMIN:
	  case BUTTON_MINH:
	     minh = atoi(s2);
	     if (pbt)
		pbt->geom.height.min = minh;
	     break;
	  case BORDERPART_FLAGS:
	  case BUTTON_FLAGS:
	     flags = ReturnStringReference(StringList, s2);
	     if (pbt)
		pbt->flags = flags;
	     break;
	  case BORDERPART_HMAX:
	  case BUTTON_MAXH:
	     maxh = atoi(s2);
	     if (pbt)
		pbt->geom.height.max = maxh;
	     break;
	  case BUTTON_XO:
	     xo = atoi(s2);
	     if (pbt)
		pbt->geom.xorigin = xo;
	     break;
	  case BUTTON_YO:
	     yo = atoi(s2);
	     if (pbt)
		pbt->geom.yorigin = yo;
	     break;
	  case BUTTON_XA:
	     xa = atoi(s2);
	     if (pbt)
		pbt->geom.xabs = xa;
	     break;
	  case BUTTON_XR:
	     xr = atoi(s2);
	     if (pbt)
		pbt->geom.xrel = xr;
	     break;
	  case BUTTON_YA:
	     ya = atoi(s2);
	     if (pbt)
		pbt->geom.yabs = ya;
	     break;
	  case BUTTON_YR:
	     yr = atoi(s2);
	     if (pbt)
		pbt->geom.yrel = yr;
	     break;
	  case BUTTON_XSR:
	     xsr = atoi(s2);
	     if (pbt)
		pbt->geom.xsizerel = xsr;
	     break;
	  case BUTTON_XSA:
	     xsa = atoi(s2);
	     if (pbt)
		pbt->geom.xsizeabs = xsa;
	     break;
	  case BUTTON_YSR:
	     ysr = atoi(s2);
	     if (pbt)
		pbt->geom.ysizerel = ysr;
	     break;
	  case BUTTON_YSA:
	     ysa = atoi(s2);
	     if (pbt)
		pbt->geom.ysizeabs = ysa;
	     break;
	  case BUTTON_SIMG:
	     simg = ReturnStringReference(StringList, s2);
	     if (pbt)
		pbt->geom.size_from_image = simg;
	     break;
	  case BUTTON_DESK:
	     desk = atoi(s2);
	     if (pbt)
		pbt->desktop = desk;
	     break;
	  case BUTTON_STICKY:
	     sticky = ReturnStringReference(StringList, s2);
	     if (pbt)
		pbt->sticky = sticky;
	     break;
	  default:
	     break;
	  }
     }
   if (name)
      Efree(name);
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a Button block.  Outcome is likely not good.\n");
}

void 
Config_Desktop(FILE * ConfigFile)
{
   ImlibColor          icl;
   Background         *bg = 0;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   int                 i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
   int                 j1 = 0, j2 = 0, j3 = 0, j4 = 0, j5 = 0;
   char               *bg1 = 0;
   char               *bg2 = 0;
   char               *name = 0;

   icl.r = 0;
   icl.g = 0;
   icl.b = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  case BG_NAME:
	     name = duplicate(s2);
	     break;
	  case BG_DESKNUM:
	     /* if its the root desktop and its another visual ... */
	     /* create a desktop def all on its own */
	     if ((ird) && (atoi(s2) == 0))
		bg = NULL;
	     if (!bg)
	       {
		  bg = CreateDesktopBG(name, &icl, bg1, i1, i2, i3, i4, i5, i6, bg2, j1, j2, j3, j4, j5);
		  AddItem(bg, bg->name, 0, LIST_TYPE_BACKGROUND);
	       }
	     SetDesktopBg(atoi(s2), bg);
	     if ((ird) && (atoi(s2) == 0))
		bg = NULL;
	     break;
	  case BG_RGB:
	     sscanf(s, "%4000s %d %d %d", s1, &icl.r, &icl.g, &icl.b);
	     break;
	  case BG_BG1:
	     sscanf(s, "%4000s %4000s %d %d %d %d %d %d", s1, s2, &i1, &i2, &i3, &i4, &i5, &i6);
	     bg1 = duplicate(s2);
	     break;
	  case BG_BG2:
	     sscanf(s, "%4000s %4000s %d %d %d %d %d", s1, s2, &j1, &j2, &j3, &j4, &j5);
	     bg2 = duplicate(s2);
	     break;
	  default:
	     break;
	  }
     }
   if (name)
      Efree(name);
   if (bg1)
      Efree(bg1);
   if (bg2)
      Efree(bg2);
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading a Desktop block.  Outcome is likely not good.\n");
}

void 
Config_Iconbox(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];

   Alert("Easter Egg!  Iconboxes aren't implemented yet.\n");

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  default:
	     break;
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading an Iconbox block.  Outcome is likely not good.\n");
}

void 
Config_Sound(FILE * ConfigFile)
{
   SoundClass         *sc;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  default:
	     sc = CreateSoundClass(s1, s2);
	     AddItem(sc, sc->name, 0, LIST_TYPE_SCLASS);
	     break;

	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading an Iconbox block.  Outcome is likely not good.\n");
}

void 
Config_ActionClass(FILE * ConfigFile)
{
   ActionClass        *ac = 0;
   Action             *a = 0;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   char                s3[FILEPATH_LEN_MAX];
   char                event = 0;
   char                anymod = 0;
   int                 mod = 0;
   int                 anybut = 0;
   int                 but = 0;
   int                 first = 1;
   char                anykey = 0;
   char               *key = 0;
   char global = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     return;
	  case CONFIG_CLASSNAME:
	  case ACLASS_NAME:
	     ac = CreateAclass(s2);
	     break;
	  case CONFIG_TYPE:
	  case ACLASS_TYPE:
	     AddItem(ac, ac->name, 0, ReturnStringReference(StringList, s2));
	     if (ReturnStringReference(StringList, s2) == LIST_TYPE_ACLASS_GLOBAL)
		global = 1;

	     break;
	  case CONFIG_MODIFIER:
	  case ACLASS_MODIFIER:
	     /* These are the defines that I have listed...
	      * These, therefore, are the ones that I am going to accept by default.
	      * REMINDER: add and'ing in future!!!!
	      * #define ShiftMask       (1<<0)
	      * #define LockMask        (1<<1)
	      * #define ControlMask     (1<<2)
	      * #define Mod1Mask        (1<<3)
	      * #define Mod2Mask        (1<<4)
	      * #define Mod3Mask        (1<<5)
	      * #define Mod4Mask        (1<<6)
	      * #define Mod5Mask        (1<<7)
	      */
	     switch (ReturnStringReference(StringList, s2))
	       {

	       case MASK_SHIFT:
		  mod = ShiftMask;
		  break;
	       case MASK_LOCK:
		  mod = LockMask;
		  break;
	       case MASK_CTRL:
		  mod = ControlMask;
		  break;
	       case MASK_MOD1:
		  mod = Mod1Mask;
		  break;
	       case MASK_MOD2:
		  mod = Mod2Mask;
		  break;
	       case MASK_MOD3:
		  mod = Mod3Mask;
		  break;
	       case MASK_MOD4:
		  mod = Mod4Mask;
		  break;
	       case MASK_MOD5:
		  mod = Mod5Mask;
		  break;
	       case MASK_CTRL_ALT:
		  mod = ControlMask | Mod1Mask;
		  break;
	       case MASK_SHIFT_ALT:
		  mod = ShiftMask | Mod1Mask;
		  break;
	       case MASK_CTRL_SHIFT:
		  mod = ShiftMask | ControlMask;
		  break;
	       case MASK_CTRL_SHIFT_ALT:
		  mod = ShiftMask | ControlMask | Mod1Mask;
	       default:
		  break;
	       }
	     break;
	  case CONFIG_ANYMOD:
	  case ACLASS_ANYMOD:
	     anymod = ReturnStringReference(StringList, s2);
	     break;
	  case CONFIG_ANYBUT:
	  case ACLASS_ANYBUT:
	     anybut = ReturnStringReference(StringList, s2);
	     break;
	  case CONFIG_BUTTON:
	  case ACLASS_BUT:
	     but = atoi(s2);
	     break;
	  case CONFIG_ANYKEY:
	  case ACLASS_ANYKEY:
	     anykey = ReturnStringReference(StringList, s2);
	     break;
	  case ACLASS_KEY:
	     key = duplicate(s2);
	     break;
	  case ACLASS_EVENT_TRIGGER:
	     event = ReturnStringReference(StringList, s2);
	     break;
	  case CONFIG_NEXT:
	     first = 1;
	     break;
	  case ACLASS_ACTION:
	     if (first)
	       {
		  a = CreateAction(event, anymod, mod, anybut, but, anykey, key);
		  /* the correct place to grab an action key */
		  if (global)
		     GrabActionKey(a);
		  AddAction(ac, a);
		  first = 0;
	       }
	     s3[0] = 0;
	     sscanf(s, "%4000s %4000s %4000s", s1, s2, s3);
	     if (!s3[0])
	       {
		  AddToAction(a, ReturnStringReference(StringList, s2), NULL);
	       }
	     else
	       {
		  AddToAction(a, ReturnStringReference(StringList, s2), duplicate(strstr(s, s3)));
	       }
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
		   "the following text in the middle of current ActionClass definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	     break;
	  }
     }
   if (key)
      Efree(key);
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading an Action Class block.  Outcome is likely not good.\n");
}

void 
Config_ImageClass(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   ImageClass         *ic = 0;
   ImageState         *ICToRead = 0;
   ColorModifierClass *cm = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     IclassPopulate(ic);
	     AddItem(ic, ic->name, 0, LIST_TYPE_ICLASS);
	     return;
	  case ICLASS_LRTB:
	     {
		char                s3[FILEPATH_LEN_MAX];
		char                s4[FILEPATH_LEN_MAX];
		char                s5[FILEPATH_LEN_MAX];

		ICToRead->border = Emalloc(sizeof(ImlibBorder));

		sscanf(s, "%4000s %4000s %4000s %4000s %4000s", s1, s2, s3, s4, s5);
		ICToRead->border->left = atoi(s2);
		ICToRead->border->right = atoi(s3);
		ICToRead->border->top = atoi(s4);
		ICToRead->border->bottom = atoi(s5);
	     }
	     break;
	  case CONFIG_INHERIT:
	     {
		ImageClass         *ICToInherit;

		ICToInherit = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS);
		ic->norm = ICToInherit->norm;
		ic->active = ICToInherit->active;
		ic->sticky = ICToInherit->sticky;
		ic->sticky_active = ICToInherit->sticky_active;
		ic->padding = ICToInherit->padding;
		ic->colmod = ICToInherit->colmod;
		ic->external = ICToInherit->external;
	     }
	     break;
	  case ICLASS_SUPERIMPOSE:
	     break;
	  case CONFIG_COLORMOD:
	  case ICLASS_COLORMOD:
	     cm = FindItem(s2, 0, LIST_FINDBY_NAME, LIST_TYPE_COLORMODIFIER);
	     if (ICToRead)
		ICToRead->colmod = cm;
	     else
		ic->colmod = cm;
	     break;
	  case ICLASS_PADDING:
	     {
		char                s3[FILEPATH_LEN_MAX];
		char                s4[FILEPATH_LEN_MAX];
		char                s5[FILEPATH_LEN_MAX];

		sscanf(s, "%4000s %4000s %4000s %4000s %4000s", s1, s2, s3, s4, s5);
		ic->padding.left = atoi(s2);
		ic->padding.right = atoi(s3);
		ic->padding.top = atoi(s4);
		ic->padding.bottom = atoi(s5);
	     }
	     break;
	  case CONFIG_CLASSNAME:
	  case ICLASS_NAME:
	     ic = CreateIclass();
	     ic->name = duplicate(s2);
	     break;
	  case CONFIG_DESKTOP:
	     /* don't ask... --mandrake */
	  case ICLASS_NORMAL:
	     ic->norm.normal = CreateImageState();
	     ic->norm.normal->im_file = duplicate(s2);
	     ICToRead = ic->norm.normal;
	     break;
	  case ICLASS_CLICKED:
	     ic->norm.clicked = CreateImageState();
	     ic->norm.clicked->im_file = duplicate(s2);
	     ICToRead = ic->norm.clicked;
	     break;
	  case ICLASS_HILITED:
	     ic->norm.hilited = CreateImageState();
	     ic->norm.hilited->im_file = duplicate(s2);
	     ICToRead = ic->norm.hilited;
	     break;
	  case ICLASS_DISABLED:
	     ic->norm.disabled = CreateImageState();
	     ic->norm.disabled->im_file = duplicate(s2);
	     ICToRead = ic->norm.disabled;
	     break;
	  case ICLASS_STICKY_NORMAL:
	     ic->sticky.normal = CreateImageState();
	     ic->sticky.normal->im_file = duplicate(s2);
	     ICToRead = ic->sticky.normal;
	     break;
	  case ICLASS_STICKY_CLICKED:
	     ic->sticky.clicked = CreateImageState();
	     ic->sticky.clicked->im_file = duplicate(s2);
	     ICToRead = ic->sticky.clicked;
	     break;
	  case ICLASS_STICKY_HILITED:
	     ic->sticky.hilited = CreateImageState();
	     ic->sticky.hilited->im_file = duplicate(s2);
	     ICToRead = ic->sticky.hilited;
	     break;
	  case ICLASS_STICKY_DISABLED:
	     ic->sticky.disabled = CreateImageState();
	     ic->sticky.disabled->im_file = duplicate(s2);
	     ICToRead = ic->sticky.disabled;
	     break;
	  case ICLASS_ACTIVE_NORMAL:
	     ic->active.normal = CreateImageState();
	     ic->active.normal->im_file = duplicate(s2);
	     ICToRead = ic->active.normal;
	     break;
	  case ICLASS_ACTIVE_CLICKED:
	     ic->active.clicked = CreateImageState();
	     ic->active.clicked->im_file = duplicate(s2);
	     ICToRead = ic->active.clicked;
	     break;
	  case ICLASS_ACTIVE_HILITED:
	     ic->active.hilited = CreateImageState();
	     ic->active.hilited->im_file = duplicate(s2);
	     ICToRead = ic->active.hilited;
	     break;
	  case ICLASS_ACTIVE_DISABLED:
	     ic->active.disabled = CreateImageState();
	     ic->active.disabled->im_file = duplicate(s2);
	     ICToRead = ic->active.disabled;
	     break;
	  case ICLASS_STICKY_ACTIVE_NORMAL:
	     ic->sticky_active.normal = CreateImageState();
	     ic->sticky_active.normal->im_file = duplicate(s2);
	     ICToRead = ic->sticky_active.normal;
	     break;
	  case ICLASS_STICKY_ACTIVE_CLICKED:
	     ic->sticky_active.clicked = CreateImageState();
	     ic->sticky_active.clicked->im_file = duplicate(s2);
	     ICToRead = ic->active.clicked;
	     break;
	  case ICLASS_STICKY_ACTIVE_HILITED:
	     ic->sticky_active.hilited = CreateImageState();
	     ic->sticky_active.hilited->im_file = duplicate(s2);
	     ICToRead = ic->sticky_active.hilited;
	     break;
	  case ICLASS_STICKY_ACTIVE_DISABLED:
	     ic->sticky_active.disabled = CreateImageState();
	     ic->sticky_active.disabled->im_file = duplicate(s2);
	     ICToRead = ic->sticky_active.disabled;
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
		   "the following text in the middle of current ImageClass definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	     break;
	  }
     }
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading an ImageClass block.  Outcome is likely not good.\n");
}

void 
Config_ColorModifier(FILE * ConfigFile)
{
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   char               *name = 0;
   char               *params = 0;
   char               *current_param = 0;
   unsigned char      *rx = 0;
   unsigned char      *ry = 0;
   unsigned char      *gx = 0;
   unsigned char      *gy = 0;
   unsigned char      *bx = 0;
   unsigned char      *by = 0;
   int                 i = 0;
   int                 rnum = 0, gnum = 0, bnum = 0;
   ColorModifierClass *cm;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	i = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     cm = CreateCMClass(name, rnum, rx, ry, gnum, gx, gy, bnum, bx, by);
	     AddItem(cm, cm->name, 0, LIST_TYPE_COLORMODIFIER);
	     Efree(rx);
	     Efree(ry);
	     Efree(gx);
	     Efree(gy);
	     Efree(bx);
	     Efree(by);
	     return;
	  case CONFIG_CLASSNAME:
	     name = duplicate(s2);
	     break;
	  case COLORMOD_RED:
	     params = strstr(s, s2);
	     strtok(params, " ");
	     while ((current_param = strtok(params, " ")))
	       {
		  if (rx)
		    {
		       rx = Erealloc(rx, sizeof(unsigned char) * (i + 1));
		       ry = Erealloc(ry, sizeof(unsigned char) * (i + 1));
		    }
		  else
		    {
		       rx = Emalloc(sizeof(unsigned char));
		       ry = Emalloc(sizeof(unsigned char));
		    }
		  rx[i] = (unsigned char)atoi(strtok(current_param, ","));
		  ry[i++] = (unsigned char)atoi(strtok(current_param, ","));
	       }
	     rnum = i;
	     break;
	  case COLORMOD_GREEN:
	     params = strstr(s, s2);
	     strtok(params, " ");
	     while ((current_param = strtok(params, " ")))
	       {
		  if (gx)
		    {
		       gx = Erealloc(rx, sizeof(unsigned char) * (i + 1));
		       gy = Erealloc(ry, sizeof(unsigned char) * (i + 1));
		    }
		  else
		    {
		       gx = Emalloc(sizeof(unsigned char));
		       gy = Emalloc(sizeof(unsigned char));
		    }
		  gx[i] = (unsigned char)atoi(strtok(current_param, ","));
		  gy[i++] = (unsigned char)atoi(strtok(current_param, ","));
	       }
	     gnum = i;
	     break;
	  case COLORMOD_BLUE:
	     params = strstr(s, s2);
	     strtok(params, " ");
	     while ((current_param = strtok(params, " ")))
	       {
		  if (bx)
		    {
		       bx = Erealloc(rx, sizeof(unsigned char) * (i + 1));
		       by = Erealloc(ry, sizeof(unsigned char) * (i + 1));
		    }
		  else
		    {
		       bx = Emalloc(sizeof(unsigned char));
		       by = Emalloc(sizeof(unsigned char));
		    }
		  bx[i] = (unsigned char)atoi(strtok(current_param, ","));
		  by[i++] = (unsigned char)atoi(strtok(current_param, ","));
	       }
	     bnum = i;
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
		   "the following text in the middle of current "
		   " ColorModifier definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	     break;
	  }
     }
   if (name)
      Efree(name);
   Alert("Warning:  Configuration appears to have ended before we were\n"
	 "Done loading an ColorModifier block.\n"
	 "Outcome is likely not good.\n");
}

void 
Config_BorderMatch(FILE * ConfigFile)
{
   BorderMatch        *bm = 0;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];
   char               *name = 0;

   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	switch (ReturnStringReference(StringList, s1))
	  {
	  case CONFIG_CLOSE:
	     AddItem(bm, bm->name, 0, LIST_TYPE_BORDERMATCH);
	     return;
	  case CONFIG_CLASSNAME:
	     name = duplicate(s2);
	     break;
	  case CONFIG_BORDER:
	  case BORDERMATCH_USEBORDER:
	     bm = CreateBorderMatch(name, s2);
	     break;
	  case BORDERMATCH_MATCHNAME:
	     bm->win_name = duplicate(strstr(s, s2));
	     break;
	  case BORDERMATCH_MATCHCLASS:
	     bm->win_class = duplicate(strstr(s, s2));
	     break;
	  case BORDERMATCH_MATCHTITLE:
	     bm->win_title = duplicate(strstr(s, s2));
	     break;
	  case BORDERMATCH_WIDTH:
	     {
		char                s3[FILEPATH_LEN_MAX];

		sscanf(s, "%4000s %4000s %4000s", s1, s2, s3);
		bm->width.min = atoi(s2);
		bm->width.max = atoi(s3);
	     }
	     break;
	  case BORDERMATCH_HEIGHT:
	     {
		char                s3[FILEPATH_LEN_MAX];

		sscanf(s, "%4000s %4000s %4000s", s1, s2, s3);
		bm->height.min = atoi(s2);
		bm->height.max = atoi(s3);
	     }
	     break;
	  case BORDERMATCH_TRANSIENT:
	     bm->transient = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERMATCH_NO_RESIZE_H:
	     bm->no_resize_h = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERMATCH_NO_RESIZE_V:
	     bm->no_resize_v = ReturnStringReference(StringList, s2);
	     break;
	  case BORDERMATCH_SHAPED:
	     bm->shaped = ReturnStringReference(StringList, s2);
	     break;
	  default:
	     Alert("Warning: unable to determine what to do with\n"
		   "the following text in the middle of current "
		   "BorderMatch definition:\n"
		   "%s\nWill ignore and continue...\n", s);
	     break;
	  }
     }
   if (name)
      Efree(name);
   Alert("Warning: Configuration appears to have ended before we were\n"
	 "Done loading an BorderMatch block.  Outcome is likely not good.\n");
}

int 
LoadConfigFile(char *file)
{
   FILE               *ConfigFile;
   char                s[FILEPATH_LEN_MAX];
   char                s1[FILEPATH_LEN_MAX];
   char                s2[FILEPATH_LEN_MAX];

   EDBUG(5, "LoadConfigFile");
   ConfigFile = fopen(file, "r");
   if (!ConfigFile)
      EDBUG_RETURN(0);
   while (GetNextLine(s, ConfigFile))
     {
	s2[0] = 0;
	sscanf(s, "%4000s %4000s", s1, s2);
	if (ReturnStringReference(StringList, s2) == CONFIG_OPEN)
	  {
	     switch (ReturnStringReference(StringList, s1))
	       {
	       case CONFIG_CLOSE:
		  fclose(ConfigFile);
		  EDBUG_RETURN(1);
	       case CONFIG_IMAGECLASS:
		  Config_ImageClass(ConfigFile);
		  break;
	       case CONFIG_TEXT:
		  Config_Text(ConfigFile);
		  break;
	       case CONFIG_MENU:
		  Config_Menu(ConfigFile);
		  break;
	       case CONFIG_BORDER:
		  Config_Border(ConfigFile);
		  break;
	       case CONFIG_BUTTON:
		  Config_Button(ConfigFile);
		  break;
	       case CONFIG_DESKTOP:
		  Config_Desktop(ConfigFile);
		  break;
	       case CONFIG_ICONBOX:
		  Config_Iconbox(ConfigFile);
		  break;
	       case CONFIG_CONTROL:
		  Config_Control(ConfigFile);
		  break;
	       case CONFIG_BORDERMATCH:
		  Config_BorderMatch(ConfigFile);
		  break;
	       case CONFIG_COLORMOD:
		  Config_ColorModifier(ConfigFile);
		  break;
	       case CONFIG_SOUND:
		  Config_Sound(ConfigFile);
		  break;
	       case CONFIG_ACTIONCLASS:
		  Config_ActionClass(ConfigFile);
		  break;
	       default:
		  Alert("Warning: Whilst loading config files Enlightenment\n"
			"encountered an unknown blocktype:\n"
			"%s\n"
			"Attempting to proceed...(this could prove fatal)\n",
			s1);
		  break;
	       }
	  }
	else
	  {
	     /* D'oh - aparently something slipped by StringLists.  EEK */
	     switch (ReturnStringReference(StringList, s1))
	       {
	       case CONFIG_LOADFILE:
		  LoadConfigFile(s2);
		  break;
	       default:
		  Esnprintf(s2, sizeof(s2), "Warning: Unknown line in configuration:\n"
			    "%s\n.  Attempting to proceed...(this could prove "
			    "fatal)\n", s);

		  Alert(s2);
		  break;
	       }
	  }
     }
   fclose(ConfigFile);
   EDBUG_RETURN(1);
}

int 
LoadStringFiles(void)
{
   char                file_to_load[FILEPATH_LEN_MAX];

   EDBUG(5, "LoadStringFiles");
   Esnprintf(file_to_load, sizeof(file_to_load), "%s/config/definitions",
	     ENLIGHTENMENT_ROOT);
   StringList = GenerateStringList(file_to_load);

   EDBUG_RETURN(0);
}

char               *
ExtractTheme(char *theme)
{
   char                s[FILEPATH_LEN_MAX];
   char                th[FILEPATH_LEN_MAX];
   FILE               *f;
   int                 i;
   unsigned char       buf[1024];

   EDBUG(7, "ExtractTheme");
   if (isdir(theme))
      EDBUG_RETURN(duplicate(theme));
   if (isfile(theme))
     {
	Esnprintf(th, sizeof(th), "/tmp/e_temp_theme_%i-%i-%i-%i-%i",
		  rand(), time(NULL), getpid(), getppid());
	md(th);
	f = fopen(theme, "r");
	if (f)
	  {
	     fread(buf, 1, 1000, f);
	     fclose(f);
	     if ((buf[0] == 31) && (buf[1] == 139))
	       {
		  /*gzipped tarball */
		  /*sprintf(s,"gzip -d -c < %s | tar -xf - -C %s",Theme_Tar_Ball,Theme_Path); */
		  Esnprintf(s, sizeof(s), "gzip -d -c < %s | (cd %s ; tar -xf -)", theme, th);
	       }
	     else if ((buf[257] == 'u') && (buf[258] == 's') && (buf[259] == 't') &&
		      (buf[260] == 'a') && (buf[261] == 'r'))
	       {
		  /*vanilla tarball */
		  /*sprintf(s,"tar -xf - -C %s < %s",Theme_Path,Theme_Tar_Ball); */
		  Esnprintf(s, sizeof(s), "(cd %s ; tar -xf %s", theme, th);
	       }
	     execApplication(s);
	     wait(&i);
	     mustdel = 1;
	     EDBUG_RETURN(duplicate(th));
	  }
     }
   EDBUG_RETURN(NULL);
}

char               *
FindFile(char *file)
{
   char                s[FILEPATH_LEN_MAX];
   char               *hom;

   EDBUG(6, "FindFile");
   if (file[0] == '/')
     {
	if (isfile(file))
	   EDBUG_RETURN(duplicate(file));
     }
   hom = homedir(getuid());
   if (hom)
     {
	Esnprintf(s, sizeof(s), "%s/.enlightenment/%s", hom, file);
	Efree(hom);
	if (isfile(s))
	   EDBUG_RETURN(duplicate(s));
     }
   Esnprintf(s, sizeof(s), "%s/%s", themepath, file);
   if (isfile(s))
      EDBUG_RETURN(duplicate(s));
   Esnprintf(s, sizeof(s), "%s/config/%s", ENLIGHTENMENT_ROOT, file);
   if (isfile(s))
      EDBUG_RETURN(duplicate(s));
   EDBUG_RETURN(NULL);
}

char               *
FindTheme(char *theme)
{
   char                s[FILEPATH_LEN_MAX];
   char               *hom;

   EDBUG(6, "FindTheme");
   if (!theme[0])
     {
	Esnprintf(s, sizeof(s), "%s/config", ENLIGHTENMENT_ROOT);
	EDBUG_RETURN(duplicate(s));
     }
   if (exists(theme))
      EDBUG_RETURN(ExtractTheme(theme));
   hom = homedir(getuid());
   if (hom)
     {
	Esnprintf(s, sizeof(s), "%s/.enlightenment/themes/%s", hom, theme);
	Efree(hom);
	if (exists(s))
	   EDBUG_RETURN(ExtractTheme(s));
     }
   Esnprintf(s, sizeof(s), "%s/themes/%s", ENLIGHTENMENT_ROOT, theme);
   if (exists(s))
      EDBUG_RETURN(ExtractTheme(s));
   Esnprintf(s, sizeof(s), "%s/config", ENLIGHTENMENT_ROOT, theme);
   if (isdir(s))
      EDBUG_RETURN(duplicate(s));
   EDBUG_RETURN(NULL);
}

int 
LoadEConfig(char *themelocation)
{
   char                s[FILEPATH_LEN_MAX];
   char                ss[FILEPATH_LEN_MAX];
   char               *theme, *file, *hom;

   EDBUG(5, "LoadEConfig");
   hom = NULL;
   mustdel = 0;
   if (LoadStringFiles())
     {
	Alert("Warning: No string definitions have been loaded.  This\n"
	      "will have serious repurcusions on system load.  Most\n"
	      "likely, nothing will continue to work at this point.\n"
	      "Enlightenment looked for the file:\n"
	      "%s/config/definitions\n"
	      "This file is the string definitions file that defines what\n"
	      "strings mean what in the Enlightenment configuration files.\n"
	      "Since this couldn't be found Enlightenment is probably not\n"
	      "going to understand anything in any configuration files it\n"
	      "reads in, and so it will have almost no configuration loaded\n"
	      "when it starts up. This is most likely the sign of a bad\n"
	      "installation of Enlightenment if this file is missing.\n"
	      "The likely causes are that the package was improperly built,\n"
	      "if a binary package, or 'make install' hasn't been typed\n"
	      "or during the installation the directory above was not\n"
	      "able to be copied over for installation perhaps due to\n"
	      "permissions or lack of disk space. It also could be that the\n"
	      "definitions file has been inadvertently deleted since\n"
	      "installation.\n"
	      "This is a serious problem and should be rectified immediately\n"
	   "Please contact your system administrator or package maintainer.\n"
	      "If you are the administrator of your own system please\n"
	      "consult the documentation that came with Enlightenment for\n"
	      "addional information.\n", ENLIGHTENMENT_ROOT);

     }
   hom = homedir(getuid());
   Esnprintf(s, sizeof(s), "%s/.enlightenment/", hom);
   Fnlib_add_dir(fd, s);
   Esnprintf(s, sizeof(s), "%s/config/", ENLIGHTENMENT_ROOT);
   Fnlib_add_dir(fd, s);
   theme = FindTheme(themepath);
   if (!theme)
     {
	Alert("Enlightenment has just experienced some major problems in\n"
	      "attempting to load the theme you specified or the default\n"
	      "configuration directory:\n"
	      "%s/config/\n"
	    "This will prevent Enlightenment from loading any configuration\n"
	      "files at all.\n"
	      "Since this couldn't be found Enlightenment is probably not\n"
	      "going to find any configuration files anywhere on your\n"
	      "system, and so it will have almost no configuration loaded\n"
	      "when it starts up. This is most likely the sign of a bad\n"
	      "installation of Enlightenment if this directory is missing.\n"
	      "The likely causes are that the package was improperly built,\n"
	      "if a binary package, or 'make install' hasn't been typed\n"
	      "or during the installation the directory above was not\n"
	      "able to be copied over for installation perhaps due to\n"
	      "permissions or lack of disk space. It also could be that the\n"
	      "config directory has been inadvertently deleted since\n"
	      "installation.\n"
	      "This is a serious problem and should be rectified immediately\n"
	   "Please contact your system administrator or package maintainer.\n"
	      "If you are the administrator of your own system please\n"
	      "consult the documentation that came with Enlightenment for\n"
	      "addional information.\n", ENLIGHTENMENT_ROOT);
	if (hom)
	   Efree(hom);
	EDBUG_RETURN(0);
     }
   strcpy(themepath, theme);
   Esnprintf(s, sizeof(s), "%s/", theme);
   Fnlib_add_dir(fd, s);
   file = FindFile("theme_pre.cfg");
   if (file)
      LoadConfigFile(file);
   file = FindFile("user_main.cfg");
   if (file)
     {
	LoadConfigFile(file);
	Efree(file);
     }
   else
      Alert("Warning: no user_main.cfg configuration file found in the\n"
	    "system configuration directory:\n"
	    "%s/config/\n"
	    "and no user_main.cfg was found in the theme specified or your\n"
	    "user config directory:\n"
	    "~/.enlightenment\n"
	    "This file holds the default user preferences for Enlightenment\n"
	    "and it is a bad sign when it cannot be found.\n"
	    "Enlightenment will continue to load, but the outcome is\n"
	    "very likely not going to be good. Please rectify this as soon\n"
	    "as possible.\n", ENLIGHTENMENT_ROOT);
   file = FindFile("theme_main.cfg");
   if (file)
     {
	LoadConfigFile(file);
	Efree(file);
     }
   else
      Alert("Warning: no theme_main.cfg configuration file found in the\n"
	    "system configuration directory:\n"
	    "%s/config/\n"
	    "and no theme_main.cfg was found in the theme specified or your\n"
	    "user config directory:\n"
	    "~/.enlightenment\n"
	    "This file holds the default theme setup for Enlightenment\n"
	    "and it is a bad sign when it cannot be found.\n"
	    "Enlightenment will continue to load, but the outcome is\n"
	    "very likely not going to be good. Please rectify this as soon\n"
	    "as possible.\n", ENLIGHTENMENT_ROOT);
   Esnprintf(ss, sizeof(ss), "%s/.enlightenment/user_misc.cfg", hom);
   if (isfile(ss))
      LoadConfigFile(ss);
   Esnprintf(ss, sizeof(ss), "%s/.enlightenment/user_autosaved.cfg", hom);
   if (isfile(ss))
      LoadConfigFile(ss);
   Efree(theme);
   DestroyStringList(StringList);
   if (hom)
      Efree(hom);
   EDBUG_RETURN(0);
}

/**************************************************************************/

void 
DeleteUserControlConfig()
{
   char                s[FILEPATH_LEN_MAX];
   char               *hom;

   EDBUG(5, "DeleteUserControlConfig");
   hom = homedir(getuid());
   Esnprintf(s, sizeof(s), "%s/.enlightenment/user_autosaved.cfg", hom);
   if (isfile(s))
      rm(s);
}

void 
SaveUserControlConfig()
{
   char                s[FILEPATH_LEN_MAX];
   char               *hom;
   FILE               *f;
   Button            **blst;
   int                 i, num, flags;

   char               *c_onoff[2] =
   {"off", "on"};
   char               *c_focus[3] =
   {"pointer", "sloppy", "click"};
   char               *c_move[2] =
   {"opaque", "box"};
   char               *c_flags[5] =
   {"FLAG_TITLE", "FLAG_MINIICON", "FLAG_FIXED",
    "FLAG_FIXED_HORIZ", "FLAG_FIXED_VERT"};

   EDBUG(5, "SaveUserControlConfig");
   hom = homedir(getuid());
   Esnprintf(s, sizeof(s), "%s/.enlightenment/user_autosaved.cfg", hom);
   f = fopen(s, "w");
   if (f)
     {
	fprintf(f, "#########################\n");
	fprintf(f, "# Automatically written config file with user settings written on exit of E\n");
	fprintf(f, "#########################\n");
	fprintf(f, "control {\n");
	fprintf(f, "  focus %s\n", c_focus[(int)mode.focusmode]);
	fprintf(f, "  move %s\n", c_move[(int)mode.movemode]);
	fprintf(f, "  resize %s\n", c_move[(int)mode.resizemode]);
	fprintf(f, "  sound %s\n", c_onoff[(int)mode.sound]);
	fprintf(f, "  slidemode %s\n", c_move[(int)mode.slidemode]);
	fprintf(f, "  slidecleanup %s\n", c_onoff[(int)mode.cleanupslide]);
	fprintf(f, "  mapslide %s\n", c_onoff[(int)mode.mapslide]);
	fprintf(f, "  slidespeedmap %i\n", mode.slidespeedmap);
	fprintf(f, "  slidespeedcleanup %i\n", mode.slidespeedcleanup);
	fprintf(f, "  desktopbgtimeout %i\n", mode.desktop_bg_timeout);
	fprintf(f, "  buttonmoveresistance %i\n", mode.button_move_resistance);
	fprintf(f, "  dragdir %i\n", desks.dragdir);
	fprintf(f, "  dragbarwidth %i\n", desks.dragbar_width);
	fprintf(f, "  dragbarordering %i\n", desks.dragbar_ordering);
	fprintf(f, "  dragbarlength %i\n", desks.dragbar_length);
	fprintf(f, "  slidein %s\n", c_onoff[(int)desks.slidein]);
	fprintf(f, "  slidespeed %i\n", desks.slidespeed);
	fprintf(f, "  hiqualbg %s\n", c_onoff[(int)desks.hiqualitybg]);
	fprintf(f, "  autosave %s\n", c_onoff[(int)mode.autosave]);
	fprintf(f, "}\n");
	blst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 0);
	if ((blst) && (num > 0))
	  {
	     for (i = 0; i < num; i++)
	       {
		  fprintf(f, "\n");
		  fprintf(f, "button {\n");
		  fprintf(f, "  name %s\n", blst[i]->name);
		  if (blst[i]->iclass)
		     fprintf(f, "  imageclass %s\n", blst[i]->iclass->name);
		  if (blst[i]->aclass)
		     fprintf(f, "  actionclass %s\n", blst[i]->aclass->name);
		  if (blst[i]->ontop >= 0)
		     fprintf(f, "  ontop %s\n", c_onoff[(int)blst[i]->ontop]);
		  fprintf(f, "  minw %i\n", blst[i]->geom.width.min);
		  fprintf(f, "  maxw %i\n", blst[i]->geom.width.max);
		  fprintf(f, "  minh %i\n", blst[i]->geom.height.min);
		  fprintf(f, "  maxh %i\n", blst[i]->geom.height.max);
		  fprintf(f, "  xo %i\n", blst[i]->geom.xorigin);
		  fprintf(f, "  yo %i\n", blst[i]->geom.yorigin);
		  fprintf(f, "  xa %i\n", blst[i]->geom.xabs);
		  fprintf(f, "  xr %i\n", blst[i]->geom.xrel);
		  fprintf(f, "  ya %i\n", blst[i]->geom.yabs);
		  fprintf(f, "  yr %i\n", blst[i]->geom.yrel);
		  fprintf(f, "  xsr %i\n", blst[i]->geom.xsizerel);
		  fprintf(f, "  xsa %i\n", blst[i]->geom.xsizeabs);
		  fprintf(f, "  ysr %i\n", blst[i]->geom.ysizerel);
		  fprintf(f, "  ysa %i\n", blst[i]->geom.ysizeabs);
		  fprintf(f, "  bsimg %s\n", c_onoff[(int)blst[i]->geom.size_from_image]);
		  fprintf(f, "  sticky %s\n", c_onoff[(int)blst[i]->sticky]);
		  if (blst[i]->flags)
		    {
		       flags = 0;
		       if (((blst[i]->flags & FLAG_FIXED_HORIZ) &&
			    (blst[i]->flags & FLAG_FIXED_VERT)) ||
			   (blst[i]->flags & FLAG_FIXED))
			  flags = 2;
		       else if (blst[i]->flags & FLAG_FIXED_HORIZ)
			  flags = 3;
		       else if (blst[i]->flags & FLAG_FIXED_VERT)
			  flags = 4;
		       else if (blst[i]->flags & FLAG_TITLE)
			  flags = 0;
		       else if (blst[i]->flags & FLAG_MINIICON)
			  flags = 1;
		       fprintf(f, "  flags %s\n", c_flags[flags]);
		    }
		  fprintf(f, "}\n");
	       }
	     Efree(blst);
	  }
	fclose(f);
     }
   if (hom)
      Efree(hom);
   EDBUG_RETURN_;
}
