/*
 *--------------------------------*-C-*---------------------------------
 * File:        graphics.h
 *
 * Copyright (c) 1994 R. Nation <nation@rocket.sanders.lockheed.com>
 * Copyright (c) 1997 Mj Olesen <olesen@me.QueensU.CA>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License version
 *  2 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

#ifndef _GRAPHICS_H
#define _GRAPHICS_H

#include <X11/Xfuncproto.h>

/*
 * number of graphics points
 * divisible by 2 (num lines)
 * divisible by 4 (num rect)
 */
#define	NGRX_PTS	1000

_XFUNCPROTOBEGIN

extern void
 Gr_ButtonReport(int /* but */ ,
		 int /* x */ ,
		 int /* y */ );

extern void
 Gr_do_graphics(int /* cmd */ ,
		int /* nargs */ ,
		int /* args */ [],
		unsigned char * /* text */ );

extern void
 Gr_scroll(int /* count */ );

extern void
 Gr_ClearScreen(void);

extern void
 Gr_ChangeScreen(void);

extern void
 Gr_expose(Window /* win */ );

extern void
 Gr_Resize(int /* w */ ,
	   int /* h */ );

extern void
 Gr_reset(void);

extern int
 Gr_Displayed(void);

_XFUNCPROTOEND

#define Gr_ButtonPress(x,y)	((void)0)
#define Gr_ButtonRelease(x,y)	((void)0)
#define Gr_scroll(count)	((void)0)
#define Gr_ClearScreen()	((void)0)
#define Gr_ChangeScreen()	((void)0)
#define Gr_expose(win)		((void)0)
#define Gr_Resize(w,h)		((void)0)
#define Gr_reset()		((void)0)
#define Gr_Displayed()		(0)	/* return zero */

#endif				/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
