#!/bin/sh
#
# WWWOFFLE - World Wide Web Offline Explorer - Version 2.3.
#
# A Perl script to update the configuration file to version 2.3 standard.
#
# Written by Andrew M. Bishop
#
# This file Copyright 1998 Andrew M. Bishop
# It may be distributed under the GNU Public License, version 2, or
# any higher version.  See section COPYING of the GNU Public license
# for conditions under which this file may be redistributed.
#

exec perl -x $0 $1

exit 1

#!perl

$#ARGV==0 || die "Usage: $0 wwwoffle.conf\n";

$conf=$ARGV[0];

#

system "mv $conf $conf.old" || die "Cannot rename config file $conf to $conf.old\n";

open(OLD,"<$conf.old") || die "Cannot open old config file $conf.old to read\n";

open(NEW,">$conf") || die "Cannot open new config file $conf to write\n";

#

if(open(INST,"<wwwoffle.conf.install") || open(INST,"<$conf.install"))
  {
   $section=$comment='';

   while(<INST>)
       {
        if(!$section && (/^[ \t]*[\#{]/ || /^[ \t\r\n]*$/))
             {
              $comment.=$_;
              next;
             }

       if(/^[ \t]*}/)
            {
             $section=$comment='';
             next;
            }

        if(!$section && /^[ \t]*([a-zA-Z]+)[ \t\r\n]*$/)
            {
             $section=$1;
             $comment{$section}=$comment;
             $comment='';
            }
       }

   close(INST);
  }
else
  {
   print "Cannot open wwwoffle.conf.install or $conf.install - no new format comments\n";
  }

$comment{"TAIL"}=$comment;

#

$prevsection='';
$section='';

while(<OLD>)
  {
   next if(!$section && (/^[ \t]*[\#{]/ || /^[ \t\r\n]*$/));

   if(/^[ \t]*{/)
       {
        print NEW $_;
        next;
       }

   if(/^[ \t]*}/)
       {
        $prevsection=$section;
        $section='';

        if($prevsection eq "MIMETypes" && !$gotpac) # Added in version 2.2
            {
             print "New MIME Types - application/x-ns-proxy-autoconfig\n";
             print NEW " .pac = application/x-ns-proxy-autoconfig\n";
            }

        if($prevsection eq "Purge" && !$gotuseurl) # Added in version 2.3
            {
             print "New Option - use-url\n";
             print NEW "\n use-url = no\n";
            }

        if($prevsection eq "DontGet" && !$gotreplacement) # Added in version 2.3
            {
             print "New Option - replacement\n";
             print NEW "\n# replacement = /local/images/trans-1x1.gif\n";
            }

        print NEW $_;
        next;
       }

   if(!$section && /^[ \t]*([a-zA-Z]+)[ \t\r\n]*$/)
       {
        $section=$1;
        $line=$_;

        if($prevsection eq "Options" && $section ne "FetchOptions") # Added in version 2.2
            {
             print "New Section - FetchOptions\n";
             print NEW $comment{"FetchOptions"};
             print NEW "FetchOptions\n";
             print NEW "{\n";
             print NEW " images = $fetch_images\n" if($fetch_images);
             print NEW " frames = $fetch_frames\n" if($fetch_frames);
             print NEW "}\n";
            }

        if($prevsection eq "Proxy" && $section ne "DontIndex") # Added in version 2.3
            {
             print "New Section - DontIndex\n";
             print NEW $comment{"DontIndex"};
             print NEW "DontIndex\n";
             print NEW "{\n";
             print NEW "}\n";
            }

        if($section eq "Mirror") # Renamed in version 2.3
            {
             print "Renamed Section - Alias\n";
             $section="Alias";
            }

        print "Section - $section\n";
        print NEW $comment{$section};
        print NEW "$section\n";
        next;
       }

   $line=$_;

   if($section eq "Options") # Changed in version 2.1 / 2.2
       {
        if($line =~ /fetch-images[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             print "Removed Option - fetch-images\n";
             $fetch_images=$1;
            }
        elsif($line =~ /fetch-frames[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             print "Removed Option - fetch-frames\n";
             $fetch_frames=$1;
            }
        elsif($line =~ /request-changed[ \t]*=[ \t]*(yes|no|0|1)/)
            {
             print "Changed Option - request-changed\n";
             $rhs=-1;
             $rhs=600 if($1 eq "yes" || $1 eq "1");
             print NEW " request-changed = $rhs\n";
            }
        else
            {
             print NEW $line;
            }
       }
   elsif($section eq "CensorHeader") # Changed in version 2.2
       {
        if($line =~ /^[ \t]*([-a-zA-Z0-9]+)[ \t\r\n]*$/)
            {
             print NEW " $1 = \n";
             print "Changed CensorHeader - header line '$1'\n";
            }
        else
            {
             print NEW $line;
            }
       }
   elsif($section eq "MIMETypes") # Added new one in version 2.2
       {
        $gotpac=1 if($line =~ /^[ \t]*\.pac[ \t]*=/);
        print NEW $line;
       }
   elsif($section eq "DontCache" || $section eq "DontGet" || $section eq "DontGetRecursive") # Changed in Version 2.3
       {
        if($section eq "DontGet" && $line =~ /^[ \t]*#?[ \t]*replacement[ \t]*=/)
             {
              $gotreplacement=1;
             }
        elsif($line =~ /^[ \t]*([^ \t#=]+)[ \t]*=[ \t]*([^ \t\n=]+)/)
            {
             $line=" ".&url_spec($1,$2)."\n";
            }
        print NEW $line;
       }
   elsif($section eq "Proxy") # Changed in version 2.3
       {
        if($line =~ /^[ \t]*([^ \t#=]+)[ \t]*=[ \t]*([^ \t\n=]+)/ && $1 !~ /^auth-/)
            {
             $line=" ".&url_spec($1,"/")." = $2\n";
            }
        print NEW $line;
       }
   elsif($section eq "Mirror") # Changed in version 2.3
       {
        if($line =~ /^[ \t]*([^ \t#=]+)[ \t]*=[ \t]*([^ \t\n=]+)/)
            {
             $line1=&url_spec($1,"/");
             $line2=&url_spec($2,"/");
             $line=" $line1 = $line2\n";
            }
        print NEW $line;
       }
   elsif($section eq "Purge") # Changed in version 2.3
       {
        if($line =~ /^[ \t]*#?[ \t]*use-url[ \t]*=/)
             {
              $gotuseurl=1;
             }
        elsif($line =~ /^[ \t]*([^ \t#=]+)[ \t]*=[ \t]*([^ \t\n=]+)/ && $1 !~ /^[a-z]+-[a-z]+/)
            {
             $line=" ".&url_spec($1,"/")." = $2\n";
            }
        print NEW $line;
       }
   else
       {
        print NEW $line;
       }
  }

print NEW $comment{"TAIL"};

#

close(NEW);
close(OLD);

#
# Subroutine to convert HOST-SPECIFICATION and FILE-SPECIFICATION into
# URL-SPECIFICATION.
#

sub url_spec
{
 ($host,$file)=@_;
 $url="";

 return($host) if($host =~ m%://%);

 $url="*://$1"    if($host =~ m%^/?([^:/]+):$%);            # [/]hostname:
 $url="*://$1:"   if($host =~ m%^/?([^:/]+)$%);             # [/]hostname
 $url="$1://$2"   if($host =~ m%^([^:/]+)/([^:/]+):$%);     # protocol/hostname:
 $url="$1://$2:"  if($host =~ m%^([^:/]+)/([^:/]+)$%);      # protocol/hostname
 $url="$1://*"    if($host =~ m%^([^:/]+)/:?$%);            # protocol/[:]
 $url="*://*"     if($host eq "/:" || $host eq "default");
 $url="*://*"     if($host eq "/");

 return("# $host $file") if(!$url);

 $url.=$file     if($file =~ m%^/%);
 $url.="/*$file" if($file =~ m%^\.%);

 $url="default" if($host eq "default" && $file eq "/");

 return($url);
}
