/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERBitString
extends BERElement {
    private BitSet m_value;
    private int m_value_num_bits;

    public BERBitString(BitSet value) {
        this.m_value = value;
    }

    public BERBitString(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int[] component_length = new int[1];
        BERElement element = null;
        if (contents_length == -1) {
            component_length[0] = 0;
            element = BERElement.getElement(decoder, stream, component_length);
            if (element != null) {
                BERBitString bit_string_element = (BERBitString)element;
                BitSet new_bit_set = new BitSet(this.m_value_num_bits + bit_string_element.getSize());
                int i = 0;
                while (i < this.m_value_num_bits) {
                    if (this.m_value.get(i)) {
                        new_bit_set.set(i);
                    }
                    ++i;
                }
                int j = 0;
                while (j < bit_string_element.getSize()) {
                    if (bit_string_element.getValue().get(j)) {
                        new_bit_set.set(this.m_value_num_bits + j);
                    }
                    ++j;
                }
                this.m_value = new_bit_set;
                this.m_value_num_bits += bit_string_element.getSize();
            }
            while (element != null) {
            }
            return;
        }
        bytes_read[0] = bytes_read[0] + contents_length;
        while (contents_length > 0) {
            component_length[0] = 0;
            element = BERElement.getElement(decoder, stream, component_length);
            if (element != null) {
                BERBitString bit_string_element = (BERBitString)element;
                BitSet new_bit_set = new BitSet(this.m_value_num_bits + bit_string_element.getSize());
                int i = 0;
                while (i < this.m_value_num_bits) {
                    if (this.m_value.get(i)) {
                        new_bit_set.set(i);
                    }
                    ++i;
                }
                int j = 0;
                while (j < bit_string_element.getSize()) {
                    if (bit_string_element.getValue().get(j)) {
                        new_bit_set.set(this.m_value_num_bits + j);
                    }
                    ++j;
                }
                this.m_value = new_bit_set;
                this.m_value_num_bits += bit_string_element.getSize();
            }
            contents_length -= component_length[0];
        }
    }

    public BERBitString(InputStream stream, int[] bytes_read) throws IOException {
        int j;
        int mask;
        int octet;
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int last_unused_bits = stream.read();
        bytes_read[0] = bytes_read[0] + 1;
        this.m_value_num_bits = (--contents_length - 1) * 8 + (8 - last_unused_bits);
        this.m_value = new BitSet();
        int bit_num = 0;
        int i = 0;
        while (i < contents_length - 1) {
            octet = stream.read();
            mask = 128;
            j = 0;
            while (j < 8) {
                if ((octet & mask) > 0) {
                    this.m_value.set(bit_num);
                } else {
                    this.m_value.clear(bit_num);
                }
                ++bit_num;
                mask /= 2;
                ++j;
            }
            ++i;
        }
        octet = stream.read();
        mask = 128;
        j = 0;
        while (j < 8 - last_unused_bits) {
            if ((octet & mask) > 0) {
                this.m_value.set(bit_num);
            } else {
                this.m_value.clear(bit_num);
            }
            ++bit_num;
            mask /= 2;
            ++j;
        }
        bytes_read[0] = bytes_read[0] + contents_length;
    }

    public void write(OutputStream stream) throws IOException {
        int j;
        int bit;
        int new_octet;
        stream.write(3);
        int num_bits = this.m_value_num_bits;
        int last_unused_bits = 8 - num_bits % 8;
        int num_content_octets = num_bits / 8 + 1;
        if (last_unused_bits > 0) {
            ++num_content_octets;
        }
        stream.write(num_content_octets);
        stream.write(last_unused_bits);
        int i = 0;
        while (i < num_bits / 8) {
            new_octet = 0;
            bit = 128;
            j = 0;
            while (j < 8) {
                if (this.m_value.get(i * 8 + j)) {
                    new_octet += bit;
                }
                bit /= 2;
                ++j;
            }
            stream.write(new_octet);
            ++i;
        }
        if (last_unused_bits > 0) {
            new_octet = 0;
            bit = 128;
            j = 0;
            while (j < last_unused_bits) {
                if (this.m_value.get(num_bits / 8 * 8 + j)) {
                    new_octet += bit;
                }
                bit /= 2;
                ++j;
            }
            stream.write(new_octet);
        }
    }

    public BitSet getValue() {
        return this.m_value;
    }

    public int getSize() {
        return this.m_value_num_bits;
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        int bit;
        int octet;
        String hex_string = "";
        int num_bits = this.m_value_num_bits;
        int i = 0;
        while (i < num_bits / 8) {
            octet = 0;
            bit = 128;
            int j = 0;
            while (j < 8) {
                if (this.m_value.get(i * 8 + j)) {
                    octet += bit;
                }
                bit /= 2;
                ++j;
            }
            hex_string = String.valueOf(hex_string) + " " + (byte)octet;
            ++i;
        }
        bit = 128;
        octet = 0;
        int k = 0;
        while (k < num_bits - num_bits / 8) {
            if (this.m_value.get(num_bits / 8 * 8 + k)) {
                octet += bit;
            }
            bit /= 2;
            ++k;
        }
        hex_string = String.valueOf(hex_string) + " " + (byte)octet;
        return "Bitstring {" + hex_string + " }";
    }
}

