#ifndef ___ARENA_STYLE_I_H___
#  define ___ARENA_STYLE_I_H___

/*
 * Header file for "style.c" internal purposes. Look in "style.h" for publics.
 */


#include "types.h"
#include "style.h"

#define S_FONT_FAMILY_HELVETICA	1
#define S_FONT_FAMILY_TIMES	2


#define SW_NORMAL	0
#define SW_IMPORTANT	1 
#define SW_INSIST	2
#define SW_LEGAL	3


#if 0	/* QingLong.01-02-96 */
#define val2num(v)  (assert(v && v->tp == NumVal),    v->num)
#define val2str(v)  (assert(v && v->tp == StringVal), v->str)
#define val2key(v)  (assert(v && v->tp == KeyVal),    v->key)
#define val2head(v) (assert(v && v->tp == ListVal),   v->left)
#define val2tail(v) (assert(v && v->tp == ListVal),   v->right)
#endif


#if 0

typedef struct s_variable
{
    long value;
    int strength;

} *Variable;

typedef struct s_style_elem
{
    int tag;
    int influence;
    char *class;
    HTList *pattern;
    struct s_style_elem *parent;
    HTList *children;
    Variable var[S_NPROPERTY];

    Bool flattened;
    Bool computed[S_NPROPERTY];
    long value[S_NPROPERTY];

} StyleElem;

#endif


#if 0	/* QingLong.01-02-96 */

typedef enum
{
    StringVal,              /* Simple value: a string */
    NumVal,		    /* Simple value: a number */
    KeyVal,		    /* Simple value: a keyword */
    PlusVal,		    /* `+' */
    MinusVal,		    /* `-' */
    TimesVal,		    /* `*' */
    DivVal,		    /* `/' */
    ListVal,		    /* left=head, right=tail */
    InterLoVal,		    /* `<<' */
    InterHiVal		    /* '>>' */
} ValTp;

typedef union _Value
{
    ValTp tp;
    char *str;                  /* Only if tp = StringVal */
    float num;		        /* Only if tp = NumVal */
    char *key;		        /* Only if tp = KeyVal */
    union _Value *left, *right; /* Otherwise */
} *Value;

#endif


typedef enum _StyleType
{
  ST_UNKNOWN,
  ST_FLAG,
  ST_FLOAT,
  ST_RGB,
  ST_PX,
  ST_PT,
  ST_PERCENT,
  ST_EM,
  ST_STR,
  ST_BGSTYLE

} StyleType;


typedef struct _StyleValue
{
  long value;
  Byte type;
  StyleInternalProperty iproperty;

} StyleValue;


typedef struct _StyleSimpleSelector
{
  int element;            /* GI or class */
  char *class;		  /* or None */
#if 0
  AttribSpec attr;
#endif
  StyleFlat *flat;        /* if associated with a flattened style */
} StyleSimpleSelector;


typedef struct _StyleSelector
{
    StyleSimpleSelector ss;
    int specificity;
    struct _StyleSelector *pred;
    struct _StyleSelector *ancestor;
} StyleSelector;


typedef struct _StyleRule
{
    StyleSelector *selector;
    StyleInternalProperty iproperty;
    StyleValue *value_p;
    Byte weight;
    Byte origin;
    Byte specificity;
    char *warning;
} StyleRule;


struct _StyleFlat
{
  StyleValue value[ArenaSI_NPROPERTY];
  Byte weight[ArenaSI_NPROPERTY];
  Byte origin[ArenaSI_NPROPERTY];
  Byte specificity[ArenaSI_NPROPERTY];
 /* Byte status[ArenaSI_NPROPERTY]; */
 /* S_UNSET, S_INITIALIZED, S_INFERRED, S_INHERITED; */
};


struct _StyleSheet
{
 Bool initial_flag;
 Bool leading_flag;
 Bool indent_flag;
 Bool margin_top_flag;
 HTList *iproperty[ArenaSI_NPROPERTY];	/* internal property is the entry
					   point in the style sheet */
};


#if 0	/* QingLong.01-02-97 */
typedef struct _AttribSpec
{
    char *name;
    Value val;
    struct _AttribSpec *next;
} *AttribSpec;
#endif


#if 0
typedef struct _Weight      /* E.g., !legal "WBvS art. 36.5" */
{
    int value;                   /* 0 (default) - 3 (!legal) */
    char *warning;
} Weight;
#endif


#if 0
typedef struct _StyleStackElement
{
    StyleSimpleSelector ss;
} StyleStackElement;
#endif



/*
 * Functions.
 */


#endif /* ifndef ___ARENA_STYLE_I_H___ */
