#ifndef ___ARENA_MAIN_H___
#  define ___ARENA_MAIN_H___

/*
 * main.h function declarations and general defines.
 */


/* General configuration. */
#include "arena.h"

/* Arena global macro definitions */
#include "defs.h"

/* Arena typedefs */
#include "types.h"


#include "HTUtils.h"
#include "HTString.h"
#include "HTList.h"
#include "HTAccess.h"
/* #include "HTEvntrg.h" */
#include "HTFormat.h"
#include "HTAnchor.h"
#include "HTArray.h"
#include "HTUser.h"

#ifdef ARENA_DEBUG	/* QingLong.14-12-96 */
#  include "debug.h"   /* debug.c */
#endif


/*
 * Global variables. :(
 */
extern Display* display;
extern unsigned int display_width, display_height;
extern int depth;
extern double display_pt2px;
extern Visual* visual;
extern Window win;
extern unsigned int win_width, win_height;
extern int screen;

extern GC gc_fill;

extern int sbar_width;

extern Pixmap default_pixmap;
int default_pixmap_width, default_pixmap_height;

extern Cursor hourglass;

extern int ExposeCount;

extern Bool initialised;

extern Bool UsePaper;

extern XFontStruct* Fonts[FONTS];  /* array of fonts */
extern char *FontsName[FONTS];
extern int LineSpacing[FONTS];
extern int BaseLine[FONTS];
extern int StrikeLine[FONTS];
extern int LineThickness[FONTS];

extern Doc* CurrentDoc;
extern Context* context;

extern HTUserProfile* UserProfile;
extern char *ArenaUser;
extern char *Editor;
extern char *Printer;
extern char *Icon;

extern char *HelpURL;

extern Bool UseMailcap;
extern Bool NoStyle;

extern Bool RepeatButtonDown;

extern Bool AbortFlag;

#ifdef ARENA_DEBUG
extern char *LibWWW_traceflags;
#  if 1
extern int library_trace; /* QingLong.08-12-96: Do we need this? What for? */
#  endif
#endif


/*
 * Functions.
 */

#if 1
int GuiEvents(    int Socket, HTRequest* Request,     int SocketOps);
# else
int GuiEvents( SOCKET Socket, HTRequest* Request, SockOps SocketOps);
#endif


int CloneSelf(void);

void Redraw(int x, int y, int w, int h);

void *Pop(void);
void Push(void *);

void SetBanner(char *title);

RETSIGTYPE Exit(int);

void SetSelection(char *s);

char *DetermineValue(char *parm, char *def);



#endif /* _ARENA_WWW_H_ */
