/* MD5C.C - RSA Data Security, Inc., MD5 message-digest algorithm
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
*/

#ifndef _XDMD5_H_
#define _XDMD5_H_

#include <glib.h>

typedef struct _XdeltaMD5Ctx XdeltaMD5Ctx;

struct _XdeltaMD5Ctx {
  guint32 state[4]; /* state (ABCD) */
  guint32 count[2]; /* number of bits, modulo 2^64 (lsb first) */
  guint8 buffer[64]; /* input buffer */
};

void xdp_md5_init   (XdeltaMD5Ctx *);
void xdp_md5_update (XdeltaMD5Ctx *, const guint8 *, guint);
void xdp_md5_final  (guint8*, XdeltaMD5Ctx *);

#endif /* _XDMD5_H_ */
