/* hotkey.h -- graphics and text strings for hotkey
 *
 * Copyright (c) 1998  Jonathan A. Buzzard (jab@hex.prestel.co.uk)
 *
 * Portuguese translations by Joao Carlos Ventura <jcv@poboxes.com>
 * French translations by Tristan Debeaupuis <Tristan.Debeaupuis@hsc.fr>
 * Japanese translations by Daisuke Sato <densuke@ga2.so-net.ne.jp>
 * German translations by Harald Ganzinger <hg@mpi-sb.mpg.de>
 *
 * $Log: hotkey.h,v $
 * Revision 1.5  1998/06/27 21:42:46  jab
 * added German language strings
 *
 * Revision 1.4  1998/06/15 21:17:02  jab
 * Japanese strings added, and graphics modified for monochrome option
 *
 * Revision 1.3  1998/06/13 19:29:21  jab
 * French strings added
 *
 * Revision 1.2  1998/05/08 22:59:48  jab
 * internationalized and Portuguese strings added
 *
 * Revision 1.1  1998/05/05 16:52:46  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#define ENGLISH    0
#define SPANISH    1
#define FRENCH     2
#define GERMAN     3
#define ITALIAN    4
#define PORTUGUESE 5
#define JAPANESE   6

static char *strings[7][2] = {
{"Resume Off", "Resume On"},
{"Resume Off", "Resume On"},
{"Rsume Dsactiv", "Rsume Activ"},
{"Wiederaufnahmemodus aus", "Wiederaufnahmemodus ein"},
{"Resume Off", "Resume On"},
{"Modo Reinicializao", "Modo Pausa"},
{"쥸塼ࡧʤ", "쥸塼ࡧ"}};

static char *text[7][4] = {
{"Low Power", "Economy", "Full Power", "User Settings"},
{"Low Power", "Economy", "Full Power", "User Settings"},
{"Conso Basse", "Economie", "Conso Maximale", "Choix de l'utilisateur"},
{"Energieverbrauch niedrig", "Energieverbrauch mittel", "Energieverbrauch hoch", "Benutzereinstellungen"},
{"Low Power", "Economy", "Full Power", "User Settings"},
{"Consumo Mnimo", "Economia", "Consumo Mximo", "Opes do Utilizador"},
{"", "", "եѥ", "桼"}};


#define BLACK   0
#define RED     1
#define BLUE    2
#define YELLOW  3
#define SILVER  4
#define GRAY    5
#define OLIVE   6
#define MARRON  7
#define NAVY    8
#define WHITE   9

static unsigned short rgb[10][3] = {
	{0x0000, 0x0000, 0x0000}, {0xffff, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xffff}, {0xffff, 0xffff, 0x0000},
	{0xc000, 0xc000, 0xc000}, {0x8000, 0x8000, 0x8000},
	{0xc000, 0xc000, 0x0000}, {0xc000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xc000}, {0xffff, 0xffff, 0xffff}};

static char mono[14] = {1,0,1,0,0,1,1,0,1,1, 1,0,0,1};

static char resumeon[32][32] = {
"                 0000           ",
"                 0  0           ",
"                 0  0           ",
"                 0 0            ",
"                000000          ",
"                010110          ",
"                011110          ",
"                011110          ",
"          0000000111100004      ",
"        00<<<<<<011110<<<0      ",
"       0<<<<<<<00000000040;     ",
"      0<<<<<<<<<<<<<<<<040;     ",
"      000000000000000<4040;     ",
"      06767676767676704040;     ",
"      07676767676767604040;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      0767676767676760400;;     ",
"      06767676767676700;;       ",
"      4000000000000000;         ",
"       4;;;;;;;;;;;;;;          "};


static char resumeoff[32][32] = {
"            ::::::::            ",
"         ::::::::::::::         ",
"       :::::      0 :::::       ",
"      :::         0 0  :::      ",
"     :::         000000 :::     ",
"    :::          010110   ::    ",
"   :: ::         011110    ::   ",
"  :::  ::        011110    :::  ",
"  ::    :: 0000000111100004 ::  ",
" ::      ::<<<<<<011110<<<0  :: ",
" ::     0<::<<<<00000000040; :: ",
" ::    0<<<::<<<<<<<<<<<040; :: ",
"::     00000::00000000<4040;  ::",
"::     067676::767676704040;  ::",
"::     0767676::76767604040;  ::",
"::     06767676::7676704440;  ::",
"::     076767676::767604440;  ::",
"::     0676767676::76704440;  ::",
"::     07676767676::7604440;  ::",
"::     067676767676::704440;  ::",
" ::    0767676767676::04440; :: ",
" ::    06767676767676::4440; :: ",
" ::    076767676767676::440; :: ",
"  ::   0676767676767670::40;::  ",
"  :::  07676767676767604::0:::  ",
"   ::  067676767676767044::::   ",
"    :: 0767676767676760444::    ",
"     :::6767676767676704:::     ",
"      :::67676767676760:::      ",
"       :::::67676767:::::       ",
"         ::::::::::::::         ",
"            ::::::::            "};


static char fullpower[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                99999999        ",
"                =444444=        ",
"                =444444=        ",
"                00544500        ",
"                  0440          ",
"                  0440          ",
"                 =4444=      ==5",
"            =====4<4444======<<5",
"           =<<<<4<444444<<<<<445",
"          =<44444444444455555545",
"          =<45554444444555555555",
"          =44500=444445500000955",
"          =440  554445550    555",
"          5550  05555550     000",
"                 055550         ",
"    2      2      0000          ",
"   22 2   222   2 8             ",
"   2  2 2 222 2 2  2            ",
"  22 22 2     2 22 22           ",
"  2  2  2  2  2  2  2           ",
" 22 22 22  2  22 22 22          ",
" 22 22 22 222 22 22 22          ",
"22  2  22 222 22  2  22         ",
"22 22 22  222  22 22 22         ",
"2  22 22  222  22 22 22         ",
"   22 22  222  22 22            ",
"      22  222  22               "};


static char lowpower[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"            99999999            ",
"            =444444=            ",
"            =444444=            ",
"            00544500            ",
"              0440              ",
"              0440              ",
"             =4444=      ==5    ",
"        =====4<4444======<<5    ",
"       =<<<<4<444444<<<<<445    ",
"      =<44444444444455555545    ",
"      =<45554444444555555555    ",
"      =44500=444445500000955    ",
"      =440  554445550    555    ",
"      5550  05555550     000    ",
"             055550             ",
"       2      0000              ",
"      222                       ",
"      222                       ",
"                                ",
"       2                        ",
"       2                        ",
"      222                       ",
"      222                       ",
"                                ",
"                                ",
"                                ",
"                                "};

static char userpower[32][32] = {
"                  :3:3:3:3:3:3:3",
"                <:<:<:<:<:<:<:<:",
"              :3:3:3:3:3:3:3:3:3",
"             :<:<:<:<:<:<:<:<:<:",
"            :3:355555555:3:3:3:3",
"            <:<5<<<<<<<<55<:<:  ",
"            :3:544444440  53:3  ",
"            <:5 4<444440  5:<:  ",
"            :35 0054400  5:3:   ",
"            :5    040   5:<:    ",
"            5     040   53:     ",
"                 =444=0 55   ==5",
"            =====4<4444======<<5",
"           =<<<<4<444444<<<<<445",
"          =<44444444444455555545",
"          =<45554444444555555555",
"          =44500=444445500000955",
"          =440  554445550    555",
"          5550  05555550     000",
"                 055550         ",
"    2      2      0000          ",
"   22 2   222   2 8             ",
"   2  2 2 222 2 2  2            ",
"  22 22 2     2 22 22           ",
"  2  2  2  2  2  2  2           ",
" 22 22 22  2  22 22 22          ",
" 22 22 22 222 22 22 22          ",
"22  2  22 222 22  2  22         ",
"22 22 22  222  22 22 22         ",
"2  22 22  222  22 22 22         ",
"   22 22  222  22 22            ",
"      22  222  22               "};
