/*
  Replaces some special characters with their ASCII representations.

  Author: Carlo Strozzi <carlos@linux.it>
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX_ARG_LENGTH    256
#define EMPTY			  ""

void show_help( char *my_name)
{
    printf("
        NoSQL operator: %s

Usage:  %s [options]

Options:
    -h        Print this help info.
    -p '/R/'  Translate only those environment variables which name
              matches the regular expression 'R'. The pattern must
              follow the AWK regexp syntax.
    -b        Escape blanks as well. 
    -H        Escape HTML '<' and '>' tags as well.


Translate some special characters in environment variables into their
ASCII escaped representation. For example, the horizontal tab character,
which ASCII decimal code is '9', gets translated into the ASCII sequence
'&#9;'. Prints the results to STDOUT in the form of variable='value' pairs,
suitable for being reused by the invoking shell to make new assignments.
Characters currently translated are: 

                   \\n & \" ' / \\t | < > \\ SPACE 

Default is to translate all the environment variables. Translation can be
applied to only those variables which names match a given regular expression.
The expression must follow the AWK language regular expression syntax.

For instance, to translate only those variables which names begin
with the letter 'W', the command is :  %s -p /^W/ 

Characters that are special to the Unix shell must be escaped on the
command line, as usual.

This operator is especially useful to write CGI programs for the WWW,
using the 'uncgi' utility (see http://hyperion.com/~koreth/uncgi.html).

An example of usage of this operator from within a shell script which
is run under 'uncgi' is :

                 eval `%s -p '/^WWW_/'`


'$Id: nsq-xenv.c,v 1.1 1998/05/29 20:43:01 carlos Exp $'

            ----------------------
NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.
This program comes with ABSOLUTELY NO WARRANTY; for details
refer to the GNU General Public License.

You should have received a copy of the GNU General Public License
along with this program;  if not, write to the Free Software
Foundation, Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307
USA.
            ----------------------\n",my_name,my_name,my_name,my_name,"\\");
}

int main( int  argc, char *argv[] ) {
  
  /* For getopt() */
  extern char* optarg;
  extern int optind;

  /* for the rest of the program. */
  register int
	a_loop;
  char
	*my_name=argv[0],
	cmd_buf[MAX_COMMAND_LENGTH],
	v_pattern[MAX_ARG_LENGTH]="/.*/";

  int debug=0, blanks=0, html=0;

  while ((a_loop = getopt(argc, argv, "xhHbp:")) != EOF) {
    switch (a_loop) {
      case 'h':
        show_help(my_name);
        exit(0);
        break;
      case 'x': 
        debug=1;
        break;
      case 'p': 
        snprintf(v_pattern,MAX_ARG_LENGTH,"%s", optarg);
        break;
      case 'H': 
        html=1;
        break;
      case 'b': 
        blanks=1;
        break;
      default:
        show_help(my_name);
        exit(1);
    }
  }

  snprintf(cmd_buf,MAX_COMMAND_LENGTH,"#
#
BEGIN { NULL=\"\"; FS=\"\\n\"; RS=NULL; ORS=\"\\n\"
  for( env in ENVIRON ) {
	if( env !~ %s ) continue

    var = ENVIRON[ env ]

    # AWK metacharacters: \"&\" MUST be done first.
    gsub( \"\\&\", \"\\&#38;\", var )
    gsub( \"\\\\\", \"\\&#92;\", var )
    gsub( \"\\042\", \"\\&#34;\", var )

    # General metacharacters.
    gsub( \"\\n\", \"\\&#10;\", var )
    if(%d) gsub( \" \", \"\\&#32;\", var )
    gsub( \"'\", \"\\&#39;\", var )

    # SED metacharacters.
    #gsub( \"\\/\", \"\\&#47;\", var )

    # NoSQL metacharacters
    gsub( \"\\t\", \"\\&#9;\", var )
    gsub( \"\\|\", \"\\&#124;\", var )

    if(%d) {
      # HTML metacharacters: < >
      gsub( \"<\", \"\\&#60;\", var )
      gsub( \">\", \"\\&#62;\", var )
    }
    print env \"='\" var \"'\"
  }
}",v_pattern, blanks, html);

  if( debug )
	fprintf (stderr, "Generated AWK program:
	  ----------\n%s\n----------\n",cmd_buf);

  execlp(AWK,"awk",cmd_buf,NULL);
  exit(0);
}

