/* File: blink.c
   (C) 1998 W. Borgert debacle@debian.org

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char *rcsid="@(#) $Id: blink.c,v 1.1.1.1 1998/10/14 18:33:23 debacle Exp $";

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* macros */
#define VERSION "0.1"
#define PROGRAM "blink"
#define PWLENGTH        8       /* length of password */
#define SERV_HOST_ADDR  "127.0.0.1"
                                /* localhost */

/* function prototypes */
static int  connect_server (void);
static void process_opts   (int , char **);
static void send_rate      (int);
static void usage          (char *);
static void wrong_use      (char *);

/* global variables */
static char passWord[PWLENGTH + 1] = "";
static int serv_tcp_port           = SERV_TCP_PORT;
static int rate                    = 0;

/* main - boring main routine */
int
main (int argc,
      char **argv)
{
  int sockfd;

  process_opts (argc, argv);
  sockfd = connect_server ();
  send_rate (sockfd);
  close (sockfd);
  return 0;
}

/* connect_server - talk to blinkd server */
static int
connect_server (void)
{
  int                sockfd;
  struct sockaddr_in serv_addr;

  bzero ((char *) &serv_addr, sizeof (serv_addr));
  serv_addr.sin_family      = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr (SERV_HOST_ADDR);
  serv_addr.sin_port        = htons (serv_tcp_port);
  if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
  {
    perror ("socket");
    exit (1);
  }
  if (connect (sockfd, &serv_addr, sizeof (serv_addr)) < 0)
  {
    perror ("connect");
    exit (1);
  }
  return sockfd;
}

/* process_opts - process command line, see function usage() for options */
static void
process_opts (int argc,
	      char **argv)
{
  int c         = 0,
    i           = 0,
    rate_flag   = 0,
    second_flag = 0,
    tcp_flag    = 0;

  while (1)
  {
    int option_index                    = 0;
    static struct option long_options[] =
    {
      {"second",        0, 0, '2'},
      {"help",          0, 0, 'h'},
      {"rate",          1, 0, 'r'},
      {"tcp-port",      1, 0, 't'},
      {"version",       0, 0, 'v'},
      {"password",      1, 0, 'w'},
      {0,               0, 0, 0}
    };
    c = getopt_long (argc, argv, "2hr:t:vw:", long_options, &option_index);
    if (c == -1)
    {
      break;
    }
    switch (c)
    {
      case '2':
        if (second_flag)
        {
          wrong_use (argv[0]);
        }
        second_flag   = 1;
        break;
      case 'h':
        usage (argv[0]);
        exit (0);
      case 'r':
        if (rate_flag)
        {
          wrong_use (argv[0]);
        }
        rate_flag = 1;
        rate      = atoi (optarg);
        break; 
      case 't':
        if (tcp_flag)
        {
          wrong_use (argv[0]);
        }
        tcp_flag      = 1;
        serv_tcp_port = atoi (optarg);
        break;
      case 'v':
        puts (PROGRAM " " VERSION);
        exit (0);
        break;
      case 'w':
        strncpy (passWord, optarg, PWLENGTH - 1);
        for (i = 0; i < strlen (optarg); i++)
        {
          optarg[i] = '*';
        }
        puts ("Password not yet supported, sorry.  I'll proceed anyway.");
        break;
      default:
        wrong_use (argv[0]);
    }
  }
  if (optind < argc)
  {
    wrong_use (argv[0]);
  }
  if (second_flag)              /* second LED has always the higher port */
  {
    serv_tcp_port++;
  }
}

/* send_rate - send new blink rate to the server */
static void
send_rate (int sockfd)
{
  if (write (sockfd, (const void *) &rate, 1) != 1)
  {
    perror ("write");
    exit (1);
  }
}

/* usage - help on options */
static void
usage (char* name)
{
  printf ("Usage: %s [options]\n"
          "Options are\n"
          "  -2,   --second        use second (Num-Lock) LED\n"
          "  -h,   --help          display this help and exit\n"
          "  -r n, --rate=n        set blink rate to n\n"
          "  -t n, --tcp-port=n    use tcp port n\n"
          "  -v,   --version       output version information and exit\n"
#if 0
          "  -w s, --password=s    set password to string s\n"
#endif
          ,
          name);
}

/* wrong_use - output for the user, if options cannot be interpreted */
static void
wrong_use (char *name)
{
  fprintf (stderr, "%s: Error in arguments.  Try %s --help\n", name, name);
  exit (1);
}
