/*
Released under GPL, written by Caolan.McNamara@ul.ie.

Copyright (C) 1998 
	Caolan McNamara

Real Life: Caolan McNamara           *  Doing: MSc in HCI
Work: Caolan.McNamara@ul.ie          *  Phone: +353-61-202699
URL: http://skynet.csn.ul.ie/~caolan *  Sig: an oblique strategy
How would you have done it?
*/

/*
warning: this software requires laola's lls to be installed,
as lls-mswordview
*/

char *version="mswordview 0.4.4";

/*

this code is often all over the shop, being more of an organic entity
that a carefully planed piece of code, so no laughing there at the back!

and send me patches by all means, but think carefully before sending me
a patch that doesnt fix a bug or add a feature but instead just changes
the style of coding, i.e no more thousand line patches that fix my 
indentation. (i like it this way :-b)

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "config.h"
#include "mswordview.h"
#include "roman.h"
#include "utf.h"

/*ok i got impatient*/
int NORMAL=20;
int inunderline = 0;
int inbold = 0;
int inah1= 0;
int inaheaderfooter=0;
int initalic = 0;
int inafont= 0;
int pagenumber=1;
int sectionpagenumber=1;
int sectionno=1;
int insuper = 0;
int insub = 0;
int inatable=0;
int cellempty=1;
int inarow=0;
int inacell=0;
int inalist = 0;
int doannos=1;

int noheaders=0;

S16 lastcellwidth[65];
S16 lastrowlen=0;

int rowcount;

U32 mainend;
U32 lastlistid =0;
int listvalue[9];
int currentfontsize;

sep *currentsep=NULL;

int newline=1;
int inacolor;
char incolor[8]="";

U8 chps=0;

int padding=1;
int verpadding=0;
int ignoreheadings=0;
long int cp=0;
long int realcp=0;
static U8 header;
int breakcount;
int footnotehack=0;

char *symbolurl=NULL;
char *wingdingurl=NULL;

U32 get_fc_from_cp(U32 acp,U32 *rgfc,U32 *avalrgfc,int nopieces);

void usage( void )
    {
    fprintf(stderr,"Usage: mswordview [-v] [--version] [-n] [--nocredits] [-c] [--corehtmlonly]  \n"
                "[-t seconds] [--timeout seconds] [-f points] [--defaultfontsize points] [-s url] [--symbolurl url] [-d url] \n"
				"[--wingdingurl url] [-h] [--ignoreheadings] [-m] [--mainonly] filename.doc\n");
    exit(-1);
    }



int main(int argc,char **argv)
	{
	olestream *anolestream;
	olestream *oleptr;
	olestream *oleptr2;
	char *analyze;
	char *slashtmp;
	char *mainstreamname=NULL;
	int ret=0;
	int timeout=-1;
	char *filename;
	char *endptr;
	char *buffer;
	char fileinbuf[1024];
	char *p;
	FILE *filein;

	int c;
	int tail=1;
	int core=1;
	int index=0;

	chp achp;

	static struct option long_options[] = 
		{
		{ "version",0 , 0, 'v' },
		{ "corehtmlonly",0 , 0, 'c' },
		{ "nocredits",0 , 0, 'n' },
		{ "noannotations",0 , 0, 'a' },
		{ "timeout",1 , 0, 't' },
		{ "nohorizontalwhite",0,0,'w'},
		{ "verticalwhite",1,0,'u'},
		{ "symbolurl", 1,0,'s'},
		{ "wingdingurl", 1,0,'d'},
		{ "ignoreheadings", 0,0,'h'},
		{ "defaultfontsize", 1,0,'f'},
		{ "mainonly", 0,0,'m' },
		{ 0,      0, 0, '0' },
		};


	while (1)
		{
		c = getopt_long (argc, argv, "mvwncaht:s:d:f:u:a", long_options, &index);
		if (c == -1)
			break;
		switch(c)
			{
			case 'f':
				if (optarg)
					{
                   	NORMAL = strtol(optarg, &endptr, 10);
				   	if ((*optarg == '\0') || (*endptr  != '\0'))
						{
						fprintf(stderr,"f option must be followed with a number\n");
						NORMAL=20;
						}
					else
						NORMAL*=2;
				 	}
				else 
					{
					printf("no val given for defaultfontsize (-f) \n");
					NORMAL=20;
					}
				break;
			case 'v':
				printf ("%s\nwriten by Caolan.McNamara@ul.ie\nweb page for updates at \nhttp://www.gnu.org/~caolan/docs/MSWordView.html   or\nhttp://www.csn.ul.ie/~caolan/docs/MSWordView.html\n", version);
				exit (0);
				break;
			case 'm':
				noheaders=1;
				break;
			case 'h':
				ignoreheadings=1;
				break;
			case 'n':
				tail=0;
				break;	
			case 'a':
				doannos=0;
				break;	
			case 'u':
				if (optarg)
					{
                   	verpadding = strtol(optarg, &endptr, 10);
				   	if ((*optarg == '\0') || (*endptr  != '\0'))
						{
						fprintf(stderr,"u option must be followed with a number\n");
						verpadding=0;
						}
					if ((verpadding < 0) || (verpadding > 2))
						{
						fprintf(stderr,"u option accepts on 0,1,2 as an argument, not %d\n",verpadding);
						verpadding=0;
						}
				 	}
				else 
					{
					printf("no val given for verticalpadding (-u) \n");
					verpadding=0;
					}
				break;
				
				break;	
			case 't':
				if (optarg)
					{
                   	timeout = strtol(optarg, &endptr, 10);
				   	if ((*optarg == '\0') || (*endptr  != '\0'))
						fprintf(stderr,"t option must be followed with a number\n");
				 	}
				else 
					printf("no val given for timeout option (-t)\n");
				break;
			case 's':
				if (optarg)
					{
					symbolurl = malloc(strlen(optarg)+1);
					if (symbolurl == NULL)
						{
						fprintf(stderr,"no mem\n");
						exit(-1);
						}
					strcpy(symbolurl,optarg);
					}
                else
                    printf("no val given\n");
                break;
			case 'd':
				if (optarg)
					{
					wingdingurl = malloc(strlen(optarg)+1);
					if (wingdingurl == NULL)
						{
						fprintf(stderr,"no mem\n");
						exit(-1);
						}
					strcpy(wingdingurl,optarg);
					}
                else
                    printf("no val given\n");
                break;
			case 'w':
				padding=0;
				break;
			case 'c':
				core=0;
				break;
			default:
				usage();
				break;
			}
		}

	if (argc <= optind) 
		{
		usage();
		}

	if (optind < argc)
		filename = strdup(argv[optind]);
	else 
		filename =NULL;

	/*set SIGCHLD handled*/
	signal_handle (SIGCHLD, reaper);

	currentfontsize = NORMAL;

	if (timeout != -1)
		{
		signal_handle (SIGALRM, timeingout);
		/*well abort after this number of seconds*/
		alarm(timeout);
		}

	/*
	use laola package to get ole stream information and to create 
	individual files for these streams
	*/
	anolestream = divide_streams(filename,&analyze,&slashtmp,argv[0]);
	/*now we have a list of the streamnames and the filenames needed*/

	/*search for main stream*/
	oleptr = anolestream;
	while (oleptr != NULL)
		{
		if (oleptr->level == 0)
			if (strncmp("WordDocument",oleptr->streamname,strlen("WordDocument")) == 0)
				{
				mainstreamname = oleptr->filename;
				break;
				}
		oleptr = oleptr->next;
		}
	

	if (mainstreamname == NULL)
		{
		printf("Sorry main document stream couldnt be found in doc \n%s\n",filename);
		printf("if this *is* a word 8 file, it appears to be corrupt\n");
		printf("or for some other reason laola cant split it into its streams\n");
		printf("this is probably a laola problem - not a mswordview problem\n");
		printf("remember, mswordview cannot handle rtf,word 6 or word 7 etc\n");

		buffer = (char *) malloc(strlen(filename) +1 + strlen("file "));
		sprintf(buffer,"file %s",filename);
		filein = popen(buffer,"r");
		if (filein != NULL)
			{
			printf("for your information, the utility \"file %s\" reports that ...\n\n",filename);
			while (fgets(fileinbuf,1024,filein) != NULL)
				printf("%s",fileinbuf);
			}
		
		free(buffer);
		ret=-1;
		}
	else
		ret = decode_word8(mainstreamname,anolestream,core);

	/*remove stream files*/
	cleanupstreams(analyze,slashtmp);

	/*free mem*/
	oleptr = anolestream->next;

	while(oleptr != NULL)
		{
		oleptr2 = oleptr;
		oleptr = oleptr->next;
		free(oleptr2);
		}
	if (anolestream != NULL)
		free(anolestream);
	if (ret != -1)
		{
		if (tail)
			{
			init_chp(&achp);
			decode_e_chp(&achp);
			printf("<p>\nDocument converted from word 8 by \n<a href=\"http://www.csn.ul.ie/~caolan/docs/MSWordView.html\">MSWordView</a> (%s)<br>\n",version);
			printf("MSWordView written by <a href=\"mailto:Caolan.McNamara@ul.ie\">Caolan McNamara</a>\n</body>\n");
			}
		if (core)
			printf("\n</html>\n");
		}
	return(ret);
	}

int decode_word8(char *mainstreamname,olestream *olestreams,int core)
	{
	U32 i,j,k;
	
	U16 wIdent,nFib,nProduct,lid,pnNext,nFibBack,chse,chseTables;
	U32 lKey,fcMin,fcMac,cbMac,fcSpare,ccpMcr,ccpTxbx,ccpSpare2,fcStshfOrig,lcbStshfOrig;
	textportions portions;
	U8 fields1,fields2,envr,reserved;
	U8 iscomplex=0;
	U32 pnPapFirst,cpnBtePap;
	U32 pnChpFirst,cpnBteChp;
	U32 pnLvcFirst,cpnBteLvc;
	U32 fcPlcfbtePapx,lcbPlcfbtePapx;
	U32 fcPlcfbteChpx,lcbPlcfbteChpx;
	U32 *plcfbtePapx;
	U32 *plcfbteChpx;
	U32 chpintervals;
	U32 intervals;
	U32 fcClx,lcbClx;
	U32 fcPlcffldMom,lcbPlcffldMom;
	U32 fcPlcffldHdr,lcbPlcffldHdr;
	U32 fcPlcffldFtn,lcbPlcffldFtn;
	U32 fcSttbfffn,lcbSttbfffn;
	ffn fontnamelist;
	ffn *tempnames;
	U32 *cp_plcfld;
	U8 *fld_plcfld;
	U32 *cp_plcfld2;
	U8 *fld_plcfld2;
	U32 *cp_plcfld3;
	U8 *fld_plcfld3;
	U32 *cp_plcfld4;
	U8 *fld_plcfld4;
	U8 len;
	char *tablename;
	char *tablestreamname=NULL;
	olestream *oleptr;
	field_info *all_fields[4];
	field_info main_fields;
	field_info header_fields;
	field_info footnote_fields;
	field_info annotation_fields;
	U32 fcPlcfLst,lcbPlcfLst;
	U32 fcPlfLfo,lcbPlfLfo;
	U32 fcSttbFnm,lcbSttbFnm;
	U32 fcPlcffndRef;
	U32 fcPlcffndTxt;
	U32 lcbPlcffndRef;
	U32 lcbPlcffndTxt;
	/*begin annotations*/
	U32 fcPlcfandRef,lcbPlcfandRef;
	U32 fcPlcfandTxt,lcbPlcfandTxt;
	U32 fcPlcffldAtn,lcbPlcffldAtn;
	U32 fcGrpXstAtnOwners,lcbGrpXstAtnOwners;
	U32 fcSttbfAtnbkmk,lcbSttbfAtnbkmk;
	U32 fcPlcfAtnbkf,lcbPlcfAtnbkf;
	U32 fcPlcfAtnbkl,lcbPlcfAtnbkl;
	/*end annotations*/
	/*begin endnotes*/
	U32 fcPlcfendRef,lcbPlcfendRef;
	U32 fcPlcfendTxt,lcbPlcfendTxt;
	U32 fcPlcffldEdn,lcbPlcffldEdn;
	U32 fcPgdEdn,lcbPgdEdn; /*whats this */
	U32 fcBkdEdn,lcbBkdEdn; /*and this for ? */
	/*end endnotes*/
	/*begin section table*/
	U32 fcPlcfsed,lcbPlcfsed;
	/*end section table*/

	
	U32 ccpHdrTxbx;
	U32 fcPlcfhdrtxbxTxt,lcbPlcfhdrtxbxTxt;
	U32 fcPlcffldHdrTxbx,lcbPlcffldHdrTxbx;
	U32 fcPlcftxbxHdrBkd,lcbPlcftxbxHdrBkd;

	U32 fcPlcspaMom,lcbPlcspaMom; 
	/*we use these to get spids, and then suck the pictures out of the the resulting tables found though fcDggInfo ??*/
	U32 fcDggInfo,lcbDggInfo;

	U16 spids[1024];
	char *names[1024];

	U32 stsh,stshlen;
	
	list_info a_list_info;
	style *masterstylesheet;

	FILE *tablefd;
	FILE *mainfd;

	int notfinished;

	error(stderr,"opening %s\n",mainstreamname);
	mainfd = fopen(mainstreamname,"r");
	if (mainfd == NULL)
		{
		fprintf(stderr,"Couldnt open %s\n",mainstreamname);
		exit(-1);
		}


	fseek(mainfd,0,SEEK_END);
	mainend = ftell(mainfd);
	error(stderr,"the end of the stream is %x\n",mainend);
	fseek(mainfd,0,SEEK_SET);
	
	wIdent=read_16ubit(mainfd);
	nFib=read_16ubit(mainfd);
	nProduct=read_16ubit(mainfd);


	if (nFib >= 101)
		error(stderr,"written by word >= 6, exactly %x\n",nProduct);
	else
		error(stderr,"written by word < 6, exactly %x\n",nProduct);

	if ((nProduct >> 8) == 0xe0)
		{
		printf("this is an unsupported word 7 doc, sorry\nthis converter is solely for word8 at the moment\ntry laola (http://wwwwbs.cs.tu-berlin.de/~schwartz/pmh/laola.html) it might get some text out of it\n");
		return(-1);
		}
	else if ((nProduct >> 8) == 0xc0)
		{
		printf("this is an unsupported (as of yet) word 6 doc, sorry\nthis converter is solely for word8 at the moment\ntry word2x (http://word2x.astra.co.uk/) for that\n");
		return(-1);
		}
	else if ((nProduct >> 8) != 0x00)
		printf("this doesnt appear to be a word 8 doc, but going ahead anyway, expect disaster!!\n");

	lid=read_16ubit(mainfd);
	pnNext=read_16ubit(mainfd);
	fields1 = getc(mainfd);
	error(stderr,"wIdent is %d,nFib is %d, nProduct is %d, lid is %d, pnNext? is %d\n",wIdent,nFib,nProduct,lid,pnNext);
		
	if (fields1 & 0x01)
		error(stderr,"mainfdot\n");
	if (fields1 & 0x02)
		error(stderr,"fGlsy\n");
	if (fields1 & 0x04)
		{
		error(stderr,"fComplex\n");
		iscomplex=1;
		error(stderr,"complex doc, here we go!\n");
		}
	if (fields1 & 0x08)
		error(stderr,"fHasPic\n");
	fields1 &= 0xF0;
	fields1 = fields1 >> 4;
	error(stderr,"no od saves is %d\n",fields1);
	fields2 = getc(mainfd);
	if (fields2 & 0x01)
		error(stderr,"fEncrypted\n");

	if (fields2 & 0x02)
		{
		tablename = "1Table";
		error(stderr,"use 1Table stream\n");
		}
	else
		{
		tablename = "0Table";
		error(stderr,"use 0Table stream\n");
		}

	oleptr = olestreams;
    while (oleptr != NULL)
        {
		if (oleptr->level == 0)
			if (strncmp(tablename,oleptr->streamname,strlen(tablename)) == 0)
				{
				tablestreamname = oleptr->filename;
				break;
				}
		oleptr = oleptr->next;
        }

    if (tablestreamname == NULL)
        fprintf(stderr,"Sorry table stream couldnt be found in doc\n");

	tablefd = fopen(tablestreamname,"r");
	if (tablefd == NULL)
		{
		fprintf(stderr,"arse couldnt open -%s-\n",tablestreamname);
		exit(-1);
		}

	if (fields2 & 0x04)
		error(stderr,"fReadOnlyRecommedned\n");
	if (fields2 & 0x08)
		error(stderr,"fWriteReservation\n");
	if (fields2 & 0x10)
		error(stderr,"fEctChar\n");
	nFibBack = read_16ubit(mainfd);
	lKey = read_32ubit(mainfd);
	envr = getc(mainfd);
	error(stderr,"nFibback is %d, lKey is %ld\n",nFibBack,lKey);
	if (envr == 0)
		error(stderr,"created in winword\n");
	else if (envr == 1)
		error(stderr,"created in mac word\n");
	reserved = getc(mainfd);
	chse = read_16ubit(mainfd);
	if (chse == 0)
		error(stderr,"windows ansi\n");
	else if (chse == 256)
		error(stderr,"mac char set\n");
	chseTables = read_16ubit(mainfd);
	if (chseTables == 0)
		error(stderr,"windows ansi\n");
	else if (chseTables== 256)
		error(stderr,"mac char set\n");

	fcMin = read_32ubit(mainfd);
	fcMac = read_32ubit(mainfd);
	fseek(mainfd,0x0040,SEEK_SET);
	cbMac = read_32ubit(mainfd);
	fcSpare= read_32ubit(mainfd);
	fcSpare= read_32ubit(mainfd);


	error(stderr,"first char is at %ld (%x)\n",fcMin,fcMin);
	error(stderr,"last char is at %ld (%x)\n",fcMac,fcMac);

	portions.ccpText = read_32ubit(mainfd);
	error(stderr,"the main doc text is of size %ld\n",portions.ccpText);
	portions.ccpFtn = read_32ubit(mainfd);
	error(stderr,"the footer text is of size %ld\n",portions.ccpFtn);
	portions.ccpHdd = read_32ubit(mainfd);
	error(stderr,"the header text is of size %ld\n",portions.ccpHdd);
	portions.fcMin = fcMin;
	portions.fcMac = fcMac;
	ccpMcr = read_32ubit(mainfd);
	portions.ccpAtn = read_32ubit(mainfd);
	error(stderr,"the annotation text is size %ld\n",portions.ccpAtn);
	portions.ccpEdn = read_32ubit(mainfd);
	ccpTxbx = read_32ubit(mainfd);
	ccpHdrTxbx = read_32ubit(mainfd);
	ccpSpare2 = read_32ubit(mainfd);
	fcStshfOrig = read_32ubit(mainfd);
	lcbStshfOrig = read_32ubit(mainfd);
	
	/*attempt to list all paragraph bounds*/

	fseek(mainfd,112,SEEK_SET);	
	pnChpFirst = read_32ubit(mainfd);
	cpnBteChp = read_32ubit(mainfd);
	error(stderr,"\n page of first different char type %d\nnumber of different character types %d\n",pnChpFirst,cpnBteChp);


	fseek(mainfd,124,SEEK_SET);	
	pnPapFirst = read_32ubit(mainfd);
	cpnBtePap = read_32ubit(mainfd);
	error(stderr,"\n page of first different para type %d\nnumber of different para types %d\n",pnPapFirst,cpnBtePap);
	
	fseek(mainfd,136,SEEK_SET);	
	pnLvcFirst = read_32ubit(mainfd);
	cpnBteLvc = read_32ubit(mainfd);
	error(stderr,"\n page of first different lvc type %d\nnumber of different lvc types %d\n",pnLvcFirst,cpnBteLvc);
	
	fseek(mainfd,154,SEEK_SET);	
	error(stderr,"the orig stsh is (%x), len (%x)\n",read_32ubit(mainfd),read_32ubit(mainfd));
	
	stsh = read_32ubit(mainfd);
	stshlen = read_32ubit(mainfd);
	error(stderr,"the new stsh is (%x), len (%x)\n",stsh,stshlen);

	masterstylesheet = decode_stylesheet(tablefd,stsh,stshlen);

	fcPlcffndRef=read_32ubit(mainfd);
	lcbPlcffndRef=read_32ubit(mainfd);
	fcPlcffndTxt=read_32ubit(mainfd);
	lcbPlcffndTxt=read_32ubit(mainfd);
	fcPlcfandRef=read_32ubit(mainfd);
	lcbPlcfandRef=read_32ubit(mainfd);
	fcPlcfandTxt=read_32ubit(mainfd);
	lcbPlcfandTxt=read_32ubit(mainfd);


	error(stderr,"footnote: table offset of frd thingies (%x) of len %d\n",fcPlcffndRef,lcbPlcffndRef);
	error(stderr,"there are %d footnotes\n",(lcbPlcffndRef-4)/6);

	error(stderr,"footnote: table offset for footnote text (%x) of len %d\n",fcPlcffndTxt,lcbPlcffndTxt);


	portions.fndRef=NULL;
	portions.fndFRD=NULL;
	portions.fndTxt=NULL;
	portions.list_foot_no = 0;

	portions.fndref_no=0;
	portions.fndtxt_no=0;

	if (lcbPlcffndRef != 0)
		{
		portions.fndref_no=(lcbPlcffndRef-4)/6;
		portions.fndRef = (U32 *) malloc( (portions.fndref_no+1) * sizeof(U32));
		if (portions.fndRef == NULL)
			{
			fprintf(stderr,"NO MEM 1\n");
			return(-1);
			}

		portions.fndFRD = (S16 *) malloc( portions.fndref_no * sizeof(S16));
		if (portions.fndFRD == NULL)
			{
			fprintf(stderr,"NO MEM 2\n");
			return(-1);
			}
		fseek(tablefd,fcPlcffndRef,SEEK_SET);
		for(i=0;i<portions.fndref_no+1;i++)
			{
			portions.fndRef[i]=read_32ubit(tablefd);
			error(stderr,"fndRef is %x\n",portions.fndRef[i]);
			}
		for(i=0;i<portions.fndref_no;i++)
			{
			portions.fndFRD[i]=(S16)read_16ubit(tablefd);
			error(stderr,"fndFRD is %d\n",portions.fndFRD[i]);
			}
		}

	if (lcbPlcffndTxt!= 0)
		{
		portions.fndtxt_no=lcbPlcffndTxt/4;
		portions.fndTxt = (U32 *) malloc( portions.fndtxt_no  * sizeof(U32) );
		if (portions.fndTxt == NULL)
			{
			fprintf(stderr,"NO MEM 3\n");
			return(-1);
			}
		fseek(tablefd,fcPlcffndTxt,SEEK_SET);
		for (i=0;i<portions.fndtxt_no;i++)
			{
			portions.fndTxt[i]=read_32ubit(tablefd);
			error(stderr,"footnote->%x\n",portions.fndTxt[i]);
			}
		}

	portions.andref_no=0;
	portions.andRef=NULL;
	portions.list_anno_no = 0;

	error(stderr,"annotation offset is %x, len is %d\n",fcPlcfandRef,lcbPlcfandRef);
	
	if (lcbPlcfandRef != 0)
		{
		portions.andref_no=(lcbPlcfandRef-4)/34;
		portions.andRef = (U32 *) malloc( (portions.andref_no+1)  * sizeof(U32) );
		if (portions.andRef == NULL)
			{
			fprintf(stderr,"NO MEM 3\n");
			return(-1);
			}
		fseek(tablefd,fcPlcfandRef,SEEK_SET);
		for (i=0;i<portions.andref_no+1;i++)
			{
			portions.andRef[i]=read_32ubit(tablefd);
			error(stderr,"annotation to be found at %x\n",portions.andRef[i]);
			}
		/*ive ignored the ANLD structure for now*/
		}

	if (lcbPlcfandTxt!= 0)
		{
		portions.andtxt_no=lcbPlcfandTxt/4;
		portions.andTxt = (U32 *) malloc( portions.andtxt_no  * sizeof(U32) );
		if (portions.andTxt == NULL)
			{
			fprintf(stderr,"NO MEM 3\n");
			return(-1);
			}
		fseek(tablefd,fcPlcfandTxt,SEEK_SET);
		for (i=0;i<portions.andtxt_no;i++)
			{
			portions.andTxt[i]=read_32ubit(tablefd);
			error(stderr,"andTxt are %x\n",portions.andTxt[i]);
			}
		}
	
	fcPlcfsed=read_32ubit(mainfd);
	lcbPlcfsed=read_32ubit(mainfd);
	error(stderr,"section: table offset for section table (%x) of len %d\n",fcPlcfsed,lcbPlcfsed);
	if (lcbPlcfsed >0)
		{
		portions.section_nos = (lcbPlcfsed-4)/16;
		error(stderr,"there are %d sections",portions.section_nos);
		portions.section_cps = (U32 *) malloc ((portions.section_nos+1) * sizeof(U32));
		portions.section_fcs = (U32 *) malloc ((portions.section_nos) * sizeof(U32));
		if ((portions.section_cps == NULL) || (portions.section_fcs ==  NULL))
			{
			error(stderr,"no mem for section_cps\n");
			return(-1);
			}
		fseek(tablefd,fcPlcfsed,SEEK_SET);
		for (i=0;i< portions.section_nos+1;i++)
			{
			portions.section_cps[i]=read_32ubit(tablefd);
			error(stderr,"section offsets are %x\n",portions.section_cps[i]);
			}
		for (i=0;i<portions.section_nos;i++)
			{
			read_16ubit(tablefd); /*internal*/
			portions.section_fcs[i] = read_32ubit(tablefd);
			error(stderr,"section file offsets are %x\n",portions.section_fcs[i]);
			read_16ubit(tablefd); /*internal*/
			read_32ubit(tablefd);
			}
		}
	
	fseek(mainfd,242,SEEK_SET);	
	portions.fcPlcfhdd = read_32ubit(mainfd);
	portions.lcbPlcfhdd = read_32ubit(mainfd);
	/*these point to the header/footer information thing*/

	error(stderr,"header in table offset of (%x), len is %d\n",portions.fcPlcfhdd,portions.lcbPlcfhdd);
	
	fcPlcfbteChpx = read_32ubit(mainfd);
	lcbPlcfbteChpx = read_32ubit(mainfd);
	error(stderr,"\nlocation of char description in table stream is %x\nsize is %ld\n",fcPlcfbteChpx,lcbPlcfbteChpx);
	plcfbteChpx = (U32 *) malloc(lcbPlcfbteChpx);
	fseek(tablefd,fcPlcfbteChpx,SEEK_SET);
	for (i=0;i<lcbPlcfbteChpx/4;i++)
		plcfbteChpx[i] = read_32ubit(tablefd);
	chpintervals = ((lcbPlcfbteChpx/4)-1)/2;
	error(stderr,"there are %d charrun intervals ? ending at ",chpintervals);
	for (i=1;i<chpintervals+1;i++)
		error(stderr,"%d (%d)", plcfbteChpx[i],plcfbteChpx[i+chpintervals]);
	error(stderr,"\n");


	fcPlcfbtePapx = read_32ubit(mainfd);
	lcbPlcfbtePapx = read_32ubit(mainfd);
	error(stderr,"\nlocation of para description in table stream is %ld\nsize is %ld\n",fcPlcfbtePapx,lcbPlcfbtePapx);
	/*go to location in table stream, */
	/*i believe that this is just an array of longs(4 bytes blocks)
	 */
	plcfbtePapx = (U32 *) malloc(lcbPlcfbtePapx);
	fseek(tablefd,fcPlcfbtePapx,SEEK_SET);
	for (i=0;i<lcbPlcfbtePapx/4;i++)
		plcfbtePapx[i] = read_32ubit(tablefd);
	intervals = ((lcbPlcfbtePapx/4)-1)/2;
	error(stderr,"there are %d pragraph intervals ? ending at ",intervals);
	for (i=1;i<intervals+1;i++)
		error(stderr,"%d %x (%d)", plcfbtePapx[i], plcfbtePapx[i],plcfbtePapx[i+intervals]);
	error(stderr,"\n");
	fseek(mainfd,274,SEEK_SET);
	fcSttbfffn=read_32ubit(mainfd);
	lcbSttbfffn=read_32ubit(mainfd);

	if (lcbSttbfffn > 0)
		{
		tempnames = &fontnamelist;
		error(stderr,"have a table of font names (%x)\n",fcSttbfffn);
		fseek(tablefd,fcSttbfffn,SEEK_SET);

		j=0;
		/*seems to be a count of font names, followed by three blanks ?*/
		read_16ubit(tablefd);
		read_16ubit(tablefd);
		j=4;
		while(j<lcbSttbfffn)
			{
			k=0;
			tempnames->name[0] = '\0';
			tempnames->next=NULL;
			len = getc(tablefd);
			error(stderr,"len is %d\n",len);
			i=1;
			notfinished=1;
			while(i<=len)
				{
				if ((i >= 40) && (notfinished))
					{
					tempnames->name[k] = read_16ubit(tablefd);
					i+=2;
					error(stderr,"font name char is %X %c %x i is %d\n",tempnames->name[k],tempnames->name[k],ftell(tablefd),i);
					if (tempnames->name[k] == 0)
						notfinished=0;
					k++;
					}
				else
					{	
					if (i==4)
						{
						tempnames->chs = getc(tablefd);
						error(stderr,"chs is (%x)  %d ",tempnames->chs,tempnames->chs);
						}
					else
						getc(tablefd);
					i++;
					}
				}
			if (tempnames->name[0] != '\0')
				{
				tempnames->next = (ffn *) malloc(sizeof(ffn));
				if (tempnames->next == NULL)
					{
					fprintf(stderr,"no memory, arrgh\n");
					return(-1);
					}
				tempnames = tempnames->next;
				tempnames->next=NULL;
				}
			j+=i;	
			}
		}

	tempnames = &fontnamelist;
	while (tempnames != NULL)
		{
		error(stderr,"font names are %s\n",tempnames->name);
		tempnames = tempnames->next;
		}

	/*determine field plc*/
	fcPlcffldMom=read_32ubit(mainfd);
	lcbPlcffldMom=read_32ubit(mainfd);
	error(stderr,"in table stream field plc is %ld, and len is %ld\n",fcPlcffldMom,lcbPlcffldMom);

	main_fields.cps = NULL;
	main_fields.flds = NULL;
	main_fields.no = -1;

	if (lcbPlcffldMom > 0)
		{
		error(stderr,"guessing that no of entries is %d\n",(lcbPlcffldMom-4)/6);
		cp_plcfld = (U32 *) malloc( (((lcbPlcffldMom-4)/6)+1) * sizeof(U32));
		if (cp_plcfld == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fld_plcfld = (U8 *) malloc( (((lcbPlcffldMom-4)/6)*2) * sizeof(U8));
		if (fld_plcfld == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fseek(tablefd,fcPlcffldMom,SEEK_SET);
		for(i=0;i<(((lcbPlcffldMom-4)/6)+1);i++)
			{
			cp_plcfld[i] =  read_32ubit(tablefd);
			error(stderr,"field cps are %x\n",cp_plcfld[i]);
			}
		for(i=0;i<(((lcbPlcffldMom-4)/6)*2);i++)
			{
			fld_plcfld[i] =  getc(tablefd);
			error(stderr,"field vals are %d\n",fld_plcfld[i]);
			}

		main_fields.cps = cp_plcfld;
		main_fields.flds = fld_plcfld;
		main_fields.no = (lcbPlcffldMom-4)/6;
		}

	fcPlcffldHdr=read_32ubit(mainfd);
	lcbPlcffldHdr=read_32ubit(mainfd);
	error(stderr,"in table stream field header plc is (%x), and len is %ld\n",fcPlcffldHdr,lcbPlcffldHdr);

	header_fields.cps = NULL;
	header_fields.flds = NULL;
	header_fields.no = -1;

	if (lcbPlcffldHdr> 0)
		{
		error(stderr,"guessing that no of entries is %d\n",(lcbPlcffldHdr-4)/6);
		cp_plcfld2 = (U32 *) malloc( (((lcbPlcffldHdr-4)/6)+1) * sizeof(U32));
		if (cp_plcfld2 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fld_plcfld2 = (U8 *) malloc( (((lcbPlcffldHdr-4)/6)*2) * sizeof(U8));
		if (fld_plcfld2 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fseek(tablefd,fcPlcffldHdr,SEEK_SET);
		for(i=0;i<(((lcbPlcffldHdr-4)/6)+1);i++)
			{
			cp_plcfld2[i] =  read_32ubit(tablefd);
			error(stderr,"header field cps are %x\n",cp_plcfld2[i]);
			}
		for(i=0;i<(((lcbPlcffldHdr-4)/6)*2);i++)
			{
			fld_plcfld2[i] =  getc(tablefd);
			error(stderr,"field vals are %d\n",fld_plcfld2[i]);
			}

		header_fields.cps = cp_plcfld2;
		header_fields.flds = fld_plcfld2;
		header_fields.no = (lcbPlcffldHdr-4)/6;
		}

	fcPlcffldFtn=read_32ubit(mainfd);
	lcbPlcffldFtn=read_32ubit(mainfd);
	error(stderr,"in table stream field footnote plc is (%x), and len is %ld\n",fcPlcffldFtn,lcbPlcffldFtn);
	fcPlcffldAtn=read_32ubit(mainfd);
	lcbPlcffldAtn=read_32ubit(mainfd);
	error(stderr,"in table stream field annotation plc is (%x), and len is %ld\n",fcPlcffldAtn,lcbPlcffldAtn);

	footnote_fields.cps = NULL;
	footnote_fields.flds = NULL;
	footnote_fields.no = -1;

	if (lcbPlcffldFtn >0)
		{
		error(stderr,"guessing that no of entries is %d\n",(lcbPlcffldFtn-4)/6);
		cp_plcfld3 = (U32 *) malloc( (((lcbPlcffldFtn-4)/6)+1) * sizeof(U32));
		if (cp_plcfld3 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fld_plcfld3 = (U8 *) malloc( (((lcbPlcffldFtn-4)/6)*2) * sizeof(U8));
		if (fld_plcfld3 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fseek(tablefd,fcPlcffldFtn,SEEK_SET);
		for(i=0;i<(((lcbPlcffldFtn-4)/6)+1);i++)
			{
			cp_plcfld3[i] =  read_32ubit(tablefd);
			error(stderr,"footnote field cps are %x\n",cp_plcfld3[i]);
			}
		for(i=0;i<(((lcbPlcffldFtn-4)/6)*2);i++)
			{
			fld_plcfld3[i] =  getc(tablefd);
			error(stderr,"field vals are %d\n",fld_plcfld3[i]);
			}

		footnote_fields.cps = cp_plcfld3;
		footnote_fields.flds = fld_plcfld3;
		footnote_fields.no = (lcbPlcffldFtn-4)/6;
		}

	annotation_fields.cps = NULL;
	annotation_fields.flds = NULL;
	annotation_fields.no = -1;

	if (lcbPlcffldAtn>0)
		{
		error(stderr,"guessing that no of entries is %d\n",(lcbPlcffldAtn-4)/6);
		cp_plcfld4 = (U32 *) malloc( (((lcbPlcffldAtn-4)/6)+1) * sizeof(U32));
		if (cp_plcfld4 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fld_plcfld4 = (U8 *) malloc( (((lcbPlcffldAtn-4)/6)*2) * sizeof(U8));
		if (fld_plcfld4 == NULL)
			{
			fprintf(stderr,"no mem\n");
			exit(-1);
			}

		fseek(tablefd,fcPlcffldAtn,SEEK_SET);
		for(i=0;i<(((lcbPlcffldAtn-4)/6)+1);i++)
			{
			cp_plcfld4[i] =  read_32ubit(tablefd);
			error(stderr,"annotation field cps are %x\n",cp_plcfld4[i]);
			}
		for(i=0;i<(((lcbPlcffldAtn-4)/6)*2);i++)
			{
			fld_plcfld4[i] =  getc(tablefd);
			error(stderr,"field vals are %d\n",fld_plcfld4[i]);
			}

		annotation_fields.cps = cp_plcfld4;
		annotation_fields.flds = fld_plcfld4;
		annotation_fields.no = (lcbPlcffldAtn-4)/6;
		}

	all_fields[0] = &main_fields;
	all_fields[1] = &header_fields;
	all_fields[2] = &footnote_fields;
	all_fields[3] = &annotation_fields;


	/*complex info bit*/
	fseek(mainfd,418,SEEK_SET);
	fcClx =  read_32ubit(mainfd);
	lcbClx = read_32ubit(mainfd);
	error(stderr,"complex bit begins at %X, and it %d long",fcClx,lcbClx);

	fseek(mainfd,474,SEEK_SET);
	fcPlcspaMom = read_32ubit(mainfd);
	lcbPlcspaMom = read_32ubit(mainfd);
	error(stderr,"error: pictures offset %x len %d\n",fcPlcspaMom,lcbPlcspaMom);

	portions.noofficedraw=0;
	portions.officedrawcps=NULL;
	portions.spids=NULL;
	portions.noofblipdata=0;

	if (lcbPlcspaMom!=0)
		{
		fseek(tablefd,fcPlcspaMom,SEEK_SET);
		portions.noofficedraw = (lcbPlcspaMom-4)/28;
		portions.officedrawcps = (U32 *) malloc(sizeof(U32) * (portions.noofficedraw+1));
		portions.spids=(U32 *) malloc(sizeof(U32) * portions.noofficedraw);
		if ((portions.officedrawcps == NULL) || (portions.spids == NULL))
			{
			error(stderr,"no mem for spids\n");
			return(-1);
			}
		for(i=0;i<portions.noofficedraw+1;i++)
			{
			portions.officedrawcps[i] = read_32ubit(tablefd);
			error(stderr,"office draw cp is %x\n",portions.officedrawcps[i]);
			}
		for(i=0;i<portions.noofficedraw;i++)
			{
			portions.spids[i] = read_32ubit(tablefd);
			error(stderr,"spid id %x\n",portions.spids[i]);
			for (j=0;j<22;j++)
				getc(tablefd);
			}
		}
	


	/*begin endnote*/
	fseek(mainfd,522,SEEK_SET);
	fcPlcfendRef = read_32ubit(mainfd);
	lcbPlcfendRef = read_32ubit(mainfd);
	fcPlcfendTxt = read_32ubit(mainfd);
	lcbPlcfendTxt = read_32ubit(mainfd);
	fcPlcffldEdn = read_32ubit(mainfd);
	lcbPlcffldEdn = read_32ubit(mainfd);
	/*end endnote*/

	fseek(mainfd,554,SEEK_SET);
	fcDggInfo = read_32ubit(mainfd);
	lcbDggInfo = read_32ubit(mainfd);
	error(stderr,"fcDggInfo is %x and len is %d\n",fcDggInfo,lcbDggInfo);

	portions.ablipdata = get_blips(fcDggInfo,lcbDggInfo,tablefd,mainfd,&(portions.noofblipdata));

	fseek(mainfd,730,SEEK_SET);
	fcSttbFnm =  read_32ubit(mainfd);
	lcbSttbFnm = read_32ubit(mainfd);
	fcPlcfLst =  read_32ubit(mainfd);
	lcbPlcfLst = read_32ubit(mainfd);
	fcPlfLfo =  read_32ubit(mainfd);
	lcbPlfLfo = read_32ubit(mainfd);

	get_table_info(tablefd,&a_list_info,fcSttbFnm,lcbSttbFnm,fcPlcfLst,lcbPlcfLst,fcPlfLfo,lcbPlfLfo,masterstylesheet);

	error(stderr,"\n-----text------ %x\n",1024);
	if (core)
		printf("<html>\n");
	fseek(mainfd,1024,SEEK_SET);

	error(stderr,"endpoint for standard is %ld\n",fcMac);


	fseek(tablefd,portions.fcPlcfhdd,SEEK_SET);
	portions.headercpno = portions.lcbPlcfhdd/4;
	portions.headercplist = NULL;
	if (portions.headercpno > 0)
		{
		error(stderr,"head no is %d\n",portions.headercpno);
		portions.headercplist = malloc(sizeof(U32) * portions.headercpno);
		if (portions.headercplist == NULL)
			{
			error(stderr,"feck no mem\n");
			return(-1);
			}

		for (i=0;i<portions.headercpno;i++)
			{
			portions.headercplist[i]= read_32ubit(tablefd);
			error(stderr,"header fc ? is %x -> %x  %d",portions.headercplist[i],portions.fcMin+portions.ccpText+portions.ccpFtn+portions.headercplist[i],i);
			switch (i)
				{
				case 6:
					error(stderr,"even header\n");
					break;
				case 7:
					error(stderr,"odd header\n");
					break;
				case 8:
					error(stderr,"even footer\n");
					break;
				case 9:
					error(stderr,"odd footer\n");
					break;
				case 10:
					error(stderr,"page 1 special header\n");
					break;
				case 11:
					error(stderr,"page 1 special footer\n");
					break;
				case 12:
					error(stderr,"even header, section 2?\n");
					break;
				case 13:
					error(stderr,"odd header, section 2?\n");
					break;
				default:
					error(stderr,"\n");
					break;
				}
			}
		}

	if (iscomplex)
		{
		error(stderr,"complex writing complex table looking in %ld (len %ld)\n",fcClx,lcbClx);
		/*i believe that the intervals and plcfbtePapx are valid entities for
		fastsaved docs as well (i bloody hope so)*/
		printf("<!--complex document-->\n");
		error(stderr,"main ends at %x\n",portions.ccpText);
		decode_clx(0,0,portions.ccpText,tablefd,mainfd,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,&a_list_info,masterstylesheet,&portions,&fontnamelist,0);
		}
	else
		{
		error(stderr,"decoding simple\n");
		printf("<!--noncomplex document-->\n");

			
		decode_simple(mainfd,tablefd,fcClx,fcMin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,&a_list_info,masterstylesheet,&portions,&fontnamelist,0);
		}

	free(plcfbtePapx);
	return(0);
	}

U32 get_fc_from_cp(U32 acp,U32 *rgfc,U32 *avalrgfc,int nopieces)
	{
	int i=0;
	U32 distance;
	U32 fc2;

	/*given a cp find the piece*/
	while(i<nopieces)
        {
        if (rgfc[i+1] >= acp)
            {
			distance = acp-rgfc[i];	
			error(stderr,"cp distance is %d\n",distance);
			if (avalrgfc[i] & 0x40000000UL)
				{
				fc2 = avalrgfc[i];
				fc2 = fc2 & 0xbfffffffUL;
				fc2 = fc2/2;
				return(fc2+distance);
				}
			else
				return(avalrgfc[i]+(2*distance));
            }
        i++;
        }
	return(0);
	}


void decode_simple_footer(FILE *mainfd,FILE *tablefd,sep *asep,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag)
	{
	U32 headerpos;
	U32 oldccpText;
	U32 begin=0;
	U32 len=0;
	int tempcp;
	int i;
	int footnoteflag=0;
	int annotationflag=0;
	field_info *tempfields;
	chp achp;
	int nopieces;
	U32 *avalrgfc;
	U32 *rgfc;
	U16 *sprm;
	U32 clxcount;
	U32 fcvalue;

	if (noheaders)
		return;
	
	if (header == 0)
		{
		error(stderr,"doing footer page number is %d\n",pagenumber);

		for (i=0;i<portions->list_foot_no;i++)
			{
			decode_footnote(&begin,&len,portions,i);

			if ((begin != -1) && (len != -1))
				{
				init_chp(&achp);
				decode_s_chp(&achp);
				if (footnoteflag == 0)
					{
					printf("\n<hr width=\"25%%\">\n");
					footnoteflag=1;
					}
				error(stderr,"beginning footnote\n");
				printf("<p>");
				/*test*/
				printf("<font color=#330099>");
				inafont=1;
				inacolor=1;
				strcpy(incolor,"#330099");
				/*end test*/
				if (!insuper)
					{
					printf("<sup>");
					insuper=2;
					}
				printf("<a name=\"foot%d\">",i);

				if (portions->fndFRD[i] > 0)
					{
					printf("%d",portions->fndFRD[i]);
					printf("</A>");
					if (insuper==2)
						printf("</sup>");
					}
				else
					footnotehack=1;
				/*dont handling custom footnotes this way*/

				headerpos = ftell(mainfd);
				oldccpText = portions->ccpText;
				header++;

				fseek(tablefd,fcClx,SEEK_SET);
				getc(tablefd);
				nopieces = get_piecetable(tablefd,&rgfc,&avalrgfc,&sprm,&clxcount);
				
				fcvalue = get_fc_from_cp(oldccpText+begin,rgfc,avalrgfc,nopieces);

				free(rgfc);
				free(avalrgfc);
				free(sprm);
				/*			
				fseek(mainfd,portions->fcMin+oldccpText+begin,SEEK_SET);
				*/
				error(stderr,"footer fcvalue is %x, old one would be %x\n",fcvalue,portions->fcMin+oldccpText+begin);
				tempcp=cp;
				portions->ccpText = len;
				cp=begin;
				tempfields = all_fields[0];
				all_fields[0] = all_fields[2];
				realcp = oldccpText+begin;
				inaheaderfooter=1;
				/*temp line*/
				fseek(mainfd,fcvalue,SEEK_SET);
				decode_simple(mainfd,tablefd,fcClx,fcvalue,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,2);
				inaheaderfooter=0;
				if (footnotehack == 1)
					{
					printf("</A>");
					footnotehack=0;
					}
				all_fields[0] = tempfields;
				cp=tempcp;
				realcp = tempcp;
				fseek(mainfd,headerpos,SEEK_SET);
				portions->ccpText = oldccpText;
				header--;
				error(stderr,"ending footnote\n");
				}
			}
		portions->list_foot_no=0; /*ready for next page footnotes*/
		for (i=0;i<portions->list_anno_no;i++)
			{
			decode_footanno(&begin,&len,portions,i);
			
			init_chp(&achp);
			decode_s_chp(&achp);

			if ((begin != -1) && (len != -1))
				{
				if (annotationflag == 0)
					{
					printf("\n<hr width=\"25%%\">\n");
					annotationflag=1;
					}
				error(stderr,"beginning annotation\n");
				/*test*/
				printf("<font color=#ff7777>");
				inafont=1;
				inacolor=1;
				strcpy(incolor,"#ff7777");
				/*end test*/
				if (!insuper)
					printf("<sup>");
				printf("<a name=\"anno%d\">",i);
				printf("anno%d",i);
				printf("</a>");
				if (!insuper)
					printf("</sup>");

				headerpos = ftell(mainfd);
				oldccpText = portions->ccpText;
				header++;

				fseek(tablefd,fcClx,SEEK_SET);
				getc(tablefd);
				nopieces = get_piecetable(tablefd,&rgfc,&avalrgfc,&sprm,&clxcount);
				
				fcvalue = get_fc_from_cp(oldccpText+portions->ccpFtn+portions->ccpHdd+begin,rgfc,avalrgfc,nopieces);

				free(rgfc);
				free(avalrgfc);
				free(sprm);
			/*	
				fseek(mainfd,portions->fcMin+oldccpText+portions->ccpFtn+portions->ccpHdd+begin,SEEK_SET);
			*/
				fseek(mainfd,fcvalue,SEEK_SET);
				tempcp=cp;
				portions->ccpText = len;
				cp=begin;
				tempfields = all_fields[0];
				all_fields[0] = all_fields[3];
				realcp = oldccpText+portions->ccpFtn+portions->ccpHdd+begin;
				/*
				decode_simple(mainfd,tablefd,fcClx,portions->fcMin+oldccpText+portions->ccpFtn+portions->ccpHdd+begin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,3);
				*/
				decode_simple(mainfd,tablefd,fcClx,fcvalue,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,3);
				all_fields[0] = tempfields;
				cp=tempcp;
				realcp = tempcp;
				fseek(mainfd,headerpos,SEEK_SET);
				portions->ccpText = oldccpText;
				header--;
				error(stderr,"ending annotation\n");
				}
			}
		portions->list_foot_no=0; /*ready for next page footnotes*/
		decode_footer(&begin,&len,portions,asep);
		if ((begin != -1) && (len != -1))
			{
			init_chp(&achp);
			decode_s_chp(&achp);
			headerpos = ftell(mainfd);
			oldccpText = portions->ccpText;
			header++;


			fseek(tablefd,fcClx,SEEK_SET);
			getc(tablefd);
			nopieces = get_piecetable(tablefd,&rgfc,&avalrgfc,&sprm,&clxcount);

			
			fcvalue = get_fc_from_cp(portions->ccpFtn+oldccpText+begin,rgfc,avalrgfc,nopieces);

			free(rgfc);
			free(avalrgfc);
			free(sprm);
			error(stderr,"standard footer, fcvalue is %x, old method %d\n",fcvalue,portions->fcMin+portions->ccpFtn+oldccpText+begin);
			
		/*	
			fseek(mainfd,portions->fcMin+portions->ccpFtn+oldccpText+begin,SEEK_SET);
		*/
	
			fseek(mainfd,fcvalue,SEEK_SET);
	
			tempcp=cp;
			portions->ccpText = len;
			cp=begin;
			tempfields=all_fields[0];
			all_fields[0] = all_fields[1];
			realcp = oldccpText+portions->ccpFtn+begin;
			/*	
			decode_simple(mainfd,tablefd,fcClx,portions->fcMin+oldccpText+portions->ccpFtn+begin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,1);
			*/
			
			decode_simple(mainfd,tablefd,fcClx,fcvalue,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,1);
			
			all_fields[0] = tempfields;
			cp=tempcp;
			realcp = tempcp;
			fseek(mainfd,headerpos,SEEK_SET);
			portions->ccpText = oldccpText;
			header--;
			error(stderr,"ending footer\n");
			}

		printf("\n<hr>\n");
		pagenumber++;
		sectionpagenumber++;
		init_chp(&achp);
		decode_s_chp(&achp);
		}
	}

void decode_simple_header(FILE *mainfd,FILE *tablefd,sep *asep,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag)
	{
	U32 headerpos;
	U32 oldccpText;
	U32 begin=0;
	U32 len=0;
	int tempcp;
	int temprealcp;
	field_info *tempfields;
	int i;
	int nopieces;
	U32 *avalrgfc=NULL;
	U32 *rgfc=NULL;
	U16 *sprm=NULL;
	U32 fcvalue;
	U32 clxcount;

	if (noheaders)
		return;
	

	if (header == 0)
		{
		error(stderr,"doing header\n");
		for (i=0;i<1;i++)
			{
			if (i==0)
				decode_header(&begin,&len,portions,asep);
#if 0
			/*
			im ignoring this for now, i think this is
			a header textbox, so ill hold off on this 
			until i get it right
			*/
			else
				decode_header2(&begin,&len,portions);
#endif
				
			if ((begin != -1) && (len != -1))
				{
				
				fseek(tablefd,fcClx,SEEK_SET);
				getc(tablefd);
				nopieces = get_piecetable(tablefd,&rgfc,&avalrgfc,&sprm,&clxcount);
				

				headerpos = ftell(mainfd);
				oldccpText = portions->ccpText;
				header++;

				fcvalue = get_fc_from_cp(portions->ccpFtn+oldccpText+begin,rgfc,avalrgfc,nopieces);
			/*	
				fseek(mainfd,portions->fcMin+portions->ccpFtn+oldccpText+begin,SEEK_SET);
			*/
				
				fseek(mainfd,fcvalue,SEEK_SET);
			

				free(avalrgfc);
				free(rgfc);
				free(sprm);

				tempcp=cp;
				portions->ccpText = len;
				cp=begin;
				tempfields = all_fields[0];
				all_fields[0] = all_fields[1];
				error(stderr,"overall header begin is %x\n",portions->fcMin+oldccpText+portions->ccpFtn+begin);
				error(stderr,"fcvalue is %x\n, ordinary seek is %x",fcvalue,portions->fcMin+portions->ccpFtn+oldccpText+begin);
				temprealcp = realcp;
				realcp = oldccpText+portions->ccpFtn+begin;
				inaheaderfooter=1;
				decode_simple(mainfd,tablefd,fcClx,fcvalue,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,1);
				inaheaderfooter=0;
				all_fields[0] = tempfields;
				cp=tempcp;
				realcp = temprealcp;
				error(stderr,"after header realcp is %x\n",realcp);
				fseek(mainfd,headerpos,SEEK_SET);
				portions->ccpText = oldccpText;
				header--;
				error(stderr,"ending header\n");
				}
			}

		}
	}

void get_next_ref(textportions *portions,signed long *nextfootnote)
	{
	int i;
	if (portions->fndref_no > 0)
		{
		/*then there might be footnotes to look out for*/
		for(i=0;i<portions->fndref_no;i++)
			{
			error(stderr,"footnote blah %d, %ld, %ld",portions->fndFRD[i],*nextfootnote,portions->fndRef[i]);
			if ( (portions->fndFRD[i] <= 0) && (*nextfootnote < portions->fndRef[i]) )
				{
				/*not automatically numbered, so we have to look out for it manually*/
				*nextfootnote = portions->fndRef[i];
				error(stderr,"the next footnote is at cp %x\n",*nextfootnote);
				break;
				}
			}
		
		}
	}

void decode_simple(FILE *mainfd,FILE *tablefd,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag)
	{
	U32 arse;
	U32 nextfc=0;
	U32 tapfc1=0;
	
	U32 nextchpfc=0;
	U32 lastfc=0;
	U32 lastchpfc=0;
	U32 internalcp;
	U32 limitcp;
	pap *apap;
	chp *achp;
	sep *asep=NULL;
	pap *tappap= NULL;
	pap *temppap = NULL;
	chp *tempchp = NULL;
	int i,j;
	int letter;
	int tempfck;
	int newpage=1;
	U32 thisfc;
	U32 sepxfc;
	

	U32 *rgfc=NULL;
	U32 *avalrgfc=NULL;
	U32 temppiece;
	U16 *sprm=NULL;
	U32 clxcount=0;
	int nopieces;
	signed long nextfootnote=0;

	U32 untilfc=0;

	int flag_8_16=0;

	int d_count=0;

	U32 nextpiece=0;

	int issection=1;

	U32 sepcp;


	apap = NULL;
	achp = NULL;
	nextfc=fcMin;
	nextchpfc=fcMin;


	error(stderr,"all text begins %ld %x ends at %ld %x, main text ends at %ld %x\n",fcMin,fcMin,fcMac,fcMac,portions->ccpText+fcMin,portions->ccpText+fcMin);


	fseek(tablefd,fcClx,SEEK_SET);
	getc(tablefd);
		
	error(stderr,"begin simple fcClx is (%x)",fcClx);
	/*
	hmm, simple files can be start off in 8 bit and go to 16
	bit and vice versa, is so the piecetable can be used to determine these
	limits
	*/
	nopieces = get_piecetable(tablefd,&rgfc,&avalrgfc,&sprm,&clxcount);
	if (nopieces > 1)
		error(stderr,"ah shit!, buggering microsoft over-complex toolkits!!!!, theres NO call for this dumb *piece* technology anyway\n");

	/*
	right so this is to guess (over safely) whether to go into unicode mode or not for
	the full html document, if i get it wrong then well ill get away with it wih utf-8 encoding
	coz i believe as ms only uses 8 bit for west european languages as far as i can tell
	*/
	if (header==0)
		{
		i=0;
		while(i<nopieces)
			{
			if (avalrgfc[i] & 0x40000000UL)
				{
				/*
				flag_8_16=0;
				untilfc=fcMin+portions->ccpText;
				*/
				error(stderr,"hokay, simple text is ascii 8 bit stuff\n");
				}
			else
				{
				/*
				flag_8_16=1;
				untilfc=fcMin+portions->ccpText+portions->ccpText;
				*/
				error(stderr,"hokay, simple text is unicode 16 bit stuff\n");
				if (header == 0)
					{
					printf("\n<head>\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;charset=utf-8\">\n</head>\n");
					break;
					}
				}
			i++;
			}

		printf("<body>\n");
		}

	/*now we have a problem as some simple (hah!!!) docs can go from 16 bit text to 
	8 bit and vice versa depending on the piece table, so keep an eye on that
	so as to know how to twiddle the flags*/
	/*find the smallest piece greater than or equal to the realcp*/
	i=0;

	while(i<nopieces)
		{
		error(stderr,"realcp is %x, rgfc[i+1] is %x\n",realcp,rgfc[i+1]);
		if (rgfc[i+1] > realcp)
			{
			nextpiece = rgfc[i+1];
			if (avalrgfc[i] & 0x40000000UL)
				{
				flag_8_16=0;
				untilfc=fcMin+portions->ccpText;
				}
			else
				{
				flag_8_16=1;
				untilfc=fcMin+portions->ccpText+portions->ccpText;
				}
			break;
			}
		i++;
		}


	error(stderr,"end simple fcClx is (%x)",fcClx);

	error(stderr,"end fc is %x\n",fcMin+portions->ccpText);

	if ( (flag < 2) && (flag >0) )
		{
		untilfc=-1;  /*max it out for header/footers and rely on doubled 0x0d's*/
		limitcp=-1;
		}
	else
		limitcp=portions->ccpText;

	/*portions->cppText gives the amount of chars to handle*/
	i=fcMin;
	internalcp=0;


	error(stderr,"fcMin is %x,untilfc is %x, it would be %x, limitcp is %x, nextpiece is %x\n",fcMin,untilfc,untilfc-fcMin,limitcp,nextpiece);
	while(internalcp < limitcp)
		{
		error(stderr,"real cp is %x nextpiece is %x\n",realcp,nextpiece);
		if (nextpiece == realcp)
			{
			error(stderr,"have to get next piece for simple text mode\n");
			/*
			here we should actually do a seek to the fc, and see if this
			nextpiece thing is ok
			*/
			j=0;

			while(j<nopieces)
				{
				if (rgfc[j+1] > realcp)
					{
					nextpiece = rgfc[j+1];
					if (avalrgfc[j] & 0x40000000UL)
						flag_8_16=0;
						
					else
						flag_8_16=1;
						
					if (avalrgfc[j] & 0x40000000UL)
						{
						error(stderr,"THUS this fc is %x\n",(avalrgfc[j]&0xbfffffffUL)/2);
						thisfc = (avalrgfc[j]&0xbfffffffUL)/2;
						}
					else
						{
						error(stderr,"THUS fc is %x\n",avalrgfc[j]);
						thisfc = avalrgfc[j];
						}
					fseek(mainfd,thisfc,SEEK_SET);
					i = thisfc;
					/*force new paragraph and chp check*/
					nextfc=i;
					error(stderr,"SEEK: we're at %x, flag is %d\n",ftell(mainfd),flag_8_16);
					break;
					}
				j++;
				}
			}

		/*get the sep*/
		if (flag == 0)
			if (issection)
				{
				error(stderr,"getting sep, %x, piece is %d\n",realcp,i);
				sepxfc = find_FC_sepx(realcp,&sepcp,portions);
				asep = get_sep(sepxfc,mainfd);
				issection=0;
				}
		
		/*
		go down through all the text, when we hit a new page spit out the 
		header
		*/
		error(stderr,"fc is %ld (%X)\n",i,i);
		if (newpage)
			{
			newpage=0;
			decode_simple_header(mainfd,tablefd,asep,fcClx,fcMin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,flag);
			error(stderr,"end: flag is %d\n",flag);
			/*force new paragraph and chp check*/
			nextfc=i;
			}


		/*get the pap*/
		if (i == nextfc) 
			{
			lastfc = i;
			temppap = apap;
			tempfck = find_FKPno_papx(i,plcfbtePapx,intervals);
			if (tempfck != -1)
				{
				apap = get_pap(tempfck,mainfd,i,&nextfc,sheet,a_list_info);
				error(stderr,"next para is at %x\n",nextfc);
				}
			
			if (apap == NULL)
				{
				error(stderr,"found no pap, reverting to previous\n");
				apap = temppap;
				}
			else if (temppap != NULL)
				{
				free(temppap);
				}

			/*if table set search for tap*/
			if (apap->fInTable)
				{
				tapfc1 = i;
				error(stderr,"we search for the tap here\n");
				error(stderr,"tappap nexts are %x, i is %x\n",tapfc1,i);
				do
					{
					error(stderr,"tappap nexts are %x\n",tapfc1);
					tempfck = find_FKPno_papx(tapfc1,plcfbtePapx,intervals);
					if (tempfck != -1)
						tappap = get_pap(tempfck,mainfd,tapfc1,&tapfc1,sheet,a_list_info);
					else
						break;
					}
				while( (tappap != NULL) && (!tappap->fTtp) );
				error(stderr,"finished search for the tap here\n");
				error(stderr,"no of cells is %d, %d\n",apap->ourtap.cell_no,tappap->ourtap.cell_no);
				/*
				at this stage tappap has the correct row structure stored in it
				that we want apap to have
				*/
				apap->ourtap = tappap->ourtap;
				}
			}

		/* get the chp, using the paps istd for a basis*/
		if ((i == nextchpfc) || (lastfc == i)) 
			{
			lastchpfc=i;
			error(stderr,"looking for chp\n");
			tempchp = achp;
			tempfck = find_FKPno_chpx(i,plcfbteChpx,chpintervals);
			if (tempfck != -1)
				achp = get_chp(tempfck,mainfd,i,&nextchpfc,sheet,apap->istd);

			if (achp == NULL)
				{
				error(stderr,"found no chp, reverting to previous\n");
				achp = tempchp;
				}
			else if (tempchp != NULL)
				free(tempchp);

			if (flag == 1)
				{
				achp->color="#7f5555";
				error(stderr,"color set\n");
				}
			else if (flag == 2)
				{
				achp->color="#330099";
				error(stderr,"color set\n");
				}
			else if (flag == 3)
				{
				achp->color="#ff7777";
				error(stderr,"color set\n");
				}
			else 
				{
				error(stderr,"color not set\n");
				achp->color=NULL;
				}

			error(stderr,"the next char lim is %d (%x)\n",nextchpfc,nextchpfc);
			
			decode_e_list(apap,achp,a_list_info);
			decode_e_chp(achp);
			}
			
		/*after we have a new pap, do the special codes*/
		if (lastfc == i)
			{
			decode_e_specials(apap,achp,a_list_info);
			decode_e_table(apap,achp,a_list_info);
			decode_s_table(apap,achp,a_list_info);
			decode_s_specials(apap,achp,a_list_info);
			decode_s_chp(achp);
			}

		if (lastchpfc == i) 
			{
			decode_s_chp(achp);
			lastchpfc = 0;
			}


		if (flag_8_16)
			letter = read_16ubit(mainfd);
		else
			letter = getc(mainfd);


		if (lastfc == i)
			{
			if ( ((letter != 12) && (letter != 13))  )
				{
				error(stderr,"doing list and next letter is %c %x\n",letter,letter);
				decode_s_list(apap,achp,a_list_info,fontnamelist,DONTIGNORENUM);
				}
			else
				error(stderr,"a special list\n");
				
				
			lastfc = 0;
			}

		if (flag)
			{
			if (letter == 13)
				{
				/*
				headers and footers seem to continue until 2 0x0d are reached, they dont
				appear after all to go until the len derived from the header table
				like i thought originally.
				*/
				d_count++;
				if (d_count == 2)
					break;
				}
			else
				d_count=0;
			}


		if ( (cp == nextfootnote) && (flag == 0) ) 
			{
			decode_reference(portions);
			get_next_ref(portions,&nextfootnote);
			}

		newpage = decode_letter(letter,flag_8_16,apap,achp,all_fields[0],mainfd,fontnamelist,a_list_info,portions,&issection);

		if (newpage)
			{
			error(stderr,"this one\n");
			decode_simple_footer(mainfd,tablefd,asep,fcClx,fcMin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,flag);
			}
			
		if (flag_8_16)
			i+=2;
		else
			i++;
		internalcp++;
		}

	if (apap == NULL)
		{
		apap = (pap *)malloc(sizeof(pap));
		if (apap == NULL)
			return;
		}
	
	apap->istd = 0;
	apap->ilvl=-1;
	apap->tableflag=0;
	decode_e_list(apap,achp,a_list_info);
	decode_e_specials(apap,achp,a_list_info);
	decode_e_table(apap,achp,a_list_info);

	if (!newpage)
		{
		error(stderr,"the other one\n");
		decode_simple_footer(mainfd,tablefd,asep,fcClx,fcMin,fcMac,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,flag);
		}
	}


void decode_header(U32 *begin,U32 *len,textportions *portions,sep *asep)
	{
	/*i dont know how these fields are working as of yet, the
	docs seem to be a bit dodgy*/
	int odd;
	int val,tval;
	*begin = -1;
	*len= -1;


	/*is this the first page of a section*/
	if ((sectionpagenumber==asep->pgnStart) && (asep->fTitlePage))
		{
		error(stderr,"checking for page 1 special header\n");
		if (portions->headercpno > 10)
			if (portions->headercplist[11] > portions->headercplist[10])
				{
				*begin = portions->headercplist[10];
				*len = portions->headercplist[11]-portions->headercplist[10];
				error(stderr,"header begin is %x end is %x\n",portions->headercplist[11],portions->headercplist[10]);
				return;
				}
		if (asep->fTitlePage)
			return;
				
		/*crazed bit of logic here :-)*/
		if (portions->headercpno > 13)
			if (portions->headercplist[portions->headercpno-1] > (portions->headercplist[10]+3))
				return;
		}
	
	/*if nothing was found continue, and pull out ordinary header*/

	if ((sectionpagenumber/2)*2 == sectionpagenumber)
		odd=0;
	else 
		odd=1;

	*len=0;


	/*if index 8 is larger than index 7 i think thats the boundaries
	of header for all pages*/

	tval = 6+(6*(sectionno-1)); /*hairy test*/

	val = tval;
	error(stderr,"header val is %d, odd is %d, pagenumber is %d\n",val,odd,pagenumber);

	if (!odd)
		{
		while ((*len==0) && (val>0))
			{
			if (portions->headercpno > val)
				{
				if (portions->headercplist[val+1] > portions->headercplist[val])
					{
					*begin = portions->headercplist[val];
					*len = portions->headercplist[val+1]-portions->headercplist[val];
					error(stderr,"header begin is %x end is %x\n",portions->headercplist[val],portions->headercplist[val+1]);
					}
				}
			else
				error(stderr,"well arse!!!, ive got the wrong idea about headers\n");
			val-=6;
			}
		}

	val=tval;
	
	if ((odd) || (*len == 0))
		{
		while ((*len==0) && (val>0))
			{
			if (portions->headercpno > val+1)
				{
				error(stderr,"val is %d headercplist[val+2] %x headercplist[val+1] %x\n",val,portions->headercplist[val+2],portions->headercplist[val+1]);
				if (portions->headercplist[val+2] > portions->headercplist[val+1])
					{
					*begin = portions->headercplist[val+1];
					*len = portions->headercplist[val+2]-portions->headercplist[val+1];
					error(stderr,"this header begin is %x end is %x\n",portions->headercplist[val+1],portions->headercplist[val+2]);
					}
				}
			else
				error(stderr,"well arse!!!, ive got the wrong idea about headers\n");
			val-=6;
			}
		}

	}

void decode_header2(U32 *begin,U32 *len,textportions *portions)
	{

	/*
	this is just a hacked together function, i have no basis for
	this at all except thats the output that word gets, dunno at all
	about this, im not seeing something obvious somewhere, hmm
	*/

	/*i dont know how these fields are working as of yet, the
	docs seem to be a bit dodgy*/
	*begin = -1;
	*len= -1;

	/*is this the first page of a section*/
	if (sectionpagenumber==1)
		return;
	
	/*if index 8 is larger than index 7 i think thats the boundaries
	of header for all pages*/
	if (portions->headercpno > 12)
		if (portions->headercplist[13] > portions->headercplist[12])
			{
			*begin = portions->headercplist[12];
			*len = portions->headercplist[13]-portions->headercplist[12];
			error(stderr,"header begin is %x end is %x\n",portions->headercplist[12],portions->headercplist[13]);
			}
	else
		error(stderr,"well arse!!!, ive got the wrong idea about headers\n");

	}

void decode_footnote(U32 *begin,U32 *len,textportions *portions,int i)
	{
	error(stderr,"footnote cp begin is %x end is %x\n",portions->fndTxt[i],portions->fndTxt[i+1]);
	*begin = portions->fndTxt[i];
	*len = portions->fndTxt[i+1]-*begin;
	}

void decode_footanno(U32 *begin,U32 *len,textportions *portions,int i)
	{
	error(stderr,"annotation cp begin is %x end is %x\n",portions->andTxt[i],portions->andTxt[i+1]);
	*begin = portions->andTxt[i];
	*len = portions->andTxt[i+1]-*begin;
	}

void decode_footer(U32 *begin,U32 *len,textportions *portions,sep *asep)
	{
	/*i dont know how these fields are working as of yet, the
	docs seem to be a bit dodgy*/
	int odd;
	int val,tval;
	*begin = -1;
	*len= -1;
	
	error(stderr,"pagenumber is %d,sectionpagenumber is %d, pgnStart is %d, title is %d\n",pagenumber, sectionpagenumber,asep->pgnStart,asep->fTitlePage);

	if ((sectionpagenumber==asep->pgnStart) && (asep->fTitlePage))
		{
		error(stderr,"checking for page 1 special footer\n");
		if (portions->headercpno > 12)
			{
			if (portions->headercplist[12] > portions->headercplist[11])
				{
				*begin = portions->headercplist[11];
				*len = portions->headercplist[12]-portions->headercplist[11];
				printf("\n<hr width=\"50%%\">\n");
				error(stderr,"header begin is %x end is %x\n",portions->headercplist[12],portions->headercplist[11]);
				return;
				}
			}
		if (asep->fTitlePage)
			return;

		/*crazed bit of logic here :-)*/
		if (portions->headercpno > 14)
			if (portions->headercplist[portions->headercpno-1] > (portions->headercplist[11]+3))
				return;
		}

	/*else contunue down the wire*/
	/*
	if its an odd page look at that, return the appropiate portion,
	if that is 0 len then return the even*/
	/*if index 10 is larger than index 9 i think thats the boundaries
	of header for odd(or all) pages*/


	if ((sectionpagenumber/2)*2 == sectionpagenumber)
		odd=0;
	else 
		odd=1;


	printf("\n<hr width=\"50%%\">\n");

	*len=0;

	tval = 8+ ((sectionno-1)*6);

	error(stderr,"odd is %d, section no is %d, tval is %d, *len is %d\n",odd,sectionno,tval,*len);

	val=tval;
	if (!odd)
		{
		while ((*len == 0) && (val > 0))
			{
			if (portions->headercpno > val)
				{
				if (portions->headercplist[val+1] > portions->headercplist[val])
					{
					*begin = portions->headercplist[val];
					*len = portions->headercplist[val+1]-portions->headercplist[val];
					error(stderr,"even begin is %x end is %x\n",portions->headercplist[val],portions->headercplist[val+1]);
					}
				}
			else
				error(stderr,"well arse!!!, ive got the wrong idea about footers val %d\n",portions->headercpno);
			val-=6;
			}
		}

	val = tval;

	if ( (odd) || (*len == 0))
		{
		while ((*len == 0) && (val > 0))
			{
			if (portions->headercpno > val+1)
				{
				if (portions->headercplist[val+2] > portions->headercplist[val+1])
					{
					*begin = portions->headercplist[val+1];
					*len = portions->headercplist[val+2]-portions->headercplist[val+1];
					error(stderr,"odd begin is %x end is %x\n",portions->headercplist[val+1],portions->headercplist[val+2]);
					}
				}
			else
				error(stderr,"well arse!!!, ive got the wrong idea about footers val %d\n",portions->headercpno);
			val-=6;
			}
		}
		
	}

void decode_s_chp(chp *achp)
	{
	error(stderr,"in start chp\n");
	if (chps)
		return;
	error(stderr,"still in start chp\n");
	error(stderr,"font =%d\n, current font is %d", achp->fontsize,currentfontsize);

	if ((achp->fontsize!=currentfontsize) || ( (achp->color != NULL) && (!inacolor))  || ( (achp->color == NULL) && (inacolor)) )
		{
		error(stderr,"font =%d\n", achp->fontsize);
		if (initalic)
			{
			printf("</I>");
			initalic=0;
			}
		if (inbold)
			{
			printf("</B>");
			inbold=0;
			}
		if (inunderline)
			{
			printf("</U>");
			inunderline=0;
			}
		if (inafont)
			{
			inacolor=0;
			printf("</font>");
			currentfontsize=NORMAL;
			inafont=0;
			}

		if ( (achp->color != NULL) || (achp->fontsize!=currentfontsize) )
			{
			printf("<font ");
			if ( (((achp->fontsize/2)-NORMAL/2) != 0) && (achp->fontsize!=NORMAL))
				{
				printf("size = \"%+d\" ", (achp->fontsize/2)-NORMAL/2);
				inafont=1;
				}
			if (achp->color != NULL)
				{
				printf("color =\"%s\"", achp->color);
				inafont=1;
				inacolor=1;
				strcpy(incolor,achp->color);
				}
			printf(">");
			currentfontsize=achp->fontsize;
			}
		}


	if ((achp->supersubscript == 1) && (!insuper))
		{
		error(stderr,"superscript begins\n");
		printf("<SUP>");
		insuper=1;
		}

	if ((achp->supersubscript == 2) && (!insub))
        {
        error(stderr,"subscript begins\n");
        printf("<SUB>");
        insub=1;
        }

	error(stderr,"bold is %d\n",achp->fBold);

	if ((achp->fBold) && (inbold == 0))
		{
		printf("<B>");
		inbold=1;
		}
	
	if ((achp->fItalic) && (initalic==0))
		{
		printf("<I>");
		initalic=1;
		}


	if ((achp->underline) && (inunderline == 0))
		{
		printf("<U>");
		inunderline=1;
		}
	}

void decode_e_chp(chp *achp)
	{
	int colorflag=0;
	error(stderr,"in end chp\n");
	if (chps)
		return;

	if ((inunderline== 1) && (achp->underline == 0))
		{
		inunderline=0;
		printf("</U>");
		}

	if ((initalic == 1) && (achp->fItalic == 0))
		{
		initalic=0;
		printf("</I>");
		if (inbold==1)
			{
			inbold=0;
			printf("</B>");
			}
		}

	if ((inbold==1) && (!achp->fBold))
		{
		if (initalic == 1)
			{
			initalic=0;
			printf("</I>");
			}
		inbold=0;
		printf("</B>");
		}

	if ((insuper) && (achp->supersubscript != 1))
		{
		insuper=0;
		if (footnotehack==1)
			{
			printf("</a>");
			footnotehack=0;
			}
		printf("</SUP>");
		}

	if ((insub) && (achp->supersubscript != 2))
		{
		insub=0;
		printf("</SUB>");
		}


	error(stderr,"the len of color is %d, %d\n",achp->color,incolor);

	if ((inacolor) && (achp->color == NULL))
		colorflag=1;
	else if (achp->color != NULL)
		if (incolor && (0 != strcmp(achp->color,incolor)) ) 
			colorflag=1;

	if ( ((inafont) && (achp->fontsize!=currentfontsize)) || colorflag )
		{
		error(stderr,"font ended\n");
		if (initalic == 1)
			{
			initalic=0;
			printf("</I>");
			}
		if (inbold == 1)
			{
			inbold=0;
			printf("</B>");
			}
		if (inafont)
			printf("</FONT>");
		inafont =0;
		inacolor=0;
		currentfontsize=NORMAL;
		}
	error(stderr,"left end chp sucessfully\n");
	}

void decode_annotation(textportions *portions, FILE *main)
	{
	int i;
	/*
	search in the first thing for the cp of this
	reference.
	*/
	i=0;
	while(i<portions->andref_no)
		{
		if (portions->andRef[i] == cp)
			{
			error(stderr,"found correct anno ref pos at %x, index was %d\n",portions->andRef[i],i);
			if (!insuper)
				printf("<sup>");
			printf("<a href=\"#anno%d\">anno%d</a>",i,i);
			if (!insuper)
				printf("</sup>");
			break;
			}
		i++;
		}

	/*part deux*/
	/*
	now to hold off to the very end any spray them all out, or at the end of every page.
	ill do the latter for the moment
	*/
	if ( (i < portions->andref_no ) && (i < 256) )
		portions->list_annotations[portions->list_anno_no++] = i;
	else if (i >= 256)
		fprintf(stderr,"oops silly programmer :-) lost an annotation\n");
	}

void decode_reference(textportions *portions)
	{
	int i;
	/*
	search in the first thing for the cp of this
	reference, then use this index into the second
	one to determine what text to use ?
	*/
	i=0;
	while(i<portions->fndref_no)
		{
		if (portions->fndRef[i] == cp)
			{
			error(stderr,"found correct ref pos at %x, index was %d\n",portions->fndRef[i],i);
			if (portions->fndFRD[i] > 0)
				{
				if (!insuper)
					{
					printf("<sup>");
					insuper=2;
					}
				error(stderr,"is autonumbered <%d>\n",portions->fndFRD[i]);
				printf("<a href=\"#foot%d\">%d</a>",i,portions->fndFRD[i]);
				}
			else
				{
				error(stderr,"is custom <%d>\n",portions->fndFRD[i]);
				/*dont handling custom footnotes the same way*/
				printf("<a href=\"#foot%d\">",i);
				footnotehack=1;
				}
			if (insuper==2)
				printf("</sup>");
			break;
			}
		error(stderr,"conpared given pos %x and ref list %x",cp,portions->fndRef[i]);
		i++;
		}

	/*part deux*/
	/*
	now to hold off to the very end any spray them all out, or at the end of every page.
	ill do the latter for the moment
	*/
	if ( (i < portions->fndref_no ) && (i < 256) )
		portions->list_footnotes[portions->list_foot_no++] = i;
	else if (i >= 256)
		fprintf(stderr,"oops silly programmer :-) lost a footnote\n");
	}


void flushbreaks(void)
	{
	int silent=0,i;

	if (breakcount == 1)
		{
		oprintf(silent,"<br>\n");
		}
	else if (breakcount > 1)
		{
		if (verpadding == 1)
			{
			for (i=0;i<breakcount;i++)
				oprintf(silent,"<br>\n");
			}
		else
			{
			oprintf(silent,"<p>\n");
			if (verpadding != 2)
				if (breakcount > 2)
					for (i=2;i<breakcount;i++)
						oprintf(silent,"<br>\n");
			}
		}
	breakcount=0;
	}


/*
letter logic:
	in comes letter, check the font stuff, if its some fonts it appears
	to be fSpec by default, then run through the fSpec code , then
	if it gets through that then if its a special font decode the char
	otherwise run it through the ordinary letter handling
*/

int decode_letter(int letter,int flag,pap *apap, chp * achp,field_info *magic_fields,FILE *main,ffn *fontnamelist,list_info *a_list_info,textportions *portions, int *issection)
	{
	int ret=0;
	int i;
	static U8 fieldwas=-1;
	static fieldeater=0;
	static long int swallowcp1=-1,swallowcp2=-1;
	static int spacecount;
	static int tabstop;
	static int silent=0;
	float tabbing;
	ffn *tempfont;
	time_t timep;
	struct tm *times;
	char date[1024];
	char *fontname=NULL;
	int fSpecflag=0;
	
	U8 target[7];
	int len;

	chp tempchp;

	cellempty--;

	if  (letter != 13 || achp->fontcode !=0 ) 
		flushbreaks();

	if (fontnamelist != NULL)
		{
		if ( (achp->fontcode !=0) && (letter > 34) ) 
			{
			error(stderr,"asked for nonstandard font %d\n",achp->fontcode);
			i=0;
			tempfont = fontnamelist;
			while (i < achp->fontcode)
				{
				tempfont = tempfont->next;
				if (tempfont == NULL)
					break;
				i++;
				}

			if (tempfont == NULL)
				{
				error(stderr,"warning!! fontcode incorrect, abandoning\n");
				return(0);
				}

			error(stderr,"i is %d and font is %s\n",i,tempfont->name);
			if (i == achp->fontcode)
				{
				if (!(strcmp("Symbol",tempfont->name)))
					{
					error(stderr,"must use symbol font for this letter\n");
					if (decode_symbol(achp->fontspec))
						{
						cp++;
						realcp++;
						return(ret);
						}
					}
				else if (!(strcmp("Wingdings",tempfont->name)))
					{
					error(stderr,"must use wingding font for this letter %c\n",letter);
					if (decode_wingding(achp->fontspec))
						{
						cp++;
						realcp++;
						return(ret);
						}
					}
				}
			}
		else 
			{
			i=0;
			tempfont = fontnamelist;
			while (i < achp->ascii_font)
				{
				tempfont = tempfont->next;
				if (tempfont == NULL)
					break;
				i++;
				}
			error(stderr,"i is %d and font is %s\n",i,tempfont->name);
			if ( (i == achp->ascii_font) && (letter > 34) ) 
				{
				if (!(strcmp("Symbol",tempfont->name)))
					{
					error(stderr,"must use symbol font for this letter here\n");
					fontname=tempfont->name;
					if (achp->fSpec==0)
						{
						achp->fSpec=1;
						fSpecflag=1;
						}
					}
				else if (!(strcmp("Wingdings",tempfont->name)))
					{
					error(stderr,"must use wingding font for this letter here %d fontcode is %d\n",letter,achp->fontcode);
					fontname=tempfont->name;
					if (achp->fSpec==0)
						{
						achp->fSpec=1;
						fSpecflag=1;
						}
					}
				}

			}
		}

	error(stderr,"cp is %x (%x) Trealcp is %x\n",cp,letter,realcp);
	if ( ( (fieldeater == 2) && (letter != 0x20) ) || ( (fieldeater > 0) && (letter == 0x20) ))
		{
		fieldeater--;
		if (fieldeater == 0)
			silent=0;
		}
	/*
	else if ((cp >= swallowcp1) && (cp < swallowcp2))
	*/
	else if ((cp > swallowcp1) && (cp < swallowcp2))
		{
		error(stderr,"swallowing %c\n",letter);
		}
	else
		{
		if ((letter != 32) && (spacecount == 1))
			{
			oprintf(silent," ");
			spacecount=0;
			tabstop++;
			}
		else if (letter != 32) 
			{
			for (i=0;i<spacecount;i++)
				{
				if (padding)
					oprintf(silent,"&nbsp;");
				tabstop++;
				}
			spacecount=0;
			}


		tabstop++;

		if (achp->fSpec==1)
			{
			switch (letter)
				{
				case 0:
					printf("%d",pagenumber);
					error(stderr,"pagenumber is now %d\n",pagenumber);
					break;
				case 1:
					error(stderr,"handle picture\n");
					break;
				case 2:
					error(stderr,"INSERT REF\n");
					decode_reference(portions);
					break;
				case 3:
				case 4:
					error(stderr,"do these matter in html mode\n");
					break;
				case 5:
					error(stderr,"INSERT ANNOTATION\n");
					if (doannos)
						decode_annotation(portions,main);
					break;
				case 6:
					error(stderr,"line no\n");
					printf("UNKNOWN LINE NO\n");
					break;
				case 7:	
					error(stderr,"what is this !, pen windowsn\n");
					break;
				case 8:	
					error(stderr,"office draw thing, must get spid\n");
					output_draw(cp,portions);
					break;
				case 10:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%a, %b ",times);
					error(stderr,"output date as %s\n",date);
					printf("%s",date);
					printf("%d",times->tm_mday);
					strftime(date,1024,",%Y",times);
					error(stderr,"output date as %s\n",date);
					printf("%s",date);
					break;
				case 30:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%x",times);
					error(stderr,"output date as %s\n",date);
					printf("%s",date);
					break;
				case 11:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%H:%M:%S",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 28:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%X",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 12:
					printf("--%d--\n",sectionno);
					error(stderr,"did section no\n");
					break;
				case 14:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%a",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 15:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%A",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 16:
					timep = time(NULL);
					times = localtime(&timep);
					/*
					strftime(date,1024,"%d",times);
					error(stderr,"output time as %s\n",date);
					*/
					printf("%d",times->tm_mday);
					break;
				case 22:
					timep = time(NULL);
					times = localtime(&timep);
					/*
					strftime(date,1024,"%H",times);
					error(stderr,"output time as %s\n",date);
					*/
					printf("%d",times->tm_hour);
					break;
				case 23:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%H",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 24:
					timep = time(NULL);
					times = localtime(&timep);
					/*
					strftime(date,1024,"%M",times);
					error(stderr,"output time as %s\n",date);
					*/
					printf("%d",times->tm_min);
					break;
				case 25:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%M",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 26:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%S",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 27:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%p",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 29:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%B ",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					printf("%d",times->tm_mday);
					strftime(date,1024,", %Y",times);
					printf("%s",date);
					break;
				case 33:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%m",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 34:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%Y",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 35:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%y",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 36:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%b",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 37:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%B",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 38:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%H:%M",times);
					error(stderr,"output time as %s\n",date);
					printf("%s",date);
					break;
				case 39:
					timep = time(NULL);
					times = localtime(&timep);
					strftime(date,1024,"%A, %B, ",times);
					printf("%s",date);
					printf("%d, ",times->tm_mday);
					strftime(date,1024,"%Y",times);
					printf("%s",date);
					break;
				case 41:
					error(stderr,"print merge ?\n");
					break;
				case 19:
					error(stderr,"\nfield begins\n");
					init_chp(&tempchp);
					chpsoff();
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					error(stderr,"cp vals are %x and %x\n",swallowcp1,swallowcp2);
					if (fieldwas == 88)
						fieldeater=2; /*eat 2 hex 20's*/
					silent=1;
					break;
				case 21:
					error(stderr,"\nfield ends\n");
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					chpson();
					silent=0;
					break;
				case 20:
					error(stderr,"\n field separator\n");
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					if ( (fieldwas == 29) || (fieldwas == 13) )
						silent=0;
					break;
				default:
					if (fontname==NULL)
						{
						if (flag)
							{
							len = our_wctomb(target,letter);
							error(stderr,"letter3: %x %d",letter,letter);
							/*
							expand this in the ranges that we will have to handle 
							ourselves, just for my own benefit for now, i might be
							able to build a table with some word macros and luck*/
							if (letter == 0x2122)
								decode_symbol(0xf0e4);
							else if (letter != 0)
								for(i=0;i<len;i++)
									{
									oprintf(silent,"%c",target[i]);
									error(stderr,"letter2: %c, silent is %d",target[i],silent);
									}
							else
								error(stderr,"given 0 as a letter !\n");
							}
						else
							{
							if (letter == 0xae)
								decode_symbol(61666);
							else if (letter != 0)
								oprintf(silent,"%c",letter);
							error(stderr,"letter2: %c %d %x, silent is %d",letter,letter,letter,silent);
							}
						}
					else
						{
						if (!(strcmp("Wingdings",fontname)))
							decode_wingding(letter);
						else if (!(strcmp("Symbol",fontname)))
							decode_symbol(letter);
						realcp++;
						cp++;
						if (fSpecflag)
							achp->fSpec=0;
						return(ret);
						}
					break;
				}
			}
		else
			{
			switch(letter)
				{
				case 13:
					error(stderr,"\n--paragraph end--\n");
					if (!silent)
						{
						breakcount++;

						if (cellempty == 0)
							cellempty++;
						
						tabstop=0;
						newline=1;
						}
					break;
				case 11:
					error(stderr,"\n(--line break--)\n");
					oprintf(silent,"<BR>\n");
					tabstop=0;
					break;
				case 45:
					error(stderr,"-");
					oprintf(silent,"-"); 
					break;
				case 32:
					spacecount++;
					tabstop--;
					if (cellempty == 0)
						cellempty++;
					break;
				case 31:
					error(stderr,"\n(-nonrequired hyphen- ?)\n");
					oprintf(silent,"-");
					break;
				case 30:
					error(stderr,"\n(-nonbreaking hyphen- ?)\n");
					oprintf(silent,"-");
					break;
				case 160:
					error(stderr,"\n(-non breaking space)\n");
					oprintf(silent,"&nbsp;");
					break;
				case 12:
					error(stderr,"\npage break (maybe section) at %x\n",cp);
					for (i=0;i<portions->section_nos+1;i++)
						{
						if (cp+1 == portions->section_cps[i])
							{
							/*sectionpagenumber=1;*/
							sectionno++;
							*issection=1;
							}
						}
					ret=1;
					/*oprintf(silent,"<hr>");*/
					tabstop=0;
					break;
				case 14:
					error(stderr,"\ncolumn break\n");
					break;
				case 9:
					tabstop--;
					error(stderr,"\ntab\n");
					tabbing = ((float)tabstop)/8;
					error(stderr,"tabbing is %f, from %d\n",tabbing,tabstop);
					if (tabbing == tabstop/8)
						{
						if (padding)
							oprintf(silent,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
						tabstop = tabstop=8;
						}
					else 
						{
						for(i=0;i< 8-((tabbing - (tabstop/8))*8);i++)
							{
							if (padding)
								oprintf(silent,"&nbsp;");
							}
						tabstop = tabstop+(8-(tabbing - (tabstop/8))*8);
						}
					/*oprintf(silent,"<TAB>");*/
					break;
				case 19:
					error(stderr,"\nfield begins\n");
					init_chp(&tempchp);
					chpsoff();
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					error(stderr,"cp vals are %x and %x\n",swallowcp1,swallowcp2);
					if (fieldwas == 88)
						fieldeater=2; /*eat 2 hex 20's*/
					silent=1;
					break;
				case 21:
					error(stderr,"\nfield ends\n");
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					chpson();
					silent=0;
					break;
				case 20:
					error(stderr,"\n field separator\n");
					decode_field(main,magic_fields,&cp,&fieldwas,&swallowcp1,&swallowcp2);
					if ( (fieldwas == 29) || (fieldwas == 13) )
						silent=0;
					break;
				case '<':
					oprintf(silent,"&lt;");
					break;
				case '>':
					oprintf(silent,"&gt;");
					break;
				case 7:
					if (cellempty == 0)
						cellempty++;
					apap->tableflag=1;
					decode_e_specials(apap,achp,a_list_info);
					decode_e_table(apap,achp,a_list_info);
					error(stderr,"\n");
					newline=1;
					break;
				case 0x96:
				case 0x2013:
					oprintf(silent,"-");
					break;
				case 145:
				case 146:
					oprintf(silent,"'");
					break;
				case 132:
				case 147:
					error(stderr,"begin quot\n");
					oprintf(silent,"&quot;");
					break;
				case 148:
					error(stderr,"end quot\n");
					oprintf(silent,"&quot;");
					break;
				case 0x85:
					if (flag)
						letter = 0x2026;
					else
						{
						fontname = "Symbol";
						letter = 0xf0bc;
						/*156.gif*/
						}
					/*deliberate fallthrough*/
				default:
					if (fontname==NULL)
						{
						if (flag)
							{
							len = our_wctomb(target,letter);
							error(stderr,"letter3: %x %d",letter,letter);
							/*
							expand this in the ranges that we will have to handle 
							ourselves, just for my own benefit for now, i might be
							able to build a table with some word macros and luck*/
							if (letter == 0x2122)
								decode_symbol(0xf0e4);
							else if (letter != 0)
								for(i=0;i<len;i++)
									{
									oprintf(silent,"%c",target[i]);
									error(stderr,"letter2: %c, silent is %d",target[i],silent);
									}
							else
								error(stderr,"given 0 as a letter !\n");
							}
						else
							{
							if (letter == 0xae)
								decode_symbol(61666);
							else if (letter != 0)
								oprintf(silent,"%c",letter);
							else
								error(stderr,"silly 0 found\n");
							error(stderr,"letter2: %c %d %x silent is %d",letter,letter,letter,silent);
							}
						}
					else
						{
						if (!(strcmp("Wingdings",fontname)))
							decode_wingding(letter);
						else if (!(strcmp("Symbol",fontname)))
							decode_symbol(letter);
						realcp++;
						cp++;
						if (fSpecflag)
							achp->fSpec=0;
						return(ret);
						}
					break;
				}
				
			}
		}
	cp++;
	realcp++;
	return(ret);
	}


void decode_clx_footer(U32 *rgfc,sep *asep,int nopieces,U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headerfooterflag)
	{
	U32 oldtablepos;
	U32 oldmainpos;
	U32 tempcp;
	U32 begin=0;
	U32 len=0;
	int k;
	field_info *tempfields;
	int i;
	int footnoteflag=0;
	int annotationflag=0;
	chp achp;

	if (noheaders)
		return;

	if (header == 0)
		{
		for (i=0;i<portions->list_foot_no;i++)
			{
			decode_footnote(&begin,&len,portions,i);

			if ((begin != -1) && (len != -1))
				{
				init_chp(&achp);
                decode_s_chp(&achp);

				if (footnoteflag == 0)
					{
					printf("\n<hr width=\"25%%\">\n");
					footnoteflag=1;
					}
				error(stderr,"beginning footnote\n");
				/*test*/
				printf("<p>");
				printf("<font color=\"#330099\">");
				inafont=1;
				inacolor=1;
				strcpy(incolor,"#330099");
				/*end test*/
				if (!insuper)
					{
					printf("<sup>");
					insuper=2;
					}
				printf("<a name=\"foot%d\">",i);

				if (portions->fndFRD[i] > 0)
					{
					printf("%d",portions->fndFRD[i]);
					printf("</A>");
					if (insuper == 2)
						printf("</sup>");
					}
				else
					 footnotehack=1;


				oldmainpos = ftell(main);
				oldtablepos = ftell(in);
				header++;

				k=0;
				while (k< nopieces)
					{
					if (portions->ccpText+begin < rgfc[k]) 
						{
						error(stderr,"piece for footer is %d (%x) (%x)\n",k-1,rgfc[k-1],portions->ccpText+begin);
						break;
						}
					k++;
					}
				tempcp=cp;
				cp=begin;
				error(stderr,"the difference is %d\n",(portions->ccpText+begin)-rgfc[k-1]);
				/*
				cp = cp-((portions->ccpText+begin)-rgfc[k-1]);
				*/
				cp = rgfc[k-1];
				error(stderr,"footer len is %d\n",len);
				error(stderr,"footer cp is %x\n",cp);
				tempfields = all_fields[0];
				all_fields[0] = all_fields[2];
				begin = portions->ccpText+begin;
				decode_clx(k-1,begin,begin+len,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,2);
				if (footnotehack == 1)
                    {
                    printf("</A>");
                    footnotehack=0;
                    }
				all_fields[0] = tempfields;
				cp=tempcp;
				fseek(in,oldtablepos,SEEK_SET);
				fseek(main,oldmainpos,SEEK_SET);
				header--;
				}
			}
		portions->list_foot_no=0; /*ready for next page footnotes*/
/*begin annotation*/
		for (i=0;i<portions->list_anno_no;i++)
			{
			decode_footanno(&begin,&len,portions,i);

			init_chp(&achp);
            decode_s_chp(&achp);

			if ((begin != -1) && (len != -1))
				{
				if (annotationflag == 0)
					{
					printf("\n<hr width=\"25%%\">\n");
					annotationflag=1;
					}
				error(stderr,"beginning annotation\n");
				/*test*/
                printf("<font color=#ff7777>");
                inafont=1;
                inacolor=1;
                strcpy(incolor,"#ff7777");
                /*end test*/

				if (!insuper)
					printf("<sup>");
				printf("<a name=\"anno%d\">",i);
				printf("anno%d",i);
				printf("</a>");
				if (!insuper)
					printf("</sup>");

				oldmainpos = ftell(main);
				oldtablepos = ftell(in);
				header++;

				k=0;
				while (k< nopieces)
					{
					if (portions->ccpText+portions->ccpFtn + portions->ccpHdd+begin < rgfc[k]) 
						{
						error(stderr,"piece for footer is %d (%x) (%x)\n",k-1,rgfc[k-1],portions->ccpText+portions->ccpFtn + portions->ccpHdd+begin);
						break;
						}
					k++;
					}
				tempcp=cp;
				cp=begin;
				error(stderr,"the difference is %d\n",(portions->ccpText+portions->ccpFtn + portions->ccpHdd+begin)-rgfc[k-1]);
				cp = cp-((portions->ccpText+portions->ccpFtn + portions->ccpHdd+begin)-rgfc[k-1]);
				error(stderr,"footer len is %d\n",len);
				error(stderr,"footer cp is %x\n",cp);
				tempfields = all_fields[0];
				all_fields[0] = all_fields[3];
				decode_clx(k-1,begin,begin+len,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,3);
				all_fields[0] = tempfields;
				cp=tempcp;
				fseek(in,oldtablepos,SEEK_SET);
				fseek(main,oldmainpos,SEEK_SET);
				header--;
				}
			}
		portions->list_anno_no=0; /*ready for next page footnotes*/
/*end annotation*/		
		decode_footer(&begin,&len,portions,asep);
		if ((begin != -1) && (len != -1))
			{
			init_chp(&achp);
            decode_s_chp(&achp);

			header++;
			error(stderr,"doing footer\n");

			oldmainpos = ftell(main);
			oldtablepos = ftell(in);
			error(stderr,"decoding footer clx 1\n");
			error(stderr,"the cp of begin of the header is probably cps (%x) to (%x)", portions->ccpText,portions->ccpText+portions->ccpFtn+portions->ccpHdd);
			k=0;
			while (k< nopieces)
				{
				if (portions->ccpText+portions->ccpFtn+begin < rgfc[k]) 
					{
					error(stderr,"piece for this footer is %d (%x) (%x)\n",k-1,rgfc[k-1],portions->ccpText+portions->ccpFtn+begin);
					break;
					}
				k++;
				}
			tempcp=cp;
			cp=begin;
			error(stderr,"the difference is %d\n",(portions->ccpText+portions->ccpFtn+begin)-rgfc[k-1]);
			cp = cp-((portions->ccpText+portions->ccpFtn+begin)-rgfc[k-1]);
			error(stderr,"footer len is %d\n",len);
			error(stderr,"footer cp is %x\n",cp);
			tempfields = all_fields[0];
			all_fields[0] = all_fields[1];
			inaheaderfooter=1;
			decode_clx(k-1,begin,begin+len,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,1);
			inaheaderfooter=0;
			all_fields[0] = tempfields;
			cp = tempcp;
			realcp = tempcp;
			fseek(in,oldtablepos,SEEK_SET);
			fseek(main,oldmainpos,SEEK_SET);
			header--;
			}
		error(stderr,"ending footer\n");
		printf("\n<hr>\n");
		pagenumber++;
		sectionpagenumber++;
		init_chp(&achp);
        decode_s_chp(&achp);
		}
	}

void decode_clx_header(U32 *rgfc,sep *asep,int nopieces,U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headerfooterflag)
	{
	U32 oldtablepos;
	U32 oldmainpos;
	U32 tempcp;
	U32 begin=0;
	U32 len=0;
	int k;
	field_info *tempfields;

	if (noheaders)
		return;

	if (header == 0)
		{
		decode_header(&begin,&len,portions,asep);
		if ((begin != -1) && (len != -1))
			{
			header++;
			oldmainpos = ftell(main);
			oldtablepos = ftell(in);
			error(stderr,"decoding header\n");
			error(stderr,"the cp of begin of the header is probably cps (%x) to (%x)", portions->ccpText+portions->ccpFtn+begin,portions->ccpText+portions->ccpFtn+begin+len);
			k=0;
			while (k< nopieces)
				{
				if (portions->ccpText+portions->ccpFtn+begin < rgfc[k]) 
					{
					error(stderr,"piece for header is %d (%x) (%x)\n",k-1,rgfc[k-1],portions->ccpText+portions->ccpFtn+begin);
					break;
					}
				k++;
				}
			tempcp=cp;
			cp=begin;
			/*cp = cp+(portions->ccpText+portions->ccpFtn+begin)-rgfc[k-1];*/
			cp = rgfc[k-1];
			error(stderr,"header cp is %x\n",cp);
			tempfields = all_fields[0];
			all_fields[0] = all_fields[1];
			/*begin+=cp;*/
			begin = portions->ccpText+portions->ccpFtn+begin;
			inaheaderfooter=1;
			decode_clx(k-1,begin,begin+len,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,1);
			inaheaderfooter=0;
			all_fields[0] = tempfields;
			cp = tempcp;
			fseek(in,oldtablepos,SEEK_SET);
			fseek(main,oldmainpos,SEEK_SET);
			header--;
			}
		}
	}

void init_chp(chp * achp)
	{
	achp->fBold=0;
	achp->fItalic=0;
	achp->ascii_font=0;
	achp->eastfont=0;
	achp->noneastfont=0;
	achp->fontsize=NORMAL;
	achp->supersubscript=0;
	achp->fontcode=0;
	achp->fontspec=0;
	achp->fSpec=0;
	achp->fObj=0;
	achp->color=NULL;
	achp->underline=0;
	}


int find_piece_cp(U32 sepcp,U32  *rgfc,int nopieces)
	{
	int i;
	error(stderr,"find_piece_cp-> %x,\n",sepcp);
	for (i=0;i<nopieces;i++)
		{
		if (sepcp <= rgfc[i])
			{
			error(stderr,"sep piece is %d cp is %x, other is %x\n",i,sepcp,rgfc[i]);
			return(i);
			}
		}
	return(-1);
	}

void decode_clx(U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[4],list_info *a_list_info,style * sheet,textportions *portions, ffn *fontnamelist,int headerfooterflag)
	{
	int paraendpiece;
	int paraendpiece2;
	int seppiece;
	int index=0;
	pap *apap=NULL;
	pap *tappap=NULL;
	pap *temppap=NULL;
	chp *achp=NULL;
	pap fakepap;
	chp fakechp;
	sep fakesep;
	long pos = ftell(in);
	long mainpos = ftell(main);
	int i;
	int k;
	U32 tapfc1=0;
	U32 tapfc2=0;
	
	U8 clxt;
	U16 cb;
	U16 *sprm=NULL;
	
	int j=0;
	int nopieces=0;
	U32 *rgfc=NULL;
	U32 *avalrgfc=NULL;
	int letter;
	int hack=0;
	U32 nextfc;
	U32 chpnextfc;
	U32 clxcount=0;
	Sprm asprmlist;
	Sprm *psprmlist=&asprmlist;
	U32 lastfc=0;
	U32 lastchpfc=0;
	static metadone=0;

	U32 sepxfc;
	U32 sepcp;
	sep *asep=NULL;

	int newpage=1;

	int notfinished=1;
	int fccount;

	int d_count=0;

	int issection=1;

	fseek(in,fcClx,SEEK_SET);
	error(stderr,"seeking table to (%x) len %d\n",fcClx,lcbClx);
	error(stderr,"begincp is %x\n",begincp);
	while ((clxcount < lcbClx) && (notfinished))
		{
		clxt = getc(in);
		clxcount++;
		error(stderr,"clxt is %d\n",clxt);

		psprmlist->list=NULL;
		psprmlist->next=NULL;
		psprmlist->len=0;

		if (clxt == 1)
			{
			/*make a list of of these gprrls*/
			/*decode them when fetched in clxt==2*/
			/*use bitfields to skip ones i dont care about*/
			error(stderr,"contains  grpprl\n");
			cb = read_16ubit(in);
			error(stderr,"cb is %d\n",cb);
			psprmlist->list = (U8 *) malloc(cb);
			if (psprmlist->list == NULL)
				{
				fprintf(stderr,"mem barfoid\n");
				exit(-1);
				}

			clxcount+=(cb+2);
			psprmlist->len=cb;
			for(i=0;i<cb;i++)
				psprmlist->list[i] = getc(in);
			psprmlist->next = (Sprm *) malloc(sizeof(Sprm));
			if (psprmlist->next == NULL)
				{
				fprintf(stderr,"mem barfoid\n");
				exit(-1);
				}
			psprmlist = psprmlist->next;
			index++;
			error(stderr,"on gp no %d\n",index);
			}
		else if (clxt == 2)
			{
			index =0;
			error(stderr,"contains  Plcfpcd\n");
			
			nopieces = get_piecetable(in,&rgfc,&avalrgfc,&sprm,&clxcount);


			/*guess based on first piece whether to go utf 8 or not*/
			/*
			actually doing utf8 all the time on complex docs as it
			turns out not to be such a good test :-(
			*/

			if ( (header == 0) && (metadone == 0) )
				{
				printf("\n<head>\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;charset=utf-8\">\n</head>\n");
				printf("<body>\n");
				metadone=1;
				}

			for(i=startpiece/*start piece*/;i<nopieces;i++)
				{

				if ((header == 0) && (metadone ==0))
					{
					printf("<body>\n");
					metadone=1;
					}

				if (notfinished == 0)
					break;

				/*get the sep*/
				if (headerfooterflag == 0)
					if (issection)
						{
						error(stderr,"getting sep, %x, piece is %d\n",cp,i);
						sepxfc = find_FC_sepx(cp,&sepcp,portions);
						asep = get_sep(sepxfc,main);
						seppiece = find_piece_cp(sepcp,rgfc,nopieces);
						init_chp(&fakechp);
						decode_gpprls(&fakepap,&fakechp,asep,sprm,seppiece,&asprmlist,sheet);
						issection=0;
						}

				if (newpage)
					{
					newpage =0;
					decode_clx_header(rgfc,asep,nopieces,startpiece,begincp,endcp,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,headerfooterflag);
					}			


				/*push this val back as its something else*/
				if (avalrgfc[i] & 0x40000000UL)
					{
					avalrgfc[i] = avalrgfc[i] & 0xbfffffffUL;
					avalrgfc[i] = avalrgfc[i]/2;
					error(stderr,"tricky ? seek val (%x)\n",avalrgfc[i]);
					error(stderr,"seeking main to (the FC %x) for len %d\n",avalrgfc[i],rgfc[i+1]-rgfc[i]);
					hack=1;
					}
				else
					{
					error(stderr,"seeking main to (the FC %x) for len %d piece %d\n",avalrgfc[i],rgfc[i+1]-rgfc[i],i);
					hack=0;
					}

				/*these ms guys often have a few offsets in the file that are *past* the end of the file, until
				i figure then out entirely ive stuck this in, which will sort them out for now*/
				if ((mainend < avalrgfc[i]) || (0 != fseek(main,avalrgfc[i],SEEK_SET)))
					{
					error(stderr,"overran the end of the file !!\n");
					continue;
					}

				error(stderr,"piece entry fc is %x sprm is %x len is %d\n",avalrgfc[i],sprm[i],rgfc[i+1]-rgfc[i]);

				temppap = apap;
				apap = NULL;
				error(stderr,"getting 1 pap nopieces is %d, current piece is %d\n",nopieces,i);
				apap = get_complex_pap(avalrgfc[i],plcfbtePapx,i,nopieces,intervals,rgfc,main,avalrgfc,&nextfc,NULL,&paraendpiece,sheet,a_list_info);
				error(stderr," the next para is at (%x)\n",nextfc);
				if (apap == NULL)
					{
					error(stderr,"we failed in out attempt to get a paragraph\n");
					if (temppap == NULL)
						{
						apap = (pap *) malloc(sizeof(pap));
						if (apap == NULL)
							{
							fprintf(stderr,"no mem aieee\n");
							exit(-1);
							}
						apap->istd = 0;
						apap->fInTable = 0;
						apap->fTtp= 0;
						apap->ilvl = -1;
						apap->ilfo = -1; /*index into hpllfo*/
						apap->tableflag=0;
						apap->list_data=NULL;
						}
					else
						{
						error(stderr,"using previous pap\n");
						apap = temppap;
						temppap = NULL;
						}
					}
				else
					{
					if (temppap != NULL)
						free(temppap);
					temppap = NULL;

					/*begin tappap search*/
					/*if we're in a table search for the one with fTtp*/
				
					decode_gpprls(apap,&fakechp,&fakesep,sprm,paraendpiece,&asprmlist,sheet);

					if (apap->fInTable)
						{
						k = i;
						do
							{
							tapfc1 = avalrgfc[k];
							error(stderr,"1. we search for the tap here\n");
							error(stderr,"tappap nexts are %x, k is %x\n",tapfc1,k);
							do
								{
								tapfc2 = tapfc1;
								tappap = get_complex_pap(tapfc1,plcfbtePapx,k,nopieces,intervals,rgfc,main,avalrgfc,&tapfc1,NULL,&paraendpiece2,sheet,a_list_info);
								if (tappap != NULL)
									decode_gpprls(tappap,&fakechp,&fakesep,sprm,paraendpiece2,&asprmlist,sheet);
								}
							while( (tappap != NULL) && (!tappap->fTtp)  && (tapfc1 != tapfc2)) ;
							k++;
							}
						while ( (tappap != NULL) && (!tappap->fTtp)  && (k<nopieces) );
						/*
						at this stage tappap has the correct row structure stored in it
						that we want apap to have
						*/
						if (tappap != NULL)
							{
							apap->ourtap = tappap->ourtap;
							error(stderr,"finished search for the tap here\n");
							error(stderr,"no of cells is %d, %d\n",apap->ourtap.cell_no,tappap->ourtap.cell_no);
							}
						}
					/*end tappap search*/
					
					}
				
				error(stderr,"AT THIS POINT %d\n",apap->istd);
				
				achp = get_complex_chp(avalrgfc[i],plcfbteChpx,i,nopieces,chpintervals,rgfc,main,avalrgfc,&chpnextfc,sheet,apap->istd);
				error(stderr," CHP: the next para is at (%x)\n",chpnextfc);
				if (achp == NULL)
					{
					error(stderr,"we failed in out attempt to get a chp\n");
					achp = (chp *) malloc(sizeof(chp));
					if (achp == NULL)
						{
						fprintf(stderr,"no mem aieee\n");
						exit(-1);
						}
					init_chp(achp);

					}

				if (headerfooterflag == 1)
					achp->color="#7f5555";
				else if (headerfooterflag == 2)
					achp->color="#330099";
				else if (headerfooterflag == 3)
					achp->color="#ff7777";
				else
					achp->color=NULL;

				/*
				the gpprl that id added is the one that belongs to the 
				piece that has the paragraph mark
				*/
				
				error(stderr,"decoding gpprl with (%x) index %d\n",sprm[paraendpiece],paraendpiece);
				fakepap.istd = apap->istd;
				decode_gpprls(&fakepap,achp,&fakesep,sprm,paraendpiece,&asprmlist,sheet);
				error(stderr,"1) ilfo is %d\n",apap->ilfo);
				decode_e_list(apap,achp,a_list_info);
				decode_e_chp(achp);
				decode_e_specials(apap,achp,a_list_info);
				decode_e_table(apap,achp,a_list_info);
				decode_s_table(apap,achp,a_list_info);
				decode_s_specials(apap,achp,a_list_info);
				decode_s_chp(achp);

				error(stderr,"2) ilfo is %d\n",apap->ilfo);
				j=0;

				/*this are the count of elements (can be both 8 and 16 bit)*/

				fccount=avalrgfc[i]-1;
				error(stderr,"fcount is %x pos is %x\n",fccount,ftell(main));
				/*this is the actual file position, always in bytes*/
				while(j<rgfc[i+1]-rgfc[i])
					{
					/*get the sep*/
					if (headerfooterflag == 0)
						if (issection)
							{
							error(stderr,"getting sep, %x, piece is %d\n",cp,i);
							sepxfc = find_FC_sepx(cp,&sepcp,portions);
							asep = get_sep(sepxfc,main);
							seppiece = find_piece_cp(sepcp,rgfc,nopieces);
							decode_gpprls(&fakepap,&fakechp,asep,sprm,seppiece,&asprmlist,sheet);
							issection=0;
							}
					
					if (newpage)
						{
						if (header == 0)
							{
							newpage =0;
							decode_clx_header(rgfc,asep,nopieces,startpiece,begincp,endcp,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,headerfooterflag);
							}
						}			

					if (!hack)
						{
						letter = read_16ubit(main);
						fccount+=2;	
						}
					else
						{
						letter = getc(main);
						fccount++;
						}

					if (j==0) 
						{
						if ( (letter != 12) && (letter!=13) )
							{
							decode_s_list(apap,achp,a_list_info,fontnamelist,DONTIGNORENUM);
							error(stderr,"finished list hwew letter was %d %x\n",letter,letter);
							}
						else
							{
							error(stderr,"finished list hwew letter was %d %x\n",letter,letter);
							}
						}


					if (fccount >= nextfc)
						{
						lastfc = nextfc;
						error(stderr,"the fc is (%x) and the first fc after end of para is (%x)",fccount,nextfc);
						error(stderr,"so im looking for the pap again\n");
						if (apap != NULL)
							{
							temppap = apap;
							apap = NULL;
							}
						error(stderr,"getting 2 pap\n");
						apap = get_complex_pap(fccount,plcfbtePapx,i,nopieces,intervals,rgfc,main,avalrgfc,&nextfc,NULL,&paraendpiece,sheet,a_list_info);
						error(stderr,"the nextfc for pap one is at %x\n",nextfc);

						if (apap == NULL)
							{
							if (temppap != NULL)
								{
								error(stderr,"we failed in out attempt to get a paragraph\n");
								if (temppap == NULL)
									{
									apap = (pap *) malloc(sizeof(pap));
									if (apap == NULL)
										{
										fprintf(stderr,"no mem aieee\n");
										exit(-1);
										}
									apap->istd = 0;
									apap->fInTable = 0;
									apap->fTtp= 0;
									apap->ilvl = -1;
									apap->tableflag=0;
									apap->ilfo = -1; /*index into hpllfo*/
									apap->list_data=NULL;
									}
								else
									{
									error(stderr,"using previous pap\n");
									apap = temppap;
									temppap = NULL;
									}
								}
							}
						else
							{
							/*begin tappap search*/
							/*if we're in a table search for the one with fTtp*/
							decode_gpprls(apap,&fakechp,&fakesep,sprm,paraendpiece,&asprmlist,sheet);
							if (apap->fInTable)
								{
								k = i;
								do
									{
									if (k==i)
										tapfc1 = fccount;
									else
										tapfc1 = avalrgfc[k];
									error(stderr,"2. we search for the tap here\n");
									error(stderr,"tappap nexts are %x, k is %x\n",tapfc1,k);
									do
										{
										tapfc2 = tapfc1;
										tappap = get_complex_pap(tapfc1,plcfbtePapx,k,nopieces,intervals,rgfc,main,avalrgfc,&tapfc1,NULL,&paraendpiece2,sheet,a_list_info);
										if (tappap != NULL)
											decode_gpprls(tappap,&fakechp,&fakesep,sprm,paraendpiece2,&asprmlist,sheet);
										}
									while( (tappap != NULL) && (!tappap->fTtp) && (tapfc1 != tapfc2)) ;
									k++;
									}
								while ( (tappap != NULL) && (!tappap->fTtp) && (k<nopieces) );
								/*
								at this stage tappap has the correct row structure stored in it
								that we want apap to have
								*/
								if (tappap != NULL)
									{
									apap->ourtap = tappap->ourtap;
									error(stderr,"finished 2nd search for the tap here\n");
									error(stderr,"no of cells is %d, %d\n",apap->ourtap.cell_no,tappap->ourtap.cell_no);
									}
								}
							/*end tappap search*/

							/*remove unneeded pap*/
							if (temppap != NULL)
								free(temppap);
							temppap = NULL;
							}

						}


					if ((fccount >= chpnextfc)  || (fccount >= lastfc))
						{
						lastchpfc=1;
						achp = get_complex_chp(fccount,plcfbteChpx,i,nopieces,chpintervals,rgfc,main,avalrgfc,&chpnextfc,sheet,apap->istd);
						error(stderr," CHP: the next para is at (%x)\n",chpnextfc);

						if (achp == NULL)
							error(stderr,"we failed in out attempt to get a chp\n");
						else
							{
							if (headerfooterflag == 1)
								achp->color="#7f5555";
							else if (headerfooterflag == 2)
								achp->color="#330099";
							else if (headerfooterflag == 3)
								achp->color="#ff7777";
							else
								achp->color=NULL;
							error(stderr,"before gprl chp fontcode is %d\n",achp->fontcode);
							decode_gpprls(&fakepap,achp,&fakesep,sprm,paraendpiece,&asprmlist,sheet);
							error(stderr,"after gprl chp fontcode is %d\n",achp->fontcode);
							decode_e_list(apap,achp,a_list_info);
							decode_e_chp(achp);
							error(stderr,"after decode chp fontcode is %d\n",achp->fontcode);
							}
						}

					if (fccount >= lastfc) 
						{
						decode_e_specials(apap,achp,a_list_info);
						decode_e_table(apap,achp,a_list_info);
						decode_s_table(apap,achp,a_list_info);
						decode_s_specials(apap,achp,a_list_info);
						decode_s_chp(achp);
						lastfc=-1;
						}

					if (lastchpfc) 
						{
						lastchpfc=-1;
						decode_s_chp(achp);
						if ( ((letter != 12) && (letter != 13)) )
							{
							decode_s_list(apap,achp,a_list_info,fontnamelist,DONTIGNORENUM);
							error(stderr,"list started following letter is %d\n",letter);
							}
						else 
							{
							error(stderr,"list started following letter is %d\n",letter);
							}
						}


					if (cp >= begincp)
						{
						if ((headerfooterflag >0) && (headerfooterflag < 2))
							{
							if (letter == 13)
								{
								/*
								headers and footers seem to continue until 2 0x0d are reached, they dont
								appear after all to go until the len derived from the header table
								like i thought originally.
								*/
								d_count++;
								if (d_count == 2)
									{
									notfinished=0;
									break;
									}
								}
							else
								d_count=0;
							}
						
						error(stderr,"decoding letter: fc is %x, nextfc is %x\n",fccount,nextfc);
						if (hack)
							newpage = decode_letter(letter,1,apap,achp,all_fields[0],main,fontnamelist,a_list_info,portions,&issection);
						else
							newpage = decode_letter(letter,1,apap,achp,all_fields[0],main,fontnamelist,a_list_info,portions,&issection);

						error(stderr,"W:sync, actuallt at %x, fccount is %x and aval is %xthough\n",ftell(main),fccount,fccount);
						}
					else
						{
						realcp++;
						cp++;
						}


					/*if newpage then decode header*/
					if (newpage)
						{
						error(stderr,"clx footer\n");
						decode_clx_footer(rgfc,asep,nopieces,startpiece,begincp,endcp,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,headerfooterflag);
						}


					/*get the sep*/
					if (headerfooterflag == 0)
						if (issection)
							{
							error(stderr,"getting sep, %x\n",cp);
							sepxfc = find_FC_sepx(cp,&sepcp,portions);
							asep = get_sep(sepxfc,main);
							seppiece = find_piece_cp(sepcp,rgfc,nopieces);
							decode_gpprls(&fakepap,&fakechp,asep,sprm,seppiece,&asprmlist,sheet);
							issection=0;
							}

					if (cp >= endcp)
						{
						error(stderr,"reached end of header or main\n");
						if ((headerfooterflag < 1) && (headerfooterflag < 2))
							{
							notfinished=0;
							break;
							}
						/*else well trust to the doubling of 0x0d to determine the end of the footer/header*/
						}

					j++;
					}/*end for/while j*/
					
				error(stderr,"here after header ?\n");

				if (achp != NULL)
					{
					free(achp);
					achp = NULL;
					}
				}
			}
		else
			fprintf(stderr,"some kind of error occured, byte count off\n");
		}


	if (apap == NULL)
		{
		apap = (pap *)malloc(sizeof(pap));
		if (apap == NULL)
			return;
		}
	
	apap->istd = 0;
	apap->ilvl=-1;
	apap->tableflag=0;
	decode_e_list(apap,achp,a_list_info);
	decode_e_specials(apap,achp,a_list_info);
	decode_e_table(apap,achp,a_list_info);
	if (apap !=NULL)
		{
		free(apap);
		apap=NULL;
		}
	if (achp !=NULL)
		{
		free(achp);
		achp=NULL;
		}

	if (!newpage)
		{
		error(stderr,"clx footer 2\n");
		decode_clx_footer(rgfc,asep,nopieces,startpiece,begincp,endcp,in,main,fcClx,lcbClx,intervals,chpintervals,plcfbtePapx,plcfbteChpx,all_fields,a_list_info,sheet,portions,fontnamelist,headerfooterflag);
		}

	if (rgfc != NULL)
		free(rgfc);
	if (avalrgfc != NULL)
		free(avalrgfc);
	if (sprm != NULL)
		free(sprm);

	fseek(in,pos,SEEK_SET);
	fseek(main,mainpos,SEEK_SET);
	}


chp *get_chp(U32 pageindex,FILE *in, U32 charindex, U32 *nextfc,style *sheet,U16 istd)
	{
	long pos = ftell(in);
	U16 i;
	U16 l;
	U16 offset;

	U8 cb;
	U16 clist=0;

	chp *retchp;

	error(stderr,"\nlooking for CHP in page %d given istd %d\n",pageindex,istd);
	/*this no refers to 512*pageindex ?*/
	error(stderr,"\n%x\n",(512*pageindex));


	*nextfc = find_next_smallest_fc(charindex,pageindex,in,&i,NULL);
	error(stderr,"next char lim is %d (%x)\n",*nextfc,*nextfc);

	retchp = (chp *) malloc(sizeof(chp));
	
	if (retchp == NULL)
		{
		fprintf(stderr,"no mem available\n");
		exit(-1);
		}

	error(stderr,"the istd of this chp is %d\n",istd);
	retchp->fBold=sheet[istd].thechp.fBold;
	error(stderr,"based on bold is %d\n",retchp->fBold);
	retchp->fItalic=sheet[istd].thechp.fItalic;
	error(stderr,"based on italic is %d\n",retchp->fItalic);
	retchp->ascii_font=sheet[istd].thechp.ascii_font;
	retchp->eastfont=sheet[istd].thechp.eastfont;
	retchp->noneastfont=sheet[istd].thechp.noneastfont;
	retchp->fontsize=sheet[istd].thechp.fontsize;
	error(stderr,"font set to styles size %d\n",sheet[istd].thechp.fontsize);
	retchp->supersubscript=sheet[istd].thechp.supersubscript;
	retchp->fontcode=sheet[istd].thechp.fontcode;
	retchp->fontspec=sheet[istd].thechp.fontspec;
	retchp->color=sheet[istd].thechp.color;
	retchp->underline=sheet[istd].thechp.underline;
	retchp->fSpec=sheet[istd].thechp.fSpec;
	retchp->fObj=sheet[istd].thechp.fObj;

	/*leap ahead to the BX we want*/
	fseek(in,i,SEEK_CUR);

	/*the first byte is the one we want*/
	offset = getc(in);
	error(stderr,"CHP: chpx offset is %ld %x, going to %x\n",offset,offset,(512*(pageindex))+offset*2);
	if (offset == 0)
		{
		error(stderr,"CHP: special chpx offset leaving now\n");
		fseek(in,pos,SEEK_SET);
		error(stderr,"at this end bold is %d\n",retchp->fBold);
		return(retchp);
		}
	
	/*this section is fucked up, why does it appear that i have to use twice
	the offset i get out of this value ?*/
	fseek(in,(512*(pageindex))+offset*2,SEEK_SET);
	cb = getc(in);
	error(stderr,"CHP: cb was %d\n",cb);


	if (cb != 0)
		{
		l=0;
		while(l<cb)
			{
			clist = read_16ubit(in);
			l+=2;
			error(stderr,"decoding sprm %X\n",clist);
			decode_sprm(in,clist,NULL,retchp,NULL,&l,NULL,sheet,istd);
			}
		}

	fseek(in,pos,SEEK_SET);
	error(stderr,"at end bold is %d\n",retchp->fBold);
	return(retchp);
	}
		
int decode_ilfo(pap *retpap,list_info *a_list_info)
	{
	int j;
	
	/*
	else now we use our a_list_data to generate the paps list_data
	including the text to use, whether to prepend a index or not
	what format the index is in, and the start index
	*/
	/*
	first get the text, ) / . / string / whatever
	*/
	error(stderr,"ilfo %d of %d\n",retpap->ilfo,a_list_info->nooflfos);
	if (retpap->ilfo >= a_list_info->nooflfos)
		{
		if (retpap->ilfo != 2047)
			{
			error(stderr,"hmm problem\n");
			return(-1);
			}
		else
			error(stderr,"legacy anld\n");
		return(-1);
		}

	/*
	what should happen here, is after we get this base list data, 
	we add the overrides to a copy of our own
	*/

	retpap->list_data = &(a_list_info->o_list_def[retpap->ilfo]);
	
	retpap->list_data->id = a_list_info->lst_ids[retpap->ilfo];
	for (j=0;j<retpap->list_data->len;j++)
	            error(stderr,"--> %c",retpap->list_data->list_string[j]);


	error(stderr,"ilfo request is %d, the id in the lfo is %x",retpap->ilfo,a_list_info->lst_ids[retpap->ilfo]);
	j=0;
	while(j<a_list_info->nooflsts)
		{
		if (a_list_info->o_lst_ids[j] == retpap->list_data->id)
			{
			error(stderr,"and the returned index is %d\n",j);
			return(j);
			}
		j++;
		}

	return(0);
	}


sep *get_sep(U32 offset,FILE *in)
	{
	sep *asep;
	U16 clist;
	U16 cb,l;
	long pos=ftell(in);

	asep = (sep *) malloc(sizeof(sep));
	if (asep == NULL)
		{
		error(stderr,"arse\n");
		exit(-1);
		}


	asep->bkc=2;
	asep->fEndNote=1;
	asep->pgnStart=1;
	asep->fTitlePage=0;
	asep->lnc=0;
	asep->nLnnMod=0;
	asep->ccolM1=0;
	asep->restart=0;
	asep->nfcPgn=0;

	fseek(in,offset,SEEK_SET);
	error(stderr,"sepx at %x",offset);
	cb = read_16ubit(in);
	error(stderr,"no of bytes is %d",cb);

	if (cb != 0)
		{
		l=0;
		while(l<cb)
			{
			clist = read_16ubit(in);
			l+=2;
			error(stderr,"decoding sprm %X\n",clist);
			decode_sprm(in,clist,NULL,NULL,asep,&l,NULL,NULL,0);
			}
		}
	
	fseek(in,pos,SEEK_SET);

	if(asep->restart)
		{
		sectionpagenumber=asep->pgnStart;
		/*pagenumber = asep->pgnStart;*/
		}

	currentsep = asep;

	return(asep);
	}

pap *get_pap(U32 pageindex,FILE *in, U32 charindex, U32 *nextfc, style *sheet,list_info *a_list_info)
	{
	long pos = ftell(in);
	U8 k;
	U16 i;
	U8 BX[13];
	U16 offset;
	U16 len;

	U16 cw;
	U32 clist;

	pap *retpap;

	error(stderr,"\nlooking for PAP in page %d\n",pageindex);
	/*this no refers to 512*pageindex ?*/
	error(stderr,"\n%x\n",(512*pageindex));


	*nextfc = find_next_smallest_fc(charindex,pageindex,in,&i,NULL);

	retpap = (pap *) malloc(sizeof(pap));
	
	if (retpap == NULL)
		{
		fprintf(stderr,"no mem available\n");
		exit(-1);
		}

	/*leap ahead to the BX we want*/
	fseek(in,i*13,SEEK_CUR);
	error(stderr,"the pap offset is %x\n",ftell(in));

	/*pull out BX word offset*/
	for(k=0;k<13;k++)
		BX[k] = getc(in);
	/*the first byte is the one we want*/
	offset = BX[0];
	error(stderr,"papx offset is %ld %x, going to %x\n",offset,offset,(512*(pageindex))+offset*2);
	if (BX[0] == 0)
		error(stderr,"special papx offset ?\n");
	/*this section is fucked up, why does it appear that i have to use twice
	the offset i get out of this value ?*/
	fseek(in,(512*(pageindex))+offset*2,SEEK_SET);
	cw = getc(in);
	if (cw == 0)
		{
		error(stderr,"cw was pad %d\n",cw);
		cw = getc(in);
		error(stderr,"cw was %d\n",cw);
		cw=cw*2;
		error(stderr,"so bytes are %d\n",cw);
		}
	else
		cw=cw*2; /*when the pap is in a stsh then this is not done*/
		
	error(stderr,"cw bytes are %d\n",cw);

	len=0;
	retpap->fInTable = 0;
	retpap->fTtp= 0;
	retpap->ilvl = -1;
	retpap->ilfo = -1; /*index into hpllfo*/
	retpap->list_data=NULL;
	retpap->tableflag=0;
	retpap->istd = read_16ubit(in);
	len+=2;
	error(stderr,"istd index is %d\n",retpap->istd);
	/*
	take the istd and get the style from the decoded style list
	and shove in the starting values values from that
	*/
	retpap->fInTable  = sheet[retpap->istd].thepap.fInTable;
	retpap->fTtp = sheet[retpap->istd].thepap.fTtp;
	retpap->ilvl = sheet[retpap->istd].thepap.ilvl;
	retpap->ilfo = sheet[retpap->istd].thepap.ilfo;
	retpap->list_data = sheet[retpap->istd].thepap.list_data;
	retpap->ouranld = sheet[retpap->istd].thepap.ouranld;
	retpap->ourtap.cell_no = lastrowlen;
	retpap->ourtap.tablewidth = 0;
	for (i=0;i<lastrowlen+1;i++)
		{
		retpap->ourtap.cellwidth[i] = lastcellwidth[i];
		retpap->ourtap.tablewidth+=lastcellwidth[i];
		}

	error(stderr,"BEGIN, ilfo is %d",retpap->ilfo);
	while (len < cw)
		{
		clist = read_16ubit(in);
		len+=2;
		/*
		and *why* do i have to take this byte out to get what i want ?
		*/
		error(stderr,"clist %x \n",clist);
		decode_sprm(in,clist,retpap,NULL,NULL,&len,NULL,sheet,retpap->istd);
		}

	error(stderr,"END");

	fseek(in,pos,SEEK_SET);
	return(retpap);
	}

U32 find_FC_sepx(U32 cp,U32 *sepcp,textportions *portions)
	{
	int j=1;
	while (j<portions->section_nos+1)
		{
		error(stderr,"find_FKPno_sepx:-> %x, %x\n",cp,portions->section_cps[j]);
		if (cp < portions->section_cps[j])
			{
			error(stderr,"the sep cp is %x\n",portions->section_cps[j]-1);
			error(stderr,"the sep fc is %x\n",portions->section_fcs[j-1]);
			*sepcp = portions->section_cps[j]-1;
			return(portions->section_fcs[j-1]);
			break;
			}
		j++;
		}
	error(stderr,"no sep FC found\n");
	return(-1);
	}

int find_FKPno_papx(U32 fc,U32 *plcfbtePapx,U32 intervals)
	{
	int j=1;
	while (j<intervals+1)
		{
		error(stderr,"->page %d, fc is (%x) and plcfbtePapx[j] is %x\n",j,fc,plcfbtePapx[j]);
		if (fc < plcfbtePapx[j])
			{
			error(stderr,"it was less that it\n");
			error(stderr,"so the FKP thatll have the limits of this is %d\n",plcfbtePapx[j+intervals]);
			return(plcfbtePapx[j+intervals]);
			break;
			}
		j++;
		}
	error(stderr,"no FKP pap found\n");
	return(-1);
	}

int find_FKPno_chpx(U32 fc,U32 *plcfbteChpx,U32 chpintervals)
	{
	int j=1;
	while (j<chpintervals+1)
		{
		error(stderr,"->chp page %d, fc is (%x) and plcfbteChpx[j] is %x\n",j,fc,plcfbteChpx[j]);
		if (fc < plcfbteChpx[j])
			{
			error(stderr,"CHP: it was less that it\n");
			error(stderr,"CHP: so the FKP thatll have the limits of this is %d\n",plcfbteChpx[j+chpintervals]);
			return(plcfbteChpx[j+chpintervals]);
			break;
			}
		j++;
		}
	error(stderr,"CHP: no chp found\n");
	return(-1);
	}

U32 find_next_smallest_fc(U32 charindex,U32 pageindex, FILE *in, U16 *location,long *pos)
	{
	U8 crun,i;
	U32 *rgfc;
	U32 rval=-1;
	if (pos != NULL)
		*pos = ftell(in);

	if (pageindex != -1)
		{
		error(stderr,"smallest seek to %x\n",(512*pageindex)+511);
		if ((mainend < (512*pageindex)+511) || (0 != fseek(in,(512*pageindex)+511,SEEK_SET)))
			error(stderr,"ran too far forward on smallest seek 1 to %x, bloody semi corrupt file\n",(512*pageindex)+511);
		else
			{
			crun = getc(in);
			error(stderr,"there are %d paragraphs/char runs in this zone at %x",crun,(512*pageindex));
			rgfc = (U32 *) malloc(sizeof(U32)*(crun+1));
			if (rgfc== NULL)
				{
				fprintf(stderr,"no memory argh\n");
				exit(-1);
				}
			fseek(in,(512*pageindex),SEEK_SET);
			for(i=0;i<crun+1;i++)
				{
				rgfc[i] = read_32ubit(in);
				error(stderr,"(%X) ", rgfc[i]);
				}
			error(stderr,"\n");
			i=0;
			while (i<crun)
				{
				if (charindex <  rgfc[i+1])
					{
					error(stderr,"looking for BX %ld, charindex is %ld (%x),  rgfc is %ld (%x),\n",i,charindex,charindex, rgfc[i+1],rgfc[i+1]);
					*location = i;
					rval = rgfc[i+1];
					break;
					}
				i++;		
				}

			free(rgfc);
			}
		}
	if (pos != NULL)
		{
		fseek(in,*pos,SEEK_SET);
		error(stderr,"papx: reset stream\n");
		}
	return(rval); 
	}


chp * get_complex_chp(U32 fc,U32 *plcfbteChpx,U16 i,U16 nopieces,U32 chpintervals,U32 *rgfc,FILE *main,U32 *avalrgfc,U32 *thenextone,style *sheet,U16 istd)
	{
	chp *achp=NULL;
	int tempfck;
	U16 location;
	long passposition;
	U32 nextfc=0;
	U32 tempfc;

	/*we have the chp's fc*/

	/*
	Using the FC, search the FCs FKP for the largest FC less 
	than the character's FC
	*/

	/*finding the correct FKP for this fc*/
	/*
	The CHPX FKP stored in that page is fetched and then the rgfc in the 
	FKP is searched to locate the bounds of the run of
	exception text that encompasses the character.
	*/
	tempfck = find_FKPno_chpx(fc,plcfbteChpx,chpintervals);

	/*now attempt to find the end of the run of text*/
	if (tempfck != -1)
		{
		nextfc = find_next_smallest_fc(fc,tempfck,main,&location,&passposition);
		error(stderr,"CHP: in this FKP the next fc larger than (%x) is (%x)\n",fc,nextfc);
		error(stderr,"CHP: the end of this piece is (%x)\n",avalrgfc[i]+rgfc[i+1]-rgfc[i]);
		}

	/*
	The CHPX for that run is then located within the FKP,
	and the CHPX is applied to the contents of the local CHP
	*/
	achp = get_chp(tempfck,main,nextfc-1,&tempfc,sheet,istd);
	*thenextone = nextfc;
	return(achp);
	}


pap * get_complex_pap(U32 fc,U32 *plcfbtePapx,U16 i,U16 nopieces,U32 intervals,U32 *rgfc,FILE *main,U32 *avalrgfc,U32 *thenextone,U32 *theotherone,int *paraendpiece,style *sheet,list_info *a_list_info)
	{
	pap *apap=NULL;
	int tempfck;
	U16 location,j;
	long passposition;
	U32 fc2;
	U32 nextfc=0;
	U32 tempfc;
	

	*paraendpiece = i;

	error(stderr,"Searching for PAP, current piece is %d\n",i);
	/*
	if we are not at the beginning of a paragraph get the 
	bounds of this paragraph, using the end mark of the paragraph
	look for the char after it, and then look at fkp.rgbx[i - 1] 
	to get the PAPX (last non-fastsaved one), add the SPRMS 
	that would be got
	from the clxt == 1 stuff
	*/

	/*
	Using the FC, search the FCs FKP for the smalled FC greater
	than the character's FC
	*/

	/*finding the correct FKP for this fc*/
	tempfck = find_FKPno_papx(fc,plcfbtePapx,intervals);

	/*now attempt to find the end of the paragraph*/
	if (tempfck != -1)
		{
		nextfc = find_next_smallest_fc(fc,tempfck,main,&location,&passposition);
		error(stderr,"in this FKP the next fc larger than (%x) is (%x)\n",fc,nextfc);
		error(stderr,"the end of this piece is (%x)\n",avalrgfc[i+1]);
		}
	else
		{
		/*set it to original again*/
		nextfc = *thenextone;
		error(stderr,"dodgy nextfc\n");
		}

	if (theotherone != NULL)
		{
		error(stderr,"setting theotherone to %x\n",nextfc);
		*theotherone = nextfc;
		}

	/*get the end fc of the piece*/
	
	fc2 = avalrgfc[i];
    if (fc2 & 0x40000000UL)
		{
        fc2 = fc2 & 0xbfffffffUL;
        fc2 = fc2/2;
		fc2 += rgfc[i+1]-rgfc[i];
        }
	else
		fc2 +=2*(rgfc[i+1]-rgfc[i]);
		
	error(stderr,"fc2 is %x\n",fc2);


	if ( nextfc <= (fc2) )
		{
		error(stderr,"not doing para end search\n");
		error(stderr,"the end of the paragraph that describes this piece is at (%x)",nextfc-1);
		/*this means that if we grab the PAP of this char that we have got the pap for the piece*/
		*paraendpiece = i;
		if (tempfck != -1)
			apap = get_pap(tempfck,main,nextfc-1,&tempfc,sheet,a_list_info);
		/*in this case the paragraph ends on nextfc*/
		*thenextone=nextfc;
		}
	else if(nextfc == -1)
		{
		nextfc = fc;
		error(stderr,"BUGGING OUT\n");
		}
	else
		{
		error(stderr,"PAP: doing para end search\n");
		/*
		in this case the paragraph will have to be looked for again
		when this piece comes to an end ?
		*/
		*thenextone = fc2;

		/*
		we go through the pieces looking for one that has a 
		end of paragraph mark in it
		
		It's possible to check if a piece contains a paragraph
		mark by using the FC of the beginning of the piece to 
		search in the FKPs for the smallest FC in the FKP
		rgfc that is greater than the FC of the beginning of the piece
		*/
		for (j=i+1;j < nopieces;j++)
			{
			fc = avalrgfc[j];
			if (fc & 0x40000000UL)
					{
					fc = fc & 0xbfffffffUL;
					fc = fc/2;
					}
			error(stderr,"fc pulled out here is (%x) (%x) %d\n",fc,avalrgfc[j],j);
			tempfck = find_FKPno_papx(fc,plcfbtePapx,intervals);
			if (tempfck != -1)
				{
				nextfc = find_next_smallest_fc(fc,tempfck,main,&location,&passposition);
				error(stderr,"the next one is (%x)\n",nextfc);
				error(stderr,"less than aval is (%x),and end is (%x)",fc,fc+rgfc[j+1]-rgfc[j]);
				error(stderr,"avals are %x and %x\n",nextfc-1,fc+rgfc[j+1]-rgfc[j]);
			/*
				if ((nextfc <= (fc+rgfc[j+1]-rgfc[j])) || ((nextfc-1 >= fc+rgfc[j+1]-rgfc[j]) && (j==i+1)))
			*/
			/*
				if ((nextfc <= (fc+rgfc[j+1]-rgfc[j])) || ((nextfc-1 == fc+rgfc[j+1]-rgfc[j]) && (j==i+1)))
			*/
			/*
				if (nextfc <= (fc+rgfc[j+1]-rgfc[j])) 
			*/
			
				fc2 = avalrgfc[j];
				if (fc2 & 0x40000000UL)
					{
					fc2 = fc2 & 0xbfffffffUL;
					fc2 = fc2/2;
					fc2 +=rgfc[j+1]-rgfc[j];
					}
				else
					fc2 += 2*(rgfc[j+1]-rgfc[j]);
				error(stderr,"fc2 is %x\n",fc2);
			

				if (nextfc <= fc2 )
					{
					/*well this is the end then*/
					error(stderr,"the end of the paragraph that describes this piece is at (%x), after trying further",nextfc-1);
					*paraendpiece = j; 

					error(stderr,"the pieceend is %d\n",*paraendpiece);
					if (tempfck != -1)
						apap = get_pap(tempfck,main,nextfc-1,&tempfc,sheet,a_list_info);
					break;
					}
				else
					error(stderr,"next cycle nopieces is %d,j is %d\n",nopieces,j);
				}
			}
		}	

	/*	
	*thenextone = nextfc;
	*/
		
	if (apap != NULL)
		error(stderr,"PAP: istd is %ld\n",apap->istd);
	return(apap);
	}

void decode_list_nfc(int *value,int no_type)
	{
	char roman[81];
	switch(no_type)
		{
		case 0:
			printf("%d",(*value)++);
			break;
		case 1:	
			printf("%s",decimalToRoman((*value)++,roman));
			break;
		case 2:	
			printf("%s",ms_strlower(decimalToRoman((*value)++,roman)));
			break;
		case 3:
			printf("%c",64+(*value)++); /*uppercase letter*/
			break;
		case 4:
			printf("%c",96+(*value)++); /*lowercase letter*/
			break;
		default:
			break;
		}
	}

void decode_list_level(pap *apap,int inalist,int num)
	{
	int i;
	if (apap->ilvl+1 != 0)
		{
		error(stderr,"List stuff inalist is %d\n, ilvl+1 is %d\n",inalist,apap->ilvl+1);
		if (apap->ilvl+1 == inalist)
			{
			if (apap->ilvl+1 != 1)
				{
				printf("\n</DIR>\n");
				printf("\n<DIR>\n");
				}
			else
				{
				if (num == IGNOREALL)
					printf("\n</fake DIR>\n<fake DIR>\n");
				else
					printf("\n<!--</DIR>\n<DIR>-->\n");

				}
			}
		else
			{
			for(i=inalist;i<apap->ilvl+1;i++)
				{
				if (i==0)
					{
					if (num == IGNOREALL)
						printf("\nfake DIR>\n");
					else
						printf("\n<!--<DIR>-->\n");
					}
				else
					printf("\n<DIR>\n");
				}
			}
		}
	inalist = apap->ilvl+1;
	}

void decode_s_anld(pap *apap,chp *achp,list_info *a_list_info,ffn *fontnamelist)
	{
	int i;
	int issection;
	
	
	chp anldchp;

	error(stderr,"ilvl is %d\n",apap->ilvl);


	if ( ( (apap->ilvl+1) > inalist)  /*|| (tempid)*/ )
		{
		error(stderr,"ANLD: new one is %d",apap->ilvl+1);
		decode_list_level(apap,0,DONTIGNORENUM);

		/*if we are at a sub level i.e > 0, then */
		error(stderr,"the ilfo to use is %d\n",apap->ilfo);

		inalist=apap->ilvl+1;
		}
		/*
	else
		list_data = apap->list_data;
		*/

	if ( (apap->ilvl) != -1)
		{
		if ( (apap->ilfo > -1) && (newline))
			{
			printf("\n");

			anldchp = *achp;
			if (apap->ouranld.flags1&0x10)
				if (apap->ouranld.flags2&0x08)
					anldchp.fBold =1;
			if (apap->ouranld.flags1&0x20)
				if (apap->ouranld.flags2&0x10)
					anldchp.fItalic=1;
			if (apap->ouranld.flags2&0x02)
					anldchp.underline = apap->ouranld.flags3&0x07;
			anldchp.ascii_font = apap->ouranld.ftc;
			anldchp.eastfont = apap->ouranld.ftc;
			anldchp.noneastfont =apap->ouranld.ftc;
			anldchp.fontsize = apap->ouranld.hps;

			i=0;
			while(i<apap->ouranld.cxchTextBefore)
				{
				error(stderr,"list string-->%d %c\n",apap->ouranld.rgxch[i],apap->ouranld.rgxch[i]);
				if (apap->ouranld.rgxch[i] == '*')
					printf("<img src=\"%s/%d.gif\">",symbolfontdir(),151);
				else
					{
					decode_letter(apap->ouranld.rgxch[i],0,apap,&anldchp,NULL,NULL,fontnamelist,NULL,NULL,&issection);
					realcp--;
					cp--;
					}
				i++;
				}

			error(stderr,"numbering type is %d\n",apap->ouranld.nfc);
			/*
			decode_list_nfc(&(listvalue[apap->ilvl]),apap->ouranld.nfc);
			*/
			decode_list_nfc(&(a_list_info->current_index_nos[apap->ilfo][apap->ilvl]),apap->ouranld.nfc);

			i=apap->ouranld.cxchTextBefore;
			while(i<apap->ouranld.cxchTextAfter)
				{
				error(stderr,"list string-->%d %c\n",apap->ouranld.rgxch[i],apap->ouranld.rgxch[i]);
				if (apap->ouranld.rgxch[i] == '*')
					printf("<img src=\"%s/%d.gif\">",symbolfontdir(),151);
				else
					{
					decode_letter(apap->ouranld.rgxch[i],0,apap,NULL,NULL,NULL,fontnamelist,NULL,NULL,&issection);
					realcp--;
					cp--;
					}
				i++;
				}

			printf(" ");
			newline=0;
			}
		}
	}
/*
ok im going out on a limb here and see does this fit the realworld: heres the hack
sections titles have the section number prepended to them, now the 0x0c is use like
i would expect it to be, *only* that after this mark sections are also considered list 
elements with links to listdata which contain a mark for a number to be used, 
with my logic i get
<section no> <list number> <the rest of list data e.g. "."> Section Name
other logic gave
<list number> <the rest of list data e.g. "."> <section no> Section Name

what ms gives is

<section no> <the rest of list data e.g. "."> Section Name

so if i have a 0x0c 

CHOP CHOP CHOP, all wrong, talking out my bum, solution is in CHANGELOG for 
version 0.2.1, in fact the section break has NOTHING to do with it, its part
of a wierd mechanism with dummy list elements, im dead proud i figured it out.
*/


void decode_s_list(pap *apap,chp *achp,list_info *a_list_info,ffn *fontnamelist,int num)
	{
	/*
	U32 tempid=0;
	*/
	int i,j,k,p;
	int index;
	int fPrev;

	int issection;/*dummy*/
	
	list_def *list_data=NULL;
	list_def *flist_data=NULL;
	list_def *plist_data=NULL;

	error(stderr,"doing start list\n");

	if (apap->ilfo == 2047)
		{
		error(stderr,"special ilfo, doing an anld\n");
		decode_s_anld(apap,achp,a_list_info,fontnamelist);
		return;
		}
	
	if (apap->ilfo > -1) 
		{
		index = decode_ilfo(apap,a_list_info);
		if (index == -1)
			{
			error(stderr,"invalid ilfo index\n");
			return;
			}
/*
		if ((apap->list_data != NULL) && (apap->ilvl+1))
			{
			if (lastlistid != apap->list_data->id)
				tempid = 1;
			}
*/

		if ( ( (apap->ilvl+1) > inalist) )
			{
			error(stderr,"ILVL: incoming indent level %d new one is %d",inalist,apap->ilvl+1);

			if (num == IGNOREALL)
				printf("\n<!--tricky old ms, hidden list values here\n");

			decode_list_level(apap,inalist,num);

			/*if we are at a sub level i.e > 0, then */
			error(stderr,"the ilfo to use is %d\n",apap->ilfo);

			flist_data = apap->list_data;
			
			i=0;
			while ( (i<apap->ilvl) && (flist_data->sub_def_list != NULL) )
				{
				error(stderr,"1 indenting into structure\n");
				flist_data = flist_data->sub_def_list;
				i++;
				}
	
			if (a_list_info->current_index_nos[index][apap->ilvl]==-1)
				{
				/*new list, start again*/
				/*
				a_list_info->current_index_nos[index][apap->ilvl]=flist_data->begin_no;
				*/
				plist_data = flist_data;
				for (p=apap->ilvl;p<9;p++)
					{
					if (plist_data != NULL)
						{
						a_list_info->current_index_nos[index][p]=plist_data->begin_no;
						plist_data = plist_data->sub_def_list;
						}
					}
				}
			inalist=apap->ilvl+1;

			}
		else
			flist_data = apap->list_data;

		if ( (apap->ilvl) != -1)
			{
			error(stderr,"list stage 1\n");
			if ( (apap->ilfo > -1) && (newline))
				{
				error(stderr,"list stage 2\n");
				if (apap->list_data != NULL)
					{
					j=0;
					list_data = apap->list_data;
					fPrev = flist_data->fPrev;
					do
						{
						if (list_data->len > 0)
							{
							i=0;

							flushbreaks();
							printf("\n");

							if ( ((!fPrev) && (j == apap->ilvl)) || (fPrev) )
								{

								error(stderr,"list is %x\n",list_data->id);

		
								
								while ( i<list_data->len )
									{
									error(stderr,"list string-->%d %c\n",list_data->list_string[i],list_data->list_string[i]);
									if (list_data->list_string[i] <= 9)
										{
										flist_data = apap->list_data;
										k=0;
										while(k<list_data->list_string[i])	
											{
											flist_data = flist_data->sub_def_list;
											k++;
											}
										error(stderr,"numbering type is %d\n",flist_data->no_type);

										if (a_list_info->current_index_nos[index][k]==-1)
											{
											/*new list, start again*/
											plist_data = flist_data;
											for (p=k;p<9;p++)
												{
												if (plist_data != NULL)
													{
													a_list_info->current_index_nos[index][p]=plist_data->begin_no;
													plist_data = plist_data->sub_def_list;
													}
												}
										/*	
											a_list_info->current_index_nos[index][k]=flist_data->begin_no;
										*/
											
											}
										else if (k!=j)
											a_list_info->current_index_nos[index][k]--;
										decode_list_nfc(&(a_list_info->current_index_nos[index][k]),flist_data->no_type);
										
										plist_data = flist_data->sub_def_list;
										for (p=j+1;p<9;p++)
											{
											if (plist_data != NULL)
												{
												a_list_info->current_index_nos[index][p]=plist_data->begin_no;
												plist_data = plist_data->sub_def_list;
												}
											}
										
										}
									else if (list_data->list_string[i] == '*')
										printf("<img src=\"%s/%d.gif\">",symbolfontdir(),151);
									else
										{
										decode_letter(list_data->list_string[i],0,apap,&(list_data->achp),NULL,NULL,fontnamelist,NULL,NULL,&issection);
										realcp--;
										cp--;
										}
									i++;
									}
									
								printf(" ");
								newline=0;
								}
							}	
						list_data = list_data->sub_def_list;
						j++;
						}
					while ( (j<apap->ilvl+1)  && (list_data != NULL) );
					}
					
					
				}
			if (num == IGNOREALL)
				printf("\n-->\n");
			}
		}
	}


void decode_s_table(pap *apap,chp *achp,list_info *a_list_info)
	{
	int redotable=0,i;
	float width;
	int clearedspecials=0;
	chp reset;
	int resetchp=0;


	reset.fBold=0;
	reset.fItalic=0;
	reset.underline=0;
	reset.ascii_font=0;
	reset.eastfont=0;
	reset.noneastfont=0;
	reset.fontsize=NORMAL;
	reset.color = NULL;

	error(stderr,"decoding start specials istd is %d\n",apap->istd);

	if ((!(inatable)) && (apap->fInTable))
		{
		if (!clearedspecials)
			{
			/*decode_e_specials(&reset,achp,a_list_info);*/
			clearedspecials=1;
			}
		if (!resetchp)
			{
			decode_e_chp(&reset);
			resetchp=1;
			}
		flushbreaks();
		printf("\n<table border=1 width=\"100%%\">\n");
		error(stderr,"set table\n");
		/*search for tap*/
		inatable=1;
		inarow=0;
		inacell=0;
		lastrowlen=apap->ourtap.cell_no;
		error(stderr,"lastrowlen is %d\n",lastrowlen);
		for (i=0;i<apap->ourtap.cell_no+1;i++)
			{
			lastcellwidth[i] = apap->ourtap.cellwidth[i];
			error(stderr,"dx-->%d",lastcellwidth[i]);
			}
		}

	if ( ((inatable) && (apap->fInTable) && (!apap->fTtp)) || ((inatable) && (!inacell) && (inarow)) )
		{
		if (inarow == 0)
			{
			if (lastrowlen != apap->ourtap.cell_no)
				{
				error(stderr,"well have to start a new table\n");
				redotable=1;
				}
			else 
				{
				for (i=0;i<apap->ourtap.cell_no+1;i++)
					{
					if (lastcellwidth[i] != apap->ourtap.cellwidth[i])
						redotable=1;
					}
				}

			if (redotable)
				{
				if (!clearedspecials)
					{
					/*decode_e_specials(&reset,achp,a_list_info);*/
					clearedspecials=1;
					}
				if (!resetchp)
					{
					decode_e_chp(&reset);
					resetchp=1;
					}
				flushbreaks();
				printf("\n</table>\n");
				printf("\n<table border=1 width=\"100%%\">\n");
				error(stderr,"redone table\n");
				inatable=1;
				inarow=1;
				inacell=0;
				lastrowlen=apap->ourtap.cell_no;
				for (i=0;i<apap->ourtap.cell_no+1;i++)
					lastcellwidth[i] = apap->ourtap.cellwidth[i];

				}

			if (!clearedspecials)
				{
				/*decode_e_specials(&reset,achp,a_list_info);*/
				clearedspecials=1;
				}
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("\n<tr>\n");
			rowcount=0;
			inarow = 1;
			}
			
		if ( (inacell == 0) && (rowcount < apap->ourtap.cell_no) )
			{
			width = (apap->ourtap.cellwidth[rowcount+1]-apap->ourtap.cellwidth[rowcount])*100;
			width = rint(width/apap->ourtap.tablewidth);
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("\n<td valign=\"top\" width=\"%.0f%%\" >\n",width); 
			cellempty=1;
			inacell=1;
			rowcount++;
			}
		else if ( (inacell == 0) && (apap->ourtap.cell_no == 0) )
			{
			error(stderr,"dont have information as to width of cells\n");
			if (!resetchp)
                {
                decode_e_chp(&reset);
                resetchp=1;
                }
            printf("\n<td valign=\"top\">\n");
            cellempty=1;
            inacell=1;
            rowcount++;
			}
			
		/*weve come into another cell*/
		}
	}

void decode_s_specials(pap *apap,chp *achp,list_info *a_list_info)
	{
	int redotable=0,i;
	int resetchp=0;
	float width;
	chp reset;

	reset.fBold=0;
	reset.fItalic=0;
	reset.underline=0;
	reset.ascii_font=0;
	reset.eastfont=0;
	reset.noneastfont=0;
	reset.fontsize=NORMAL;
	reset.color = NULL;


	error(stderr,"decoding start specials istd is %d\n",apap->istd);

	if (ignoreheadings == 0)
		{
		if ((apap->istd == 1) && (inah1 != 1))
			{
			inah1=1;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H1>");
			}

		if ((apap->istd == 2) && (inah1 != 2))
			{
			inah1=2;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H2>");
			}

		if ((apap->istd == 3) && (inah1 != 3))
			{
			inah1=3;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H3>");
			}

		if ((apap->istd == 4) && (inah1 != 4))
			{
			inah1=4;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H4>");
			}

		if ((apap->istd == 5) && (inah1 != 5))
			{
			inah1=5;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H5>");
			}

		if ((apap->istd == 6) && (inah1 != 6))
			{
			inah1=6;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H6>");
			}

		if ((apap->istd == 7) && (inah1 != 7))
			{
			inah1=7;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H7>");
			}

		if ((apap->istd == 8) && (inah1 != 8))
			{
			inah1=8;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H8>");
			}

		if ((apap->istd == 9) && (inah1 != 9))
			{
			inah1=9;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("<H9>");
			}
		}	

	error(stderr,"manually doing start chp\n");
	}

void decode_e_list(pap *apap,chp *achp,list_info *a_list_info)
	{
	int i;
	int lvl;
	error(stderr,"inah1 is going in %d\n",inah1);
	if ( (apap->ilvl+1) < inalist)
		{
		error(stderr,"ILVL: apap->ilvl+1 id %d inalist is %d\n",(apap->ilvl+1),inalist);
/*
		if (apap->ilvl+1 == 0)
			lvl = 1;
		else
*/
			lvl = apap->ilvl+1;

		for(i=inalist;i>lvl;i--)
			{
			if (i==1)
				printf("\n<!--</DIR>-->");
			else
				printf("\n</DIR>");
			}
		inalist=apap->ilvl+1;
		}
	}

void decode_e_table(pap *apap,chp *achp,list_info *a_list_info)
	{
	pap reset;
	chp resetc;
	int clearedspecials=0;
	error(stderr,"decoding end table\n");

    reset.istd =0;
    reset.fInTable=0;
    reset.fTtp=0;
	reset.tableflag=0;
	reset.ilvl=-1;
	reset.ilfo=-1;
	reset.list_data=NULL;

	resetc.fBold=0;
	resetc.fItalic=0;
	resetc.underline=0;
	resetc.ascii_font=0;
	resetc.eastfont=0;
	resetc.noneastfont=0;
	resetc.fontsize=NORMAL;
	resetc.color = NULL;

	if ((apap->fInTable == 1) && (apap->fTtp == 1) && apap->tableflag)
		{
		error(stderr,"cell and row end\n");
		if (!clearedspecials)
			{
			decode_e_chp(&resetc);
			decode_e_specials(&reset,achp,a_list_info);
			clearedspecials=1;
			}
		printf("\n</tr>\n");
#if 0
		printf("\n</table>\n");
		inatable=0;
#endif
		inarow=0;
		inacell=0;
		apap->tableflag=0;
		}
	else if ((apap->fInTable == 1)  && (apap->fTtp != 1) && apap->tableflag )
		{
		if (!clearedspecials)
			{
			decode_e_chp(&resetc);
			decode_e_specials(&reset,achp,a_list_info);
			clearedspecials=1;
			}
		if (cellempty == 1)
			printf("&nbsp;");
		printf("\n</td>\n");
		inacell=0;
		apap->tableflag=0;
		error(stderr,"cell end\n");
		}

	if ( (inatable) && (!apap->fInTable) && (!inarow) )
		{
		error(stderr,"table ends here\n");
		if (!clearedspecials)
			{
			decode_e_chp(&resetc);
			decode_e_specials(&reset,achp,a_list_info);
			clearedspecials=1;
			}
		printf("\n</table>\n");
		lastrowlen=0;
		inatable=0;
		}

	}
void decode_e_specials(pap *apap,chp *achp,list_info *a_list_info)
	{
	int resetchp=0;
	chp reset;
	error(stderr,"decoding specials istd is %d\n",apap->istd);
	/*before a para ends, well reset all chars to original defaults*/

	reset.fBold=0;
	reset.fItalic=0;
	reset.underline=0;
	reset.ascii_font=0;
	reset.eastfont=0;
	reset.noneastfont=0;
	/*
	reset.fontsize=currentfontsize;
	*/
	
	reset.fontsize=NORMAL;
	

	reset.color = NULL;
	/*
	if (achp != NULL)
		reset.color = achp->color;
	else
		error(stderr,"no chp here ?\n");
	*/

	error(stderr,"manual end chp\n");
	/*
	decode_e_chp(&reset);
	*/

	if (ignoreheadings ==0)
		{
		if ((apap->istd != 9) && (inah1 == 9))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
				
			printf("</H9>\n");
			}
		else if ((apap->istd != 8) && (inah1 == 8))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H8>\n");
			}
		else if ((apap->istd != 7) && (inah1 == 7))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H7>\n");
			}
		else if ((apap->istd != 6) && (inah1 == 6))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H6>\n");
			}
		else if ((apap->istd != 5) && (inah1 == 5))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H5>\n");
			}
		else if ((apap->istd != 4) && (inah1 == 4))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H4>\n");
			}
		else if ((apap->istd != 3) && (inah1 == 3))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H3>\n");
			}
		else if ((apap->istd != 2) && (inah1 == 2))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H2>\n");
			}
		else if ((apap->istd != 1) && (inah1 == 1))
			{
			inah1=0;
			if (!resetchp)
				{
				decode_e_chp(&reset);
				resetchp=1;
				}
			printf("</H1>\n");
			}
		}
	error(stderr,"inah1 is now %d\n",inah1);
	}

void decode_gpprls(pap *apap,chp *achp,sep *asep,U16 *gpprl,int index,Sprm *sprmlists,style *sheet)
	{
	/**/
	int j=0;
	U16 i=0;
	Sprm *thesprmlist=sprmlists;
	U16 sprm;
	U8 operand;
	U8 *pointer;

	error(stderr,"index were looking for is %d\n",index);
	if (index <0)
		return;

	/*the index were given is the sprm, if its a varient 1 
	ignore it for now, if its varient 2 go through the list of sprms countinf
	varients 2, until we get to this one*/
	if (0 == (gpprl[index] & 0x01))
		{
		error(stderr,"varient 1s, (%x)\n",gpprl[index]);
		/*
		sprm = (gpprl[index] >> 1) && 0x00FF;
		*/
		sprm = (gpprl[index] >> 1) & 0x00FF;
		operand = gpprl[index] >> 8;
		error(stderr,"GPRL is (%x) operand is %d",sprm,operand);
		return;
		}
	else
		{
		error(stderr,"varient 2s, (%x) (%x) (%x)\n",gpprl[index]&0xFFFE,gpprl[index]>>1,gpprl[index]);
		for (i=0;i<index;i++)
			{
			if (gpprl[i] & 0x01)
				j++;
			}
		error(stderr,"read index val is %d\n",j);
		}
	i=0;	
	while(i<(gpprl[index]>>1))
		{
		thesprmlist=thesprmlist->next;
		if (thesprmlist == NULL)
			{
			error(stderr,"gpprl index is wrong at %d!\n",i);
			return;
			}
		i++;
		}


/*hum 261*/
	i=0;
	error(stderr,"sprm list len is %d\n",thesprmlist->len);
	while (i<thesprmlist->len)
		{
		sprm = sread_16ubit(thesprmlist->list+i);
		i+=2;
		error(stderr,"clist is %x, at len point %d\n",sprm,i);

		pointer = thesprmlist->list+i;
		if (apap == NULL)
			fprintf(stderr,"aha !!\n");

		decode_sprm(NULL,sprm,apap,achp,asep,&i,&pointer,sheet,apap->istd);
		error(stderr,"after line\n");
		/*change above to include sep*/
		}
	}



void decode_field(FILE *main,field_info *magic_fields,long *cp,U8 *fieldwas,long *swallowcp1,long *swallowcp2)
	{
	time_t timep;
	struct tm *times;
	char date[1024];
	/*
	called at the start of a field, find the field associated
	with that cp and decode meaning, process to end of field
	*/

	/*wont deal with enbedded fields yet\n*/
	int i=0;
	int type=0;

	*swallowcp1 = -1;
	*swallowcp2 = -1;

	error(stderr,"decoding field with cp %x\n",*cp);

	if (magic_fields != NULL)
		{
		while(i<magic_fields->no+1)
			{
			error(stderr,"field entry says %d (%x)\n",i,magic_fields->cps[i]);
			if (magic_fields->cps[i] == *cp)
				{
				error(stderr,"found field entry at %d\n",i);
				type = (magic_fields->flds[i*2])&0x1f;
				error(stderr,"type is %d \n",type);
				break;
				}
			i++;
			}

		switch(type)
			{
			case 19:
				/*beggining a field*/
				*fieldwas = magic_fields->flds[(i*2)+1];
				switch (*fieldwas)
					{
					case 88:
						error(stderr,"HYPERLINK\n");
						/*
						printf("<a href=\"");
						*/
						printf("<a href=");
						*swallowcp1 = magic_fields->cps[i+1]-2;
						*swallowcp2 = magic_fields->cps[i+1];
						break;
					case 33:
						if ((currentsep != NULL) && (inaheaderfooter))
							{
							error(stderr,"soing nfc\n");
							error(stderr,"nfcPgn is %d\n",currentsep->nfcPgn);
							decode_list_nfc(&sectionpagenumber,currentsep->nfcPgn);
							sectionpagenumber--;
							}
						else 
							printf("%d",sectionpagenumber);
						error(stderr,"sectionpagenumber is now %d, inaheaderfooter is %d\n",sectionpagenumber,inaheaderfooter);
						break;
					case 65:
						printf("%d",sectionno);
						error(stderr,"sectionno is now %d\n",sectionno);
						break;
					case 26:
						printf("unknown # of pages");
						break;
					case 31:
						timep = time(NULL);
						times = localtime(&timep);
						strftime(date,1024,"%x",times);
						error(stderr,"output date as %s\n",date);
						printf("%s",date);
						break;
					case 32:
						timep = time(NULL);
						times = localtime(&timep);
						strftime(date,1024,"%X",times);
						error(stderr,"output time as %s\n",date);
						printf("%s",date);
						break;
					case 29:
						error(stderr,"spitting out original filename\n");
						break;
					case 13:
						error(stderr,"spitting out toc\n");
						break;
					default:
						error(stderr,"unsupported field %d\n",*fieldwas);
						break;
					}
				break;
			case 20:
				switch (*fieldwas)
					{
					case 65:
					case 33:
					case 26:
						break;
					case 88:
						error(stderr,"HYPERLINK middle\n");
						/*
						printf("\">");
						*/
						printf(">");
						break;
					case 29:
						error(stderr,"filename middle\n");
						break;
					case 13:
						error(stderr,"toc middle\n");
						break;
					default:
						error(stderr,"unsupported field %d\n",*fieldwas);
						break;
					}
				error(stderr,"field middle reached\n");
				break;
			case 21:
				switch (*fieldwas)
					{
					case 65:
					case 33:
					case 26:
						break;
					case 88:
						error(stderr,"HYPERLINK end\n");
						printf("</a>");
						break;
					default:
						error(stderr,"unsupported field %d\n",*fieldwas);
						break;
					}
				error(stderr,"field end reached\n");
				break;
			default:
				error(stderr,"field wierdness!!\n");
				break;
			}
		}
	}


void chpsoff()
	{
	chps=1;
	}

void chpson()
	{
	chps=0;
	}
