;; $Id: dbblock.dsl 1.6 1998/06/12 12:07:39 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(element highlights ($block-container$))

(element blockquote
  (make element gi: "BLOCKQUOTE"
	(process-children-trim)))

(element epigraph ($block-container$))

(element attribution ($paragraph$))

(element para ($paragraph$))
(element simpara ($paragraph$))

(element formalpara
  (make element gi: "DIV"
	attributes: (list
		     (list "CLASS" (gi)))
	(make element gi: "P"
	      (process-children))))

(element (formalpara title)
  (make element gi: "B"
	(process-children)
	(literal ". ")))

(element (formalpara para)
  (process-children))

(element sidebar 
  (make element gi: "TABLE"
	attributes: (list
		     (list "CLASS" (gi))
		     (list "BORDER" "1")
		     (list "CELLPADDING" "5"))
	(make element gi: "TR"
	      (make element gi: "TD"
		    ($semiformal-object$)))))

(element (sidebar title)
  (empty-sosofo))

(element abstract 
  (make element gi: "BLOCKQUOTE"
	attributes: '(("CLASS" "ABSTRACT"))
	(process-children)))

(element authorblurb ($block-container$))

(define ($inline-object$)
  (process-children))

(define ($informal-object$)
  (let ((id (attribute-string (normalize "id"))))
    (make element gi: "DIV"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (if id
	      (make element gi: "A"
		    attributes: (list (list "NAME" id))
		    (empty-sosofo))
	      (empty-sosofo))

	  (if %spacing-paras%
	      (make element gi: "P" (empty-sosofo))
	      (empty-sosofo))
	  
	  (process-children)
	  
	  (if %spacing-paras%
	      (make element gi: "P" (empty-sosofo))
	      (empty-sosofo)))))
  
(define ($formal-object$)
  (let* ((nsep  (gentext-label-title-sep (gi)))
	 (id    (attribute-string (normalize "id")))
	 (titlesosofo (make sequence
			(literal (gentext-element-name (gi)))
			(if (string=? (element-label) "")
			    (literal nsep)
			    (literal " " (element-label) nsep))
			(with-mode title-mode
			  (process-node-list 
			   (select-elements (children (current-node))
					    (normalize "title")))))))
    (make element gi: "DIV"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (make element gi: "P"
		(make element gi: "B"
		      (if id
			  (make element gi: "A"
				attributes: (list (list "NAME" id))
				titlesosofo)
			  titlesosofo)))
	  (process-children))))

(define ($semiformal-object$)
  ;; semiformal means optional title...
  (if (node-list-empty? (select-elements (children (current-node)) 
					 (normalize "title")))
      ($informal-object$)
      ($formal-object$)))

(element example ($formal-object$))

(element (example title) (empty-sosofo)) ; don't show caption below example
(element informalexample ($informal-object$))

(element (figure title) (empty-sosofo)) ; don't show caption below figure

(element figure ($formal-object$))

(element informaltable ($informal-object$))

(element table ($formal-object$))

(element (table title) (empty-sosofo))
