#include "libpdftex.h"
#include "image.h"

integer read_png_info(integer img)
{
    FILE *png_file = xfopen(IMG_NAME(img), FOPEN_RBIN_MODE);
    if ((PNG_PTR(img) = png_create_read_struct(PNG_LIBPNG_VER_STRING, 
        NULL, NULL, NULL)) == NULL)
        FAIL("png_create_read_struct() failed");
    if ((PNG_INFO(img) = png_create_info_struct(PNG_PTR(img))) == NULL)
        FAIL("png_create_info_struct() failed");
    if (setjmp(PNG_PTR(img)->jmpbuf))
        FAIL("setjmp() failed");
    png_init_io(PNG_PTR(img), png_file);
    png_read_info(PNG_PTR(img), PNG_INFO(img));
    if (PNG_INFO(img)->color_type & PNG_COLOR_MASK_ALPHA) {
/*

   Before pdftex-0.12o-1 we failed when touching png with alpha channel, now we
   strip this channel. 09/06/1998 Pavel Jank ml.

*/
        png_set_strip_alpha(PNG_PTR(img));
        WARN("can't handle alpha channel correctly, stripped\nPlease report bugs to pdftex@tug.org");
    }
    if (PNG_INFO(img)->interlace_type != 0) {
/*

   Before pdftex-0.12o-1 we failed when touching interlaced png, now it's ok.
   09/06/1998 Pavel Jank ml.

*/
        png_bytep row = XTALLOC(PNG_INFO(img)->rowbytes, png_byte);
        int i, number_of_passes = png_set_interlace_handling(PNG_PTR(img));
        while (number_of_passes-->1) {
            for (i = 0; i < PNG_INFO(img)->height; i++)
                png_read_row(PNG_PTR(img), row, NULL);
        }
        free(row);
        WARN("experimental support for interlaced png\nPlease report bugs to pdftex@tug.org");
    }
    if (PNG_INFO(img)->bit_depth == 16) {
        png_set_strip_16(PNG_PTR(img));
        WARN("can't handle 16 bits per channel, strip down to 8 bits");
    }
    png_read_update_info(PNG_PTR(img), PNG_INFO(img));
    return 0;
}

void write_png(integer n, integer img)
{
    int i, j;
    integer palette_objnum = 0;
    png_bytep row = XTALLOC(PNG_INFO(img)->rowbytes, png_byte);
    pdfbegindict(n);
    PDF_PRINTF("/Type /XObject\n/Subtype /Image\n/Width %li\n/Height %li\n/BitsPerComponent %li\n" AND
               (long int)PNG_INFO(img)->width AND
               (long int)PNG_INFO(img)->height AND
               (long int)PNG_INFO(img)->bit_depth);
    PDF_PRINTF("/ColorSpace ");
    switch (PNG_INFO(img)->color_type) {
    case PNG_COLOR_TYPE_PALETTE:
        pdfcreateobj(0, 0);
        palette_objnum = objptr;
        PDF_PRINTF("[/Indexed /DeviceRGB %li %li 0 R]\n" AND
                   (long int)(PNG_INFO(img)->num_palette - 1) AND
                   (long int)palette_objnum);
        break;
    case PNG_COLOR_TYPE_GRAY:
        PDF_PRINTF("/DeviceGray\n");
        break;
    default:
        PDF_PRINTF("/DeviceRGB\n");
    }
    pdfbeginstream();
    for (i = 0; i < PNG_INFO(img)->height; i++) {
    	png_read_row(PNG_PTR(img), row, NULL);
        for (j = 0; j < PNG_INFO(img)->rowbytes; j++) {
            pdfbuf[pdfptr++] = row[j];
            if (pdfptr == pdfbufsize)
                pdfflush();
        }
    }
    pdfendstream();
    if (palette_objnum > 0) {
        pdfbegindict(palette_objnum);
        pdfbeginstream();
        for (i = 0; i < PNG_INFO(img)->num_palette; i++) {
            if (pdfptr + 3 >= pdfbufsize)
                pdfflush();
            pdfbuf[pdfptr++] = PNG_INFO(img)->palette[i].red;
            pdfbuf[pdfptr++] = PNG_INFO(img)->palette[i].green;
            pdfbuf[pdfptr++] = PNG_INFO(img)->palette[i].blue;
        }
        pdfendstream();
    }
    free(row);
    pdfflush();
}
