/* ---------------------------------------------------------------------

   XfreeCD v0.7.7

   Copyright (C) 1998 Brian C. Lane
   nexus@tatoosh.com
   http://www.tatoosh.com/nexus

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   ============================[ HISTORY ]==============================
   07/05/98	Fixed intermittant bug with recalling CD info. There was
   	 	a spare strcat(tmpstr) in the request loop of offsets!
   	 	Depending on the state of memory this could really hose
   	 	the requests.

   06/26/98     Fixing Revision # for original submissions. Store them
                locally as #0 so that the first send to the server will
		increment it to #1 and the server will get #1.
		Also added the VERSION number to the makefile to make
		changing the version easier.

   06/22/98     I just noticed a problem. The Length of track #1 is wrong!
                Seems to be stuck at 20:36. cd_control.c was waiting until
		the track was at #2 before calculating the length. FIXED.

   06/20/98     TODO
                1. Fix EXT problems.
		   FIXED.
		2. Reread spec on blank tracks. It refused 'Track 6'
		   I shouldn't save any default strings to disk or send
		   them to the database. Only show them when updating
		   the clist. DONE. Sends a blank ttitle if none is
		   entered.

		3. Made change, but edit doesn't work and it complains
		   about lots of g_strings != NULL (means ==) that need
		   to be fixed (probably in the edit an edit copy). Make
		   sure the (blank) placeholders are not copied over unless
		   they are edited.
		   Writing of blank tracks doesn't work when the user has
		   deleted everything since it holds a string of zero
		   length.
		   FIXED. Check the length for 0.

		4. If the CD is paused when XfreeCD is run it doesn't
		   show the current track in the display. FIXED.

		5. If the CD is paused when XfreeCD is run and you show
		   the track names, it is blank. The database has not
		   been read yet. FIXED.

		6. Main Tracklist display is updated every second...
		   This is because some of the CDDB entries have a revision
		   of -1. I convert these into revision 1 now.

   06/19/98     Finishing up the extended data support. Adding free_cdinfo
                to the appropriate places. Need to make sure its only called
		when its needed and not in the update loop.
		Changed Cancel button in edit window to Close

		Shit. Nov I've broken it and I don't know how. Well, then
		I'll just break it more. Changing all string usage to
		dynamically allocated GString * from gtk.

		Whew! Okay, I've converted all the static string storage
		over to GString usage. It appears to be working okay for
		the moment. Now to stress test it with all the CDDB
		requirements.

		Testing and making submissions to CDDB test server.
		1. Inexact doesn't save to disk with my ID, it saves it
		   with the downloaded id (because I canged the way it
		   is saved after being received!). Change in cddbd.c
		   so it save to local, reads it, changes discid and
		   saves it again <ICK>. FIXED.

		2. There is a problem when reading extended info. It
		   is writing a blank EXTD and EXT0 then another EXT0
		   and then up to the end-1 tracks. Fix it tomorrow.
		   FIXED. 1 - off error.

   06/16/98     Things that need fixing:
                1. 99 track CD isn't downloaded, causes an error and
		   it retries the server endlessly.
		   The track array in cdinfo was 1 short! I should use
		   0-98 instead of 1-99 for all access.
		   FIXED.

		2. Server error caused by not sending all the track offsets
		   (buffer overflow). Fixed by sending it the offsets one
		   at a time. FIXED.

		3. Edit window coredumps when trying to edit 99 track
		   NIN-broken. FIXED. display structure had a [99] in it.
		   
		4. Main tracklist window flickers every second...

		5. Need to process extended data, save to local database,
		   resend it to server when tracks change. Don't need
		   to edit it or display it (most CDs don't use it at all).
		   Reading works now.
		   a. Need to write it back to disk. DONE.
		   b. Need to free the used memory when a CD is ejected
		      DONE.

		6. Need to read the Revision # correctly
		   DONE.

   06/06/98     Fixed problem with changing categories. Once the new
                category has successfully been written it erases the
		old category.
		While it is waiting to get new data from the server
		it is displaying the old track data. Needs to be erased
		from the cdinfo structure as well as the display.
		FIXED.
		I would like to make long title in the track window
		wrap automatically, but the GTK label doesn't have
		wrapping, so too bad.
		Adding a Send to Server option. This just uses the
		local mail binary (must be in the path). This should
		work for everyone.
		Works, Tested successfully.
		Added support for multiple TITLEx lines. Tested, and it
		works fine. Sent 5 test of long title and long track
		names to the cddb-test server.
		I just noticed a bug with the clist edit window. It
		is resetting the vertical scroll bar when you select
                a track that has to be scrolled down to. Probably
		because I reload the clist when the trackname is
		edited. FIXED.

   06/05/98     Trying to tidy up all the loose ends.
                GTK cannot figure out the geometry of the window before
		it is actually showing, so the negative geometry with
		titlebar doean't work right. Hardcoded the window size
		to 137x60

   06/02/98     Adding display of full string returned by server error.
                Fixed close error, I was returning the wrong thing from
		delete_event.
   
   06/01/98     Adding seperate Window Class names to the different
                windows so that the user can individually control the
		title bar, move/resize, etc. As suggested by Michael
		J. Hammel

   05/31/98     Adding support for -geometry, apparently this has not
                been added to GTK+ itself yet, so I have to do it
		myself, using XParseGeometry. Works Great!
		When geometry is passed a '- it needs to be relative
		to the other corner of the window, not the upper
		left. Fixed.

   05/28/98	Bug with eject on exit. It needs to send the current
   		state to the cd_control process when it reads the
   		config file. FIXED.
   		Need to add dropdown list for categories in edit. DONE.

   05/27/98     More finishing touches <G>.
                Added selection of next track in the track window when
		it goes to the next track. Looks nicer.
		Fixed a bug with multiple DTITLE lines.

		NEED TO DO:
		x 1. Build local cddb directories sometime (either under
		     the setup menu, or the first time it writes,
		     or at compile time). The best would be when it
		     tries to write to a non-existant directory, create
		     the structure needed.
		     Works. It creates only the category directory
		     needed and the root cddb directory if it doesn't
		     exist yet. This way the categories aren't limited
		     to a static list.
		x 2. Editing track names and saving to local database.
		x 3. Sending edited track info to the database, or just
		     a new discid for the CD. Requires email. Use the
		     mail binary, but allow users to spec. it?
		x 4. Allow user to select local .cddb support or internet
		     so they can build their own database in the cddb
		     format even if they have no inet connection.
		  5. Clean up code. Add comments.
		     There is a bunch of duplicated code that can be
		     put into a subroutine with maybe 1 parameter
		     passed to it. The clist updating routines are
		     one.
		x 6. Convert my usage of printf to g_print

   05/26/98     Finishing touches. Got the text window to work, thanks
                to Owen. I had to add it to the notebook before
		it is realized, otherwise it doesn't know who its
		parent is (this is because text windows are changes as
		you add to them).
		Changed to main window to be a POPUP so that it has no
		title bars. Keeps people from resizing it too!

   05/25/98     Problem with using device from main process -- we only
                send 2 bytes to the cd_control process!! How am I going
		to pass the new device? A 2 stage send? With the second
		part being the new device?

		Added CD_SET_DEVICE to cd_control.
		Adding sending of it to read_config.
		Switching cd device is now working!

		Adding clear of display.tclist to no disc display points


   05/24/98     Adding support for inexact matches. CDDBD_INEX_LINE.
                Inexact matching works!!! It saves it as the locally
		calculated discid (recalculated just before the save).

		x 1. Need to update the track list if its already open
		     when the new data is downloaded from the server or
		     read from disk.
		x 2. Clear the track list and title when nodisc info is
		     available (on change, use Track #, etc).
		x 3. Click on a track in the track list to jump to
		     that track directly.
	       no  5. CD changer support...
		x 6. Volume update is slow, needs to be called on click.

		I've decided not to include changer support. Too hard to
		integrate into the current GUI. And there probably isn't
		a great need.

   05/23/98     The Help/Setup dialog is partially working. It still
                complains when making the help text box, why?
		The startup sequence isn't working right. Not playing
		after closing the tray, or even when already closed.

		I also don't like the startup pause for checking for the
		current status. That should be handled by a startup
		state machine in the status callback. May help solve the
		startup play problem. Fixed. Status returned was NO_STATUS
		which I was checking for some reason.

		Software selectable eject on exit with no play is now
		working correctly.

		Server refresh is working as far as updating the internal
		list but the list in the setup dialog isn't working. Also
		changes to cddb and device are cross-polinated! It is
		happening at the realloc in the device_edit and cddb_edit
		routines. Pointer copied over somehow? realloc wrong?
		typical bug. Assignment to wrong place.

		Some of th things left to do:
		x 1. refresh server listing after update from internet
		     while dialog box is still open.
		x 2. Status box showing the info while connected to the
		     server.
		x 3. Implement Inexact match
		x    a. receive list of discids and titles from the server
		        Add a new command to cddbd return value
		x    b. Show a dialog box with the list of titles and have
		        the user pick one or Cancel.
		x    c. re-submit the query using the user selected discid
		x 4. Saving to disk saves the wrong revision #, -1
		o 5. Popup window when display is left clicked that shows
		     and allows editing of title and tracks.
		     showing title and track is working.
		  6. Need to switch to using config.device and telling the
		     cd_control process about it when we change it.
		  7. Submitting a new disc to the database (via email?)


   05/22/98     Need to finish the help/setup menu window.
                x Device (defaults to /dev/cdrom)
		x Server List
		x cddb support
	       no changer support
		x Eject at end?
		x Startup behavior


		Since I have the WM set to no titles and bars it makes it
		hard to manipulate the setup screen! How about if I were
		to extend the cdplayers window up or down (how to tell?)
		and include the setup/server/tracklist data that way?
		How do you delete things once you've packed them? Or can
		you? 


   05/21/98     Right click on display window and dragging now works
                fine for moving the window around.


   05/20/98     Blink isn't working. Fixed. Multiple places calling
                update_display. FIXED.
		Also need to add window dragging if right clicked in
		the display area.
		Need to add parallel tracklist window popup if right
		click on either of the track digits (or area).

		At startup we need to know the current state of the
		CD before we go off and send a play command to it. FIXED.
		When it has to close the door to play it doesn't start
		playing automatically.
		When it tries to play with no CD in the drive it doesn't
		recover when you insert a disc and hit play.
		Because fd_cd is < 0. Check for this.

		There is a problem with setting the play button graphic
		and state at the point where it is sent to control.
		it it fails then the state/button is wrong! But if I
		wait until it succeeds/fails then response time is
		greatly delayed... Added code to make sure the button
		state matched the display state and to change it if it
		differs. Seems to work nicely. Shows playup until it
		fails and then switches to stopup. WORKS WELL.

		Eject doesn't work with status doing an init. Do an
		initial init when cd_control is started. FIXED.

		Dragging now sortof works. It loses track of the cursor
		if its moved too fast, and won't ungrab (ick!)

   05/19/98     Read/Write config now works, needs to still be tested
                with multiple servers though.

   05/18/98     Adding configuration writing and reading

   05/17/98     Found a chunck of startup code that was double-copied,
                The player actually plays, ejects, etc. OK.
		The volume display needs to update immediatly as does
		the time display update when the key is pressed. Eject
		should eject even when no cd has been opened.
		At startup we should?
		  Play automatically
		  Show no disc and do nothing until play pressed
		  Show total # of tracks and time remaining
		All of these should be user selectable.
		When a CD is opened for the first time (no discid stored
		in cdinfo) we should query the database.
		Clicking (right probably) on the display should pop up a
		list of the tracks (editable).
		There are some == NULL problems that need to be taken care
		at starup, probably due to not realizing widgets first?
		Blink isn't working right (doesn't blink)
		Remaining on track counts up, not down!
		Help/Setup dialog needs to be nicer looking, black to match
		the look of the main box (how do I change the colors of
		the dialogs?)

   05/16/98     Finishing up the cd control, adding get motd and get
                server list from cddb.cddb.com
		I really should add protocol support, but really, it
		works fine like this...
		OK, it 'looks like' the low level and server support is
		now working okay. The code is a bit hard to read and
		could probably use some macroing or other cleanups,
		but I'll save that for later.

		Now to start adding the GTK+ GUI stuff again and integrate
		it with the data returning from the server and the CD
		control process.

		Well, the UI is sort of running. It complains a little,
		and puts two 'NO DISC' pixmaps in the window, but it
		starts at least!

   05/09/98     Added local cddb database support. It successfully reads
                the disc info from the database.

   05/03/98     Restarted this whole project from the ground up. I am
                writing the CD control and cddb support code first,
		and then adding the GUI interface.

		cd_control and cddb will be seperate processes forked
		from the main process at startup.

   -------------------------------------------------------------------- */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include "cd_control.h"
#include "cddbd.h"
#include "cddb.h"
#include "xfreecd.h"
#include "xpm_button.h"


/* Include all the bitmaps used (in xpm format) */
#include "bitmaps/ffup.xpm"
#include "bitmaps/ffdn.xpm"
#include "bitmaps/rewup.xpm"
#include "bitmaps/rewdn.xpm"
#include "bitmaps/sfwddn.xpm"
#include "bitmaps/srevdn.xpm"
#include "bitmaps/stopup.xpm"
#include "bitmaps/playup.xpm"
#include "bitmaps/playdn.xpm"
#include "bitmaps/pauseup.xpm"
#include "bitmaps/ejup.xpm"
#include "bitmaps/ejdn.xpm"
#include "bitmaps/exitup.xpm"
#include "bitmaps/exitdn.xpm"
#include "bitmaps/helpup.xpm"
#include "bitmaps/helpdn.xpm"
#include "bitmaps/rptup.xpm"
#include "bitmaps/rptdn.xpm"
#include "bitmaps/rptupact.xpm"
#include "bitmaps/volup.xpm"
#include "bitmaps/voldn.xpm"
#include "bitmaps/null.xpm"
#include "bitmaps/nodisc.xpm"
#include "bitmaps/plstrkup.xpm"
#include "bitmaps/plstrkdn.xpm"
#include "bitmaps/mnstrkup.xpm"
#include "bitmaps/mnstrkdn.xpm"
#include "bitmaps/plscdup.xpm"
#include "bitmaps/plscddn.xpm"
#include "bitmaps/mnscdup.xpm"
#include "bitmaps/mnscddn.xpm"
#include "bitmaps/minus.xpm"
#include "bitmaps/bar.xpm"
#include "bitmaps/redbar.xpm"
#include "bitmaps/nobar.xpm"
#include "bitmaps/a0.xpm"
#include "bitmaps/a1.xpm"
#include "bitmaps/a2.xpm"
#include "bitmaps/a3.xpm"
#include "bitmaps/a4.xpm"
#include "bitmaps/a5.xpm"
#include "bitmaps/a6.xpm"
#include "bitmaps/a7.xpm"
#include "bitmaps/a8.xpm"
#include "bitmaps/a9.xpm"
#include "bitmaps/an.xpm"
#include "bitmaps/b0.xpm"
#include "bitmaps/b1.xpm"
#include "bitmaps/b2.xpm"
#include "bitmaps/b3.xpm"
#include "bitmaps/b4.xpm"
#include "bitmaps/b5.xpm"
#include "bitmaps/b6.xpm"
#include "bitmaps/b7.xpm"
#include "bitmaps/b8.xpm"
#include "bitmaps/b9.xpm"
#include "bitmaps/bn.xpm"


#undef DEBUG1
#undef DEBUG2
#undef DEBUG3
#undef DEBUG4
#undef DEBUG5
#undef DEBUG6
#undef DEBUG7
#undef DEBUG8
#undef DEBUG9
#undef MAIL_DEBUG

#define	CDROM_NODISC	0
#define CDROM_PLAYING	1
#define CDROM_PAUSED	2

#define TRACK_ELAPSED	0
#define TRACK_REMAIN	1
#define CD_ELAPSED	2
#define CD_REMAIN	3


#define HELP_TEXT( x )       gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, x, -1)
#define COLOR_TEXT( x, y )   gtk_text_insert (GTK_TEXT (text), NULL, y, NULL, x, -1)

int read_config( struct CONFIG * );
int run_gtk();
void free_config( struct CONFIG * );
gint delete_event(GtkWidget *, gpointer);
void destroy (GtkWidget *, gpointer);
void cd_fd_read( gpointer, gint, GdkInputCondition);
void cddbd_fd_read( gpointer, gint, GdkInputCondition);
void ff_press(GtkWidget *, GdkEventButton *);
void ff_release(GtkWidget *, GdkEventButton *);
void rew_press(GtkWidget *, GdkEventButton *);
void rew_release(GtkWidget *, GdkEventButton *);
void play_press(GtkWidget *, GdkEventButton *);
void play_release(GtkWidget *, GdkEventButton *);
void eject_press(GtkWidget *, GdkEventButton *);
void eject_release(GtkWidget *, GdkEventButton *);
void ex_press(GtkWidget *, GdkEventButton *);
void ex_release(GtkWidget *, GdkEventButton *);
void help_press(GtkWidget *, GdkEventButton *);
void help_release(GtkWidget *, GdkEventButton *);
void tdisp_press(GtkWidget *, GdkEventButton *);
void tdisp_release(GtkWidget *, GdkEventButton *);
void rpt_press(GtkWidget *, GdkEventButton *);
void rpt_release(GtkWidget *, GdkEventButton *);
void vol_press(GtkWidget *, GdkEventButton *);
void vol_release(GtkWidget *, GdkEventButton *);
void set_vol( int amount );
static int expose_display( GtkWidget *, GdkEventExpose *);
gint update_cdrom( gpointer );
void play_next();
void play_previous();
void pause_cdrom();
void resume_cdrom();
void play_track(int);
void update_display();
void stop_cdrom();
void eject_cdrom();
int cdrom_status();
int write_config( struct CONFIG * );
static void display_released (GtkWidget *);
static void display_motion (GtkWidget *, GdkEventMotion *);
static void display_pressed (GtkWidget *, GdkEventButton *);
void wait_status();
gint show_tracks();
void set_eject( int );


typedef struct _cursoroffset {gint x,y;} CursorOffset;

/* Global Variables and structures */
struct CDINFO cdinfo;
struct CONFIG config;
 
char          cmnd[2];
int           cd_pid, cd_fd,            /* Communications with the CD control */
              cddbd_pid, cddbd_fd;      /* Communications with cd database */
gint          gdk_cd_fd,
              gdk_cddbd_fd;


static GdkWindow *root_win = NULL;


struct _pbutton	ff,			/* Fast Forward button		*/
		rew,			/* Rewind			*/
		play,			/* Play				*/
		vol,			/* Volume control		*/
		eject,			/* Elect			*/
		tdisp,			/* Time Display			*/
		rpt,			/* Repeat			*/
		ex,			/* Exit button			*/
		help;			/* Help				*/

/* Display pixmaps and current disc status */
struct _display 
{
  GtkWidget	*main_window;           /* The main window              */
  GtkWidget     *vbox;                  /* Vbox holding everything      */
  GtkWidget	*wid;			/* Widget for placing pixmaps	*/
  GtkWidget     *progress;              /* CDDBD progress dialog window */
  GtkWidget     *plabel;                /* Progress dialog label        */
  GtkWidget     *twindow;               /* Track Window pointer         */
  GtkWidget     *tclist;                /* List of tracks               */               
  GtkWidget     *ttitle;                /* Track list title widget      */
  GtkWidget     *tewindow;              /* Track Edit Window            */
  GtkWidget     *teentry;               /* Track Entry Window           */
  GtkWidget     *teclist;               /* Clist for Track Edit         */
  GtkWidget     *cb;                    /* ComboBox list of Servers     */
  GdkPixmap	*image;			/* image to paint onto		*/
  GdkPixmap	*null_pixmap;		/* Blank with : 		*/
  GdkBitmap	*null_mask;
  GdkPixmap	*nodisc_pixmap;		/* NO DISC			*/
  GdkBitmap	*nodisc_mask;
  GdkPixmap	*minus_pixmap;		/* Minus sign			*/
  GdkBitmap	*minus_mask;
  GdkPixmap	*playup_pixmap;		/* Play in white		*/
  GdkBitmap	*playup_mask;
  GdkPixmap	*playdn_pixmap;
  GdkBitmap	*playdn_mask;
  GdkPixmap	*pauseup_pixmap;	/* Pause bars in white		*/
  GdkBitmap	*pauseup_mask;
  GdkPixmap	*stopup_pixmap;		/* play and pause in gray	*/
  GdkBitmap	*stopup_mask;
  GdkPixmap     *sfwddn_pixmap;         /* Seek forward down button     */
  GdkBitmap     *sfwddn_mask;
  GdkPixmap     *srevdn_pixmap;         /* Seek reverse down button     */
  GdkBitmap     *srevdn_mask;
  GdkPixmap	*rptupact_pixmap;	/* repeat active (white)	*/
  GdkBitmap	*rptupact_mask;
  GdkPixmap	*plstrkup_pixmap;	/* Elapsed track time		*/
  GdkBitmap	*plstrkup_mask;
  GdkPixmap	*plstrkdn_pixmap;
  GdkBitmap	*plstrkdn_mask;
  GdkPixmap	*mnstrkup_pixmap;	/* Remaining track time		*/
  GdkBitmap	*mnstrkup_mask;
  GdkPixmap	*mnstrkdn_pixmap;
  GdkBitmap	*mnstrkdn_mask;
  GdkPixmap	*plscdup_pixmap;	/* Elapsed CD time		*/
  GdkBitmap	*plscdup_mask;
  GdkPixmap	*plscddn_pixmap;
  GdkBitmap	*plscddn_mask;
  GdkPixmap	*mnscdup_pixmap;	/* Remaining CD time		*/
  GdkBitmap	*mnscdup_mask;
  GdkPixmap	*mnscddn_pixmap;
  GdkBitmap	*mnscddn_mask;
  GdkPixmap	*bar_pixmap;		/* Volume Bargraph		*/
  GdkBitmap	*bar_mask;
  GdkPixmap	*redbar_pixmap;		/* Volume Bargraph		*/
  GdkBitmap	*redbar_mask;
  GdkPixmap	*nobar_pixmap;		/* Volume Bargraph		*/
  GdkBitmap	*nobar_mask;

  GdkPixmap	*a_pixmap[11];		/* Large digits			*/
  GdkBitmap	*a_mask[11];
  GdkPixmap	*b_pixmap[11];		/* Small Digits			*/
  GdkBitmap	*b_mask[11];

  GString       *tmp_category;          /* New Category entry */
  GString       *tmp_title;             /* Title storage for edit_tracks*/
  GString       *tmp_track[99];         /* Song names for editing       */
  int           tmp_row;                /* Current row in tmp_track     */

  short         startup;                /* Startup State machine        */
  short         cddb_lock;              /* Lock cddb access while busy  */
  int		status;			/* Current player status
  					   0 = no disc in drive
  					   1 = stopped
  					   2 = playing
  					   3 = paused
  					 */
  int		playbtn;		/* State of play button, same as
  					   above (use CDROM_ equates)
  					 */
  int		time;			/* Time mode			*/
  int		track,                  /* track # - 1 to end of CD     */
                minute,
                second;                 /* Info for the display		*/
  int		repeat;			/* Repeat status		*/
} display;



/* Signal handling code */
static int caught_fatal_sig = 0;

static void on_signal (int sig_num)
{
  if (caught_fatal_sig)
/*    raise (sig_num);*/
    kill (getpid (), sig_num);
  caught_fatal_sig = 1;

  switch (sig_num)
    {
    case SIGHUP:
      g_print("sighup caught\n");
      gdk_exit(1);
      break;
    case SIGINT:
      g_print("sigint caught\n");
      gdk_exit(1);
      break;
    case SIGQUIT:
      g_print("sigquit caught\n");
      gdk_exit(1);
      break;
   case SIGABRT:
      g_print("sigabrt caught\n");
      gdk_exit(1);
      break;
    case SIGBUS:
      g_print("sigbus caught\n");
      destroy(NULL,NULL);
      break;
    case SIGSEGV:
      g_print("sigsegv caught\n");
      destroy(NULL,NULL);
      break;
    case SIGPIPE:
      g_print("sigpipe caught\n");
      gdk_exit(1);
      break;
    case SIGTERM:
      g_print("sigterm caught\n");
      gdk_exit(1);
      break;
    case SIGFPE:
      g_print("sigfpe caught\n");
      destroy(NULL,NULL);
      break;
    default:
      g_print("unknown signal\n");
      destroy(NULL,NULL);
      break;
    }
}

static void on_sig_child (int sig_num)
{
  int pid;
  int status;

  while (1)
    {
      pid = waitpid (WAIT_ANY, &status, WNOHANG);
      if (pid <= 0)
        break;
    }
}


/* ------------------------------------------------------------------------
   Where it all begins...
   ------------------------------------------------------------------------ */
int main( int argc, char *argv[] )
{
  int    x,
         x_ret,
         y_ret,
         w_ret,
         h_ret,
         stat=0;

  bzero( &cdinfo, sizeof( struct CDINFO ) );

  /* Start up the CD control process */
  if( ( cd_fd = start_cd_control( &cd_pid ) ) < 0 )
    {
      perror("start_cd_control error");
      exit(-1);
    }

  /* Start up the CDDBD control process */
  if( ( cddbd_fd = start_cddbd( &cddbd_pid ) ) < 0 )
    {
      perror("start_cd_dbd error");
      exit(-1);
    }

  /* Startup GTK */
  gtk_init (&argc, &argv);

  /* Tell gdk to watch the cd control and cddb pipes for reading */
  gdk_cd_fd = gdk_input_add( cd_fd, GDK_INPUT_READ, cd_fd_read, 0 );
  gdk_cddbd_fd = gdk_input_add( cddbd_fd, GDK_INPUT_READ, cddbd_fd_read, 0 );

  /* Get the -geometry parameters */
  for( x = 0; x < argc; x++ )
    {
      if( (strcasecmp( argv[x], "-geometry" ) == 0) || (strcasecmp( argv[x], "-geom" ) == 0) )
	{
	if( argv[x+1] != NULL )
	  {
#ifdef DEBUG7
	    g_print("Passing %s to XParseGeometry\n", argv[x+1]);
#endif

	    stat = XParseGeometry( argv[x+1], &x_ret, &y_ret, &w_ret, &h_ret );

#ifdef DEBUG7
	    g_print("%d = XParseGeometry( s, %d, %d, %d, %d )\n",
                    stat, x_ret, y_ret, w_ret, h_ret );
#endif
	  }
	}
    }

 /* Handle some signals */
  signal (SIGHUP, on_signal);
  signal (SIGINT, on_signal);
  signal (SIGQUIT, on_signal);
  signal (SIGABRT, on_signal);
  signal (SIGBUS, on_signal);
  signal (SIGSEGV, on_signal);
  signal (SIGPIPE, on_signal);
  signal (SIGTERM, on_signal);
  signal (SIGFPE, on_signal);
  
  /* Handle child exits */
  signal (SIGCHLD, on_sig_child);

  run_gtk( stat, x_ret, y_ret );

  gdk_input_remove( gdk_cd_fd );
  gdk_input_remove( gdk_cddbd_fd );

  /* Tell cd_control to quit */
  cmnd[0] = CD_QUIT;
  cmnd[1] = 0;
  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
      close( cd_fd );
      exit(-1);
    }

  /* Tell cddbd to quit */
  cdinfo.cddbd_cmnd = DB_QUIT;
  if( write( cddbd_fd, &cdinfo, sizeof( struct CDINFO ) ) < 0 )
    {
      perror("write to cddbd error");
      close( cd_fd );
      close( cddbd_fd );
      exit(-1);
    }

  close( cd_fd );
  close( cddbd_fd );
  return(0);
}



/* ----- subroutines follow ------ */


void send_device()
{
  char  buffer[80];

  /* Send the CD device to the cd_control process */
  buffer[0] = CD_SET_DEVICE;
  buffer[1] = 0;
  if( write( cd_fd, buffer, 2 ) < 0 )
    {
      perror("write to cd_control error - 1a");
    }

  sprintf( buffer, "%s\n", config.device );
  if( write( cd_fd, buffer, strlen(buffer) ) < 0 )
    {
      perror("write to cd_control error - 1b");
    }
}


/* ------------------------------------------------------------------------
   Read the configuration file from $HOME/.xfreecdrc

   Return -2 if a malloc fails
   ------------------------------------------------------------------------ */
int read_config( struct CONFIG *config )
{
  FILE  *fp;
  char  fname[1024],
        line[80],
        *p;
  struct SITE *sp, *sp2;

  if( ( p = getenv( "HOME" ) ) == NULL )
    {
      g_print("Cannot find HOME enviornmental variable\n");
      return(-1);
    }

  strncpy( fname, p, 1023 );
  if( fname[strlen(fname)-1] != '/' )
    strcat( fname, "/" );
  strcat( fname, ".xfreecdrc" );

  if( ( fp = fopen( fname, "rb" ) ) == NULL )
    {
      /* Setup reasonable defaults */

      /* Setup for the default device (/dev/cdrom) */
      if( ( config->device = (char *) malloc( strlen(DEFAULT_DEVICE)+1 ) ) == NULL )
	{
	  return(-2);
	}
      strcpy( config->device, DEFAULT_DEVICE );

      /* Get some memory for the path to the local database.
	 By default I put this in the user's home directory ~/.cddb
      */
      if( ( config->local_cddb = (char *) malloc( strlen(DEFAULT_CDDB_PATH)+1 ) ) == NULL )
	{
	  return(-2);
	}
      strcpy( config->local_cddb, DEFAULT_CDDB_PATH );
      strcpy( cdinfo.local_cddb, config->local_cddb );

     /* Get some memory for the cddbd email address */
      if( ( config->to_cddbd = (char *) malloc( strlen(DEFAULT_TO_CDDBD)+1 ) ) == NULL )
	{
	  return(-2);
	}
      strcpy( config->to_cddbd, DEFAULT_TO_CDDBD );

      /* Get some memory for the SITE */
      if( ( config->server = (struct SITE *) malloc( sizeof(struct SITE) ) ) == NULL )
	{
	  return(-2);
	}

      bzero( config->server, sizeof(struct SITE) );
      
       /* Fill in the site with cddb.cddb.com */
      if( ( config->server->name = (char *) malloc( strlen(DEFAULT_SERVER)+1 ) ) == NULL )
	{
	  return(-2);
	}
      strcpy( config->server->name, DEFAULT_SERVER );
      config->server->port = 888;
      config->server->next = NULL;

      /* Set current server to the default */
      if( ( config->current = (char *) malloc( strlen(DEFAULT_SERVER)+1 ) ) == NULL )
	{
	  return(-2);
	}
      strcpy( config->current, DEFAULT_SERVER );

      config->done_eject = 0;          /* Eject when done playing */
      config->exit_eject = 0;          /* Eject on exit when not playing */
      config->startup = 1;             /* Play at startup */
      config->cddb = 0;
      config->changer = 0;
      config->saved = 0;               /* Needs to be saved */

      /* Write this as the default */
      return( write_config( config ) );
    }

  /* Process the lines in the file */
  while( fgets( line, 80, fp ) != NULL )
    {
      if( (line[0] == '#') || (line[0] == '\n') )
	continue;

      p = strtok( line, "= \n" );
      if( strcmp( p, "DEVICE" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  /* Get some memory for the device */
	  if( ( config->device = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      fclose( fp );
	      return(-2);
	    }
	  strcpy( config->device, p );

	  continue;
	}

      if( strcmp( p, "LOCAL_CDDB" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  /* Get some memory for the path to the local database.
	  */
	  if( ( config->local_cddb = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      fclose( fp );
	      return(-2);
	    }
	  strcpy( config->local_cddb, p );
	  strcpy(  cdinfo.local_cddb, p );
	  continue;
	}

      if( strcmp( p, "TO_CDDBD" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  /* Get some memory for the path to the local database.
	  */
	  if( ( config->to_cddbd = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      fclose( fp );
	      return(-2);
	    }
	  strcpy( config->to_cddbd, p );
	  continue;
	}

      if( strcmp( p, "SERVER" ) == 0 )
	{
	  p = strtok( NULL, "=: \n" );

	  /* Reserve some space for this server, add it to the end of the list */
	  if( ( sp = (struct SITE *) malloc( sizeof(struct SITE) ) ) == NULL )
	    {
	      return(-2);
	    }
	  bzero( sp, sizeof(struct SITE) );
      
	  /* Reserve space for the name */
	  if( ( sp->name = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      return(-2);
	    }
	  strcpy( sp->name, p );

	  p = strtok( NULL, "=: \n" );
	  sp->port = atoi(p);
	  sp->next = NULL;

	  /* Is it the first in the list? */
	  if( config->server == NULL )
	    {
	      /* Yep, First in the list */
	      config->server = sp;
	    } else {
	      /* Walk to the end of the list (no cuts!!) */
	      sp2 = config->server;
	      while( sp2->next != NULL )
		{
		  sp2 = sp2->next;
		}

	      /* Add the new site to the end of the list */
	      sp2->next = sp;
	    }

	  continue;
	}

      if( strcmp( p, "CURRENT" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );

	  /* Get some memory for the current server name */
	  if( ( config->current = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      fclose( fp );
	      return(-2);
	    }
	  strcpy( config->current, p );
	  continue;
	}

      if( strcmp( p, "DONE_EJECT" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  config->done_eject = atoi( p );
	  continue;
	}

      if( strcmp( p, "EXIT_EJECT" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  config->exit_eject = atoi( p );
	  set_eject( config->exit_eject );          /* Tell the CD_CONTROL device about state */
	  continue;
	}

      if( strcmp( p, "STARTUP" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  config->startup = atoi( p );
	  continue;
	}

      if( strcmp( p, "CDDB" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  config->cddb = atoi( p );
	  continue;
	}

      if( strcmp( p, "CHANGER" ) == 0 )
	{
	  p = strtok( NULL, "= \n" );
	  config->changer = atoi( p );
	  continue;
	}


    }
  fclose( fp );


  /* 
     I've added config->to_cddbd since last release, so if it wasn't read from the
     rcfile give it a default value so people don't need to erase their old rcfile
  */
  if( config->to_cddbd == NULL )
    {
      if( ( config->to_cddbd = (char *) malloc( strlen( DEFAULT_TO_CDDBD ) + 1 ) ) == NULL )
	{
	  fclose( fp );
	  return(-2);
	}
      strcpy( config->to_cddbd, DEFAULT_TO_CDDBD );
    }
  
  config->saved = 1;            /* Just read it, same as saved file */

  return 0;
}


/* ------------------------------------------------------------------------
   Write the configuration file to $HOME/.xfreecdrc
   ------------------------------------------------------------------------ */
int write_config( struct CONFIG *config )
{
  FILE  *fp;
  char  fname[1024],
        *p;
  struct SITE  *sp;

  /* Already saved, no need to save it again */
  if( config->saved == 1 )
    return(0);

  if( ( p = getenv( "HOME" ) ) == NULL )
    {
      g_print("Cannot find HOME enviornmental variable\n");
      return(-1);
    }

  strncpy( fname, p, 1023 );
  if( fname[strlen(fname)-1] != '/' )
    strcat( fname, "/" );
  strcat( fname, ".xfreecdrc" );

  if( ( fp = fopen( fname, "wb" ) ) == NULL )
    {
      return(-2);
    }

  fprintf( fp, "# XfreeCD v%s configuration file\n", VERSION );
  fprintf( fp, "#\n");
  fprintf( fp, "DEVICE=%s\n", config->device );
  fprintf( fp, "LOCAL_CDDB=%s\n", config->local_cddb );
  fprintf( fp, "TO_CDDBD=%s\n", config->to_cddbd );

  /* Walk down the list of servers */
  sp = config->server;
  while( sp != NULL )
    {
      fprintf( fp, "SERVER=%s:%d\n", sp->name, sp->port);
      sp = sp->next;
    }

  fprintf( fp, "CURRENT=%s\n", config->current );
  fprintf( fp, "DONE_EJECT=%d\n", config->done_eject );
  fprintf( fp, "EXIT_EJECT=%d\n", config->exit_eject );
  fprintf( fp, "STARTUP=%d\n", config->startup );
  fprintf( fp, "CDDB=%d\n", config->cddb );
  fprintf( fp, "CHANGER=%d\n", config->changer );

  fclose( fp );

  config->saved = 1;            /* config is now same as saved on disk */

  return 0;
}



/* -----------------------------------------------------------------------
   Free up the info used in the cdinfo structure
   ----------------------------------------------------------------------- */
void free_cdinfo()
{
  int  x;

#ifdef DEBUG8
  g_print("Freeing any used extended data\n" );
#endif

  if( cdinfo.title != NULL )
    {
      g_string_free( cdinfo.title, 1 );
      cdinfo.title = NULL;
    }

  if( cdinfo.category != NULL )
    {
      g_string_free( cdinfo.category, 1 );
      cdinfo.category = NULL;
    }

  for( x = 0; x < 99; x++ )
    {
      if( cdinfo.name[x] != NULL )
	{
	  g_string_free( cdinfo.name[x], 1 );
	  cdinfo.name[x] = NULL;
	}
    }


  if( cdinfo.extd != NULL )
    {
      g_string_free( cdinfo.extd, 1 );
      cdinfo.extd = NULL;
    }

  for( x = 0; x < 99; x++ )
    {
      if( cdinfo.extt[x] != NULL )
	{
	  g_string_free( cdinfo.extt[x], 1 );
	  cdinfo.extt[x] = NULL;
	}
    }

  /* Clean up the display's temporary storage */
  if( display.tmp_category != NULL )
    {
      g_string_free( display.tmp_category, 1 );
      display.tmp_category = NULL;
    }

  if( display.tmp_title != NULL )
    {
      g_string_free( display.tmp_title, 1 );
      display.tmp_title = NULL;
    }

  for( x = 0; x < 99; x++ )
    {
      if( display.tmp_track[x] != NULL )
	{
	  g_string_free( display.tmp_track[x], 1 );
	  display.tmp_track[x] = NULL;
	}
    }  
}


/* -----------------------------------------------------------------------
   Free up any memory used by the config structure to store the paths
   and site names.
   ----------------------------------------------------------------------- */
void free_config( struct CONFIG *config )
{
  struct SITE *sp;

  /* Need to free up memory usage */
  free( config->local_cddb );
  free( config->device );
  free( config->to_cddbd );

  /* Walk the server list, freeing up memory */
  while( config->server != NULL )
    {
      sp = config->server;
      config->server = config->server->next;
      free( sp->name );
      free( sp );
    }

  /* Free up the dynamically allocated strings in cdinfo */
  free_cdinfo();
}



/* -----------------------------------------------------------------------
   Load the CD info from the local database or set defaults
   ----------------------------------------------------------------------- */
void local_cddb()
{

#ifdef DEBUG1
  g_print("Loading local Database\n");
#endif

  /* No internet support, just try and read the local DB */
  if( read_cddb( &cdinfo ) < 0 )
    {

#ifdef DEBUG1
      g_print("Not found on disk, defaulting\n");
#endif

      /* Unknown title */
      if( cdinfo.title == NULL )
	cdinfo.title = g_string_new( "Unknown CD" );
      else
	cdinfo.title = g_string_assign( cdinfo.title, "Unknown CD" );

      if( cdinfo.category == NULL )
	cdinfo.category = g_string_new( "misc" );
      else
	cdinfo.category = g_string_assign( cdinfo.category, "misc" );

      /* Set a default revision, so they can edit the list */
      cdinfo.revision = 0;
    }	      

#ifdef DEBUG9
  g_print("local_cddb() revision = %d\n", cdinfo.revision );
#endif

}


/* -----------------------------------------------------------------------
   The Main GTK setup routine
   ----------------------------------------------------------------------- */
int run_gtk( int stat, int x_ret, int y_ret )
{
  GtkWidget	*window,
                *button,
  	        *hbox1,
  		*hbox2,
        	*table;
  GtkTooltips	*tips;
  GtkStyle	*style;
  GdkColor	tip_color;
  GdkColormap	*colormap;      
  gint          timer;
  CursorOffset  *icon_pos;
  int           x_pos, 
                y_pos;

  bzero( &config, sizeof( struct CONFIG ) );
  bzero( &display, sizeof( struct _display ) );
  bzero( &cdinfo, sizeof( struct CDINFO ) );

  cdinfo.revision = -1;                /* Initalize the revision number */

  /* Copyright info, version info */
  g_print("XfreeCD v%s\n", VERSION );
  g_print("Copyright 1998 by Brian C. Lane\n<http://www.tatoosh.com/nexus>\n\n");

  root_win = gdk_window_foreign_new (GDK_ROOT_WINDOW ());

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  display.main_window = window;
  gtk_container_border_width( GTK_CONTAINER( window ), 0 );

  /* Give it a name */
  gtk_window_set_title (GTK_WINDOW (window), "XfreeCD");
  gtk_window_set_wmclass(GTK_WINDOW(window), "XfreeCD", NULL );

  /* when the window is given the "delete_event" signal (this is given
   * by the window manager (usually the 'close' option, or on the
   * titlebar), we ask it to call the delete_event () function
   * as defined above.  The data passed to the callback
   * function is NULL and is ignored in the callback. */
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);
  
  /* here we connect the "destroy" event to a signal handler.  
   * This event occurs when we call gtk_widget_destroy() on the window,
   * or if we return 'FALSE' in the "delete_event" callback. */
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);

  gtk_widget_realize(window);

  /* Start up a new list of tool tips */
  tips = gtk_tooltips_new();

  /* Show the tooltips after the cursor has paused for 2 seconds */
  gtk_tooltips_set_delay( tips, 2000 );

  /*
   * This section fills in all the data structures used by the xpm_button
   * subroutine call to create buttons.
   * Eventually this will be more automatic/cleaner/maybe a widget?
   */
   
  ff.up_xpm = (gchar *) ffup_xpm;
  ff.dn_xpm = (gchar *) ffdn_xpm;
  ff.press = &ff_press;
  ff.release = &ff_release;

  rew.up_xpm = (gchar *) rewup_xpm;
  rew.dn_xpm = (gchar *) rewdn_xpm;
  rew.press = &rew_press;
  rew.release = &rew_release;
  
  play.up_xpm = (gchar *) stopup_xpm;
  play.dn_xpm = (gchar *) playdn_xpm;
  play.press = &play_press;
  play.release = &play_release;
  
  eject.up_xpm = (gchar *) ejup_xpm;
  eject.dn_xpm = (gchar *) ejdn_xpm;
  eject.press = &eject_press;
  eject.release = &eject_release;

  ex.up_xpm = (gchar *) exitup_xpm;
  ex.dn_xpm = (gchar *) exitdn_xpm;
  ex.press = &ex_press;
  ex.release = &ex_release;
  
  help.up_xpm = (gchar *) helpup_xpm;
  help.dn_xpm = (gchar *) helpdn_xpm;
  help.press = &help_press;
  help.release = &help_release;

  tdisp.up_xpm = (gchar *) plstrkup_xpm;
  tdisp.dn_xpm = (gchar *) plstrkdn_xpm;
  tdisp.press = &tdisp_press;
  tdisp.release = &tdisp_release;
  
  rpt.up_xpm = (gchar *) rptup_xpm;
  rpt.dn_xpm = (gchar *) rptdn_xpm;
  rpt.press = &rpt_press;
  rpt.release = &rpt_release;
  
  vol.up_xpm = (gchar *) volup_xpm;
  vol.dn_xpm = (gchar *) voldn_xpm;
  vol.press = &vol_press;
  vol.release = &vol_release;
  
  
  /* 
   *  The XfreeCD window consists of:
   *    one vertical box that contains:
   *    Two vertical boxes
   *    The top one with hbox of the display and right justified, a 3x2 table
   *    The bottom one with a hbox of 3 buttons
   */

  /* Make a vbox to hold our hboxes */
  display.vbox = gtk_vbox_new( FALSE, 0 );
  gtk_container_add( GTK_CONTAINER( window ), display.vbox );
  gtk_widget_show( display.vbox );

  /* Make a hbox to hold the bottom row of buttons REW/PLAY/FF */    
  hbox1 = gtk_hbox_new( FALSE, 0 );
  gtk_box_pack_end( GTK_BOX( display.vbox ), hbox1, FALSE, FALSE, 0 );
  gtk_widget_show( hbox1 );

  /* Make a hbox to put the table into */
  hbox2 = gtk_hbox_new( FALSE, 0 );
  gtk_box_pack_start( GTK_BOX( display.vbox ), hbox2, FALSE, FALSE, 0 );
  gtk_widget_show( hbox2 );  

  /* Make the xpm_buttons and add the tooltips for each one */
  button = xpm_button( window, &rew );
  gtk_box_pack_start( GTK_BOX( hbox1 ), button, FALSE, FALSE, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Previous Track", "ContextHelp/buttons/Prev" );

  button = xpm_button( window, &play );
  gtk_box_pack_start( GTK_BOX( hbox1 ), button, FALSE, FALSE, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Play/Pause", "ContextHelp/buttons/Play" );

  button = xpm_button( window, &ff );
  gtk_box_pack_start( GTK_BOX( hbox1 ), button, FALSE, FALSE, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Next Track", "ContextHelp/buttons/Next" );
  
  /* Make a table for the 6 control buttons */
  table = gtk_table_new( 2, 3, TRUE );

  /* Add the table to the end of the hbox (the display goes first) */
  gtk_box_pack_end( GTK_BOX( hbox2 ), table, FALSE, FALSE, 0 );

  /* Make sure it is showing */
  gtk_widget_show( table );
  
  button = xpm_button( window, &vol );
  gtk_table_attach( GTK_TABLE( table ), button, 0, 1, 0, 1, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Volume", "ContextHelp/buttons/Volume" );
  
  button = xpm_button( window, &tdisp );
  gtk_table_attach( GTK_TABLE( table ), button, 1, 2, 0, 1, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Time Display", "ContextHelp/buttons/Time" );
  
  button = xpm_button( window, &ex );
  gtk_table_attach( GTK_TABLE( table ), button, 2, 3, 0, 1, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Exit", "ContextHelp/buttons/Exit" );
  
  button = xpm_button( window, &rpt );
  gtk_table_attach( GTK_TABLE( table ), button, 0, 1, 1, 2, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Repeat", "ContextHelp/buttons/Repeat" );
  
  button = xpm_button( window, &eject );
  gtk_table_attach( GTK_TABLE( table ), button, 1, 2, 1, 2, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Eject", "ContextHelp/buttons/Eject" );
  
  button = xpm_button( window, &help );
  gtk_table_attach( GTK_TABLE( table ), button, 2, 3, 1, 2, 0, 0, 0, 0 );
  gtk_widget_show( button );
  gtk_tooltips_set_tip( tips, button, "Help", "ContextHelp/buttons/Help" );
  

  /* Get the window's style info */
  style = gtk_widget_get_style( window );

  /* Load all the other pixmaps (some are duplicates) */
  display.null_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.null_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) null_xpm );
  
  display.nodisc_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.nodisc_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) nodisc_xpm );
  
  display.minus_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.minus_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) minus_xpm );

  display.playup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.playup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) playup_xpm );

  display.playdn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.playdn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) playdn_xpm );

  display.pauseup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.pauseup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) pauseup_xpm );

  display.stopup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.stopup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) stopup_xpm );

  display.sfwddn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.sfwddn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) sfwddn_xpm );

  display.srevdn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.srevdn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) srevdn_xpm );

  display.rptupact_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.rptupact_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) rptupact_xpm );

  display.plstrkup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.plstrkup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) plstrkup_xpm );

  display.plstrkdn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.plstrkdn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) plstrkdn_xpm );

  display.mnstrkup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.mnstrkup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) mnstrkup_xpm );

  display.mnstrkdn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.mnstrkdn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) mnstrkdn_xpm );

  display.plscdup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.plscdup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) plscdup_xpm );

  display.plscddn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.plscddn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) plscddn_xpm );

  display.mnscdup_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.mnscdup_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) mnscdup_xpm );

  display.mnscddn_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.mnscddn_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) mnscddn_xpm );

  display.bar_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.bar_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) bar_xpm );

  display.nobar_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.nobar_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) nobar_xpm );

  display.redbar_pixmap = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.redbar_mask,
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) redbar_xpm );

  display.a_pixmap[0] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[0],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a0_xpm );
 
  display.a_pixmap[1] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[1],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a1_xpm );
 
  display.a_pixmap[2] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[2],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a2_xpm );
 
  display.a_pixmap[3] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[3],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a3_xpm );
 
  display.a_pixmap[4] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[4],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a4_xpm );
 
  display.a_pixmap[5] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[5],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a5_xpm );
 
  display.a_pixmap[6] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[6],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a6_xpm );
 
  display.a_pixmap[7] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[7],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a7_xpm );
 
  display.a_pixmap[8] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[8],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a8_xpm );
 
  display.a_pixmap[9] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.a_mask[9],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) a9_xpm );
 
  display.a_pixmap[10] = gdk_pixmap_create_from_xpm_d( window->window,
  		 				    &display.a_mask[10],
  		 				    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) an_xpm );
 
 
  display.b_pixmap[0] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[0],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b0_xpm );

  display.b_pixmap[1] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[1],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b1_xpm );

  display.b_pixmap[2] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[2],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b2_xpm );

  display.b_pixmap[3] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[3],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b3_xpm );

  display.b_pixmap[4] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[4],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b4_xpm );

  display.b_pixmap[5] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[5],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b5_xpm );

  display.b_pixmap[6] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[6],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b6_xpm );

  display.b_pixmap[7] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[7],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b7_xpm );

  display.b_pixmap[8] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[8],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b8_xpm );

  display.b_pixmap[9] = gdk_pixmap_create_from_xpm_d( window->window,
  						    &display.b_mask[9],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) b9_xpm );

  display.b_pixmap[10] = gdk_pixmap_create_from_xpm_d( window->window,
   						    &display.b_mask[10],
  						    &style->bg[GTK_STATE_NORMAL],
  						    (gchar **) bn_xpm );

  /*
   * Create a drawing area for us to show the track and time
   */
  display.wid = gtk_drawing_area_new();
  gtk_box_pack_start( GTK_BOX( hbox2 ), display.wid, FALSE, FALSE, 0 );
  gtk_widget_show( display.wid );

  /* Make sure it is redrawn when covered and uncovered by others */  
  gtk_signal_connect( GTK_OBJECT( display.wid ), "expose_event",
  		      (GtkSignalFunc) expose_display, NULL );

  gtk_drawing_area_size( GTK_DRAWING_AREA(display.wid), 92, 30 );
  gtk_widget_set_events( display.wid, GDK_EXPOSURE_MASK | 
                         GDK_BUTTON_MOTION_MASK |
                         GDK_POINTER_MOTION_HINT_MASK |
                         GDK_BUTTON_PRESS_MASK);

  /*  gtk_widget_realize (display.wid);*/

  gtk_signal_connect (GTK_OBJECT (display.wid), "button_press_event",
                      GTK_SIGNAL_FUNC (display_pressed),NULL);
  gtk_signal_connect (GTK_OBJECT (display.wid), "button_release_event",
                      GTK_SIGNAL_FUNC (display_released),NULL);
  gtk_signal_connect (GTK_OBJECT (display.wid), "motion_notify_event",
                      GTK_SIGNAL_FUNC (display_motion),NULL);

  /* Data area to keep track of the cursor position for moving the window */
  icon_pos = g_new (CursorOffset, 1);
  gtk_object_set_user_data(GTK_OBJECT(display.wid), icon_pos);

  x_pos = 0;
  y_pos = 0;
  /* Check the retun bits -- we want XValue & YValue */
  if( stat & XValue )
    {
      /* Is the value negative (relative to right side?) */
      if( stat & XNegative )
	{
	  /* Make sure it returned a negative value */
	  if( x_ret < 0 )
	    x_pos = (gdk_screen_width()-137) + x_ret;
	  else
	    x_pos = (gdk_screen_width()-137) - x_ret;
	} else {
	  x_pos = x_ret;
	}
    }

  /* Did we get a Y position? */
  if( stat & YValue )
    {
      /* Is the value negative (relative to bottom side?) */
      if( stat & YNegative )
	{
	  /* Make sure it returned a negative value */
	  if( y_ret < 0 )
	    y_pos = (gdk_screen_height()-60) + y_ret;
	  else
	    y_pos = (gdk_screen_height()-60) - y_ret;
	} else {
	  y_pos = y_ret;
	}
    }

#ifdef DEBUG7
  g_print("Setting x=%d  y=%d\n", x_pos, y_pos );
#endif

  /* Put the window where the user wants it (x_pos,y_pos) */
  gtk_widget_set_uposition( window, x_pos, y_pos );

  /* Setup the colors for the tooltip windows, postit yellow */
  colormap = gdk_window_get_colormap (window->window);
  tip_color.red = 61669;
  tip_color.green = 59113;
  tip_color.blue = 35979;
  gdk_color_alloc (colormap, &tip_color);

  /* Set the foreground/background of the tooltips */
  gtk_tooltips_set_colors( tips, &tip_color, &window->style->fg[GTK_STATE_NORMAL] );

  /* Showing the window last so everything pops up at once. */
  gtk_widget_show (window);

  /* Start the 1 second update timer */
  timer = gtk_timeout_add( 1000, update_cdrom, NULL );

  /*
     Read some useful info from .xfreecdrc
     Path to local database
     server list
     default server
  */
  if( read_config( &config ) < 0 )
    {
      g_print("read_config failed\n");
      g_free( icon_pos );
      exit(-1);
    }

  /* Send the device to the cd_control process */
  send_device();

  /* Tell cd_control about the exit on eject decision */
  set_eject( config.exit_eject );

  gtk_main ();

  /* Turn off the 1 second timeout */
  gtk_timeout_remove( timer );

  g_free( icon_pos );

  free_config( &config );        /* Free up config's memory usage */

  return(0);
}


gint delete_event(GtkWidget *widget, gpointer data)
{
    /* if you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal.  Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit ?'
     * type dialogs. */

    /* Change TRUE to FALSE and the main window will be destroyed with
     * a "delete_event". */

    return (FALSE);
}

/* another callback */
void destroy (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}



/* --------------------------------------------------------------
   Copy the edited data over to cdinfo and write to local database
   --------------------------------------------------------------- */
void write_tracks()
{
  GString      *old_category;
  int  x;
  char         *texts[3],
               *p,
               text1[255],
               text2[255],
               fname[1024],
               tmp_fname[1024];


  /* Sanity checks. We can't save or send if some of the important fields
     are blank.
  */
  if( display.tmp_title == NULL )
    return;

  if( display.tmp_category == NULL )
    return;

  if( cdinfo.category == NULL )
    return;

  /* Save the old category so we can erase it if its changed */
  old_category = g_string_new( cdinfo.category->str );
  
  /* Copy the new title into the cdinfo structure */
  cdinfo.title = g_string_assign( cdinfo.title, display.tmp_title->str );
  g_string_free( display.tmp_title, 1 );
  display.tmp_title = NULL;

  /* Copy the track names if they exist and delete display storage */
  for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
    {
      if( display.tmp_track[x] != NULL )
	{
	  if( cdinfo.name[x] == NULL )
	    cdinfo.name[x] = g_string_new( display.tmp_track[x]->str );
	  else
	    cdinfo.name[x] = g_string_assign( cdinfo.name[x], display.tmp_track[x]->str );
	  g_string_free( display.tmp_track[x], 1 );
	  display.tmp_track[x] = NULL;
	}
    }

  /* Copy the new categry name over */
  cdinfo.category = g_string_assign( cdinfo.category, display.tmp_category->str );

  /* Update the track window's info if its still open */
  if( display.twindow != NULL )
    {
      gtk_clist_freeze (GTK_CLIST (display.tclist));

      /* Clear out the old list first */
      gtk_clist_clear( GTK_CLIST( display.tclist ) );

      /* Set the new title */
      if( cdinfo.title != NULL )
	sprintf( text1, "%s", cdinfo.title->str );
      else
	strcpy( text1, "" );

      gtk_label_set( GTK_LABEL( display.ttitle ), text1 );

      /* Add the track names */
      for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
	{
	  sprintf( text1, "%d", x+1 );
	  sprintf( text2, "%d:%02d",cdinfo.track[x].length/60,cdinfo.track[x].length%60 );
	  texts[0] = text1;
	  texts[2] = text2;
	  if( cdinfo.name[x] != NULL )
	    texts[1] = cdinfo.name[x]->str;
	  else
	    texts[1] = "(blank)";

	  gtk_clist_append (GTK_CLIST (display.tclist), texts);
	}
      gtk_clist_thaw( GTK_CLIST( display.tclist ) );
      gtk_clist_select_row( GTK_CLIST(display.tclist), display.track-1, -1 );
    }

  /* Save to database -- overwrite previous */
  if( write_cddb( &cdinfo, 1 ) < 0 )
    {
      perror("write_cddb error");
    } else {
#ifdef DEBUG3
      g_print("Wrote %08lx ok\n", cddb_discid( &cdinfo ) );
#endif

      /* The write was successful, we can erase the old category if it is different */
      if( strcmp( cdinfo.category->str, old_category->str ) != 0 )
	{
	  /* Build the path to the old entry */
	  /* Convert a leading ~ into the user's HOME directory */
	  if( cdinfo.local_cddb[0] == '~' )
	    {
	      /* Copy the reset of the path/filename to tmp_fname */
	      strncpy( tmp_fname, &cdinfo.local_cddb[1], 1023 );

	      if( ( p = (char *) getenv("HOME") ) == NULL )
		{
		  return;
		}
	      strncpy( fname, p, 1023 );

	      /* Make sure there is a slash inbetween the two */
	      if( (fname[strlen(fname)-1] != '/') && (tmp_fname[0] != '/') )
		{
		  strcat( fname, "/" );
		}

	      strncat( fname, tmp_fname, 1023-strlen( p ) );
	    } else {
	      strncpy( fname, cdinfo.local_cddb, 1023 );
	    }

	  if( fname[strlen(fname)-1] != '/')
	    strcat( fname, "/" );

	  /* Add the category name */
	  strcat( fname, old_category->str );
	  strcat( fname, "/" );
	  sprintf( tmp_fname, "%08lx", cdinfo.discid );
	  strcat( fname, tmp_fname );

	  /* Delete it */
	  unlink( fname );
	}
    }

  g_string_free( old_category, 1 );
}



/* --------------------------------------------------------------
   Send the cdinfo to the database

   Increment the revision and save the new one to disk.
   Use a system call to mail and cat
   --------------------------------------------------------------- */
void send_cddbd( GtkWidget  *widget, GtkWidget *window)
{
  char  *p,
        tmp_fname[1024],
        fname[1024],
        buffer[1024];

  /* Close the edit window */
  gtk_widget_destroy( window );

  /* Increment the revision number */
  cdinfo.revision++;

  /* Copy all the changes to the cdinfo structure */
  write_tracks();

  /* Make sure it has a title */
  if( cdinfo.title != NULL )
    {
      /* Convert a leading ~ into the user's HOME directory */
      if( cdinfo.local_cddb[0] == '~' )
	{
	  /* Copy the reset of the path/filename to tmp_fname */
	  strncpy( tmp_fname, &cdinfo.local_cddb[1], 1023 );
	
	  if( ( p = (char *) getenv("HOME") ) == NULL )
	    {
	      return;
	    }
	  strncpy( fname, p, 1023 );

	  /* Make sure there is a slash inbetween the two */
	  if( (fname[strlen(fname)-1] != '/') && (tmp_fname[0] != '/') )
	    {
	      strcat( fname, "/" );
	    }

	  strncat( fname, tmp_fname, 1023-strlen( p ) );
	} else {
	  strncpy( fname, cdinfo.local_cddb, 1023 );
	}

      if( fname[strlen(fname)-1] != '/')
	strcat( fname, "/" );

      /* Add the category name */
      strcat( fname, cdinfo.category->str );
      strcat( fname, "/" );
      sprintf( tmp_fname, "%08lx", cdinfo.discid );
      strcat( fname, tmp_fname );

      sprintf( buffer, "cat %s | %s -s \"cddb %s %08lx\" %s", fname, MAIL_BINARY, cdinfo.category->str, cdinfo.discid, config.to_cddbd );

#ifdef MAIL_DEBUG
      g_print( "%s\n", buffer );
#else      
      /* Make a system call */
      system( buffer );
#endif
    }
}


/* --------------------------------------------------------------
   Save the new cd data to the local cd database
  --------------------------------------------------------------- */
void save_tracks( GtkWidget  *widget, GtkWidget *window)
{
  gtk_widget_destroy( window );

  /* Update cdinfo and write the new data to the local database */
  write_tracks();
}


/* ----------------------------------------------------------------------
   The track entry data has changed. Copy it to a temporary location...
   ---------------------------------------------------------------------- */
void track_entry(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;
  char         *texts[3],
               text1[255],
               text2[255];

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  if( display.tmp_track[display.tmp_row] == NULL )
    display.tmp_track[display.tmp_row] = g_string_new( entry_text );
  else
    display.tmp_track[display.tmp_row] = g_string_assign( display.tmp_track[display.tmp_row], entry_text );

  /* Update the clist in the edit window */
  if( display.tewindow != NULL )
    {
      gtk_clist_freeze (GTK_CLIST (display.teclist));
      
      /* Remove the old entry first */
      gtk_clist_remove( GTK_CLIST( display.teclist ), display.tmp_row );

      /* Insert the new data */
      sprintf( text1, "%d", display.tmp_row+1 );
      sprintf( text2, "%d:%02d",cdinfo.track[display.tmp_row].length/60,cdinfo.track[display.tmp_row].length%60 );
      texts[0] = text1;
      texts[2] = text2;
      if( display.tmp_track[display.tmp_row] != NULL )
	texts[1] = display.tmp_track[display.tmp_row]->str;
      else
	texts[1] = "(blank)";
      gtk_clist_insert (GTK_CLIST (display.teclist), display.tmp_row, texts);

      /* Select the correct row in the clist */
      gtk_clist_select_row( GTK_CLIST(display.teclist), display.tmp_row, -1 );

      gtk_clist_thaw( GTK_CLIST( display.teclist ) );

    }
}


/* -------------------------------------------------------------------
   The Title entry data has changed, copy it to a temporary location
   ------------------------------------------------------------------- */
void title_entry(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  if( display.tmp_title == NULL )
    display.tmp_title = g_string_new( entry_text );
  else
    display.tmp_title = g_string_assign( display.tmp_title, entry_text );
}


/* ----------------------------------------------------------------------
   The user selected a track, copy its data into the edit widget
   (display.teedit)
   ---------------------------------------------------------------------- */
void select_teclist (GtkWidget *widget,
		     gint row,
		     gint column,
		     GdkEventButton * bevent)
{

#ifdef DEBUG9
  g_print ("Selection: Track #%d by button %d\n", row, bevent ? bevent->button : 0 );
#endif

  if( bevent )
    {
      if( bevent->button == 1 )
	{
	  display.tmp_row = row;
	  /* Copy the track name into the edit widget */
	  if( display.tmp_track[display.tmp_row] != NULL )
	    gtk_entry_set_text( GTK_ENTRY( display.teentry ), display.tmp_track[display.tmp_row]->str);
	  else
	    gtk_entry_set_text( GTK_ENTRY( display.teentry ), "(blank)" );
	}
    }
}




/* --------------------------------------------------------------------
   If the user select a track in the tracklist window, play that
   track now.
   -------------------------------------------------------------------- */
void select_tclist (GtkWidget *widget,
              gint row,
              gint column,
              GdkEventButton * bevent)
{

#ifdef DEBUG9
  g_print ("Selection: Track #%d by button %d\n", row, bevent ? bevent->button : 0 );
#endif

  if( bevent )
    {
      if( bevent->button == 1 )
	{
	  play_track( row+1 );      
	}
    }
}




/* -----------------------------------------------------------------------
   Handle the button press events

   Each button has a xx_press and xx_release event where they change their
   pixmaps to show a up or down state.

   The FF, REW, Eject button also have to update the state of the play
   button since they can effect the state that the player is in. I'm sure
   there is a better way to do this...
   ----------------------------------------------------------------------- */


/* -----------------------------------------------------------------------
   Copy the selected item into the category
   ----------------------------------------------------------------------- */
static void menuitem_response (gchar *string)
{
  if( display.tmp_category == NULL )
    display.tmp_category = g_string_new( string );
  else
    display.tmp_category = g_string_assign( display.tmp_category, string );
}


/* -----------------------------------------------------------------------
   Start up the window for editing the track list.
   Close the normal track list while doing this.
   Save it to cddb format when close is clicked.
   Don't save when Cancel is clicked.
   ----------------------------------------------------------------------- */
static void edit_tracks(GtkWidget *widget, GtkWidget *data)
{
  GtkWidget    *vbox1,
               *hbox1,
               *button,
               *edit,
               *optionmenu,
               *menu,
               *menuitem;
  int          x,
               curr_cat;
  char         *texts[3],
               text1[255],
               text2[255];
  static char  *titles[] =
  {
    "Track #",
    "Title",
    "Length"
  };
  static char  *categories[] =
  {
    "blues",
    "classical",
    "country",
    "data",
    "folk",
    "jazz",
    "misc",
    "newage",
    "reggae",
    "rock",
    "soundtrack"
  };


  /* Don't allow edit if there's no disk */
  if( display.status == CDROM_NODISC )
    return;

  if (!display.tewindow)
    {
      display.tewindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_usize (display.tewindow, 300, 400);
      
      gtk_signal_connect (GTK_OBJECT (display.tewindow), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			  &display.tewindow);

      gtk_window_set_title (GTK_WINDOW (display.tewindow), "Edit Track Info" );
      gtk_container_border_width (GTK_CONTAINER (display.tewindow), 4);
      gtk_window_set_wmclass(GTK_WINDOW(display.tewindow), "XfreeCDet", NULL );

      /* create a vbox to hold the clist and buttons */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (display.tewindow), vbox1);
      gtk_widget_show (vbox1);

      /* Make a hbox to hold discid and category dropdown */
      hbox1 = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start( GTK_BOX( vbox1 ), hbox1, FALSE, FALSE, 2 );
      gtk_widget_show (hbox1);

      /* Need to show the disc id and category */
      /* Maybe category should be a drop-down listing of the standard categories? */
      sprintf( text1, "Discid: 0x%08lx   Category : ", cdinfo.discid );
      button = gtk_label_new( text1 );
      gtk_box_pack_start( GTK_BOX( hbox1 ), button, FALSE, FALSE, 2 );
      gtk_widget_show( button );

      /* Optionmenu for selecting the category */
      optionmenu = gtk_option_menu_new();
      menu = gtk_menu_new();

      curr_cat = 0;
      /* Add the categories */
      for( x = 0; x < 11; x++ )
	{
	  /* Set the current category */
	  if( cdinfo.category != NULL )
	    {
	      if( strcmp( cdinfo.category->str, categories[x] ) == 0 )
		{
		  curr_cat = x;
		  if( display.tmp_category == NULL )
		    display.tmp_category = g_string_new( cdinfo.category->str );
		  else
		    display.tmp_category = g_string_assign( display.tmp_category, cdinfo.category->str );
		}
	    } else {
	      display.tmp_category= g_string_new( categories[0] );
	    }
	  menuitem = gtk_menu_item_new_with_label( categories[x] );
	  gtk_menu_append (GTK_MENU (menu), menuitem);
	  gtk_signal_connect_object( GTK_OBJECT(menuitem), "activate",
	      GTK_SIGNAL_FUNC(menuitem_response), (gpointer) categories[x] );
	  gtk_widget_show (menuitem);
	}
      gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
      gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), curr_cat );
      gtk_box_pack_start (GTK_BOX (hbox1), optionmenu, FALSE, FALSE, 0);
      gtk_widget_show (optionmenu);



      /* Entry Widget for the title of the CD */
      edit = gtk_entry_new_with_max_length( 254 );
      gtk_signal_connect(GTK_OBJECT(edit), "changed",
			 GTK_SIGNAL_FUNC(title_entry),
			 edit);

      if( cdinfo.title != NULL )
	gtk_entry_set_text( GTK_ENTRY( edit ), cdinfo.title->str );
      gtk_editable_select_region( GTK_EDITABLE( edit ), 0, -1 );
      gtk_box_pack_start( GTK_BOX( vbox1 ), edit, FALSE, FALSE, 2 );
      gtk_widget_show( edit );

      /* Initalize the title */
      if( cdinfo.title != NULL )
	display.tmp_title = g_string_new( cdinfo.title->str );

      /* Entry Widget for the track name-changed by selecting a diff. track */
      display.teentry = gtk_entry_new_with_max_length( 254 );
      gtk_box_pack_start( GTK_BOX( vbox1 ), display.teentry, FALSE, FALSE, 2 );
      gtk_widget_show( display.teentry );

      /* Create the clist */
      display.teclist = gtk_clist_new_with_titles (3, titles);
      gtk_clist_set_row_height (GTK_CLIST (display.teclist), 20);
      gtk_clist_set_column_width (GTK_CLIST (display.teclist), 0, 45);
      gtk_clist_set_column_width (GTK_CLIST (display.teclist), 1, 150);
      gtk_clist_set_column_width (GTK_CLIST (display.teclist), 2, 45);
      gtk_signal_connect (GTK_OBJECT (display.teclist),
			  "select_row",
			  (GtkSignalFunc) select_teclist,
			  NULL);
#ifdef GOOBER
      gtk_clist_set_selection_mode (GTK_CLIST (display.teclist), GTK_SELECTION_BROWSE);
#endif
      gtk_clist_set_policy (GTK_CLIST (display.teclist),
			    GTK_POLICY_AUTOMATIC,
			    GTK_POLICY_AUTOMATIC);

      gtk_clist_set_column_justification (GTK_CLIST (display.teclist), 0, GTK_JUSTIFY_CENTER);
      gtk_clist_set_column_justification (GTK_CLIST (display.teclist), 1, GTK_JUSTIFY_LEFT);
      gtk_clist_set_column_justification (GTK_CLIST (display.teclist), 2, GTK_JUSTIFY_LEFT);
	  
      gtk_clist_freeze (GTK_CLIST (display.teclist));

      display.tmp_row = 0;
      /* Add the track names */
      for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
	{
	  sprintf( text1, "%d", x+1 );
	  sprintf( text2, "%d:%02d",cdinfo.track[x].length/60,cdinfo.track[x].length%60 );
	  texts[0] = text1;
	  texts[2] = text2;
	  if( cdinfo.name[x] != NULL )
	    texts[1] = cdinfo.name[x]->str;
	  else
	    texts[1] = "(blank)";
	  gtk_clist_append (GTK_CLIST (display.teclist), texts);

	  /* Initalize the temporary storage */
	  if( cdinfo.name[x] != NULL )
	    display.tmp_track[x] = g_string_new( cdinfo.name[x]->str );
	  else
	    display.tmp_track[x] = NULL;
	}
      gtk_clist_thaw( GTK_CLIST( display.teclist ) );
	  
      gtk_container_border_width (GTK_CONTAINER (display.teclist), 5);
      gtk_box_pack_start (GTK_BOX (vbox1), display.teclist, TRUE, TRUE, 0);
      gtk_widget_show (display.teclist);

      /* Now we can update the track edit control, since the tclist is setup */
      gtk_signal_connect(GTK_OBJECT(display.teentry), "changed",
			 GTK_SIGNAL_FUNC(track_entry),
			 display.teentry);
      if( display.tmp_track[0] != NULL )
	gtk_entry_set_text( GTK_ENTRY( display.teentry ), display.tmp_track[0]->str );
      gtk_editable_select_region( GTK_EDITABLE( display.teentry ), 0, -1 );

      button = gtk_button_new_with_label ("Send To Server");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC(send_cddbd),
				 GTK_OBJECT (display.tewindow));
      gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 2);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Save");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC(save_tracks),
				 GTK_OBJECT (display.tewindow));
      gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 2);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC(gtk_widget_destroy),
				 GTK_OBJECT (display.tewindow));
      gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 2);
      gtk_widget_show (button);

      gtk_widget_show( display.tewindow );
    }
}



/*
   Handle button press in the display window.
   Determine if its a click for a track list or a drag to move the window
*/
static void display_pressed (GtkWidget *widget, GdkEventButton *event)
{
  CursorOffset *p;
  GtkWidget    *vbox1,
               *button;
  int          x;
  char         *texts[3],
               text1[255],
               text2[255];
  static char  *titles[] =
  {
    "Track #",
    "Title",
    "Length"
  };


  /* ignore double and triple click */
  if (event->type != GDK_BUTTON_PRESS)
    return;

  /* Right button is move window */
  if( event->button == 3 )
    {
      if( ( p = gtk_object_get_user_data (GTK_OBJECT(widget)) ) != NULL )
	{
	  p->x = (int) event->x;
	  p->y = (int) event->y;

	  gtk_grab_add (widget);
	  gdk_pointer_grab (widget->window, TRUE,
			    GDK_BUTTON_RELEASE_MASK |
			    GDK_BUTTON_MOTION_MASK |
			    GDK_POINTER_MOTION_HINT_MASK,
			    NULL, NULL, 0);
	}
    } else if( event->button == 1 ) {
      /* Show the title and the tracks, using a clist */
      if (!display.twindow)
	{
	  display.twindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	  gtk_widget_set_usize (display.twindow, 300, 350);

	  gtk_signal_connect (GTK_OBJECT (display.twindow), "destroy",
			      GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			      &display.twindow);

	  /*	  gtk_window_set_title (GTK_WINDOW (display.twindow), cdinfo.title); */
	  gtk_container_border_width (GTK_CONTAINER (display.twindow), 4);
	  gtk_window_set_wmclass(GTK_WINDOW(display.twindow), "XfreeCDt", NULL );

	  /* create a vbox to hold the clist and buttons */
	  vbox1 = gtk_vbox_new (FALSE, 0);
	  gtk_container_add (GTK_CONTAINER (display.twindow), vbox1);
	  gtk_widget_show (vbox1);

	  if( cdinfo.title != NULL )
	    sprintf( text1, "%s", cdinfo.title->str );
	  else
	    strcpy( text1, "" );
	  display.ttitle = gtk_label_new( text1 );
	  gtk_box_pack_start( GTK_BOX( vbox1 ), display.ttitle, FALSE, FALSE, 0 );
	  gtk_widget_show( display.ttitle );

	  /* Create the clist */
	  display.tclist = gtk_clist_new_with_titles (3, titles);
	  gtk_clist_set_row_height (GTK_CLIST (display.tclist), 20);
	  gtk_clist_set_column_width (GTK_CLIST (display.tclist), 0, 45);
	  gtk_clist_set_column_width (GTK_CLIST (display.tclist), 1, 150);
	  gtk_clist_set_column_width (GTK_CLIST (display.tclist), 2, 45);
	  gtk_signal_connect (GTK_OBJECT (display.tclist),
			      "select_row",
			      (GtkSignalFunc) select_tclist,
			      NULL);

#ifdef GOOBER
	  gtk_clist_set_selection_mode (GTK_CLIST (display.tclist), GTK_SELECTION_BROWSE);
#endif
	  gtk_clist_set_policy (GTK_CLIST (display.tclist),
				GTK_POLICY_AUTOMATIC,
				GTK_POLICY_AUTOMATIC);

	  gtk_clist_set_column_justification (GTK_CLIST (display.tclist), 0, GTK_JUSTIFY_CENTER);
	  gtk_clist_set_column_justification (GTK_CLIST (display.tclist), 1, GTK_JUSTIFY_LEFT);
	  gtk_clist_set_column_justification (GTK_CLIST (display.tclist), 2, GTK_JUSTIFY_LEFT);

	  if( display.status != CDROM_NODISC )
	    {
	      gtk_clist_freeze (GTK_CLIST (display.tclist));
	      /* Add the track names */
	      for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
		{
		  sprintf( text1, "%d", x+1 );
		  sprintf( text2, "%d:%02d",cdinfo.track[x].length/60,cdinfo.track[x].length%60 );
		  texts[0] = text1;
		  texts[2] = text2;
		  if( cdinfo.name[x] != NULL )
		    texts[1] = cdinfo.name[x]->str;
		  else
		    texts[1] = "(blank)";
		  gtk_clist_append (GTK_CLIST (display.tclist), texts);
		}
	      gtk_clist_thaw( GTK_CLIST( display.tclist ) );
	    }

	  gtk_container_border_width (GTK_CONTAINER (display.tclist), 5);
	  gtk_box_pack_start (GTK_BOX (vbox1), display.tclist, TRUE, TRUE, 0);
	  gtk_widget_show (display.tclist);

	  button = gtk_button_new_with_label ("Edit Info");
	  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				     GTK_SIGNAL_FUNC(edit_tracks),
				     GTK_OBJECT (display.twindow));
	  gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 2);
	  gtk_widget_show (button);

	  button = gtk_button_new_with_label ("Close");
	  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				     GTK_SIGNAL_FUNC(gtk_widget_destroy),
				     GTK_OBJECT (display.twindow));

	  gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 2);
	  /*	  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); */
	  /*	  gtk_widget_grab_default (button); */
	  gtk_widget_show (button);
	  gtk_widget_show( display.twindow );
	}
    }
}


static void display_released (GtkWidget *widget)
{
  gtk_grab_remove (widget);
  gdk_pointer_ungrab (0);
}


static void display_motion (GtkWidget *widget, GdkEventMotion *event)
{
  gint xp, yp;
  CursorOffset * p;
  GdkModifierType mask;

  if( ( p = gtk_object_get_user_data (GTK_OBJECT (widget)) ) != NULL )
    {
      /*
       * Can't use event->x / event->y here 
       * because I need absolute coordinates.
       */
      gdk_window_get_pointer (root_win, &xp, &yp, &mask);
      gtk_widget_set_uposition (display.main_window, xp  - p->x, yp  - p->y);
    }
}




void ff_press (GtkWidget *widget, GdkEventButton *event)
{
  /* Left button pressed */
  if( event->button == 1 )
  {
    /* Set the FF down image */
    gtk_pixmap_set( GTK_PIXMAP( ff.wid ),
                    ff.image.dn_pixmap,
                    ff.image.dn_mask );

    /* Tell the CD control to play the next track */
    play_next();
     

    /* Update the state of the play button -- Should be a subroutine */
    if( (display.playbtn != CDROM_PLAYING) && (display.status != CDROM_NODISC))
      {
     	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
     			display.playup_pixmap,
     			display.playup_mask );
     	display.playbtn = CDROM_PLAYING;
      }
  }
}


void ff_release (GtkWidget *widget, GdkEventButton *event)
{
  if( (event->button == 1) )
  {
    /* Draw the button up image */
    gtk_pixmap_set( GTK_PIXMAP( ff.wid ),
                    ff.image.up_pixmap,
                    ff.image.up_mask );
  }
}


void rew_press (GtkWidget *widget, GdkEventButton *event)                              
{
  /* Left button pressed */
  if( event->button == 1 )
  {
    /* Draw the down image for REW */
    gtk_pixmap_set( GTK_PIXMAP( rew.wid ),
                    rew.image.dn_pixmap,
                    rew.image.dn_mask );

    /* Tell the CD to play the previous track */
    play_previous();
    

    /* Update the state of the Play button -- should be a subroutine */
    if( (display.playbtn != CDROM_PLAYING) && (display.status != CDROM_NODISC))
      {
     	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
     			display.playup_pixmap,
     			display.playup_mask );
     	display.playbtn = CDROM_PLAYING;
      }
     
  }
}


void rew_release (GtkWidget *widget, GdkEventButton *event)
{
  if( (event->button == 1) )
  {
    /* Draw the up image for the button */
    gtk_pixmap_set( GTK_PIXMAP( rew.wid ),
                    rew.image.up_pixmap,
                    rew.image.up_mask );
  }
}


void play_press (GtkWidget *widget, GdkEventButton *event)                              
{
  int x;

  /* Left button press */
  if( event->button == 1 )
  {
    /* Depending on the current state of the button, display the correct image */
    switch( display.playbtn )
    {
      case CDROM_PLAYING:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.playdn_pixmap,
                    				display.playdn_mask );
                                pause_cdrom();
				display.playbtn = CDROM_PAUSED;
      				break;

      case CDROM_PAUSED:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.playdn_pixmap,
                    				display.playdn_mask );
                                resume_cdrom();
				display.playbtn = CDROM_PLAYING;
      				break;

      case CDROM_NODISC:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.playdn_pixmap,
                    				display.playdn_mask );

                                play_track( 1 );
				update_display();
				display.playbtn = CDROM_PLAYING;
				break;
    }    
  } else if( event->button ==3 ) {
    /* Stop playing without ejecting the CD */
    switch( display.playbtn )
      {

      case CDROM_PLAYING :	
      case CDROM_PAUSED :
	stop_cdrom();
	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
			display.playdn_pixmap,
			display.playdn_mask );
	update_display();
	display.playbtn = CDROM_NODISC;

	/* Clear out the track list */
	if( display.twindow != NULL )
	  {
	  gtk_clist_clear( GTK_CLIST( display.tclist ) );

	  /* Clear the title */
	  gtk_label_set( GTK_LABEL( display.ttitle ), "" );
	  }

	/* Erase the title and track names */
	if( cdinfo.title != NULL )
	  {
	    g_string_free( cdinfo.title, 1 );
	    cdinfo.title = NULL;
	  }

	for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
	  {
	    if( cdinfo.name[x] != NULL )
	      {
		g_string_free( cdinfo.name[x], 1 );
		cdinfo.name[x] = NULL;
	      }
	  }

	/* Free up dynamically allocated cdinfo strings */
	free_cdinfo();
	break;

      case CDROM_NODISC :
	break;
    }
  }
}


void play_release (GtkWidget *widget, GdkEventButton *event)
{
  if( (event->button == 1) || (event->button ==3) )
  {
    switch( display.playbtn )
    {
      case CDROM_PAUSED:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.pauseup_pixmap,
                    				display.pauseup_mask );
    				break;

      case CDROM_PLAYING:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.playup_pixmap,
                    				display.playup_mask );
    				break;

      case CDROM_NODISC:	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
                    				display.stopup_pixmap,
                    				display.stopup_mask );
    				break;

    }
  }
}


void eject_press (GtkWidget *widget, GdkEventButton *event)                              
{
  int x;

  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( eject.wid ),
                    eject.image.dn_pixmap,
                    eject.image.dn_mask );


    /*
     * If we are playing or paused then we will be stopped, so change
     * the play button to the stop button
     */
    switch( display.status )
      {
      case CDROM_PAUSED :
      case CDROM_PLAYING :
	gtk_pixmap_set( GTK_PIXMAP( play.wid ),
			display.stopup_pixmap,
			display.stopup_mask );
	display.playbtn = CDROM_NODISC;
	break;
      }
    eject_cdrom();
    display.playbtn = CDROM_NODISC;
    gdk_draw_pixmap( display.wid->window,
		     display.wid->style->black_gc,
		     display.nodisc_pixmap,
		     0, 0,
		     0, 0, 92, 30 );

    /* Clear out the track list */
    if( display.twindow != NULL )
      {
	gtk_clist_clear( GTK_CLIST( display.tclist ) );

	/* Clear the title */
	gtk_label_set( GTK_LABEL( display.ttitle ), "" );
      }


    /* Erase the title and track names */
    if( cdinfo.title != NULL )
      {
	g_string_free( cdinfo.title, 1 );
	cdinfo.title = NULL;
      }

    for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
      {
	if( cdinfo.name[x] != NULL )
	  {
	    g_string_free( cdinfo.name[x], 1 );
	    cdinfo.name[x] = NULL;
	  }
      }

    /* Free up the dynamically allocated cdinfo strings */
    free_cdinfo();
  }
}


void eject_release (GtkWidget *widget, GdkEventButton *event)
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( eject.wid ),
                    eject.image.up_pixmap,
                    eject.image.up_mask );
  }
}


gint ex_timer( gpointer data )
{
  gtk_timeout_remove( ex.timer );

  gtk_main_quit();

  return FALSE;
}


void ex_press (GtkWidget *widget, GdkEventButton *event)                              
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( ex.wid ),
                    ex.image.dn_pixmap,
                    ex.image.dn_mask );

    /* In 100mS execute the play_next function */
    ex.timer = gtk_timeout_add( 500, ex_timer, NULL );

  }
}


void ex_release (GtkWidget *widget, GdkEventButton *event)
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( ex.wid ),
                    ex.image.up_pixmap,
                    ex.image.up_mask );
  }
}


void
destroy_window (GtkWidget  *widget,
                GtkWidget **window)
{
  *window = NULL;
}


void close_setup( GtkWidget  *widget, GtkWidget *window)
{
  gtk_widget_destroy( window );

  /* Write configuration */
  write_config( &config );

  /* Send the new device to the cd_control process */
  send_device();
}


/* Toggle the state of the cddb button */
static void toggle_cddb (GtkWidget *checkbutton,
		       GtkWidget *text)
{
  config.cddb = GTK_TOGGLE_BUTTON(checkbutton)->active;

#ifdef DEBUG3
  g_print("Toggling cddb = %d\n", config.cddb );
#endif

  config.saved = 0;            /* Needs to be written to disk */
}


#ifdef CHANGER_SUPPORT
/* Toggle the CD changer support button */
static void toggle_changer (GtkWidget *checkbutton,
		       GtkWidget *text)
{
  config.changer = GTK_TOGGLE_BUTTON(checkbutton)->active;

#ifdef DEBUG3
  g_print("Toggling changer = %d\n", config.changer );
#endif

  config.saved = 0;            /* Needs to be written to disk */
}
#endif


/* Toggle the Eject when done playing */
static void toggle_eject_done(GtkWidget *checkbutton,
		       GtkWidget *text)
{
  config.done_eject = GTK_TOGGLE_BUTTON(checkbutton)->active;

#ifdef DEBUG3
  g_print("Toggling done_eject = %d\n", config.done_eject );
#endif

  config.saved = 0;            /* Needs to be written to disk */
}


/* Toggle the Eject at Close */
static void toggle_eject_exit(GtkWidget *checkbutton,
		       GtkWidget *text)
{
  config.exit_eject = GTK_TOGGLE_BUTTON(checkbutton)->active;

#ifdef DEBUG3
  g_print("Toggling exit_eject = %d\n", config.exit_eject );
#endif

  set_eject( config.exit_eject );
  config.saved = 0;            /* Needs to be written to disk */
}

static void toggle_startup(GtkWidget *checkbutton,
		       GtkWidget *text)
{
  config.startup = GTK_TOGGLE_BUTTON(checkbutton)->active;
  config.saved = 0;            /* Needs to be written to disk */
}


void cddb_servers()
{

  /* Placeholder for server listing/editing */
}


static void
page_switch (GtkWidget *widget, GtkNotebookPage *page, gint page_num)
{
  GtkNotebookPage *oldpage;

  oldpage = GTK_NOTEBOOK (widget)->cur_page;

  if (page == oldpage)
    return;

}


void device_entry(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  config.device = realloc( config.device, strlen(entry_text)+1);
  strcpy( config.device, entry_text );
  config.saved = 0;            /* Needs to be written to disk */
}

void cddb_entry(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  config.local_cddb = realloc( config.local_cddb, strlen(entry_text)+1);
  strcpy( config.local_cddb, entry_text );
  strcpy( cdinfo.local_cddb, entry_text );

  config.saved = 0;            /* Needs to be written to disk */
}

void cddb_to_email(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  config.to_cddbd = realloc( config.to_cddbd, strlen(entry_text)+1);
  strcpy( config.to_cddbd, entry_text );

  config.saved = 0;            /* Needs to be written to disk */
}


void server_entry(GtkWidget *widget, GtkWidget *entry)
{
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

  config.current = realloc( config.current, strlen(entry_text)+1);
  strcpy( config.current, entry_text );
  config.saved = 0;            /* Needs to be written to disk */
}


void refresh_servers()
{
  char buffer[80];

  /* Need to lock this routine until we complete the last request */
  if( display.cddb_lock == 0 )
    {
      /* Get the server list from cddb.cddb.com - DB_SITES */
      /* Tell it to print the diagnostic string */
      cdinfo.cddbd_cmnd = DB_SITES;

      /* Set the server to connect to */
      strncpy( cdinfo.server, "cddb.cddb.com", 80 );
      cdinfo.port = 888;
      if( write( cddbd_fd, &cdinfo, sizeof( struct CDINFO ) ) < 0 )
	{
	  perror("write to cddbd error");
	}

      display.cddb_lock = 1;
     
      /* Start up a progress dialog */
      display.progress = gtk_dialog_new ();

      sprintf( buffer, "Connecting to %s:%d", cdinfo.server, cdinfo.port );

      gtk_signal_connect( GTK_OBJECT( display.progress ), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
                          &display.progress);

      gtk_window_set_title (GTK_WINDOW (display.progress), "CDDBD Status");
      gtk_container_border_width (GTK_CONTAINER (display.progress), 0);
      gtk_window_set_wmclass(GTK_WINDOW(display.progress), "XfreeCDp", NULL );

      display.plabel = gtk_label_new (buffer);
      gtk_misc_set_padding (GTK_MISC (display.plabel), 10, 10);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->vbox),
                          display.plabel, FALSE, FALSE, 0);
      gtk_widget_show( display.plabel );
      gtk_widget_show( display.progress );
    }
}


/* -----------------------------------------------------------------------
   Display the help/setup dialog box

   All changed info is saved when this dialog is exited.
   ----------------------------------------------------------------------- */
gint help_timer( gpointer data )
{
  struct SITE       *sp;
  static GtkWidget  *window = NULL;
  GtkWidget         *notebook,
                    *text,
                    *vbox1,
                    *vbox2,
                    *label,
                    *button,
                    *table,
                    *hscrollbar,
                    *vscrollbar,
                    *edit;
  GList             *cbitems = NULL;


  gtk_timeout_remove( help.timer );   
  help.timer = 0;

  /* Create the main window for the notebook */
  if( !window )
    {
      window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                          &window);

      gtk_window_set_title (GTK_WINDOW (window), "notebook");
      gtk_container_border_width (GTK_CONTAINER (window), 0);
      gtk_window_set_title (GTK_WINDOW( window ), "XfreeCD Setup");
      gtk_widget_set_usize (window, 250, 300);
      gtk_window_set_wmclass(GTK_WINDOW(window), "XfreeCDs", NULL );
 
      /* Create a vbox to hold the notebook */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (window), vbox1);

      /* Create the notebook */
      notebook = gtk_notebook_new ();
      gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
                          GTK_SIGNAL_FUNC (page_switch), NULL);
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
      gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);
      gtk_container_border_width (GTK_CONTAINER (notebook), 10);
      gtk_widget_realize (notebook);

      /* Create the about page for the notebook -- Put a text window in it */
      vbox2 = gtk_vbox_new( FALSE, 0 );
      gtk_widget_show( vbox2 );

      table = gtk_table_new (2, 2, FALSE);
      gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      gtk_box_pack_start (GTK_BOX (vbox2), table, TRUE, TRUE, 0);
      gtk_widget_show (table);

      text = gtk_text_new (NULL, NULL);
      gtk_text_set_editable (GTK_TEXT (text), FALSE);
      gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (text);

      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
                        GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
      gtk_widget_show (hscrollbar);

      vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
      gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
                        GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (vscrollbar);

      /* Create the label box for the About page */
      label = gtk_label_new ("About");
      
      /* Add it to the notebook */
      gtk_notebook_append_page_menu (GTK_NOTEBOOK(notebook), vbox2, label, label  );

      gtk_text_freeze (GTK_TEXT (text));

      gtk_widget_realize (text);

      /* Add the actual text */
      HELP_TEXT( "XfreeCD v0.7.7\n" );
      HELP_TEXT( "Copyright 1998 Brian C. Lane\n" );
      HELP_TEXT( "<nexus@tatoosh.com>\n" );
      HELP_TEXT( "http://www.tatoosh.com/nexus\n\n" );

      HELP_TEXT( "Click on the 'SETUP' tab to set the\n" );
      HELP_TEXT( "CD device and some options:\n\n" );
      HELP_TEXT( "AutoPlay will start playing the CD\n" );
      HELP_TEXT( "when XfreeCD is started\n\n" );
      HELP_TEXT( "Eject when done will eject the CD\n" );
      HELP_TEXT( "when it is finished playing if repeat\n" );
      HELP_TEXT( "is not turned on (the button on the\n" );
      HELP_TEXT( "main panel).\n\n" );
      HELP_TEXT( "Eject on Exit will eject the CD if it\n");
      HELP_TEXT( "is not playing when you exit.\n\n" );
      HELP_TEXT( "Click on the 'CDDB' tab to set up\n" );
      HELP_TEXT( "the support for online cd database\n" );
      HELP_TEXT( "support. The Local CDDB Path\n" );
      HELP_TEXT( "should point to a directory where\n" );
      HELP_TEXT( "you have read and write\n");
      HELP_TEXT( "permission. This is where the\n" );
      HELP_TEXT( "track lists for the CDs will be\n");
      HELP_TEXT( "saved.\n\n");
      HELP_TEXT( "The CDDB Submit email field is for\n" );
      HELP_TEXT( "the email address of the CDDB\n");
      HELP_TEXT( "server to submit CD information\n" );
      HELP_TEXT( "to. The send button is located\n" );
      HELP_TEXT( "in the Track Edit window. Please\n" );
      HELP_TEXT( "only submit CDs that do not exist\n");
      HELP_TEXT( "in the database and that have\n" );
      HELP_TEXT( "complete title and track text\n" );
      HELP_TEXT( "entered.\n\n" );
      HELP_TEXT( "The CDDB server is the internet\n" );
      HELP_TEXT( "site where requests for unknown\n" );
      HELP_TEXT( "CDs will be sent to. Initially only\n" );
      HELP_TEXT( "cddb.cddb.com is listed. Click\n");
      HELP_TEXT( "Refresh Server List to download a\n");
      HELP_TEXT( "list of the available servers.\n" );
      HELP_TEXT( "Use the combobox to pick a server\n" );
      HELP_TEXT( "close to you. If you unselect cddb\n" );
      HELP_TEXT( "support the internet server will\n" );
      HELP_TEXT( "not be queried, but the local\n" );
      HELP_TEXT( "database will be used.\n\n" );
      HELP_TEXT( "Right click & drag on the main\n");
      HELP_TEXT( "display window will allow you to\n" );
      HELP_TEXT( "move XfreeCD even when you\n");
      HELP_TEXT( "have title bars and handles. Left\n");
      HELP_TEXT( "Clicking on the display will open\n");
      HELP_TEXT( "up the Track List window.\n\n" );
      HELP_TEXT( "In the Track List window you can\n");
      HELP_TEXT( "click on the title of a track and\n");
      HELP_TEXT( "XfreeCD will jump directly to\n" );
      HELP_TEXT( "that track and play it.\n\n" );
      HELP_TEXT( "Right clicking on the play/pause\n");
      HELP_TEXT( "button will stop playing and\n");
      HELP_TEXT( "turn off the CD player.\n\n");
      HELP_TEXT( "Volume is controlled by left/right\n");
      HELP_TEXT( "clicking on the volume button.\n\n");
      HELP_TEXT( "Thanks to Ti Kan and Steve Scherf\n" );
      HELP_TEXT( "for creating CDDB.\n\n" );

      gtk_text_thaw (GTK_TEXT (text));

      /* Add the general setup page */
      vbox2 = gtk_vbox_new( FALSE, 0 );
      gtk_widget_show( vbox2 );

      /* Add an editable field for the device */
      label = gtk_label_new ("CDROM device:");
      gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
      gtk_widget_show (label);

      edit = gtk_entry_new_with_max_length(20);
      gtk_signal_connect(GTK_OBJECT(edit), "changed",
			 GTK_SIGNAL_FUNC(device_entry),
			 edit);
      gtk_widget_show( edit );

#ifdef DEBUG3
      g_print("config.device = %s\n", config.device );
#endif

      if( config.device != NULL )
	gtk_entry_set_text( GTK_ENTRY( edit ), config.device );
      gtk_editable_select_region( GTK_EDITABLE( edit ), 0, -1 );
      gtk_box_pack_start( GTK_BOX( vbox2 ), edit, FALSE, FALSE, 0 );
      gtk_widget_show( edit );

#ifdef DEBUG3
      g_print("config.startup = %d\n", config.startup );
#endif
      
      /* Create a check button for Playing at Startup */
      button = gtk_check_button_new_with_label("AutoPlay");
      gtk_box_pack_start( GTK_BOX( vbox2 ), button, FALSE, FALSE, 0 );
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), (config.startup == 1));
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( toggle_startup ), NULL );
      gtk_widget_show( button );

#ifdef DEBUG3
      g_print("config.changer = %d\n", config.changer );
#endif

#ifdef CHANGER_SUPPORT
      /* Create a check button for CD Changer */
      button = gtk_check_button_new_with_label("CD Changer");
      gtk_box_pack_start( GTK_BOX( vbox2 ), button, FALSE, FALSE, 0 );
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), (config.changer == 1));
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( toggle_changer ), NULL );
      gtk_widget_show( button );
#endif

#ifdef DEBUG3
      g_print("config.done_eject = %d\n", config.done_eject );
#endif

      /* Create a check button for Eject on Close */
      button = gtk_check_button_new_with_label("Eject when done");
      gtk_box_pack_start( GTK_BOX( vbox2 ), button, FALSE, FALSE, 0 );
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), (config.done_eject==1));
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( toggle_eject_done ), NULL );
      gtk_widget_show( button );

      /* Create a check button for Eject on Exit (and not playing) */
      button = gtk_check_button_new_with_label("Eject on Exit");
      gtk_box_pack_start( GTK_BOX( vbox2 ), button, FALSE, FALSE, 0 );
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), (config.exit_eject==1));
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( toggle_eject_exit ), NULL );
      gtk_widget_show( button );

      
      /* Create the label box for the Setup page */
      label = gtk_label_new ("Setup");
      
      /* Add it to the notebook */
      gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ), vbox2, label, label );


      /* Create the CDDB page for the notebook */
      vbox2 = gtk_vbox_new( FALSE, 0 );
      gtk_widget_show( vbox2 );

       /* Path to the local cddb database */
      label = gtk_label_new( "Local CDDB Path" );
      gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
      gtk_widget_show (label);

     /* Add an editable field for the local CDDBD database */
      edit = gtk_entry_new_with_max_length( 1023 );
      gtk_signal_connect(GTK_OBJECT(edit), "changed",
			 GTK_SIGNAL_FUNC(cddb_entry),
			 edit);
      gtk_widget_show( edit );

#ifdef DEBUG3
      g_print("config.local_cddb = %s\n", config.local_cddb );
#endif

      if( config.local_cddb != NULL )
	gtk_entry_set_text( GTK_ENTRY( edit ), config.local_cddb );
      gtk_editable_select_region( GTK_EDITABLE( edit ), 0, -1 );
      gtk_box_pack_start( GTK_BOX( vbox2 ), edit, FALSE, FALSE, 0 );
      gtk_widget_show( edit );

       /* Email address for submitting to the database */
      label = gtk_label_new( "CDDB Submit Email" );
      gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
      gtk_widget_show (label);

      /* Add an editable field for the email address */
      edit = gtk_entry_new_with_max_length( 1023 );
      gtk_signal_connect(GTK_OBJECT(edit), "changed",
			 GTK_SIGNAL_FUNC(cddb_to_email),
			 edit);
      gtk_widget_show( edit );

#ifdef DEBUG3
      g_print("config.local_cddb = %s\n", config.local_cddb );
#endif

      if( config.to_cddbd != NULL )
	gtk_entry_set_text( GTK_ENTRY( edit ), config.to_cddbd );
      gtk_editable_select_region( GTK_EDITABLE( edit ), 0, -1 );
      gtk_box_pack_start( GTK_BOX( vbox2 ), edit, FALSE, FALSE, 0 );
      gtk_widget_show( edit );


#ifdef DEBUG3
      g_print("config.cddb = %d\n", config.cddb );
#endif

      /* Create a check button for CDDB support */
      button = gtk_check_button_new_with_label("CDDB Support");
      gtk_box_pack_start( GTK_BOX( vbox2 ), button, FALSE, FALSE, 0 );
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), (config.cddb == 1));
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( toggle_cddb ), NULL );
      gtk_widget_show( button );


      /* Create the list of servers, use a combobox for this */
      label = gtk_label_new( "CDDB Server" );
      gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
      gtk_widget_show (label);

      /* Walk the list */
      cbitems = NULL;
      sp = config.server;
      while( sp != NULL )
	{
	  cbitems = g_list_append(cbitems, sp->name);
	  sp = sp->next;
	}
      
      display.cb = gtk_combo_new ();
      gtk_combo_set_popdown_strings (GTK_COMBO (display.cb), cbitems);

      /* Here we should put the selected server into the entry box */
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(display.cb)->entry), config.current);

      gtk_signal_connect(GTK_OBJECT(GTK_COMBO(display.cb)->entry), "changed",
			 GTK_SIGNAL_FUNC(server_entry),
			 GTK_COMBO(display.cb)->entry);
      gtk_editable_select_region (GTK_EDITABLE (GTK_COMBO(display.cb)->entry),
                                  0, -1);
      gtk_box_pack_start (GTK_BOX (vbox2), display.cb, FALSE, FALSE, 0);
      gtk_widget_show (display.cb);


      /* Add a button to refresh the list with */
      button = gtk_button_new_with_label("Refresh Server List");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC (refresh_servers),
                                 GTK_OBJECT( window ));
      gtk_box_pack_end (GTK_BOX (vbox2), button, FALSE, FALSE, 0);

      /* Create the label box for the CDDB page */
      label = gtk_label_new ("CDDB");
      
      /* Add it to the notebook */
      gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ), vbox2, label, label );

      /* Add the close button */
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC (close_setup),
                                 GTK_OBJECT( window ));
      gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 0);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (button);
    }

  if (!GTK_WIDGET_VISIBLE (window))
    gtk_widget_show_all (window);
  else
    gtk_widget_destroy( window );

  return FALSE;
}


#ifdef GOOBER1
void old_stuff()
{

  /* A useful frame with 3 radio buttons in it */

      /* Create a frame with the Startup options as radio buttons */
      frame = gtk_frame_new("Startup Action");
      gtk_box_pack_start(GTK_BOX(vbox2), frame, FALSE, FALSE, 0);
      gtk_widget_show(frame);

      /* Add the general setup page */
      vbox3 = gtk_vbox_new( FALSE, 0 );
      gtk_container_add(GTK_CONTAINER(frame), vbox3);
      gtk_container_border_width(GTK_CONTAINER(vbox3), 0); 
      gtk_widget_show( vbox3 );

      /* create radio button for Play at startup */
      button = gtk_radio_button_new_with_label( NULL, "Play CD");
      if( config.startup == STARTUP_PLAY )
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      else
 	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), FALSE);
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( play_setup ), NULL );
      gtk_box_pack_start(GTK_BOX(vbox3), button, FALSE, FALSE, 0);
      gtk_widget_show(button);
 
      button = gtk_radio_button_new_with_label(
	      gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "Show Tracks");
      if( config.startup == STARTUP_TRACKS )
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      else
 	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), FALSE);
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( tracks_setup ), NULL );
      gtk_box_pack_start(GTK_BOX(vbox3), button, FALSE, FALSE, 0);
      gtk_widget_show(button);
 
      button = gtk_radio_button_new_with_label(
	      gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "No Disc");
      if( config.startup == STARTUP_NODISC )
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      else
 	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), FALSE);
      gtk_signal_connect( GTK_OBJECT( button ), "toggled",
			  GTK_SIGNAL_FUNC( nothing_setup ), NULL );
      gtk_box_pack_start(GTK_BOX(vbox3), button, FALSE, FALSE, 0);
      gtk_widget_show(button);
 








  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *check;
  GtkWidget *separator;
  GtkWidget *table;
  GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  GtkWidget *text;

    gtk_container_border_width (GTK_CONTAINER (box2), 10);
    gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
    gtk_widget_show (box2);


    table = gtk_table_new (2, 2, FALSE);
    gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
    gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
    gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
    gtk_widget_show (table);

    text = gtk_text_new (NULL, NULL);
    gtk_text_set_editable (GTK_TEXT (text), TRUE);
    gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
		      GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		      GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
    gtk_widget_show (text);

    /*      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
     *      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
     *			GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
     *      gtk_widget_show (hscrollbar);
     */

    vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
    gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		      GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
    gtk_widget_show (vscrollbar);
    

    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "This program will play CDs using an attached ", -1);
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "IDE or SoundBlaster CD player. It currently ", -1);
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "does not work with SCSI drives.\n\n", -1);
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "The latest version is available from my webpage.", -1);
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "Please email me with any suggestions, problems,", -1);
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                     "or comments you may have\n\n", -1);
     
    hbox = gtk_hbutton_box_new ();
    gtk_box_pack_start (GTK_BOX (box2), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    /*      check = gtk_check_button_new_with_label("Editable");
     *      gtk_box_pack_start (GTK_BOX (hbox), check, FALSE, FALSE, 0);
     *      gtk_signal_connect (GTK_OBJECT(check), "toggled",
     *			  GTK_SIGNAL_FUNC(text_toggle_editable), text);
     *      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), TRUE);
     *      gtk_widget_show (check);
     */

    /*      check = gtk_check_button_new_with_label("Wrap Words");
     *      gtk_box_pack_start (GTK_BOX (hbox), check, FALSE, TRUE, 0);
     *      gtk_signal_connect (GTK_OBJECT(check), "toggled",
     *			  GTK_SIGNAL_FUNC(text_toggle_word_wrap), text);
     *      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), FALSE);
     *      gtk_widget_show (check);
     */

    /* Checkbox for www.cddb.com support */
    check = gtk_check_button_new_with_label("www.cddb.com");
    gtk_box_pack_start (GTK_BOX (hbox), check, FALSE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT(check), "toggled",
			GTK_SIGNAL_FUNC(about_toggle_cddb), text);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), FALSE);
    gtk_widget_show (check);

    /* Checkbox for CD Changer support */
    check = gtk_check_button_new_with_label("CD changer");
    gtk_box_pack_start (GTK_BOX (hbox), check, FALSE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT(check), "toggled",
			GTK_SIGNAL_FUNC(about_toggle_cddb), text);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), FALSE);
    gtk_widget_show (check);

    gtk_text_set_word_wrap(GTK_TEXT(text), TRUE );
    
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
    gtk_widget_show (separator);


    box2 = gtk_vbox_new (FALSE, 10);
    gtk_container_border_width (GTK_CONTAINER (box2), 10);
    gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
    gtk_widget_show (box2);

}
#endif


void help_press (GtkWidget *widget, GdkEventButton *event)                              
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( help.wid ),
                    help.image.dn_pixmap,
                    help.image.dn_mask );

    /* In XXXmS execute the help dialog window function */
    help.timer = gtk_timeout_add( 500, help_timer, NULL );
  }
}


void help_release (GtkWidget *widget, GdkEventButton *event)
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( help.wid ),
                    help.image.up_pixmap,
                    help.image.up_mask );
  }
}


void tdisp_press (GtkWidget *widget, GdkEventButton *event)                              
{
  if( event->button == 1 )
  {
    /* Cycle through the time display options */
    switch( display.time )
    {
      case TRACK_ELAPSED :	display.time = TRACK_REMAIN;
      				gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.plstrkdn_pixmap,
      						display.plstrkdn_mask );
      				break;
      				
      case TRACK_REMAIN :	display.time = CD_ELAPSED;
      				gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.mnstrkdn_pixmap,
      						display.mnstrkdn_mask );
      				break;
      				
      case CD_ELAPSED :		display.time = CD_REMAIN;
      				gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.plscddn_pixmap,
      						display.plscddn_mask );
      				break;
      				
      case CD_REMAIN :		display.time = TRACK_ELAPSED;
      				gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.mnscddn_pixmap,
      						display.mnscddn_mask );
      				break;
    }
  }
}


void tdisp_release (GtkWidget *widget, GdkEventButton *event)
{
  if( event->button == 1 )
  {
    switch( display.time )
    {
      case TRACK_ELAPSED :	gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.plstrkup_pixmap,
      						display.plstrkup_mask );
      				break;
      				
      case TRACK_REMAIN :	gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.mnstrkup_pixmap,
      						display.mnstrkup_mask );
      				break;
      				
      case CD_ELAPSED :		gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.plscdup_pixmap,
      						display.plscdup_mask );
      				break;
      				
      case CD_REMAIN :		gtk_pixmap_set( GTK_PIXMAP( tdisp.wid ),
      						display.mnscdup_pixmap,
      						display.mnscdup_mask );
      				break;
    }
  }
}


void rpt_press (GtkWidget *widget, GdkEventButton *event)                              
{
  if( event->button == 1 )
  {
    gtk_pixmap_set( GTK_PIXMAP( rpt.wid ),
                    rpt.image.dn_pixmap,
                    rpt.image.dn_mask );

    if( display.repeat == 0 )
      display.repeat = 1;
    else
      display.repeat = 0;
  }
}


void rpt_release (GtkWidget *widget, GdkEventButton *event)
{
  if( event->button == 1 )
  {
    if( display.repeat == 0 )
    {
      gtk_pixmap_set( GTK_PIXMAP( rpt.wid ),
                      rpt.image.up_pixmap,
                      rpt.image.up_mask );
    } else {
      gtk_pixmap_set( GTK_PIXMAP( rpt.wid ),
                      display.rptupact_pixmap,
                      display.rptupact_mask );
    }
  }
}


void vol_press (GtkWidget *widget, GdkEventButton *event)                              
{
  switch( event->button )
  {
    case 1 :	gtk_pixmap_set( GTK_PIXMAP( vol.wid ),
                   	        vol.image.dn_pixmap,
                    		vol.image.dn_mask );
    		set_vol( +10 );
		update_display();
    		break;
    		
    case 3 :	gtk_pixmap_set( GTK_PIXMAP( vol.wid ),
                   	        vol.image.dn_pixmap,
                    		vol.image.dn_mask );
		set_vol( -10 );
		update_display();
    		break;
    	
  }
}

void vol_release (GtkWidget *widget, GdkEventButton *event)
{
  if( (event->button == 1) || (event->button == 3) )
  {
    gtk_pixmap_set( GTK_PIXMAP( vol.wid ),
                    vol.image.up_pixmap,
                    vol.image.up_mask );
  }
}

/* -----------------------------------------------------------------------------------------
   Show the track title listbox, allow editing of it. Hilight the current track. Show
   total time for each track. Show discid for the CD. Allow sending to CDDB.
   ----------------------------------------------------------------------------------------- */
gint show_tracks( )
{

  return FALSE;
}


/* -----------------------------------------------------------------------
   Redraw the uncovered part of the display
   ----------------------------------------------------------------------- */
static int expose_display( GtkWidget *widget, GdkEventExpose *event )
{
  switch( display.status )
  {
    case CDROM_PLAYING :	gdk_draw_pixmap (widget->window,
                     				 widget->style->black_gc,
                     				 display.null_pixmap, 
                     				 event->area.x, event->area.y,
                     				 event->area.x, event->area.y,
                     				 event->area.width, event->area.height);
  				break;

    case CDROM_NODISC :		gdk_draw_pixmap (widget->window,
                     				 widget->style->black_gc,
                     				 display.nodisc_pixmap, 
                     				 event->area.x, event->area.y,
                     				 event->area.x, event->area.y,
                     				 event->area.width, event->area.height);
  				break;
  }
                                                                                                       
  return FALSE;
}





/* -----------------------------------------------------------------------
   Update the cdrom status and the display
   
   This routine is called once per second to check for the end of the CD
   and to update the display.
   ----------------------------------------------------------------------- */
gint update_cdrom( gpointer data )
{
  /* Get the latest info into cdinfo structure */
  cdrom_status();
  
  return TRUE;
}


/* -----------------------------------------------------------------------
   Draw the current track # onto the null_pixmap and then copy the
   pixmap to the display
   ----------------------------------------------------------------------- */
void draw_track()
{
  gdk_draw_pixmap( display.null_pixmap,
 		   display.wid->style->black_gc,
		   display.a_pixmap[display.track/10],
                   0, 0,
                   2, 2, 11, 22 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.a_pixmap[display.track%10],
                   0, 0,
                   15, 2, 11, 22 );

  gdk_draw_pixmap( display.wid->window,
                   display.wid->style->black_gc,
                   display.null_pixmap,
                   0, 0,
                   0, 0, 92, 30 );
}		  


/* -----------------------------------------------------------------------
   Draw the minute digits onto the null_pixmap and then copy the
   pixmap to the display. Also draws the minus sign if needed.
   ----------------------------------------------------------------------- */
void draw_minute()
{
  /* Show or don't show the minus sign */
  if((display.minute<0) || (display.second<0))
    {
      gdk_draw_pixmap( display.null_pixmap,
		       display.wid->style->black_gc,
		       display.minus_pixmap,
		       0, 0,
		       32, 10, 8, 16 );
    } else {
      gdk_draw_pixmap( display.null_pixmap,
		       display.wid->style->black_gc,
		       display.b_pixmap[10],
		       0, 0,
		       32, 10, 8, 16 );
    }

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[abs(display.minute)/10],
                   0, 0,
                   42, 10, 8, 16 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[abs(display.minute)%10],
                   0, 0,
                   52, 10, 8, 16 );

  gdk_draw_pixmap( display.wid->window,
                   display.wid->style->black_gc,
                   display.null_pixmap,
                   0, 0,
                   0, 0, 92, 30 );
}


/* -----------------------------------------------------------------------
   Draw the second digits onto the null_pixmap and then copy the
   pixmap to the display.
   ----------------------------------------------------------------------- */
void draw_second()
{
  /* Show or don't show the minus sign */
  if((display.minute<0) || (display.second<0))
    {
      gdk_draw_pixmap( display.null_pixmap,
		       display.wid->style->black_gc,
		       display.minus_pixmap,
		       0, 0,
		       32, 10, 8, 16 );
    } else {
      gdk_draw_pixmap( display.null_pixmap,
		       display.wid->style->black_gc,
		       display.b_pixmap[10],
		       0, 0,
		       32, 10, 8, 16 );
    }

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[abs(display.second/10)],
                   0, 0,
                   68, 10, 8, 16 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[abs(display.second%10)],
                   0, 0,
                   78, 10, 8, 16 );

  gdk_draw_pixmap( display.wid->window,
                   display.wid->style->black_gc,
                   display.null_pixmap,
                   0, 0,
                   0, 0, 92, 30 );
}


/* -----------------------------------------------------------------------
   Erase the minute digits and the minus sign. This is used by the blink
   routine.
   ----------------------------------------------------------------------- */
void erase_minute()
{				  
  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[10],
                   0, 0,
                   32, 10, 8, 16 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[10],
                   0, 0,
                   42, 10, 8, 16 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[10],
                   0, 0,
                   52, 10, 8, 16 );

  gdk_draw_pixmap( display.wid->window,
                   display.wid->style->black_gc,
                   display.null_pixmap,
                   0, 0,
                   0, 0, 92, 30 );
}


/* -----------------------------------------------------------------------
   Erase the second digits. This is used by the blink routine.
   ----------------------------------------------------------------------- */
void erase_second()
{
  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[10],
                   0, 0,
                   68, 10, 8, 16 );

  gdk_draw_pixmap( display.null_pixmap,
                   display.wid->style->black_gc,
                   display.b_pixmap[10],
                   0, 0,
                   78, 10, 8, 16 );

  gdk_draw_pixmap( display.wid->window,
                   display.wid->style->black_gc,
                   display.null_pixmap,
                   0, 0,
                   0, 0, 92, 30 );
}


/* -----------------------------------------------------------------------
   Decide what to show on the display
   If there is no disc, then show NO DISC bitmap
   If playing then update the display digits
   If paused then blink the time
   
   It keeps track of the previous states of things so only the areas that
   have changed get updated each time. An improvement would be to only
   update the digits that change (instead of both minute or both second
   digits), but it isn't that important.
   ----------------------------------------------------------------------- */
void update_display()
{
  static int	curr_track=-1,		/* Default to unknown value	*/
  		curr_minute=-1,
  		curr_second=-1,
  		curr_status=-1,
                curr_volume=-1,
  		blinking=0,
                tclist_track=-1;        /* Track selected in tclist */ 
                
  int		x;

  /*
   * If the volume needs updating then we draw a bargraph, one bar for
   *  every 17 volume units. 15 bars maximum with the last 5 being red
   */
  if( curr_volume != cdinfo.volume )
  {
    for( x = 0; x < (cdinfo.volume / 17); x++ )
    {
      if( x < 10 )
      {
        gdk_draw_pixmap( display.null_pixmap,
                         display.wid->style->black_gc,
                         display.bar_pixmap,
                         0, 0,
                         30+(x*4), 1, 4, 7 );
      } else {
        gdk_draw_pixmap( display.null_pixmap,
                         display.wid->style->black_gc,
                         display.redbar_pixmap,
                         0, 0,
                         30+(x*4), 1, 4, 7 );
      }
    }
    for( ; x < 15; x++ )
    {
      gdk_draw_pixmap( display.null_pixmap,
                       display.wid->style->black_gc,
                       display.nobar_pixmap,
                       0, 0,
                       30+(x*4), 1, 4, 7 );
    }

    gdk_draw_pixmap( display.wid->window,
                     display.wid->style->black_gc,
                     display.null_pixmap,
                     0, 0,
                     0, 0, 92, 30 );

    curr_volume = cdinfo.volume;
  }

  switch( display.time )
    {
    case TRACK_ELAPSED :
      display.minute = cdinfo.sc.cdsc_reladdr.msf.minute;
      display.second = cdinfo.sc.cdsc_reladdr.msf.second;
      break;

    case TRACK_REMAIN :
      display.minute = 0 - ( (cdinfo.track[display.track-1].length/60) - cdinfo.sc.cdsc_reladdr.msf.minute);
      display.second = 0 - ( (cdinfo.track[display.track-1].length%60) - cdinfo.sc.cdsc_reladdr.msf.second);
      break;
      
    case CD_ELAPSED : 
      display.minute = cdinfo.sc.cdsc_absaddr.msf.minute;
      display.second = cdinfo.sc.cdsc_absaddr.msf.second;
      break;
      
    case CD_REMAIN :
      display.minute = 0-cdinfo.cd_remaining/60;
      display.second = 0-cdinfo.cd_remaining%60;
      break;  
    }


  switch( display.status )
  {
    case CDROM_PLAYING :       	if( display.track != curr_track )
    				{
    				  draw_track();
    				  
  				  curr_track = display.track;
    				}
    
    				if( display.minute != curr_minute )
    				{
				  draw_minute();
  				  
    				  curr_minute = display.minute;
    				}
    
    				if( display.second != curr_second )
    				{
				  draw_second();
				  
   				  curr_second = display.second;
   				}
				curr_status = display.status;

				if( display.playbtn != CDROM_PLAYING )
				  {
				    gtk_pixmap_set( GTK_PIXMAP( play.wid ),
						    display.playup_pixmap,
						    display.playup_mask );

				    display.playbtn = CDROM_PLAYING;
				  }

				/* If the track window is open, update selected track */
				if( display.twindow != NULL )
				  {
				    if( tclist_track+1 != curr_track )
				      {
					if( curr_track > 0 )
					  tclist_track = curr_track -1;
					else
					  tclist_track = 0;
					gtk_clist_select_row( GTK_CLIST(display.tclist), tclist_track, -1 );
				      }
				  }
				
   				break;
   
    /* Flash the min/sec digits while paused */
    case CDROM_PAUSED :		if( display.track != curr_track )
                                {
    				  draw_track();
    				  
  				  curr_track = display.track;
    				}
    

                                if( blinking )
    				{
				  draw_second();
    				  draw_minute();
    				  blinking=0;  
    				} else {
    				  erase_second();
    				  erase_minute();
    				  curr_second = -1;
    				  curr_minute = -1;
    				  blinking=1;
    				}

                                if( display.playbtn != CDROM_PAUSED )
				  {
				    gtk_pixmap_set( GTK_PIXMAP( play.wid ),
						    display.pauseup_pixmap,
						    display.pauseup_mask );
				    display.playbtn = CDROM_PAUSED;
				  }
    				break; 
    
    				/* Display NO DISC */
    case CDROM_NODISC :		if( curr_status != display.status )
    				{
    				  gdk_draw_pixmap( display.wid->window,
    				  		   display.wid->style->black_gc,
    						   display.nodisc_pixmap,
    						   0, 0,
    						   0, 0, 92, 30 );

    				  curr_status = display.status;
    				}

                                if( display.playbtn != CDROM_NODISC )
				  {
				    gtk_pixmap_set( GTK_PIXMAP( play.wid ),
						    display.stopup_pixmap,
						    display.stopup_mask );
				    display.playbtn = CDROM_NODISC;
				  }

				break;
  }

#ifdef DEBUG4
  g_print( "update called. status = %d  remain = %d\n", display.status, cdinfo.cd_remaining );
  g_print( "        curr  new\n");
  g_print( "track   %03d : %03d\n", curr_track, display.track );
  g_print( "minute  %03d : %03d\n", curr_minute, display.minute );
  g_print( "second  %03d : %03d\n", curr_second, display.second );
  g_print( "volume  %03d : %03d\n", curr_volume, cdinfo.volume );
#endif

}


/* ------------------------------------------------------------------------
   Process data coming back from the cd_control process

   This is a stateless process since it only returns a cdinfo structure
   ------------------------------------------------------------------------ */
void wait_status()
{
  struct CDINFO tmpinfo;
  struct SITE   *sp;
  char          buffer[80];
  int           x;
  char         *texts[3],
               text1[255],
               text2[255];


  /* Read the new cdinfo structure from the cd_control process */
  if( read( cd_fd, &tmpinfo, sizeof(struct CDINFO) ) < 0 )
    perror("cdrom_status(read)");

  /* Copy the useful bits from tmpinfo  to cdinfo */
  memcpy( &cdinfo.tochdr, &tmpinfo.tochdr, sizeof(tmpinfo.tochdr) );
  memcpy( &cdinfo.leadout, &tmpinfo.leadout, sizeof(tmpinfo.leadout) );
  memcpy( &cdinfo.volume, &tmpinfo.volume, sizeof(tmpinfo.volume) );

  /* Copy track length, but not the track name over from the status */
  for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
    {
      cdinfo.track[x].te = tmpinfo.track[x].te;
      cdinfo.track[x].length = tmpinfo.track[x].length;
      cdinfo.track[x].frame_offset = tmpinfo.track[x].frame_offset;
    }

  memcpy( &cdinfo.sc, &tmpinfo.sc, sizeof(tmpinfo.sc) );
  memcpy( &cdinfo.ti, &tmpinfo.ti, sizeof(tmpinfo.ti) );
  cdinfo.cd_length = tmpinfo.cd_length;
  cdinfo.discid = tmpinfo.discid;

  switch( cdinfo.sc.cdsc_audiostatus )
    {
    case CDROM_AUDIO_PLAY :
    case CDROM_AUDIO_PAUSED :
      if( cdinfo.sc.cdsc_audiostatus == CDROM_AUDIO_PLAY )
	display.status = CDROM_PLAYING;
      else
	display.status = CDROM_PAUSED;

      /* Update the currently playing track */
      display.track = cdinfo.sc.cdsc_trk;

      /* Update the number of seconds remaining on the CD */
      cdinfo.cd_remaining = cdinfo.cd_length - ((cdinfo.sc.cdsc_absaddr.msf.minute*60)+cdinfo.sc.cdsc_absaddr.msf.second);

      /* Do we need track data? Can we request it? */
      if( (display.cddb_lock == 0) && (cdinfo.revision == -1))
	{
	  if( config.cddb == 1 )
	    {   
#ifdef DEBUG9
	      g_print("reading cddb info %d\n", cdinfo.revision );
#endif
	      /* Try and find a cddb entry in the local CD database */
	      if( read_cddb( &cdinfo ) < 0 )
		{
		  /* Default server to query */
		  strcpy( cdinfo.server, "cddb.cddb.com" );
		  cdinfo.port = 888;

		  /* So here we query the default internet server */
		  if( config.current != NULL )
		    {
		      /* Use the current + 888 even if not found in the list */
		      strcpy( cdinfo.server, config.current );

		      /* Find the current server in the list */
		      sp = config.server;
		      while( sp != NULL )
			{
			  if( strcmp( sp->name, config.current ) == 0 )
			    {
			      strcpy( cdinfo.server, sp->name );
			      cdinfo.port = sp->port;
			      sp = NULL;
			    }else {
			      sp = sp->next;
			    }
			}
		    }
		  /* Send the command to the server - Starts a state machine */
		  cdinfo.cddbd_cmnd = DB_READ;
		  if( write( cddbd_fd, &cdinfo, sizeof( struct CDINFO) ) < 0 )
		    {
		      perror("write to cddbd_fd error");
		      if( cdinfo.revision < 0 )
			cdinfo.revision = -2;     /* Failed, Don't try again */
		    }
		  /* Lock the use of the internet database */
		  display.cddb_lock = 1;

		  /* !!!! This could probably be turned into a subroutine
		     !!!! */

		  /* Start up a progress dialog */
		  display.progress = gtk_dialog_new ();
		  
		  sprintf(buffer, "Connecting to %s:%d", cdinfo.server,
			                                 cdinfo.port );

		  gtk_signal_connect( GTK_OBJECT( display.progress ), "destroy",
				      GTK_SIGNAL_FUNC(gtk_widget_destroy),
				      &display.progress);

		  gtk_window_set_title (GTK_WINDOW (display.progress), "CDDBD Status");
		  gtk_container_border_width (GTK_CONTAINER (display.progress), 0);
		  gtk_window_set_wmclass(GTK_WINDOW(display.progress), "XfreeCDp", NULL );

		  display.plabel = gtk_label_new (buffer);
		  gtk_misc_set_padding (GTK_MISC (display.plabel), 10, 10);
		  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->vbox),
				      display.plabel, FALSE, FALSE, 0);
		  gtk_widget_show( display.plabel );
		  gtk_widget_show( display.progress );
		} else {
		  /* Read of local database successful */
#ifdef DEBUG5
		  g_print("Title : %s\n", cdinfo.title->str );
		  for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
		    {
		      g_print("Track %d : %s\n", x+1, cdinfo.name[x]->str );
		    }
#endif
		}
	    } else {
	      /* Read the data from the local database, or set defaults */
	      local_cddb();
	    }

	  /* If the track list window is open, update the list */
	  if( display.twindow != NULL )
	    {
#ifdef DEBUG9
	      g_print("Updating Track Window revision=%d\n", cdinfo.revision);
#endif

	      gtk_clist_freeze (GTK_CLIST (display.tclist));
	      
	      /* Clear out the old list first */
	      gtk_clist_clear( GTK_CLIST( display.tclist ) );
	      
	      /* Set the new title */
	      if( cdinfo.title != NULL )
		sprintf( text1, "%s", cdinfo.title->str );
	      else
		strcpy( text1, "" );
	      gtk_label_set( GTK_LABEL( display.ttitle ), text1 );
	      
	      /* Add the track names */
	      for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
		{
		  sprintf( text1, "%d", x+1 );
		  sprintf( text2, "%d:%02d",cdinfo.track[x].length/60,cdinfo.track[x].length%60 );
		  texts[0] = text1;
		  texts[2] = text2;
		  if( cdinfo.name[x] != NULL )
		    texts[1] = cdinfo.name[x]->str;
		  else
		    texts[1] = "(blank)";
		  gtk_clist_append (GTK_CLIST (display.tclist), texts);
		}
	      gtk_clist_thaw( GTK_CLIST( display.tclist ) );
	      gtk_clist_select_row( GTK_CLIST(display.tclist), display.track-1, -1 );
	    }
	}
      break;

#ifdef OLD_WAY					
      case CDROM_AUDIO_PAUSED :
      display.status = CDROM_PAUSED;
      break;
#endif

    case CDROM_AUDIO_NO_STATUS :
      /* Only clean things up once */
      if( display.status != CDROM_NODISC )
	{
	  /* Clear out the track list */
	  if( display.twindow != NULL )
	    {
	      gtk_clist_clear( GTK_CLIST( display.tclist ) );
	      
	      /* Clear the title */
	      gtk_label_set( GTK_LABEL( display.ttitle ), "" );
	    }

	  /* Free dynamically allocated cdinfo strings */
	  free_cdinfo();

	  display.status = CDROM_NODISC;
	  /* Reset the revision # so next will recall from database*/
	  cdinfo.revision = -1;
	}
      break;

    default:
      /* Only cleanup once */
      if( display.status != CDROM_NODISC )
	{
	  /* Clear out the track list */
	  if( display.twindow != NULL )
	    {
	      gtk_clist_clear( GTK_CLIST( display.tclist ) );

	      /* Clear the title */
	      gtk_label_set( GTK_LABEL( display.ttitle ), "" );
	    }

	  /* Free dynamically allocated cdinfo strings */
	  free_cdinfo();

	  display.status = CDROM_NODISC;
	  cdinfo.revision = -1;
	}
      break;
  }  


  /*
   * If the CD is over then either restart it, or eject it, or show NO DISC
   */
  if( (cdinfo.cd_remaining == 0) && (display.status == CDROM_PLAYING) )
    {
      /* If repeat is on, start playing the cd over from the start */
      if( display.repeat == 1 )
	{
	  display.track = cdinfo.tochdr.cdth_trk0;
	  play_track( cdinfo.tochdr.cdth_trk0 );
	} else {
	  /* Clear out the track list */
	  if( display.twindow != NULL )
	    {
	      gtk_clist_clear( GTK_CLIST( display.tclist ) );

	      /* Clear the title */
	      gtk_label_set( GTK_LABEL( display.ttitle ), "" );
	    }

	  /* Free up any dynamically allocated cdinfo strings */
	  free_cdinfo();

	  /* Eject when done Playing - only eject if the user has enabled this */
	  if( config.done_eject == 1 )
	    {
	      /* All done, eject it for the next disc! */
	      eject_cdrom();
	    } else {
	      stop_cdrom();
	    }

	  gtk_pixmap_set( GTK_PIXMAP( play.wid ),
			  display.stopup_pixmap,
			  display.stopup_mask );
	  display.playbtn = CDROM_NODISC;
	}
    }
}


/* -------------------------------------------------------------------------
   Process data coming back from the cd_control process

   This is a stateless process since it only returns a cdinfo structure
   ------------------------------------------------------------------------- */
void cd_fd_read( gpointer data, gint source, GdkInputCondition condition)
{
  wait_status();

  if( display.startup == 0 )
    {
      if( config.startup == 1 )
	{
	  /* If it is already playing, don't restart it */
	  if( ( cdinfo.sc.cdsc_audiostatus != CDROM_AUDIO_PLAY ) &&
	      (cdinfo.discid != 0 ) )
	    {
#ifdef DEBUG6
	      g_print("Starting play of cd. audiostatus = %d\n", cdinfo.sc.cdsc_audiostatus );
#endif
	      play_track( 1 );
	    }
	}

      /* Stop trying after the discid gets set by cd_control process */
      if( cdinfo.discid != 0 )
	display.startup = 1;
    }

  update_display();
}


/* ------------------------------------------------------------------------
   this is the signal handler that gets called if GtkList
   emits the "selection_changed" signal
   ------------------------------------------------------------------------ */
void inexact_selected( GtkWidget *gtklist, gpointer func_data)
{
  char      *p,
            buffer[80];
  GList     *dlist;
  GtkObject *list_item;
  gchar     *item_data_string;


  /* fetch the doubly linked list of selected items
   * of the GtkList, remember to treat this as read-only!
   */
  dlist=GTK_LIST(gtklist)->selection;

  /* if there are no selected items there is nothing more
   * to do than just telling the user so
   */
  if (dlist)
    {
      list_item=GTK_OBJECT(dlist->data);
      item_data_string=gtk_object_get_data(list_item,
					   "XfreeCDkey");
      p = strtok( item_data_string, " \n" );
      p = strtok( NULL, " \n" );

#ifdef DEBUG3
      g_print("Retrieving data for %s\n", p);
#endif

      /* Change the discid so the new request will work */
      sscanf( p, "%lx", &cdinfo.discid );
      cdinfo.cddbd_cmnd = DB_READ;
      if( write( cddbd_fd, &cdinfo, sizeof( struct CDINFO) ) < 0 )
	{
	  perror("write to cddbd_fd error");
	  if( cdinfo.revision < 0 )
	    cdinfo.revision = -2;     /* Failed, Don't try again */
	}
      /* Lock use of the CDDB internet server */
      display.cddb_lock = 1;

      /* Delete the old progress box */
      gtk_widget_destroy( display.progress );

      /* Start up a new progress dialog */
      display.progress = gtk_dialog_new ();

      sprintf(buffer, "Connecting to %s:%d", cdinfo.server, cdinfo.port );

      gtk_signal_connect( GTK_OBJECT( display.progress ), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroy),
			  &display.progress);

      gtk_window_set_title (GTK_WINDOW (display.progress), "CDDBD Status");
      gtk_container_border_width (GTK_CONTAINER (display.progress), 0);
      gtk_window_set_wmclass(GTK_WINDOW(display.progress), "XfreeCDp", NULL );

      display.plabel = gtk_label_new (buffer);
      gtk_misc_set_padding (GTK_MISC (display.plabel), 10, 10);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->vbox),
			  display.plabel, FALSE, FALSE, 0);
      gtk_widget_show( display.plabel );
      gtk_widget_show( display.progress );
    } else {
      gtk_widget_destroy( display.progress );
    }
}




/* -------------------------------------------------------------------------
   Process data coming back from the cddbd process

   This routine processes data from the pipe to the cddbd process. This gets
   the track names and site list from the server.
   ------------------------------------------------------------------------- */
void cddbd_fd_read( gpointer data, gint source, GdkInputCondition condition)
{
  struct CDINFO tmpinfo;
  int           x;
  static struct SITE   *sp,
                       *sp_top=NULL,
                       *sp_end=NULL;
  char          *p, buffer[80];
  gchar         *string;
  GtkWidget     *button,
                *scrolled_win,
                *list,
                *vbox1,
                *label;
  static GList  *cbitems=NULL;
  char         *texts[3],
               text1[255],
               text2[255];


  /* Read back the status structure */
  if( read( cddbd_fd, &tmpinfo, sizeof( struct CDINFO ) ) != sizeof( struct CDINFO ) )
    {
      perror( "CDDBD status read" );
      close( cd_fd );
      close( cddbd_fd );
      exit(-1);
    }

  switch( tmpinfo.cddbd_stat )
    {
    case CDDBD_OPEN_OK :
#ifdef DEBUG3
      g_print("Connected to %s ok\n", tmpinfo.server );
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Connected to %s:%d", tmpinfo.server, tmpinfo.port);
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}
      break;

    case CDDBD_DONE_OK :
      display.cddb_lock = 0;

      /* Copy the info from the tmpinfo to cdinfo */
#ifdef DEBUG3
      g_print("Got the new data ok\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Retrieved %s", tmpinfo.title->str );
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      gtk_widget_destroy( display.progress );

      /* Read the new data from the database */
      local_cddb();

      /* If the track list window is open, update the list */
      if( display.twindow != NULL )
	{
	  gtk_clist_freeze (GTK_CLIST (display.tclist));
	  
	  /* Clear out the old list first */
	  gtk_clist_clear( GTK_CLIST( display.tclist ) );

	  /* Set the new title */
	  if( cdinfo.title != NULL )
	    sprintf( text1, "%s", cdinfo.title->str );
	  else
	    strcpy( text1, "" );
	  gtk_label_set( GTK_LABEL( display.ttitle ), text1 );

	  /* Add the track names */
	  for( x = 0; x < cdinfo.tochdr.cdth_trk1; x++ )
	    {
	      sprintf( text1, "%d", x+1 );
	      sprintf( text2, "%d:%02d",cdinfo.track[x].length/60,cdinfo.track[x].length%60 );
	      texts[0] = text1;
	      texts[2] = text2;
	      if( cdinfo.name[x] != NULL )
		texts[1] = cdinfo.name[x]->str;
	      else
		texts[1] = "(blank)";
	      gtk_clist_append (GTK_CLIST (display.tclist), texts);
	    }
	  gtk_clist_thaw( GTK_CLIST( display.tclist ) );
	  gtk_clist_select_row( GTK_CLIST(display.tclist), display.track-1, -1 );
	}
      break;
      
      /* Process the line of text */
    case CDDBD_MOTD_LINE :
      
      if( tmpinfo.line[0] == '.' )
	{
	  display.cddb_lock = 0;
#ifdef DEBUG3
	  g_print("End of MOTD\n");
#endif

	  gtk_widget_destroy( display.progress );

	} else {
#ifdef DEBUG3
	  /* Do something with the MOTD, for now print it */
	  g_print( "%s", tmpinfo.line );
#endif

	  if( display.plabel != NULL )
	    {
	      gtk_label_set (GTK_LABEL (display.plabel), tmpinfo.line);
	    }
	}
      break;

      /* Process the line of text */
    case CDDBD_SITE_LINE :
      
      if( tmpinfo.line[0] == '.' )
	{
	  display.cddb_lock = 0;
#ifdef DEBUG3
	  g_print("End of Site listing\n");
#endif
	  if( display.plabel != NULL )
	    {
	      sprintf (buffer, "Retrieved Site Listing ok" );
	      gtk_label_set (GTK_LABEL (display.plabel), buffer);
	    }

	  if( sp_top != NULL )
	    {
	      /* Everything seems okay, erase the old list and add the new one */
	      while( config.server != NULL )
		{
		  sp = config.server;
		  config.server = config.server->next;
		  free( sp->name );
		  free( sp );
		}

	      /* Point config to the new list */
	      config.server = sp_top;
	      sp_top = sp_end = NULL;

	      config.saved = 0;             /* Need to save this to disk */
	      write_config( &config );      /* Write new list to disk */
	      strncpy( cdinfo.device, config.device, 80 );

	      /* Need to let the site list in the dialog box be updated if it is
		 still being shown (user could close it before we finish).
	      */
	      if( display.cb != NULL )
		{

		  /* Walk the list */
		  cbitems = NULL;
		  sp = config.server;
		  while( sp != NULL )
		    {
		      cbitems = g_list_append(cbitems, sp->name);
		      sp = sp->next;
		    }
      
		  gtk_combo_set_popdown_strings (GTK_COMBO (display.cb), cbitems);
		  cbitems = NULL;
		}

	    }
	  gtk_widget_destroy( display.progress );

	} else {
	  /* Do something with the SITE, for now print it */
	  /* Need to store in a temp. List until complete, then move to config */
#ifdef DEBUG3
	  g_print( "%s", tmpinfo.line );
#endif

	  if( display.plabel != NULL )
	    {
	      gtk_label_set (GTK_LABEL (display.plabel), tmpinfo.line);
	    }

	  /* Reserve some space for this server, add it to the end of the list */
	  if( ( sp = (struct SITE *) malloc( sizeof(struct SITE) ) ) == NULL )
	    {
	      perror("malloc - 1");
	    }
	  bzero( sp, sizeof(struct SITE) );
      
	  p = strtok( tmpinfo.line, " \n" );

	  /* Reserve space for the name */
	  if( ( sp->name = (char *) malloc( strlen(p)+1 ) ) == NULL )
	    {
	      perror("malloc - 2");
	    }
	  strcpy( sp->name, p );

	  p = strtok( NULL, " \n" );
	  sp->port = atoi(p);
	  sp->next = NULL;

	  /* Is it the first in the list? */
	  if( sp_top == NULL )
	    {
	      /* Yep, First in the list */
	      sp_top = sp;
	      sp_end = sp;
	    } else {
	      /* No, add it to the end of the list */
	      sp_end->next = sp;
	      sp_end = sp;
	    }
	}
      break;


      /* Process the line of text inexact matches */
    case CDDBD_INEX_LINE :
      
      if( tmpinfo.line[0] == '.' )
	{
	  cdinfo.revision = -2;
	  display.cddb_lock = 0;

#ifdef DEBUG3
	  g_print("End of Inexact Match listing\n");
#endif

	  if( display.plabel != NULL )
	    {
	      sprintf (buffer, "Retrieved inexact matches for discid 0x%08lx", cdinfo.discid );
	      gtk_label_set (GTK_LABEL (display.plabel), buffer);
	    }

	  /* Here we want to add a list of the sites to the progress box,
	     add a cancel button, and add a signal to use one of the inexact
	     matches in a new search.
	  */
	  if( cbitems != NULL )
	    {
	      /* Add a vbox to hold the list and cancel button */
	      vbox1 = gtk_vbox_new( FALSE, 0 );
	      gtk_box_pack_start( GTK_BOX (GTK_DIALOG (display.progress)->action_area),
				  vbox1, FALSE, TRUE, 1 );
	      gtk_widget_show( vbox1 );
	      
	      scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	      gtk_widget_set_usize( scrolled_win, 250, 100 );
	      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					      GTK_POLICY_AUTOMATIC,
					      GTK_POLICY_AUTOMATIC);
	      gtk_box_pack_start (GTK_BOX( vbox1 ), scrolled_win, FALSE, FALSE, 0);
	      gtk_widget_show (scrolled_win);

	      /* Put a list into the scrolling window */
	      list = gtk_list_new ();
	      gtk_list_set_selection_mode (GTK_LIST (list), GTK_SELECTION_SINGLE);
	      gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	      gtk_container_set_focus_vadjustment (GTK_CONTAINER (list),
	      	   gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolled_win)));
	      gtk_signal_connect(GTK_OBJECT(list),
				 "selection_changed",
				 GTK_SIGNAL_FUNC(inexact_selected),
				 NULL);
	      gtk_widget_show (list);

	      /* Add the list of inexact matches to the list from cbitems */
	      gtk_list_append_items( GTK_LIST( list ), cbitems );

	      button = gtk_button_new_with_label ("Cancel");
	      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
					 GTK_SIGNAL_FUNC(gtk_widget_destroy),
					 GTK_OBJECT (display.progress));
	      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	      gtk_box_pack_start (GTK_BOX( vbox1 ), button, TRUE, TRUE, 0);
	      gtk_widget_grab_default (button);
	      gtk_widget_show (button);
	      
	      cbitems = NULL;
	    } else {
	      gtk_widget_destroy( display.progress );
	    }
	} else {
	  /* Need to store in a temp. List until we receive the last line */
#ifdef DEBUG3
	  g_print( "%s", tmpinfo.line );
#endif

	  /* Show the line in the progress box */
	  if( display.plabel != NULL )
	    {
	      gtk_label_set (GTK_LABEL (display.plabel), tmpinfo.line);
	    }

	  /* Add it to a list of sites */
	  /* Need to detect first line of this type and set cbitems to NULL, or else
	     set it to null when everything else is finished with it.
	  */
	  if( tmpinfo.line[strlen(tmpinfo.line)-1] == '\n' )
	    {
	      tmpinfo.line[strlen(tmpinfo.line)-1] = 0x00;
	    }

	  button=gtk_list_item_new();
	  label=gtk_label_new( tmpinfo.line );
	  gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	  gtk_container_add (GTK_CONTAINER (button), label);
	  gtk_widget_show (label);
	  gtk_widget_show(button);
	  gtk_label_get(GTK_LABEL(label), &string);
	  gtk_object_set_data(GTK_OBJECT(button),
			      "XfreeCDkey",
			      string);
	  cbitems = g_list_append(cbitems, button);

	}
      break;



    case CDDBD_MATCH_OK :
#ifdef DEBUG3
      g_print("Got a match for 0x%08lx\n", tmpinfo.discid );
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Retrieving data for id 0x%08lx", tmpinfo.discid);
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      break;
      
    case CDDBD_ENTRY_OK :
#ifdef DEBUG3
      g_print("Reading CDDB Database entry from %s\n", tmpinfo.server );
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Reading CDDB info from %s", tmpinfo.server);
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}
      break;
      
    case CDDBD_DONE_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;


#ifdef DEBUG3
      g_print("Error reading temporary file\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Error Reading temp. file");
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    case CDDBD_OPEN_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Failed to connect to %s\n", tmpinfo.server );
      g_print("%s\n", tmpinfo.line );
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Failed to connect to %s", tmpinfo.server );
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    case CDDBD_READ_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Socket read failed\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Socket Read Failed");
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    case CDDBD_WRITE_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Socket write failed\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Socket Write Failed");
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    case CDDBD_TMPF_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Error, cannot create a temporary filename\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Cannot Create temp. file");
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    case CDDBD_FOPEN_ERR :
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Error opening temporary file\n");
#endif

      if( display.plabel != NULL )
	{
	  sprintf (buffer, "Error opening temp. file");
	  gtk_label_set (GTK_LABEL (display.plabel), buffer);
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
      
    default:
      cdinfo.revision = -2;
      display.cddb_lock = 0;

#ifdef DEBUG3
      g_print("Server returned %d\n", tmpinfo.cddbd_stat );
#endif

      if( display.plabel != NULL )
	{
	  sprintf( buffer, "Server: %s", tmpinfo.line );
	  gtk_label_set (GTK_LABEL (display.plabel), buffer );
	}

      button = gtk_button_new_with_label ("OK");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                 GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                 GTK_OBJECT (display.progress));
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (display.progress)->action_area),
                          button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      break;
    }
}


/* -----------------------------------------------------------------------
   Get the current status of the cdrom and fill in the display info

   return -1 = error writing
   ----------------------------------------------------------------------- */
int cdrom_status()
{
  /* Get the status of the cd */
  cmnd[0] = CD_STATUS;
  cmnd[1] = 0;
  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
      return(-1);
    }

  return 0;
}


/* -----------------------------------------------------------------------
   Play a track
   ----------------------------------------------------------------------- */
void play_track( int track )
{
  /* Start Playing right away */
  cmnd[0] = CD_PLAY;
  cmnd[1] = track;
  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Play the next track
   ----------------------------------------------------------------------- */
void play_next()
{
  cmnd[0] = CD_PLAY;
  cmnd[1] = display.track == cdinfo.tochdr.cdth_trk1 ? display.track = cdinfo.tochdr.cdth_trk0 : ++display.track;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Play the previous track
   ----------------------------------------------------------------------- */
void play_previous()
{
  cmnd[0] = CD_PLAY;
  cmnd[1] = display.track == cdinfo.tochdr.cdth_trk0 ? display.track = cdinfo.tochdr.cdth_trk1 : --display.track;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Eject the cd tray if we are currently playing, otherwise start playing.
   
   This should really be seperated into 2 pieces of code for more positive
   control over the cdrom.
   ----------------------------------------------------------------------- */
void eject_cdrom()
{
  cmnd[0] = CD_EJECT;
  cmnd[1] = 0;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Pause the cdrom
   ----------------------------------------------------------------------- */
void pause_cdrom()
{
  cmnd[0] = CD_PAUSE;
  cmnd[1] = 0;  

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Resume playing the cdrom
   ----------------------------------------------------------------------- */
void resume_cdrom()
{
  cmnd[0] = CD_RESUME;
  cmnd[1] = 0;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Change the volume setting

   amount is +/- amount to adjust by
   ----------------------------------------------------------------------- */
void set_vol( int amount )
{
  /* Limit the volume setting to 0 to 255 */
  cdinfo.volume += amount;
  cdinfo.volume = cdinfo.volume < 0 ? 0 : cdinfo.volume > 255 ? 255 : cdinfo.volume;

  cmnd[0] = CD_VOLUME;
  cmnd[1] = (unsigned char) cdinfo.volume;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Stop playing the cdrom
   ----------------------------------------------------------------------- */
void stop_cdrom()
{
  cmnd[0] = CD_STOP;
  cmnd[1] = 0;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}


/* -----------------------------------------------------------------------
   Set the Eject CD on exit state
   ----------------------------------------------------------------------- */
void set_eject( int state )
{
  cmnd[0] = CD_SET_EJECT;
  cmnd[1] = state;

  if( write( cd_fd, &cmnd, 2 ) < 0 )
    {
      perror("write to cd_control error");
    }
}
