/******************************************************************************
*   WMSound Setup       for WindowMaker Sound Server            [Version 0.7] *
*   Copyright (C) 1998  Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*                                                                             *
*   WindowMaker Sound Server                                                  *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net>              *
*                       William Moore <billy@mud.mind.net>                    *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#include <WINGs.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <proplist.h>

#include "wsconfig.h"
#include "wmss.h"


extern Display	*dpy;


static void
wmssExitInfo(WMButton *bPtr, WMSSInfoPanel *panel)
{
    panel->flags.done = 1;
}

WMSSInfoPanel*
wmssCreateInfoPanel(WMScreen *scrPtr, char **soundpath)
{
    WMSSInfoPanel	*panel;
    WMFont		*font;

    panel = malloc(sizeof(WMSSInfoPanel));
    memset(panel, 0, sizeof(WMSSInfoPanel));

    /*
    ---------------------
    The Actual Info Panel
    ---------------------
    */
    panel->win = WMCreateWindow(scrPtr, "infoPanel");
    WMSetWindowTitle(panel->win, "WMSound Setup Info");
    WMResizeWidget(panel->win, 340,176);


    /*
    ----------
    Name Label
    ----------
    */
    panel->nameLabel = WMCreateLabel(panel->win);
    WMResizeWidget(panel->nameLabel, 170, 20);
    WMMoveWidget(panel->nameLabel, 14, 22);

    font = WMBoldSystemFontOfSize(scrPtr, 20);
    WMSetLabelFont(panel->nameLabel, font);
    WMSetLabelText(panel->nameLabel, "WMSound Setup");
    WMReleaseFont(font);
    /*
    -------------
    Version Label
    -------------
    */
    panel->versionLabel = WMCreateLabel(panel->win);
    WMResizeWidget(panel->versionLabel, 100, 14);
    WMMoveWidget(panel->versionLabel, 184, 26);

    font = WMBoldSystemFontOfSize(scrPtr, 14);
    WMSetLabelFont(panel->versionLabel, font);
    WMSetLabelText(panel->versionLabel, "Version 0.7");
    WMReleaseFont(font);
    /*
    -------------
    Credits Label
    -------------
    */
    panel->creditsLabel = WMCreateLabel(panel->win);
    WMResizeWidget(panel->creditsLabel, 312, 40);
    WMMoveWidget(panel->creditsLabel, 14, 70);

    font = WMSystemFontOfSize(scrPtr, 10);
    WMSetLabelFont(panel->creditsLabel, font);
    WMSetLabelText(panel->creditsLabel, "Thanks go to:\n     ]d for helping me out with some nasty bugs\n     Antony Quinn for his great WMSound Server");
    WMReleaseFont(font);
    /*
    ----------
    Info Label
    ----------
    */
    panel->infoLabel = WMCreateLabel(panel->win);
    WMResizeWidget(panel->infoLabel, 312, 30);
    WMMoveWidget(panel->infoLabel, 14, 138);

    font = WMSystemFontOfSize(scrPtr, 9);
    WMSetLabelFont(panel->infoLabel, font);
    WMSetLabelText(panel->infoLabel, "(C) Copyright 1998, by Pascal G.Hofstee\n<daeron@shadowmere.student.utwente.nl>\nhttp://shadowmere.student.utwente.nl/wmss");
    WMReleaseFont(font);




    /*
    ---------
    Exit Button
    ---------
    */
    panel->exitButton = WMCreateCommandButton(panel->win);
    WMResizeWidget(panel->exitButton, 75,24);
    WMMoveWidget(panel->exitButton, 257, 144);
    WMSetButtonText(panel->exitButton, "Exit");
    WMSetButtonAction(panel->exitButton, (WMAction *)wmssExitInfo, panel);



    WMRealizeWidget(panel->win);
    WMMapSubwidgets(panel->win);

    return panel;
}


void
wmssRunInfoPanel(WMSSInfoPanel *panel)
{
    XEvent event;

    WMMapWidget(panel->win);

    panel->flags.done = 0;

    while (!panel->flags.done) {
        WMNextEvent(dpy, &event);
        WMHandleEvent(&event);
    }

    WMUnmapWidget(panel->win);
}


void
wmssDestroyInfoPanel(WMSSInfoPanel *panel)
{
    WMUnmapWidget(panel->win);
    WMDestroyWidget(panel->win);
    free(panel);
}

