/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*                       William Moore <billy@mud.mind.net>		      *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/
#include "wmsound.h"

static int getPathList();
static int getString();

typedef struct SDefaults {
	const char	*Key;
	const char	*Default;
	void		*Addr;
	int		(*convert)();
} SDefaults;


struct SDefaults Options [ ] = {
	{"SoundPath",	DEF_SOUND_PATH,	&sPrefrences.SoundPath, 		getPathList},
	{"Device",	DEF_DEVICE,	&sPrefrences.SoundDevice,		getString},
	{"AppExit",	"appexit.wav", 	&sPrefrences.Sound[WMSound_AppExit], 	getString},
	{"AppStart",	"maximize.wav", &sPrefrences.Sound[WMSound_AppStart], 	getString},
	{"Hide",	"hide.wav",	&sPrefrences.Sound[WMSound_Hide], 	getString},
	{"Iconify",	"iconify.wav",	&sPrefrences.Sound[WMSound_Iconify], 	getString},
	{"DeIconify",	"deiconify.wav",&sPrefrences.Sound[WMSound_DeIconify],	getString},
	{"Maximize",	"maximize.wav",	&sPrefrences.Sound[WMSound_Maximize], 	getString},
	{"UnMaximize",	"minimize.wav", &sPrefrences.Sound[WMSound_UnMaximize], getString},
	{"Shade",	"shade.wav",	&sPrefrences.Sound[WMSound_Shade], 	getString},
	{"Startup",	"startup.wav",	&sPrefrences.Sound[WMSound_Startup], 	getString},
	{"UnHide",	"unhide.wav",	&sPrefrences.Sound[WMSound_UnHide], 	getString},
	{"UnShade",	"unshade.wav",  &sPrefrences.Sound[WMSound_UnShade], 	getString},
	{"UserDefined", "check.wav",    &sPrefrences.Sound[WMSound_UserDefined], getString},
	
	
};
#define MaxOptions (sizeof(Options) / sizeof(Options[0]))

void sReadDefaults(proplist_t *dict, const char *Filename) {
  proplist_t key, value, filename;
  int i;
	
  *dict = PLMakeDictionaryFromEntries(NULL,NULL,NULL);
  filename = PLMakeString((char*)Filename);
	
  PLSetFilename(*dict,filename);
	
  for(i=0;i<MaxOptions;i++) {
    key = PLMakeString((char*)Options[i].Key);
    value = PLGetProplistWithDescription((char*)Options[i].Default);
    if(value) {
      PLInsertDictionaryEntry(*dict,key,value);
    }
  }
}

void sUpdateOptions( ) {
  proplist_t *AllKeys;		// All Keys in WMSoundAttributes
  unsigned int i, MaxKeys;	// Counter Variables
  int x;
  proplist_t *Key,*Entry;
  char *name;
  	
  AllKeys = PLGetAllDictionaryKeys(WMSound);
  MaxKeys = PLGetNumberOfElements(AllKeys);
	
  for(i=0;i<MaxKeys;i++) {
    proplist_t *Key = PLGetArrayElement(AllKeys,i);
    proplist_t *Entry = PLGetDictionaryEntry(WMSound,Key);
    name = PLGetString(Key);
		
    // This Simple Loop cycles through the Options table and then
    // updates each one accordingly.
    for(x=0;x<MaxOptions;x++) {
      if(!strcmp(name,Options[x].Key)) {
	if ((*Options[x].convert) (&Options[x], Entry) < 0) {
	  sBugf("'%s' is not in the right format",Options[x].Key);
	}
      }
    }
  }
}


static int getPathList (SDefaults *entry, proplist_t *value) {
  static char **data;
  unsigned int i, MaxPaths = PLGetNumberOfElements(value);
  proplist_t *path;
  	
  if (!PLIsArray(value)) {
    return -1;
  }
	
  data = malloc(sizeof(char *)*(MaxPaths+1));
	
  for(i=0;i<MaxPaths;i++) {
    path = PLGetArrayElement(value,i);
	
    if(!PLIsString(path)) {
      return -1;
    }
		
    data[i] = strdup(PLGetString(path));
  }
  data[i] = NULL;
	
  if (*(char***)entry->Addr!=NULL) {
    char **tmp = *(char ***)entry->Addr;
    for(i=0;tmp[i]!=NULL;i++) {
      free(tmp[i]);
    }
    free(tmp);
  }
  *(char***)entry->Addr = data;
  return 0;
}

static int getString (SDefaults *entry, proplist_t *value) {
  if (!PLIsString(value)) {
    return -1;
  }
  *(char **)entry->Addr = PLGetString(value);
  return 0;
}
