#include <stdio.h>
#include <libgus.h>
#include <assert.h>

/*
 *  Hey - C is very good language for writing of songs :-))
 */

#define CARD		( 1 - 1 )
#define DEVICE		( device -> device )

#define KICK1		(164-129)
#define KICK2		(165-129)
#define SNARE1		(167-129)
#define COWBELL		(185-129)
#define TOMLO1		(172-129)
#define TOMLO2		(170-129)
#define TOMHI1		(179-129)
#define TOMHI2		(177-129)
#define TRIANGEL1	(209-129)
#define CYMBAL1		(178-129)
#define CYMBAL2		(186-129)

#define PGM( x )	instr[ iused++ ] = ( x )

static gus_midi_device_t *device;

static inline void play( int drum, int vel )
{
  gus_midi_note_on( DEVICE, 9, drum, vel );
  gus_midi_note_off( DEVICE, 9, drum, vel );
}  

void main()
{
  int i;

  if ( gus_midi_open_intelligent( GUS_MIDI_OUT, NULL, 4096, GUS_MIDI_OF_NONE ) < 0 )
    {
      printf( "open error: %s\n", gus_midi_error );
      return;
    }
  device = gus_midi_output_devices();
  assert( device );
  if ( device -> cap & GUS_MIDI_CAP_MEMORY )
    {
      int iused;
      int instr[ 20 ];
    
      iused = 0;
      PGM( KICK1 + 128 );		/* preload drum patches */
      PGM( KICK2 + 128 );		/* preload drum patches */
      PGM( SNARE1 + 128 );		/* preload drum patches */
      PGM( COWBELL + 128 );		/* preload drum patches */
      PGM( TOMLO1 + 128 );		/* preload drum patches */
      PGM( TOMLO2 + 128 );		/* preload drum patches */
      PGM( TOMHI1 + 128 );		/* preload drum patches */
      PGM( TOMHI2 + 128 );		/* preload drum patches */
      PGM( TRIANGEL1 + 128 );		/* preload drum patches */
      PGM( CYMBAL1 + 128 );		/* preload drum patches */
      PGM( CYMBAL2 + 128 );		/* preload drum patches */
      gus_midi_preload_program( DEVICE, (int *)&instr, iused );
    }
  gus_midi_reset();
  gus_midi_timer_base( 100 );
  gus_midi_timer_tempo( 100 );
  gus_midi_timer_start();
  for ( i = 0; i < 6; i++ )
    {
      play( KICK1, 128 );
      gus_midi_wait( 80 );
      gus_midi_write();
    }
  for ( i = 0; i < 12; i++ )
    {
      play( KICK1, 128 );
      gus_midi_wait( 40 - ( i * 2 ) );
      play( SNARE1, 128 );
      gus_midi_wait( 40 - ( i * 2 ) );
      gus_midi_write();
    }
  for ( i = 0; i < 12; i++ )
    {
      play( KICK1, 128 );
      gus_midi_wait( 10 );
      play( COWBELL, 60 );
      gus_midi_wait( 10 );
      play( SNARE1, 128 );
      gus_midi_wait( 20 );
      play( KICK1, 100 );
      gus_midi_wait( 10 );
      play( KICK2, 128 );
      gus_midi_wait( 10 );
      play( SNARE1, 128 );
      gus_midi_wait( 20 );
      play( COWBELL, 100 );
      gus_midi_write();
    }
  gus_midi_wait( 10 );
  play( TOMLO1, 128 ); gus_midi_wait( 10 );
  play( TOMLO2, 100 ); gus_midi_wait( 10 );
  play( TOMHI1, 128 ); gus_midi_wait( 10 );
  play( TOMHI2, 90 ); gus_midi_wait( 10 );
  play( CYMBAL1, 128 ); gus_midi_wait( 10 );
  for ( i = 0; i < 12; i++ )
    {
      play( KICK1, 128 );
      gus_midi_wait( 10 );
      if ( i > 0 ) play( COWBELL, 60 );
      gus_midi_wait( 10 );
      play( SNARE1, 128 );
      gus_midi_wait( 20 );
      play( KICK1, 100 );
      gus_midi_wait( 10 );
      play( KICK2, 128 );
      gus_midi_wait( 10 );
      play( SNARE1, 128 );
      gus_midi_wait( 20 );
      play( COWBELL, 100 );
      play( TRIANGEL1, 100 );
      gus_midi_write();
    }
  gus_midi_wait( 20 );
  play( CYMBAL1, 128 );
  play( CYMBAL1, 128 );
  play( CYMBAL2, 128 );
  play( CYMBAL2, 128 );
  gus_midi_wait( 200 );
  gus_midi_close();
}
