/*==============================================================================

  $Id: mmio.h,v 1.8 1998/09/20 21:45:14 miod Exp $

  MikMod file I/O and error codes

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _MMIO_H_
#define _MMIO_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>

#include <tdefs.h>

/*========== Error codes */

enum {
	MMERR_OPENING_FILE = 1,
    MMERR_OUT_OF_MEMORY,

    MMERR_SAMPLE_TOO_BIG,
    MMERR_OUT_OF_HANDLES,
    MMERR_UNKNOWN_WAVE_TYPE,

    MMERR_LOADING_PATTERN,
    MMERR_LOADING_TRACK,
    MMERR_LOADING_HEADER,
    MMERR_LOADING_SAMPLEINFO,
    MMERR_NOT_A_MODULE,
	MMERR_NOT_A_STREAM,
	MMERR_ITPACK_INVALID_DATA,

    MMERR_DETECTING_DEVICE,
    MMERR_INVALID_DEVICE,
    MMERR_INITIALIZING_MIXER,
	MMERR_OPENING_AUDIO,
	MMERR_16BIT_ONLY,
	MMERR_NON_BLOCK,

	MMERR_AF_AUDIO_PORT,

    MMERR_AIX_CONFIG_INIT,
    MMERR_AIX_CONFIG_CONTROL,
    MMERR_AIX_CONFIG_START,

    MMERR_HP_SETSAMPLESIZE,
    MMERR_HP_SETSPEED,
    MMERR_HP_CHANNELS,
    MMERR_HP_AUDIO_OUTPUT,
    MMERR_HP_AUDIO_DESC,
    MMERR_HP_GETGAINS,
    MMERR_HP_SETGAINS,
    MMERR_HP_BUFFERSIZE,

	MMERR_OSS_SETFRAGMENT,
	MMERR_OSS_SETSAMPLESIZE,
	MMERR_OSS_SETSTEREO,
	MMERR_OSS_SETSPEED,

	MMERR_SGI_SPEED,
	MMERR_SGI_16BIT,
	MMERR_SGI_8BIT,
	MMERR_SGI_STEREO,
	MMERR_SGI_MONO,

	MMERR_SUN_INIT,
	MMERR_SUN_16BIT_ULAW,

    MMERR_MAX
};

/*========== Memory allocation */

extern void* _mm_malloc(size_t);
extern void* _mm_calloc(size_t,size_t);

/*========== Error handling */

typedef void (_mm_handler)(void);

extern _mm_handler *_mm_errorhandler;
extern int  _mm_errno;
extern BOOL _mm_critical;
extern CHAR *_mm_errmsg[MMERR_MAX];

extern _mm_handler *_mm_RegisterErrorHandler(_mm_handler*);

/*========== Portable file I/O */

extern BOOL _mm_FileExists(CHAR *fname);

#define _mm_write_SBYTE(x,y) fputc((int)x,y)
#define _mm_write_UBYTE(x,y) fputc((int)x,y)

#define _mm_read_SBYTE(x) (SBYTE)fgetc(x)
#define _mm_read_UBYTE(x) (UBYTE)fgetc(x)

#define _mm_write_SBYTES(x,y,z) fwrite((void *)x,1,y,z)
#define _mm_write_UBYTES(x,y,z) fwrite((void *)x,1,y,z)
#define _mm_read_SBYTES(x,y,z)  fread((void *)x,1,y,z)
#define _mm_read_UBYTES(x,y,z)  fread((void *)x,1,y,z)

#define _mm_rewind(x) _mm_fseek(x,0,SEEK_SET)

extern int  _mm_fseek(FILE*,long,int);
extern void _mm_iobase_setcur(FILE*);
extern void _mm_iobase_revert(void);
extern long _mm_ftell(FILE*);
extern FILE *_mm_fopen(CHAR*,CHAR*);
extern void _mm_write_string(CHAR*,FILE*);
extern int  _mm_read_string (CHAR*,int,FILE*);

extern SWORD _mm_read_M_SWORD(FILE*);
extern SWORD _mm_read_I_SWORD(FILE*);
extern UWORD _mm_read_M_UWORD(FILE*);
extern UWORD _mm_read_I_UWORD(FILE*);

extern SLONG _mm_read_M_SLONG(FILE*);
extern SLONG _mm_read_I_SLONG(FILE*);
extern ULONG _mm_read_M_ULONG(FILE*);
extern ULONG _mm_read_I_ULONG(FILE*);

extern int _mm_read_M_SWORDS(SWORD*,int,FILE*);
extern int _mm_read_I_SWORDS(SWORD*,int,FILE*);
extern int _mm_read_M_UWORDS(UWORD*,int,FILE*);
extern int _mm_read_I_UWORDS(UWORD*,int,FILE*);

extern int _mm_read_M_SLONGS(SLONG*,int,FILE*);
extern int _mm_read_I_SLONGS(SLONG*,int,FILE*);
extern int _mm_read_M_ULONGS(ULONG*,int,FILE*);
extern int _mm_read_I_ULONGS(ULONG*,int,FILE*);

extern void _mm_write_M_SWORD(SWORD,FILE*);
extern void _mm_write_I_SWORD(SWORD,FILE*);
extern void _mm_write_M_UWORD(UWORD,FILE*);
extern void _mm_write_I_UWORD(UWORD,FILE*);

extern void _mm_write_M_SLONG(SLONG,FILE*);
extern void _mm_write_I_SLONG(SLONG,FILE*);
extern void _mm_write_M_ULONG(ULONG,FILE*);
extern void _mm_write_I_ULONG(ULONG,FILE*);

extern void _mm_write_M_SWORDS(SWORD*,int,FILE*);
extern void _mm_write_I_SWORDS(SWORD*,int,FILE*);
extern void _mm_write_M_UWORDS(UWORD*,int,FILE*);
extern void _mm_write_I_UWORDS(UWORD*,int,FILE*);

extern void _mm_write_M_SLONGS(SLONG*,int,FILE*);
extern void _mm_write_I_SLONGS(SLONG*,int,FILE*);
extern void _mm_write_M_ULONGS(ULONG*,int,FILE*);
extern void _mm_write_I_ULONGS(ULONG*,int,FILE*);

#ifdef __cplusplus
}
#endif
#endif
