/* gradio.h
 * Contains prototypes and some useful constant definition
 */

/* (c) 1998 by Keith Wesolowski (wesolows@cs.unr.edu) 

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <asm/io.h>
#include <gtk/gtk.h>
#include <linux/version.h>

/* Make sure we have the right version code */
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,1,106))
#define NO_KERNEL
#else
#undef NO_KERNEL
#endif /* LINUX_VERSION_CODE */

#define GR_TUNER_UP 0
#define GR_TUNER_DOWN 1

#define GR_VOL_UP 2
#define GR_VOL_DOWN 3

#define GR_TUNER_STEP_LARGE 200
#define GR_TUNER_STEP_SMALL 10

#define GR_FREQ_MIN 87900
#define GR_FREQ_MAX 108100
#define GR_FREQ_DEFAULT 100100
#define GR_VOL_MIN 0
#define GR_VOL_MAX 11

#define DEV_NAME "/dev/radio"

#define gradio_read_card(address) ((int)inb (address))
#define gradio_write_card(address,value) (outb (value, address))

typedef enum radio_if_type { GR_IF_KERNEL=0, GR_IF_DIRECT, GR_IF_NONE } radio_if_type;

typedef struct
{
    radio_if_type interface;
    int port;
    int freq;
    int vol;
    int muted;
    int mem[8];
    int power;
    int memset;
    int tuned;
} radio_status;

void gradio_get_interface (void);
void gradio_use_direct (void);

void gradio_init (void);
int gradio_check_cmdline (int argc, char *argv[]);
void gradio_usage (char *name);

GtkWidget *gradio_get_volume_box (GtkWidget *w);
GtkWidget *gradio_get_tuner_box (GtkWidget *w);
GtkWidget *gradio_get_memory_box (GtkWidget *w);
GtkWidget *gradio_get_control_box (GtkWidget *w);
GtkWidget *gradio_get_display (GtkWidget *w);
GtkWidget *xpm_label_box_d (GtkWidget *parent, gchar **xpm_d, 
			    gchar *label_text);

gint gradio_delete_event_cb (GtkWidget *w, gpointer *data);
void gradio_destroy_cb (GtkWidget *w, gpointer *data);
void gradio_vol_cb (GtkWidget *w, gpointer *data);
void gradio_tuner_cb (GtkWidget *w, GdkEventButton *data);
void gradio_power_cb (GtkWidget *w, gpointer *data);
void gradio_mute_cb (GtkWidget *w, gpointer *data);
void gradio_memory_cb (GtkWidget *w, GdkEventButton *data);
gint gradio_button_press_cb (GtkWidget *w, GdkEvent *data);
void gradio_setfreq_cb (GtkWidget *w, gpointer *data);
void gradio_help_cb (GtkWidget *w, gpointer *data);
void gradio_about_cb (GtkWidget *w, gpointer *data);
void gradio_freq_from_value_cb (GtkWidget *w, gpointer *data);
void gradio_close_dialog_cb (GtkWidget *w, gpointer *data);
void gradio_port_ok_cb (GtkWidget *w, gpointer *data);

double gradio_get_freq_fact (int fd);
int gradio_setfreq (int fr);
int gradio_setvol (int lvl);
void gradio_mute (int state);
void gradio_get_port (int *addr);

void gradio_save_rcfile (void);

void gradio_pixmap_inits (GtkWidget *w);
void gradio_set_display_from_status (void);
