#include "mpegsound.h"
#include "splay.h"
#include <string.h>
#include <sys/stat.h>
#include <math.h>
#include <unistd.h>
#include "../common.h"

Soundinputstream *loader = NULL;
Rawtoemusic	 *player = NULL;
Mpegtoraw	 *server = NULL;

char *song_path;

int pcmperframe, frequency, maxframes;
int wait_for_me;
int do_downmix = 0;
int do_mono = 0;

extern int end_of_song;
extern int end_song;
extern int stop_song;
extern pthread_t player_thread;
extern pthread_mutex_t player_lock;

void sseek_to_frame(int second)
{
   int frame;
   if (!server)
      return;
   if (!frequency)
      frequency = server->getfrequency();
   if (!pcmperframe)
      pcmperframe = server->getpcmperframe();
   frame = second * frequency / pcmperframe;
   server->clearbuffer();
   server->setframe(frame);
}

void *mp3_thread(void *foo)
{
   int start = 0;
   if (foo)
      start = *(int*)foo; 
   player = new Rawtoemusic;
   player->initialize(NULL);
   server = new Mpegtoraw(loader, player);
   server->initialize(song_path);
   server->setforcetomono(do_mono);
   server->setdownfrequency(do_downmix);
   server->run(-1);
   frequency = server->getfrequency();
   pcmperframe = server->getpcmperframe();
/*   if (start)
      server->setframe(start * frequency / pcmperframe);  */
   wait_for_me = 0;
   pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
   pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);
   while(1) {
      pthread_mutex_lock(&player_lock);
      if (!server->run(5) && (server->geterrorcode() == SOUND_ERROR_FINISH)) {
         end_song = 1;
	 server->clearbuffer();
	 pthread_mutex_unlock(&player_lock);
	 while (1) {
	    pthread_testcancel();
	    usleep(500);
         }
      }
      pthread_mutex_unlock(&player_lock);
      pthread_testcancel();
   }
}

int splay(int start, char *path)
{
   int err;
   end_of_song = 0;
   loader = Soundinputstream::hopen(path, &err);
   if (!loader)
      return 0;
   song_path = path;
   wait_for_me = 1;
   frequency = 0;
   pcmperframe = 0;
   pthread_create(&player_thread, NULL, mp3_thread, (void *)&start);
   return 1;
}

void spause_it(void)
{
}

void sstop(int playing)
{
   while (wait_for_me)
      usleep(100);
   pthread_cancel(player_thread);
   pthread_join(player_thread, NULL);
   if (!server)
      return;
   server->clearbuffer();
   player->abort();
   player->resetsoundtype();
   delete loader;
   delete player;
   delete server;
   server = NULL;
   frequency = 0;
   pcmperframe = 0;
}

int sis_file(char *path)
{
   char *temp;
   if (!path)
      return 0;
   if ((temp = strrchr(path, '.')) && (temp+3)) {
      if (!strcasecmp((temp+1),"mp3")) 
         return 1;
      if (!strcasecmp((temp+1),"mpg")) 
         return 1;
      if (!strcasecmp((temp+1),"mp2"))
         return 1;
   }
   return 0;
}

void sversion_info(char *id, char *version, char *copyright)
{
   strcpy(id, "splay");
   strcpy(version, "0.8.2");
   strcpy(copyright, "1998 Woo-jae Jung");
}

void sinit(void)
{
}

void sconfig(char *left, char *right)
{
   if (!strncmp("BEGIN", left, 5) || !strncmp("END", left, 3))
      return;
   else if (!strncmp("DOWNMIX", left, 7))
      do_downmix = parsebool(right);
   else if (!strncmp("FORCETOMONO", left, 4))
      do_mono = parsebool(right);
}
