
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <pthread.h>
#include "../common.h"

#include "gen.h"

extern int end_song;
extern int stop_song;
extern pthread_t player_thread;
extern pthread_mutex_t player_lock;

WrapperList *list;
char *filename;

void gen_seek_to_frame(int second)
{
}

void *gen_thread(void *foo)
{
   char *command;
   struct wrapper_item *cur;

   pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
   if (!list || !list->first)
      goto gendone;
   cur = list->first;
   while (cur) {
      char *temp = strrchr(filename, '.');

      if (!(temp + 1))
	 goto gendone;
      if (!strcasecmp((temp + 1), cur->extension))
	 break;
      cur = cur->next;
   }
   command = Emalloc(strlen(cur->player) + strlen(filename) + 2);
   sprintf(command, "%s %s", cur->player, filename);
   system(command);
   Efree(command);
 gendone:
   end_song = 1;
   return NULL;
}

int gen_play(int start, char *path)
{
   filename = duplicate(path);
   pthread_create(&player_thread, NULL, gen_thread, NULL);
   return 1;
}

void gen_pause_it(void)
{
}

void gen_stop(int playing)
{
   pthread_cancel(player_thread);
   pthread_join(player_thread, NULL);
   Efree(filename);
}

int gen_is_file(char *path)
{
   struct wrapper_item *cur;
   char *temp;

   if (!path || !list || !list->first)
      return 0;
   cur = list->first;
   if ((temp = strrchr(path, '.')) && (temp + 1)) {
      while (cur) {
	 if (!strcasecmp((temp + 1), cur->extension))
	    return 1;
	 cur = cur->next;
      }
   }
   return 0;
}

void gen_version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "genwrap");
   strcpy(version, "0.1");
   strcpy(copyright, "1998 Isaac Richards");
}

void gen_init(void)
{
}

void gen_get_info(struct playlist_item *song)
{
   char *temp;

   temp = strrchr(song->path, '/');
   if (temp + 1) {
      temp++;
      song->name = duplicate(temp);
   }
   song->length = 0;
}

void gen_config(char *left, char *right)
{
   struct wrapper_item *cur;

   if (!strncmp("BEGIN", left, 5) || !strncmp("END", left, 3))
      return;
   if (!list) {
      list = Emalloc(sizeof(WrapperList));
      list->first = NULL;
      list->last = NULL;
   }
   cur = list->first;
   if (cur) {
      while (cur->next)
	 cur = cur->next;
      cur->next = Emalloc(sizeof(struct wrapper_item));

      list->last = cur->next;
      cur = cur->next;
   }
   else {
      cur = Emalloc(sizeof(struct wrapper_item));

      list->last = list->first = cur;
   }
   cur->next = NULL;
   cur->extension = duplicate(left);
   cur->player = duplicate(right);
}

struct player_plugin *setup_plugin(void)
{
   struct player_plugin *temp = Emalloc(sizeof(struct player_plugin));

   temp->init = gen_init;
   temp->config = gen_config;
   temp->seek_to_frame = gen_seek_to_frame;
   temp->play = gen_play;
   temp->stop = gen_stop;
   temp->pause_it = gen_pause_it;
   temp->is_file = gen_is_file;
   temp->get_info = gen_get_info;
   temp->version_info = gen_version_info;
   return temp;
}
