#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "../common.h"
#include "cd.h"
#include "cddb.h"
#include "struct.h"

#define DEFAULTDEVICE "/dev/cdrom"

char cdplayerDevice[128] = DEFAULTDEVICE;

int currenttrack = 0;
int maxtracks = 31;

void *cd_thread(void *foo);

extern int cur_track, cur_index, cur_lasttrack, cur_firsttrack, cur_pos_abs;
extern int cur_frame, cur_pos_rel, cur_tracklen, cur_cdlen, cur_ntracks;
extern int cur_nsections, cur_listno, cur_stopmode, exit_on_eject, cur_balance;
extern enum cd_modes cur_cdmode;
extern char cur_contd, cur_avoid;
extern char *cd_device;
extern struct cdinfo_wm thiscd, *curcd;
extern int cddb_port;
extern char *cddb_host, *cddb_dir;

int cur_balance = 10;
int info_modified = 0;

/* (denis) my globals : */


unsigned int cue_time = 10;	/* nbr of seconds for cue -> see -c command line option */
unsigned int vol_step = 5;	/* Volume to set when right click on display */
unsigned int autoPlay = 0;	/* if set, play a disk when it is inserted -> see -a c.l. option  */
unsigned int datatrack = 0;	/* is the current track a data track ? */

unsigned int curr_track = 0;

void pre_cda(void)
{
   cd_status();
   if (cur_cdmode != EJECTED) {
      if (curcd->trk[curr_track].data)
	 datatrack = 1;
      else
	 datatrack = 0;
   }
   cd_status();
}

void cd_seek_to_frame(int second)
{
   pre_cda();
   maxtracks = thiscd.ntracks + 1;
   play_cd(curr_track, second, maxtracks);
   cd_status();
}

int getnumtracks(void)
{
   cd_status();
   fill_cddb_data(0);
   return thiscd.ntracks;
}

int cd_play(int start, char *song)
{
   int maxtracks;
   int track = atoi(song + 1);

   curr_track = track;
   pre_cda();
   maxtracks = thiscd.ntracks + 1;
   play_cd(curr_track, start, maxtracks);
   cd_status();
   pthread_create(&player_thread, NULL, cd_thread, NULL);
   return 1;
}

void cd_pause_it(void)
{
   pre_cda();
   pause_cd();
}

void cd_stop(int playing)
{
   pthread_cancel(player_thread);
   pthread_join(player_thread, NULL);
   pre_cda();
   if (playing) {
      curr_track = 0;
      cur_cdmode = 3;
      stop_cd();
   }
   else {
      curr_track = 0;
      eject_cd();
   }
}

void *cd_thread(void *foo)
{
   pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
   pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);
   while (curr_track != cur_track) {
      cd_status();
      usleep(500);
   }
   while (1) {
      pthread_mutex_lock(&player_lock);
      cd_status();
      if ((curr_track != cur_track) || (cur_cdmode != PLAYING))
	 end_song = 1;
      pthread_mutex_unlock(&player_lock);
      pthread_testcancel();
      usleep(500);
   }
}

int cd_is_file(char *path)
{
   char *temp;

   if ((temp = strrchr(path, '.')))
      if (!strcasecmp((temp + 1), "cda"))
	 return 1;
   return 0;
}

void cd_version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "ascd");
   strcpy(version, "0.7");
   strcpy(copyright, "1997 Rob Malda and Denis Bourez");
}

void cd_init(void)
{
}

void cd_get_info(struct playlist_item *song)
{
   int track;

   if (!song || !song->path)
      return;
   track = atoi(song->path + 1);
   cd_status();
   if (!thiscd.tried)
      fill_cddb_data(0);
   if (thiscd.name && thiscd.trk[track - 1].name) {
      song->name = Emalloc(strlen(thiscd.name) + strlen(thiscd.trk[track - 1].name) + 6);
      sprintf(song->name, "(%s)-%s", thiscd.name, thiscd.trk[track - 1].name);
   }
   else {
      song->name = Emalloc(15);
      sprintf(song->name, "CD Track %d", track);
   }
   if (cd_status()) {
      track = atoi((song->path) + 1);
      song->length = curcd->trk[track - 1].length;
   }
}

void cd_config(char *left, char *right)
{
   if (!strncmp("BEGIN", left, 5) || !strncmp("END", left, 3))
      return;
   else if (!strncmp("CDDB_HOST", left, 9)) {
      cddb_host = Emalloc(strlen(right) + 1);
      strcpy(cddb_host, right);
   }
   else if (!strncmp("CDDB_PORT", left, 9))
      cddb_port = atoi(right);
   else if (!strncmp("CDDB_DIR", left, 8)) {
      cddb_dir = Emalloc(strlen(right) + 1);
      strcpy(cddb_dir, right);
   }
}

struct player_plugin *setup_plugin(void)
{
   struct player_plugin *temp = Emalloc(sizeof(struct player_plugin));

   temp->init = cd_init;
   temp->config = cd_config;
   temp->seek_to_frame = cd_seek_to_frame;
   temp->play = cd_play;
   temp->stop = cd_stop;
   temp->pause_it = cd_pause_it;
   temp->is_file = cd_is_file;
   temp->get_info = cd_get_info;
   temp->version_info = cd_version_info;
   return temp;
}
