

#include "widget.h"
#include "../econfig.h"

Window comms_win;
char *comms_msg;

int FindE(void)
{
   Atom a, ar;
   unsigned char *s = NULL;
   unsigned long num, after;
   int format;

   EDBUG(8, "FindE");
   a = XInternAtom(disp, "ENLIGHTENMENT_COMMS", True);
   if (a == None)
      EDBUG_RETURN(FALSE);
   XGetWindowProperty(disp, root, a, 0, 14, False, AnyPropertyType, &ar, &format, &num, &after, &s);
   if (s)
      sscanf((char *) s, "%*s %x", (unsigned int *) &comms_win);
   else
      comms_win = 0;
   XFree(s);
   EDBUG_RETURN((comms_win) ? TRUE : FALSE);
}

char *ECommsGet(XEvent ev)
{
   char s[13], s2[9], *msg;
   int i;

   EDBUG(8, "ECommsGet");
   if (ev.type != ClientMessage)
      EDBUG_RETURN(NULL);
   s[12] = 0;
   s2[8] = 0;
   msg = NULL;
   for (i = 0; i < 8; i++)
      s2[i] = ev.xclient.data.b[i];
   for (i = 0; i < 12; i++)
      s[i] = ev.xclient.data.b[i + 8];
   if (comms_msg) {
      comms_msg = Erealloc(comms_msg, strlen(comms_msg) + strlen(s) + 1);
      strcat(comms_msg, s);
   }
   else
      comms_msg = duplicate(s);
   if (strlen(s) < 12) {
      msg = comms_msg;
      comms_msg = NULL;
   }
   EDBUG_RETURN(msg);
}

void HandleEComms(XEvent ev)
{
   char *s;
   char s1[512], s2[512];

   EDBUG(5, "HandleEComms");
   s = ECommsGet(ev);
   if (!s)
      EDBUG_RETURN_;
   splitstring(s1, s2, s);
   if (!strcmp("PLAY_FILE", s1)) {
      fprintf(stderr, "Blah, someone wants me to play: %s\n", s2);
   }
   else
      fprintf(stderr, "Unknown E message %s\n", s);
   Efree(s);
   EDBUG_RETURN_;
}

void ECommsSend(char *s)
{
   char ss[21];
   int i, j, len;
   XEvent ev;
   Atom a;

   EDBUG(8, "ECommsSend");
   if (!s)
      EDBUG_RETURN_;
   len = strlen(s);
   a = XInternAtom(disp, "ENL_MSG", True);
   ev.xclient.type = ClientMessage;
   ev.xclient.serial = 0;
   ev.xclient.send_event = True;
   ev.xclient.window = comms_win;
   ev.xclient.message_type = a;
   ev.xclient.format = 8;
   for (i = 0; i < len + 1; i += 12) {
      sprintf(ss, "%8x", (int) comms_win);
      for (j = 0; j < 12; j++) {
	 ss[(8 + j)] = s[(i + j)];
	 if (!s[(i + j)])
	    j = 12;
      }
      ss[20] = 0;
      for (j = 0; j < 20; j++)
	 ev.xclient.data.b[j] = ss[j];
      XSendEvent(disp, comms_win, False, 0, &ev);
   }
   EDBUG_RETURN_;
}

void SetUpE(void)
{
   EDBUG(5, "SetUpE");
   ECommsSend("set clientname eMusic");
   ECommsSend("set version DR0.5");
   ECommsSend("set author Chutt");
   ECommsSend("set email ijr@po.cwru.edu");
   ECommsSend("set web http://www.icom.net/~smelecat/emp3");
   EDBUG_RETURN_;
}

typedef struct {
   CARD32 flags;
   CARD32 functions;
   CARD32 decorations;
   INT32 inputMode;
} MWMHints;

/* Motif window hints */
#define MWM_HINTS_FUNCTIONS     (1L << 0)
#define MWM_HINTS_DECORATIONS   (1L << 1)
#define MWM_HINTS_INPUT_MODE    (1L << 2)

int checkforMWM(void)
{
   Atom a;

   EDBUG(6, "checkforMWM");
   a = XInternAtom(disp, "_MOTIF_WM_HINTS", False);
   if (a == None)
      EDBUG_RETURN(FALSE);
   EDBUG_RETURN(TRUE);
}

void ESetBorderless(Window win)
{
   MWMHints mwmhints;
   Atom a;

   EDBUG(6, "ESetBorderless");
   a = XInternAtom(disp, "_MOTIF_WM_HINTS", False);
   if (a == None)
      EDBUG_RETURN_;
   mwmhints.flags = MWM_HINTS_DECORATIONS;
   mwmhints.functions = 0;
   mwmhints.decorations = 0;
   mwmhints.inputMode = 0;
   XChangeProperty(disp, win, a, a, 32, PropModeReplace, (unsigned char *) &mwmhints, 4);
   EDBUG_RETURN_;
}
