
#include "widget.h"
#include "../econfig.h"

void HideContainer(Container * cont)
{
   EDBUG(5, "HideContainer");
   if (cont->visible) {
      XUnmapWindow(disp, cont->win);
      cont->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideContainer(Container * cont)
{
   EDBUG(5, "UnhideContainer");
   if (!cont->visible) {
      XMapWindow(disp, cont->win);
      cont->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void CreateContainer(Container * cont, Window parent)
{
   EDBUG(5, "CreateContainer");
   if (!cont)
      EDBUG_RETURN_;
   cont->parent = parent;
   if (!cont->parent)
      cont->parent = root;
   if (cont->transparent)
      cont->win = CreateClearWin(cont->parent, cont->x, cont->y, cont->w, cont->h);
   else {
      cont->win = CreateWin(cont->parent, cont->x, cont->y, cont->w, cont->h);
      XSetWindowBackground(disp, cont->win, 0);
   }
   XMapWindow(disp, cont->win);
   XClearWindow(disp, cont->win);
   EDBUG_RETURN_;
}

void DefaultsContainer(Container * cont)
{
   cont->x = cont->y = cont->w = cont->h = 0;
   cont->visible = TRUE;
   cont->state = 1;
   cont->exposed = 0;
   cont->transparent = FALSE;
   cont->action_left = cont->action_middle = cont->action_right = 0;
}

Container *ConfigContainer(Window parent, FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   Container *cont = Emalloc(sizeof(Container));

   EDBUG(5, "ConfigContainer");
   DefaultsContainer(cont);
   cont->parent = parent;
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("LOCATION", s1, 8))
	    getcoords(s2, &cont->x, &cont->y);
	 else if (!strncmp("SIZE", s1, 4))
	    getcoords(s2, &cont->w, &cont->h);
	 else if (!strncmp("VISIBLE", s1, 7))
	    cont->state = parsebool(s2);
	 else if (!strncmp("TRANSPARENT", s1, 11))
	    cont->transparent = parsebool(s2);
	 else if (!strncmp("ACTION_R", s1, 8))
	    cont->action_right = parse_action(s2);
	 else if (!strncmp("ACTION_M", s1, 8))
	    cont->action_middle = parse_action(s2);
	 else if (!strncmp("ACTION_L", s1, 8))
	    cont->action_left = parse_action(s2);
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateContainer(cont, parent);
   EDBUG_RETURN(cont);
}

void MoveContainer(Container * cont, int x, int y)
{
   EDBUG(5, "MoveContainer");
   cont->x = x;
   cont->y = y;
   XMoveWindow(disp, cont->win, x, y);
   EDBUG_RETURN_;
}

void ScaleContainer(Container * cont, double scale_w, double scale_h)
{
   EDBUG(5, "ScaleContainer");
   cont->x *= scale_w;
   cont->y *= scale_h;
   cont->h *= scale_h;
   cont->w *= scale_w;
   XMoveResizeWindow(disp, cont->win, cont->x, cont->y, cont->w, cont->h);
   if (!cont->transparent)
      XSetWindowBackground(disp, cont->win, 0);
   XClearWindow(disp, cont->win);
   EDBUG_RETURN_;
}

void EventContainer(Container * cont, XEvent ev)
{
   EDBUG(5, "EventContainer");
   if (ev.type != ButtonRelease)
      EDBUG_RETURN_;
   if (ev.xbutton.button == 3 && !cont->action_right)
      ev.xbutton.button = 1;
   else if (ev.xbutton.button == 2 && !cont->action_middle)
      ev.xbutton.button = 1;
   if (ev.xbutton.button == 3)
      do_action(cont->action_right);
   else if (ev.xbutton.button == 2)
      do_action(cont->action_middle);
   else
      do_action(cont->action_left);
   EDBUG_RETURN_;
}

int isEventContainer(Container * cont, XEvent ev)
{
   EDBUG(5, "isEventContainer");
   if (ev.xbutton.subwindow == cont->win)
      EDBUG_RETURN(TRUE);
   if (ev.xany.window == cont->win)
      EDBUG_RETURN(TRUE);
   EDBUG_RETURN(FALSE);
}

void FreeContainer(Container * cont)
{
   EDBUG(5, "FreeContainer");
   if (!cont)
      EDBUG_RETURN_;
   Efree(cont);
   cont = NULL;
   EDBUG_RETURN_;
}
