typedef struct {
   Window win, parent;
   int x, y, w, h;
   int visible;
   ImageDat *normal, *clicked, *over, *current;
   int currentPart, parts;
   int state;
   int exposed;
   int action_left, action_middle, action_right;
} Button;

struct _multibutton {
   int position;
   Button *button;
   struct _multibutton *next, *prev;
};

typedef struct {
   int *var;
   int visible, state, number;
   struct _multibutton *first, *last, *current;
} MultiButton;

Button *ConfigButton(Window parent, FILE * file);
void EventButton(Button * button, XEvent ev);
void CreateButton(Button * button, Window parent);
void ClickButton(Button * button);
void NormalButton(Button * button);
void HideButton(Button * button);
void UnhideButton(Button * button);
void MoveButton(Button * button, int x, int y);
void ResizeButton(Button * button, int new_w, int new_h);
void ScaleButton(Button * button, double scale_w, double scale_h);
int isEventButton(Button * button, XEvent ev);
void SetButtonPart(Button * button, int x);
void FreeButton(Button * button);

MultiButton *ConfigMultiButton(Window parent, FILE * file, int *var);
void EventMultiButton(MultiButton * mbutton, XEvent ev);
void HideMultiButton(MultiButton * mbutton);
void UnhideMultiButton(MultiButton * mbutton);
void MoveMultiButton(MultiButton * mbutton, int x, int y);
void ScaleMultiButton(MultiButton * mbutton, double scale_w, double scale_h);
int isEventMultiButton(MultiButton * mbutton, XEvent ev);
void SetVarMultiButton(MultiButton * mbutton, int *var);
void SetMultiButton(MultiButton * mbutton, int number);
void CreateMultiButton(MultiButton * mbutton, Window parent);
void FreeMultiButton(MultiButton * mbutton);
