#include "emusic.h"

Widget *PlayWin;
ListBox *listbox;
int actiontype;


void Create_PlayWin(void)
{
   EDBUG(5, "Create_PlayWin");
   if (!PlayWin->state)
      HideWidget(PlayWin);
   EDBUG_RETURN_;
}

void PlayWin_Callback(char *the_return_path)
{
   char *temp, *returnpath;

   EDBUG(5, "PlayWin_Callback");
   if (FileWin->okdone) {
      returnpath = duplicate(the_return_path);
      switch (actiontype) {
      case ADD:
	 if (FileWin->cdmode)
	    cdtolist(returnpath, listbox->current_selection);
	 else if (!chdir(returnpath))
	    dirtolist(returnpath, "*", FileWin->recurse);
	 else {
	    temp = splitdir(returnpath);
	    if (strlen(returnpath) == 0)
	       dirtolist("/", temp, FileWin->recurse);
	    else
	       dirtolist(returnpath, temp, FileWin->recurse);
	 }
	 break;
      case SAVE:
	 saveplaylist(playlist, returnpath);
	 break;
      case LOAD:
	 loadplaylist(returnpath);
	 break;
      default:
	 break;
      }
      actiontype = 0;
      DisplayListBox(listbox);
      Efree(returnpath);
   }
   EDBUG_RETURN_;
}


void Display_PlayEditor(void)
{
   EDBUG(5, "Display_PlayEditor");
   if (PlayWin->exposed) {
      DisplayListBox(listbox);
      PlayWin->exposed = FALSE;
   }
   EDBUG_RETURN_;
}

void CheckToPlay(void)
{
   EDBUG(5, "CheckToPlay");
   DisplayListBox(listbox);
   if (!playlist->first) {
      cur_item = NULL;
      playing = FALSE;
   }
   if (!cur_item || ((listbox->current_selection == cur_item->pos) && playing)) {
      stop();
      if (playing && cur_item)
	 control(PLAY);
   }
   EDBUG_RETURN_;
}

void TogglePlayWin(void)
{
   EDBUG(4, "TogglePlayWin");
   if (PlayWin->visible)
      HideWidget(PlayWin);
   else {
      if (PlayWin->deferred) {
	 PlayWin->x = CurMW->MainWin->x + PlayWin->offset_x;
	 PlayWin->y = CurMW->MainWin->y + PlayWin->offset_y;
	 CreateWidget(PlayWin);
      }
      MoveWidget(PlayWin, CurMW->MainWin, CurMW->MainWin->x, CurMW->MainWin->y);
      UnhideWidget(PlayWin);
      if (PlayWin->raised != CurMW->MainWin->raised)
	 RaiseLowerWidget(PlayWin);
      listbox->current_selection = 1;
      listbox->start = 1;
      DisplayListBox(listbox);
   }
   EDBUG_RETURN_;
}

void Event_PlayEditor(XEvent ev)
{
   EDBUG(4, "Event_PlayEditor");
   if (!FindEventWidget(PlayWin, ev)) {
      if (!PlayWin->shaped)
	 EDBUG_RETURN_;
      if ((ev.type == ButtonPress) && (ev.xbutton.window == PlayWin->win)) {
	 move_x = ev.xbutton.x + PlayWin->offset_x;
	 move_y = ev.xbutton.y + PlayWin->offset_y;
	 moving = TRUE;
      }
      else if ((ev.type == ButtonRelease) &&
	       (ev.xbutton.window == PlayWin->win)) {
	 if (ev.xbutton.button == 3) {
	    RaiseLowerWidget(CurMW->MainWin);
	    RaiseLowerWidget(PlayWin);
	 }
	 else
	    moving = FALSE;
      }
   }
   EDBUG_RETURN_;
}

void Select_Current(int current)
{
   struct playlist_item *cur;
   int playing_temp = playing;

   EDBUG(4, "Select_Current");
   if (!playlist->first) {
      cur_item = NULL;
      EDBUG_RETURN_;
   }
   if (current <= (playlist->last->pos / 2)) {
      cur = playlist->first;
      while (cur && (cur->pos != current))
	 cur = cur->next;
   }
   else {
      cur = playlist->last;
      while (cur && (cur->pos != current))
	 cur = cur->prev;
   }
   if (cur) {
      control(STOP);
      flush_audio();
      cur_item = cur;
      if (playing_temp)
	 control(PLAY);
   }
   EDBUG_RETURN_;
}

void Defaults_PlayWin(void)
{
   EDBUG(6, "Defaults_PlayWin");
   PlayWin = Emalloc(sizeof(Widget));
   PlayWin->visible = TRUE;
   PlayWin->raised = TRUE;
   PlayWin->win = root;
   PlayWin->first = NULL;
   listbox = NULL;
   EDBUG_RETURN_;
}

void ConfigPlayEditor(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   struct _widget *cur = NULL;
   int end = FALSE;

   EDBUG(4, "ConfigPlayEditor");
   if (textmode)
      EDBUG_RETURN_;
   Defaults_PlayWin();
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("OFFSET", s1, 10))
	    getcoords(s2, &PlayWin->offset_x, &PlayWin->offset_y);
	 else if (!strncmp("VISIBLE", s1, 7)) {
	    PlayWin->state = parsebool(s2);
	    deferred = PlayWin->deferred = !PlayWin->state;
	 }
	 else if (!strncmp("BEGIN", s1, 5)) {
	    upstr(s2);
	    if (!PlayWin->first) {
	       PlayWin->first = Emalloc(sizeof(struct _widget));

	       cur = PlayWin->first;
	    }
	    else {
	       cur->next = Emalloc(sizeof(struct _widget));

	       cur = cur->next;
	    }
	    PlayWin->last = cur;
	    cur->widget = NULL;
	    cur->next = NULL;
	    if (!strncmp("BACKGROUND", s2, 9)) {
	       cur->type = BACKGROUND;
	       cur->widget = ConfigBack(file);
	       PlayWin->w = ((Background *) cur->widget)->w;
	       PlayWin->h = ((Background *) cur->widget)->h;
	       PlayWin->win = ((Background *) cur->widget)->win;
	       PlayWin->shaped = ((Background *) cur->widget)->shaped;
	       if (!deferred)
		  MoveWidget(PlayWin, CurMW->MainWin, 0, 0);
	    }
	    else if (!strncmp("BUTTON", s2, 6)) {
	       cur->type = BUTTON;
	       cur->widget = ConfigButton(PlayWin->win, file);
	    }
	    else if (!strncmp("LISTBOX", s2, 7)) {
	       cur->type = LISTBOX;
	       cur->widget = ConfigListBox(PlayWin->win, file);
	       SetPlaylistListBox(cur->widget, playlist);
	       listbox = cur->widget;
	    }
	 }
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      Create_PlayWin();
   else
      PlayWin->visible = FALSE;
   deferred = FALSE;
   EDBUG_RETURN_;
}
