
#include <X11/Xlib.h>

struct ringBuffer {
   char *bufferPtr;
   int inPos, outPos;
};

#define bufferSize(A) (((A)->inPos+AUDIO_BUFFER_SIZE-(A)->outPos) % AUDIO_BUFFER_SIZE)
#define bufferFree(A) (AUDIO_BUFFER_SIZE-1-bufferSize(A))

int audio_play(char *buffer, int size);
int audioBufferOpen(int frequency, int stereo, int sign, int big, int volume);
void audioBufferClose(void);
int audioBufferWrite(char *buf, int bytes);
void flush_audio(void);
void KillAnalysisWin(void);
void SetAnalysisWin(Window win);
void ToggleAnalysisType(void);

extern int AUDIO_BUFFER_SIZE;
extern int buffer_running;
extern int do_analysis;
extern int inputFinished;
extern struct ringBuffer audioBuffer;
