# Module: ExternalProgs.tcl
# 6.5.96 T.Niederreiter
#
# Defines all external called programs and icons.
#

# System-Programs:

set DF df
set MKE2FS mke2fs
set LS ls
set DU du
set RM rm
set MOUNT mount
set UMOUNT umount
set DATE date
set CHOWN chown
set CAT cat
set FGREP fgrep

# config-files
set CFGFILE "xcdroast.conf"
set MSTRTYPEFILE "mastertype.def"
set MSTRHEADER "masterheader.def"
set WINPOSITIONS "winpositions.def"

global TESTSAMPLE CDRICO LOGOICO
global BINDIR ISODETECT ISOSIZE ISOINFO
global ISOINFO READCDDA PLAYCDDA MYDD MYCMP
global CDWRITE MKISOFS LIBDIR CDRECORD


# Init the external paths

proc init_paths { } {
global TESTSAMPLE CDRICO LOGOICO
global BINDIR ISODETECT ISOSIZE ISOINFO
global ISOINFO READCDDA PLAYCDDA MYDD MYCMP
global CDWRITE MKISOFS LIBDIR CDRECORD

	# sound-files
	set TESTSAMPLE $LIBDIR/sound/test.cdr 


	# Icons/Logos

	set CDRICO $LIBDIR/logo/xcdricon.xbm
	set LOGOICO $LIBDIR/logo/xcdrlogo.gif


	# Private-Programs:

	set BINDIR "$LIBDIR/bin"

	set ISODETECT $BINDIR/isodetect
	set ISOSIZE $BINDIR/isosize
	set ISOINFO $BINDIR/isoinfo
	set READCDDA $BINDIR/readcdda
	set PLAYCDDA $BINDIR/playcdda
	set MYDD $BINDIR/mydd
	set MYCMP $BINDIR/mycmp
	set MKISOFS $BINDIR/mymkisofs-1.12b4
	set CDRECORD $BINDIR/cdrecord-1.6.1
}

