"""
  PDA.Palm.Tk.DBPicker - multiple PalmOS database picker
  $Id$

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This is a file selection dialog box, in the familiar 'installer'
  style.  That is, it has two listboxes -- the one on the left is
  a file browser, and the one on the right accumulates your
  selections.  Buttons arranged between the boxes allow you to
  add and remove files from the selection.

"""

from Tkinter import *
import tkSimpleDialog

from PDA.Palm import pdbfile
from PDA.Palm.Tk.DBInfoDialog import DBInfoDialog

import sys, os, string

class DBPicker(tkSimpleDialog.Dialog):
    def __init__(self, parent, path='.', title='DB File Picker'):
	self.path = os.path.normpath(os.path.join(os.getcwd(), path))

	tkSimpleDialog.Dialog.__init__(self, parent, title)

    def body(self, p):
	center = Frame(p)
	center.columnconfigure(0, weight=1)
	center.columnconfigure(3, weight=1)
	
	# center frame: listboxes and buttons
	self.lb_file = Listbox(center, selectmode=EXTENDED)
	self.lb_file.grid(row=0, column=0, sticky='news')
	vs = Scrollbar(center, orient='vertical', command=self.lb_file.yview)
	vs.grid(row=0, column=1, sticky='ns')
	hs = Scrollbar(center, orient='horizontal', command=self.lb_file.xview)
	hs.grid(row=1, column=0, sticky='ew')
	self.lb_file.configure(xscrollcommand=hs.set, yscrollcommand=vs.set)

	self.lb_select = Listbox(center, selectmode=EXTENDED)
	self.lb_select.grid(row=0, column=3, sticky='news')
	vs = Scrollbar(center, orient='vertical', command=self.lb_select.yview)
	vs.grid(row=0, column=4, sticky='ns')
	hs = Scrollbar(center, orient='horizontal', command=self.lb_select.xview)
	hs.grid(row=1, column=3, sticky='ew')
	self.lb_select.configure(xscrollcommand=hs.set, yscrollcommand=vs.set)

	bbox = Frame(center)
	w = Button(bbox, text='Add >>', command=self.add_selection)
	w.grid(row=0, column=0)
	w = Button(bbox, text='Remove', command=self.remove_selection)
	w.grid(row=1, column=0)
	w = Button(bbox, text='Clear', command=self.clear_selection)
	w.grid(row=2, column=0)
	bbox.grid(row=0, column=2, sticky='ns')

	center.grid(row=1, sticky='news')

	self.fill_file_list()
	self.selection_list = []
	self.fill_selection_list()
	
	return self.lb_file
    
    def fill_file_list(self):
	"""Fill the left listbox with information about the current directory."""
	l = self.lb_file
	l.delete(0, END)

	self.subdir_list = pdbfile.listsubdirs(self.path)
	self.subdir_list.sort()
	l.insert(END, '(Parent Directory)')
	for n in self.subdir_list:
	    l.insert(END, n)

	# option here
	fmt = '%(filename)s [%(dbname)s]'

	self.file_list = pdbfile.listdir(self.path)
	self.file_list.sort()
	for n, i in self.file_list:
	    l.insert(END, fmt % {'filename':n, 'dbname': i.get('name')})

    def fill_selection_list(self):
	l = self.lb_select

	l.delete(0, END)
	for n in self.selection_list:
	    l.insert(END, n[1].get('name', '(Unknown)'))
	    

    def selected_files(self):
	l = self.lb_file.curselection()
	try: l = map(string.atoi, l)
	except ValueError: pass

	ndir = len(self.subdir_list)+1

	return map(lambda x,l=self.file_list: l[x],
		   filter(lambda x,y=ndir: x >= y, l))

    def selected_dirs(self):
	l = self.lb_file.curselection()
	try: l = map(string.atoi, l)
	except ValueError: pass

	ndir = len(self.subdir_list)+1

	return map(lambda x,l=self.subdir_list: l[x],
		   filter(lambda x,y=ndir: x >= y, l))

    def selected_selections(self):
	l = self.lb_select.curselection()
	try: l = map(string.atoi, l)
	except ValueError: pass

	return map(lambda x,l=self.selection_list: l[x], l)

    def add_selection(self, event=None):
	"""Add the selected files to the selection."""
	for x in self.selected_files():
	    self.selection_list.append(x)
	    self.lb_select.insert(x[1].get('name','(Unknown)'))

    def remove_selection(self, event=None):
	l = self.lb_select.curselection()
	try: l = map(string.atoi, l)
	except ValueError: pass

	for x in l:
	    self.selection_list[x] = None
	self.selection_list = filter(lambda x: x is not None, self.selection_list)
	self.fill_selection_list()

    def clear_selection(self, event=None):
	self.selection_list = []
	self.fill_selection_list()
	
