"""
  PDA.Palm.Tk.ConduitDialogs - some dialogs related to conduits
  $Id$

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

"""

import string

from Tkinter import *
import tkSimpleDialog

class ConduitInfoDialog(tkSimpleDialog.Dialog):
    def __init__(self, parent, conduit):
	self.conduit = conduit
	tkSimpleDialog.Dialog.__init__(self, parent, conduit.name)

    def body(self, parent):
	i = parent
	c = self.conduit
	
	Label(i, text=c.name,
	      font=('Helvetica',14,'bold')).grid(row=0, column=0, sticky='ew')
	if c.version:
	    Label(i, text='Version %s' % c.version).grid(row=1, column=0, sticky='ew')
	if c.author:
	    Label(i, text='By %s' % c.author).grid(row=2, column=0, sticky='ew')
	if c.url:
	    Label(i, text=c.url).grid(row=3, column=0, sticky='ew')
	if c.description:
	    Label(i, text=c.description, justify=LEFT,
		  wraplength=250).grid(row=4, column=0, sticky='ew')

    def buttonbox(self):
	box = Frame(self)
	Button(box, text="OK", width=10, command=self.ok,
	       default=ACTIVE).grid(row=0, column=0)
	Button(box, text="Options...", width=10,
	       command=self.showoptions).grid(row=0, column=1)

	self.bind('<Return>', self.ok)
	self.bind('<Escape>', self.ok)
	self.bind('<Alt-O>', self.showoptions)
	box.pack()

    def showoptions(self, event=None):
	ShowOptionsDialog(self, self.conduit)
    

class ShowOptionsDialog(tkSimpleDialog.Dialog):
    def __init__(self, parent, conduit):
	self.conduit = conduit
	tkSimpleDialog.Dialog.__init__(self, parent, 'Options for %s' % conduit.name)

    def body(self, parent):
	self.listbox = Listbox(parent)
	self.listbox.grid(row=0, column=0, sticky='nsew')

	self.conduit_names = self.conduit.options.keys()
	for n in self.conduit_names:
	    o = self.conduit.options[n]
	    self.listbox.insert(END, '%s - %s' % (o.name, o.title))

	return self.listbox

