#include <sys/param.h>
#include <sys/mount.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>

#include "mntopts.h"

struct mntopt mopts[] = {
	MOPT_STDOPTS,
	MOPT_UPDATE,
	{NULL}
};

void usage(void);

int
main(int argc,char **argv)
{
	char *dev, *dir;
	int ch,mntflags=0,opts;
	struct vfsconf *vfc;

	while((ch=getopt(argc,argv,"o:")) != EOF)
		switch(ch){
			case 'o':
				getmntopts(optarg,mopts,&mntflags,&opts);
				break;
			case '?':
			default:
				usage();
			}
	argc -= optind;
	argv += optind;

	if(argc != 2)
		usage();

	dev = argv[0];
	dir = argv[1];

	vfc = getvfsbyname("ntfs");
	if(!vfc && vfsisloadable("ntfs")) {
		if(vfsload("ntfs"))
			err(1, "vfsload(ntfs)");
		endvfsent();
		vfc = getvfsbyname("ntfs");
	}

	if(!vfc)
		err(1, "no ntfs found");

	if(mount(vfc->vfc_index,dir,mntflags,/*args*/dev) < 0)
		err(1, "%s", dev);
	exit(0);
}

void
usage()
{
	fprintf(stderr,
		"usage: mount_ntfs [-o options] special node\n");
	exit(1);
}
