#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include <iostream.h>
#include <fstream.h>

#include "config.h"
#include "Debug.h"
#include "Lexer.h"
#include "Config.h"

/****************************************************************
 * CONFIG
 ****************************************************************/
#define STRNCPY(dest,source) \
    if(source.length()>=sizeof(dest))\
      throw SyntaxError(lex,"argument too long");\
    strcpy(dest,source.c_str());

#define HANDLESTRGARG(name) \
    if(tok==#name) {\
      a1=lex.getToken();\
      STRNCPY(name,a1);\
    }

#define HANDLEINTARG(name) \
    if(tok==#name) {\
      a1=lex.getToken();\
      name=atoi(a1.c_str());\
    }

void Config::read(const char *fn)
{
  Lexer lex(fn);
  string tok,a1,a2,a3;

  for(;;) {
    tok=lex.getToken();
    if(lex.eof()) break;

    HANDLESTRGARG(SpoolDirectory)
    else HANDLESTRGARG(LogDirectory)
    else HANDLESTRGARG(PrefetchFile)
    else HANDLESTRGARG(Username)
    else HANDLESTRGARG(Groupname)
    else HANDLESTRGARG(CachePort)
    else HANDLESTRGARG(Admin)
    else HANDLESTRGARG(PidFile)
    else HANDLEINTARG(SpoolSize)
    else HANDLEINTARG(ClientTimeout)
    else HANDLEINTARG(Retries)
    else if(tok=="LogStyle") {
      LogStyle=0;
      for(;;) {
	a1=lex.getToken();
	if(a1=="strict-inn") LogStyle|=LogINN;
	else if(a1=="hostname") LogStyle|=LogName;
	else if(a1=="ip-address") LogStyle|=LogAddr;
	else break;
      }
      lex.putbackToken(a1);
    } else if(tok=="ServerType") {
      a1=lex.getToken();
      if(a1=="inetd") ServerType=inetd;
      else if(a1=="standalone") ServerType=standalone;
      else throw SyntaxError(lex,"illegal ServerType");
    } else if(tok=="ConfigVersion") {
      a1=lex.getToken();
      if(atoi(a1.c_str())!=4) throw SyntaxError(lex,"expecting ConfigVersion 4");
    } else if(tok=="NewsServerList") {
      srvrs.read(lex);
    } else if(tok=="Timeouts") {
      a1=lex.getToken();
      a2=lex.getToken();
      ttl_list=atoi(a1.c_str());
      ttl_desc=atoi(a2.c_str());
    } else {
      throw SyntaxError(lex,"unknown keyword");
    }
  }
}
