#include<errno.h>
#include<fcntl.h>
#include<sys/param.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<time.h>
#include<unistd.h>
#include<ctype.h>

#include"util.h"

int mkpdir(char *dirname, int mode)
{
  struct stat s;
  char buf[MAXPATHLEN];
  char *p,*q;

  if(stat(dirname,&s)<0) {
    if (errno!=ENOENT) return -1;
    p=buf;
    q=dirname;
    if(*q=='/') *p++=*q++;
    while(*q) {      
      while(*q && *q!='/') *p++=*q++;
      *p='\0';
      if(stat(buf,&s)<0) {
	if(errno!=ENOENT) return -1;
	if(mkdir(buf,mode)<0) return -1;
      }
      if(!(S_ISDIR(s.st_mode))) {
	errno=ENOTDIR;
	return -1;
      }
      while(*q=='/') *p++=*q++;
    }
  }
  if(!(S_ISDIR(s.st_mode))) {
    errno=ENOTDIR;
    return -1;
  }
  return 0;
}

const char *group2dir(const char *name) 
{
  static char buf[MAXPATHLEN],*p;
  const char *q;

  p=buf;
  q=name;
  while(((*p)=((*q!='.')?*q:'/'))!='\0') {
    p++; q++;
  }

  return buf;
}

/* matchgroup
 * Description:
 *   Checks whether a newsgroup matches a given list of patterns. 
 *   The pattern-list is a comma separated list of newsgroup-patterns 
 *   that may contain a wildcard (*) at the end and start with a !
 *   to indicate that the newsgroup must not match a pattern.
 *   Eg: comp.*,!comp.os.win* matches all newsgroups starting
 *   with comp., except those starting with comp.os.win. This
 *   rule is especially designed for our special windows-friends ;)
 * Parameters:
 *   pattern ... the pattern-list
 *   group ... the name of the newsgroup terminated by \0 or a 
 *             whitespace.
 * Return:
 *   If the newsgroup is matched by a positive pattern, the number of
 *   matching characters plus one will be returned.
 *   If the newsgroup is matched by a negative pattern (one that
 *   starts with !), minus the number of characters minus one will 
 *   be returned.
 * Exceptions:
 *   none
 */
int matchgroup(const char *pattern, const char *group)
{
  char c;
  int j,clen,bmlen=0,bmrej=0;
  int rejrule=0;

  j=0;
  do {
    clen=0;
    if(pattern[j]=='!') {
      j++; rejrule=1;
    } else {
      rejrule=0;
    }
    while((c=pattern[j]) && c==group[clen]) {
      clen++;
      j++;
    }
    
    switch(c) {
    case ',':
    case '\0':
      if(group[clen]!='\0' && !isspace(group[clen])) {
	clen=-1;
      }
      clen++;
      break;
    case '*':
      clen++;
      break;
    default: 
      clen=-1;
      break;
    }
    
    if(clen>bmlen) {
      bmlen=clen;
      bmrej=rejrule;
    }
    
    while(c && c!=',') {
      j++;
      c=pattern[j];
    }
    j++;
  } while(c);
  
  return bmrej?-bmlen:bmlen;
}
