
/*
 * errors that arise from ldap use
 * $Id: errors.c,v 1.4 1998/03/04 23:54:17 leonard Exp $
 *
 * Most errors become their own exception
 */

#include "errors.h"

/* the generic (unknown) error object */

PyObject*
LDAPerror_object;

/* list of error objects */

#define NUM_LDAP_ERRORS		LDAP_NO_MEMORY+1
static PyObject* 
errobjects[ NUM_LDAP_ERRORS ];

/* convert an LDAP error into a python exception */

PyObject*
LDAPerror( LDAP*l, char*msg ) 
{
	if (l == NULL) {
		PyErr_SetFromErrno( LDAPerror_object );
	} else {
		int errnum = l->ld_errno;
		PyObject* errobj;
		PyObject *info;

		if (errnum<0 || errnum>=NUM_LDAP_ERRORS)
		    	Py_FatalError("LDAPerror - invalid error");

		errobj = errobjects[errnum];
		
		if (errnum == LDAP_NO_MEMORY)
			PyErr_NoMemory();

		info = PyDict_New();

		PyDict_SetItemString( info, "desc", 
				PyString_FromString(ldap_err2string(errnum)));

		if (l->ld_matched != NULL && *l->ld_matched != '\0') 
		   PyDict_SetItemString( info, "matched", 
		   		PyString_FromString(l->ld_matched) );

		if (l->ld_error != NULL && *l->ld_error != '\0') 
		   PyDict_SetItemString( info, "info", 
		   		PyString_FromString(l->ld_error) );

		PyErr_SetObject( errobj, info );

	}
	return NULL;
}


/* initialisation */

void
LDAPinit_errors( PyObject*d ) {

	/* create the generic error object */

	LDAPerror_object = PyString_FromString( "error" );
	PyDict_SetItemString( d, "error", LDAPerror_object );

	/* create each LDAP error object.
	 * (some are copies of existing python exception objects) */

#	define seterrobj2(n,o) \
		PyDict_SetItemString( d, #n, (errobjects[LDAP_##n] = o) ); \
		Py_INCREF( errobjects[LDAP_##n] )

#	define seterrobj(n) \
		seterrobj2( n, PyString_FromString("ldap." #n ) )

#	define seterrobjas(n,existing) \
		seterrobj2( n, existing )

	seterrobj(SUCCESS);
	seterrobj(OPERATIONS_ERROR);
	seterrobj(PROTOCOL_ERROR);
	seterrobj(TIMELIMIT_EXCEEDED);
	seterrobj(SIZELIMIT_EXCEEDED);
	seterrobj(COMPARE_FALSE);
	seterrobj(COMPARE_TRUE);
	seterrobj(STRONG_AUTH_NOT_SUPPORTED);
	seterrobj(STRONG_AUTH_REQUIRED);
	seterrobj(PARTIAL_RESULTS);
	/* seterrobjas(NO_SUCH_ATTRIBUTE, PyExc_AttributeError); */
	seterrobj(NO_SUCH_ATTRIBUTE);
	seterrobj(UNDEFINED_TYPE);
	seterrobj(INAPPROPRIATE_MATCHING);
	seterrobj(CONSTRAINT_VIOLATION);
	seterrobj(TYPE_OR_VALUE_EXISTS);
	seterrobj(INVALID_SYNTAX);
	/* seterrobjas(NO_SUCH_OBJECT, PyExc_NameError); */
	seterrobj(NO_SUCH_OBJECT);
	seterrobj(ALIAS_PROBLEM);
	seterrobj(INVALID_DN_SYNTAX);
	seterrobj(IS_LEAF);
	seterrobj(ALIAS_DEREF_PROBLEM);
	seterrobj(INAPPROPRIATE_AUTH);
	seterrobj(INVALID_CREDENTIALS);
	seterrobj(INSUFFICIENT_ACCESS);
	seterrobj(BUSY);
	seterrobj(UNAVAILABLE);
	seterrobj(UNWILLING_TO_PERFORM);
	seterrobj(LOOP_DETECT);
	seterrobj(NAMING_VIOLATION);
	seterrobj(OBJECT_CLASS_VIOLATION);
	seterrobj(NOT_ALLOWED_ON_NONLEAF);
	seterrobj(NOT_ALLOWED_ON_RDN);
	seterrobj(ALREADY_EXISTS);
	seterrobj(NO_OBJECT_CLASS_MODS);
	seterrobj(RESULTS_TOO_LARGE);
	seterrobj(OTHER);
	seterrobj(SERVER_DOWN);
	seterrobj(LOCAL_ERROR);
	seterrobj(ENCODING_ERROR);
	seterrobj(DECODING_ERROR);
	seterrobj(TIMEOUT);
	seterrobj(AUTH_UNKNOWN);
	seterrobj(FILTER_ERROR);
	seterrobj(USER_CANCELLED);
	/* seterrobjas(PARAM_ERROR, PyExc_ValueError); */
	seterrobj(PARAM_ERROR);
	seterrobj(NO_MEMORY);
}
