/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#ifdef unicos
#include <sys/types.h>
#endif
#include <sys/wait.h>
#include <setjmp.h>
#include "connect.h"
#include "main.h"

extern void sending(struct client_type *);
extern void receive_data(void *);
extern short get_var_from_pftprc(const char *, char *, short);
extern void handler(int);
extern void init_user_id(int);

void client_filter_programm(void *cstruct)
{
   struct client_type *clientstr = (struct client_type *)cstruct;
   int pfds[2];
   int pid;
   /*
    * Start a child process for the filter of the client.
    */
   if (pipe(pfds) < 0) {
      if (slfp) fprintf(slfp, "** pipe: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   if ((pid = fork()) < 0) {
      if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   /*
    * Here goes the child 'sending'.
    */
   if (pid) {
      int optval=1;
      int status=1;
      signal(SIGPIPE, handler);
      close(*pfds);
      (*statstr)->fp = fdopen(*(pfds+1), "w");
      if ((*statstr)->_STANDARD_INPUT_) {
         setvbuf((*statstr)->fp, \
         (*statstr)->_STDIN_BUFFER_, \
         (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
         (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      sending(clientstr);
#ifndef unicos
      setsockopt((*statstr)->ws, SOL_SOCKET, SO_SNDBUF, (char *)&optval, sizeof(optval));
#endif
      if ((*statstr)->version && !(*statstr)->_STANDARD_INPUT_) fputs("0 -1 0\nB", (*statstr)->fp);
      fclose((*statstr)->fp);
      while (wait((int *)&status) != pid);
      shutdown((*statstr)->ws, 1);
   }
   else {
      signal(SIGPIPE, handler);
      /*
       * Set descriptors for the filter of the client.
       */
      dup2(*pfds, 0);
      close(*(pfds+1));
      dup2(s, 1);
      close(s);

      /*
       * Before we start the filter sending
       * to the daemon we close stderr.
       */
      if ((*statstr)->_PFTP_DAEMON_) close(2);

      /*
       * Execute the filter programm specified
       * by the environment variable PFTPCFILTER.
       */
      execvp(*filter, filter);
      if (slfp) fprintf(slfp, "** exec: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
}

jmp_buf fenv;

void server_filter_programm(void *snum)
{
   FILE *fp;
   int strnum = (int)*(int *)snum;
   int pfds[2];
   int pid;
   int size=(*(statstr+strnum))->size;

   /*
    * Reset the signals to its defaults behavoir.
    */
   signal(SIGCHLD, SIG_DFL);
#ifndef USE_POSIX_THREAD
   signal(SIGINT, SIG_DFL);
   signal(SIGQUIT, SIG_DFL);
#endif

   /*
    * Start a child for the filter of the server.
    */
   if (pipe(pfds) < 0) {
      fprintf(stderr, "** pipe: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   if ((pid = fork()) < 0) {
      fprintf(stderr, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   /*
    * Here goes the child 'receive_data'.
    */
   if (pid) {
      if (slfp) fflush(slfp);
      close(*(pfds+1));
      fp = fdopen(*pfds, "r");
      if ((*(statstr+strnum))->_STANDARD_INPUT_) {
         setvbuf(fp, \
         (*statstr)->_STDIN_BUFFER_, \
         (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
         (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      (*(statstr+strnum))->fp = fp;
      (*(statstr+strnum))->REMOTEHOSTNAME[size] = '\0';
      if (!setjmp(fenv)) {
         int status=1;
         receive_data((void *)&strnum);
         while (wait((int *)&status) != pid);
      }
      else fclose ((*(statstr+strnum))->fp);
      close(*pfds);
      if (slfp) fflush(slfp);
#ifdef USE_POSIX_THREAD
      if (!(*statstr)->_STANDARD_INPUT_) pthread_exit(0);
      else exit(0);
#else
      exit(0);
#endif
   }
   else {
      if ((*statstr)->_PFTP_DAEMON_) {
         /*
          * Set user's home directory and resource file location.
          */
         init_user_id(strnum);
      }

      /*
       * Set descriptors for the filter of the server.
       */
      close(*pfds);
      dup2((*(statstr+strnum))->ns, 0);
      close((*(statstr+strnum))->ns);
      dup2(*(pfds+1), 1);
      close(*(pfds+1));

      /*
       * Before we start the filter for the
       * daemon we close stderr.
       */
      if ((*statstr)->_PFTP_DAEMON_) close(2);

      /*
       * Execute the filter programm specified
       * by the environment variable PFTPSFILTER.
       */
      execvp(*filter, filter);
      if (slfp) {
         fprintf(slfp, "** exec: %s\n", _PFTP_ERROR_ARRAY_);
         fflush(slfp);
      }
      longjmp(fenv, 1);
      exit(1);
   }
}


int set_filter(short isserver, short strnum)
{
   int j=0, h=(*(statstr+strnum))->usefilter;
   char last = '\0', *str=NULL, *tmp=NULL;

   if (!h) {
      if (*filter) free(*filter);
      *filter=NULL;
      return 1;
   }
   if (isserver) {
      if ((*statstr)->_PFTP_DAEMON_ || !(str = getenv("PFTPSFILTER"))) {
         MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc("PFTPSFILTER", str, strnum)) {
            if ((*statstr)->_PFTP_DAEMON_) {
               if (str) free(str);
               return 0;
            }
            else {
               fprintf(stderr, "** Please set the environment variable PFTPSFILTER!\n");
               exit(1);
            }
         }
      }
   }
   else {
      if (!(str = getenv("PFTPCFILTER"))) {
         MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc("PFTPCFILTER", str, strnum)) {
            fprintf(stderr, "** Please set the environment variable PFTPCFILTER!\n");
            exit(1);
         }
      }
   }
   /*
    * Get memory.
    */
   if (!*filter) {
      MEM_CHECK((*filter = (char *)calloc(SONAME, sizeof(char))));
   }

   /*
    * Set vector filter.
    */
   for (--((*(statstr+strnum))->usefilter),tmp=str; (*(statstr+strnum))->usefilter && *tmp; tmp++) {
      if (*tmp == ':') ((*(statstr+strnum))->usefilter)--;
   }
   if ((*(statstr+strnum))->usefilter) {
      if ((*statstr)->_PFTP_DAEMON_) {
         if (str) free(str);
         return 0;
      }
      else {
         fprintf(stderr, "** Filter %d not found. Check your filter variable.\n\n", h);
         exit(1);
      }
   }
   for (;*tmp == ' ' && *tmp; tmp++);
   for (j=h=0; *tmp && *tmp != ':'; tmp++) {
      if (*tmp != ' ') {
         *(*(filter+j)+h) = *tmp;
         h++;
      }
      else if (last != ' ') {
         *(*(filter+j)+h) = '\0';
         j++;
         h = 0;
         /*
          * Get memory.
          */
         if (!*(filter+j)) {
            MEM_CHECK((*(filter+j) = (char *)calloc(SONAME, sizeof(char))));
         }
      }
      last = *tmp;
   }
   *(*(filter+j)+h) = '\0';
   if (!getenv("PFTPSFILTER") && !getenv("PFTPCFILTER")) free(str);
   if (!**(filter+j)) *(filter+j) = (char *)NULL;
   else *(filter+j+1) = (char *)NULL;

   /*
    * Print out filter type.
    * root must not know that!
    * Think twice before changing this.
    */
   if (slfp && !((*statstr)->_PFTP_DAEMON_ && !getuid())) {
      fprintf(slfp, "* Using `");
      for (j=0; *(filter+j); j++)
      fprintf(slfp, "%s ", *(filter+j));
      fprintf(slfp, "\b' as filter.\n");
      fflush(slfp);
   }
   return 1;
}


/*
 * accs--Get a socket to work with.
 */
void accs(void)
{
   /*
    * Get a socket to work with.  This socket will
    * be in the Internet domain, and will be a
    * stream socket.
    */
   if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      fprintf(stderr, "** socket: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
}



short set_prog(char **pa, char *pname)
{
   char last = '\0', *str=NULL, *tmp=NULL;
   int h=0;

   if (!(str = getenv(pname))) {
      MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
      if (!get_var_from_pftprc(pname, str, 0)) {
         free(str);
         return 0;
      }
   }

   MEM_CHECK((*pa = (char *)calloc(SONAME, sizeof(char))));

   for (tmp=str;*tmp == ' ' && *tmp; tmp++);
   for (h=0; *tmp; tmp++) {
      if (*tmp != ' ') {
         *(*pa+h) = *tmp;
         h++;
      }
      else if (last != ' ') {
         *(*pa+h) = '\0';
         pa++;
         h = 0;
         MEM_CHECK((*pa = (char *)calloc(SONAME, sizeof(char))));
      }
      last = *tmp;
   }
   *(*pa+h) = '\0';
   if (!getenv(pname)) free(str);
   if (!**pa) *pa = NULL;
   else {
      pa++;
      *pa = NULL;
   }

   return 1;
}


char **run_prog(char **pa, char *file)
{
   int pid=0;
   char **tmp;

   for (tmp=pa; *tmp; tmp++);
   *tmp++ = file;
   *tmp-- = NULL;
   if ((pid = fork()) < 0) {
      if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   
   if (!pid) {
      execvp(*pa, pa);
      if (slfp) fprintf(slfp, "** exec: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   while (wait((int *)0) != pid);
   *tmp = NULL;

   return --tmp;
}
