/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <setjmp.h>
#include "connect.h"
#include "main.h"

extern void accs(void);
extern void handler(int);
extern void sending(struct client_type *);
extern void client_filter_programm(void *);
extern int set_filter(short, short);
extern void free_memory(void);
extern void set_tty(int);
void reply_from_server(void);

jmp_buf cenv;

void jhandler(int sig)
{
   alarm(0);
   longjmp(cenv, 1);
}

/*
 * Client--This is the client part of pftp.
 */
void Client(int portn, struct client_type *clientstr)
{
   FILE *rp=NULL;
   int i, optval=(*statstr)->bsize;
   struct hostent *hp=(struct hostent *)NULL;
   struct sockaddr_in sin;
   int sinlen;

   sinlen = sizeof(sin);
   memset((char *)&sin, 0, sinlen);
   clientstr->argc -= ((int) (*statstr)->_OPTIONS_ - (int) (*statstr)->_STANDARD_INPUT_);
   i = (int) (*statstr)->_OPTIONS_;
   /*
    * Set signals SIGPIPE and SIGINT.
    */
   signal(SIGPIPE, handler);
   signal(SIGINT, handler);

   /*
    * Next, we need to look up the network
    * address of our host.
    */
   if (!(*statstr)->_HOSTNAME_) (*statstr)->_HOSTNAME_ = *((clientstr->argv)+i);
   if ((hp = (struct hostent *)gethostbyname((*statstr)->_HOSTNAME_)) != NULL) {
      memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);
   }
   else if (!(sin.sin_addr.s_addr = inet_addr((*statstr)->_HOSTNAME_))) {
      fprintf(stderr, "** %s: unknown host.\n", (*statstr)->_HOSTNAME_);
      exit(1);
   }
   if (hp) (*statstr)->_HOSTNAME_ = hp->h_name;

   if (slfp) {
      fprintf(slfp, "\n*** pftp is contacting %s ", (*statstr)->_HOSTNAME_);
      fprintf(slfp, "on port %d ***\n\n", portn);
   }
   
   /*
    * Get a socket and set options on it.
    */
   accs();   
   if (!(*statstr)->_STANDARD_INPUT_) {
#ifdef HP_UX
      optval = BUFSIZE;
#endif
      setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&optval, sizeof(optval));
   }
   else if ((*statstr)->_SET_STDIN_BUF_) {
      setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&((*statstr)->_STDIN_BUFSIZ_), \
      sizeof((*statstr)->_STDIN_BUFSIZ_));
   }

   if (s) {
      /*
       * Create the address we will be connecting to.
       */
      sin.sin_family = AF_INET;
      sin.sin_port = htons(portn);

      /*
       * Try to connect to the address, For this to
       * succeed, the server already have bound
       * this address, and must have issued a listen()
       * request.
       * First send file name.
       */
      if (connect(s, (struct sockaddr *)&sin, sinlen) < 0) {
#ifdef Linux
         if (slfp) fprintf(slfp, "** connect: %s\n", _PFTP_ERROR_ARRAY_);
#else
         if (isatty(2)) perror("** connect");
#endif
         exit(1);
      }

#if !defined HP_UX && !defined unicos
      fcntl(s, F_SETFL, FASYNC);
#endif

      /*
       * See if the server sends an id.
       */
      (*statstr)->ns = dup(s);
      (*statstr)->ws = dup(s);
      rp = fdopen((*statstr)->ns, "r");
      signal(SIGALRM, jhandler);
      if (!setjmp(cenv)) {
         char *str=NULL, *tmp=NULL;
         int ii=0;

         MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
         if ((*statstr)->_PFTP_DAEMON_ & BIT_TWO) alarm(27);
         else if ((*statstr)->_PFTP_DAEMON_) alarm(13);
         else alarm(7);
         for (ii=0; ii < 2; ii++) {
            if (fgets(str, SONAME, rp)) {
               alarm(0);
               for (tmp=str; *tmp && *tmp != '\n'; tmp++);
               *tmp = '\0';
               if (strlen(str) > 4 && *(str+4) == ' ') {
                  *(str+4) = '\0';
                  if (!strcmp(str, "PFTP")) {
                     MEM_CHECK(((*statstr)->version = (char *)calloc(SONAME, sizeof(char))));
                     strcpy((*statstr)->version, str+5);
                  }
                  else if (!strcmp(str, "STAT")) {
                     MEM_CHECK(((*statstr)->sstatus = (char *)calloc(SONAME, sizeof(char))));
                     strcpy((*statstr)->sstatus, str+5);
                  }
               }
            }
         }
         if (!((*statstr)->sstatus) && slfp) {
            if (slfp) fprintf(slfp, "** Unable to connect to %s: Connection refused\n",
               (*statstr)->_HOSTNAME_);
            exit(1);
         }
         if (str) free(str);
      }
      signal(SIGALRM, SIG_IGN);

      /*
       * Check if a daemon is running on remote site.
       */
      (*statstr)->fp = fdopen((*statstr)->ws, "w");
      if ((*statstr)->_PFTP_DAEMON_) {
         if (!(*statstr)->version \
         || (strcmp((*statstr)->sstatus, "daemon") \
         && strcmp((*statstr)->sstatus, "inetd server"))) {
            if (slfp) {
               int hor=0;
               fprintf(slfp, "** There is no daemon running on the remote site.\n");
               fprintf(slfp, "** Do you want to send the data to the server (y|n)? ");
               set_tty(1);
               hor=fgetc(stdin);
               set_tty(0);
               fputc('\n', slfp);
               if (hor == 'y') (*statstr)->_PFTP_DAEMON_ = 0;
               else exit(1);
               
            }
            else exit(1);
         }
      }
      /*
       * Check if a server is running on remote site.
       */
      else if ((*statstr)->version && !(*statstr)->_PFTP_DAEMON_) {
         if (!strcmp((*statstr)->sstatus, "daemon")) {
            if (slfp) {
               int hor=0;
               fprintf(slfp, "** There is a daemon running on the remote site.\n");
               fprintf(slfp, "** Do you want to send the data to the daemon (y|n)? ");
               set_tty(1);
               hor=fgetc(stdin);
               set_tty(0);
               fputc('\n', slfp);
               if (hor == 'y') {
                  (*statstr)->_PFTP_DAEMON_ = BIT_ONE;
                  MEM_CHECK((client_destdir = (char *)calloc(LONAME, sizeof(char))));
                  strcpy(client_destdir, "~");
               }
               else exit(1);
               
            }
            else exit(1);
         }
      }

      /*
       * If sending data to the daemon get the user name.
       */
      if ((*statstr)->_PFTP_DAEMON_) {
         int ll=0;
         char *username=NULL, *str=NULL;
         if ((*statstr)->rlogin) username = (*statstr)->rlogin;   
         else {
            MEM_CHECK((username = (char *)calloc(SONAME, sizeof(char))));
            fprintf(stderr, "Username: "); fgets(username, SONAME, stdin);
            for (ll=0; *(username+ll); ll++) {
               if (*(username+ll) == '\n') *(username+ll) = '\0';
            }
         }
         if ((*statstr)->from) {
            fprintf((*statstr)->fp, "USER %s\nFROM %s\nPROG %d\nGOON 1\n",
            username, (*statstr)->from, (*statstr)->usefilter);
            if ((*statstr)->from) free((*statstr)->from);
         }
         else {
            fprintf((*statstr)->fp, "USER %s\nPROG %d\nGOON 1\n",
            username, (*statstr)->usefilter);
         }

         fflush((*statstr)->fp);
         /*
          * Wait for the daemon/inetd server to be ready.
          */
         MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
         if (read((*statstr)->ns, str, SONAME) < 0) {
            if (slfp) fprintf(slfp, "** The server doesn't answer to the request.\n");
            exit(1);
         }
         *(str+4) = '\0';
         if (strcmp(str, "COME")) {
            fputs((str+5), stderr);
            shutdown(s, 2);
            exit(1);
         }
         if (str) free(str);
         if (username) free(username);
      }

      /*
       * Set client filter if '-f' was given on cmdline.
       */
      set_filter(0, 0);

      /*
       * Set file pointer.
       */
      clientstr->argv += i + 1;
      if (*filter) {
         client_filter_programm((void *)clientstr);
      }
      else {
         fflush((*statstr)->fp);
         if ((*statstr)->_STANDARD_INPUT_) {
            setvbuf((*statstr)->fp, \
            (*statstr)->_STDIN_BUFFER_, \
            (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
            (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
         }

         /*
          * Actually send the files.
          */
         sending(clientstr);
         if ((*statstr)->version && !(*statstr)->_STANDARD_INPUT_) {
            fputs("0 -1 0\nB", (*statstr)->fp);
         }
         fclose((*statstr)->fp);
      }

      if ((*statstr)->version && !(*statstr)->_STANDARD_INPUT_) {
         reply_from_server();
      }
      else if (slfp && !(*statstr)->_STANDARD_INPUT_) fprintf(slfp, "<*> Data sent to an old pftp server.\n");
      if ((*statstr)->sstatus) free((*statstr)->sstatus);
      free((*statstr)->version);
      fclose(rp);
   }
   if (clientstr) free(clientstr);
   free_memory();
   if (slfp) fputc('\n', slfp);
}


void reply_from_server(void)
{
   char *str=NULL, *tmp=NULL;
   FILE *rp=NULL;

   rp = fdopen((*statstr)->ns, "r");
   signal(SIGALRM, jhandler);
   fflush(slfp);
   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
   if (!setjmp(cenv) && slfp) {
      alarm(60);
      if (fgets(str, SONAME, rp)) {
         alarm(0);
         for (tmp=str; *tmp && *tmp != '\n'; tmp++);
         *tmp = '\0';
         *(str+4)='\0';
         if (!strcmp("OKAY", str)) {
            fputs(str+5, slfp);
            fprintf(slfp, " to pftp %s.\n", (*statstr)->sstatus);
         }
         else if (!strcmp("ERRO", str)) {
            fputc('\n', slfp);
            fputs(str+5, slfp);
         }
      }
      else {
         fprintf(slfp, "\r** Connection rejected by %s.          ", (*statstr)->_HOSTNAME_);
      }
      shutdown(s, 2);
   }
   else if (slfp && (*statstr)->version) fprintf(slfp, "** Connection timed out.\n");
   else if (slfp) fprintf(slfp, "<*> Data sent to pftp %s.\n", (*statstr)->sstatus);
   if (str) free(str);
}
